/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.fonts.nfont;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.fonts.nfont.a.b;
import org.icepdf.core.pobjects.fonts.nfont.c;
import org.icepdf.core.pobjects.fonts.nfont.c.a;
import org.icepdf.core.pobjects.fonts.nfont.d;
import org.icepdf.core.pobjects.fonts.nfont.e;

public class CMap
implements org.icepdf.core.pobjects.fonts.CMap {
    private static final Logger logger = Logger.getLogger(CMap.class.toString());
    public static final CMap IDENTITY = new org.icepdf.core.pobjects.fonts.nfont.b();
    public static final CMap IDENTITY_H = new c();
    public static final CMap IDENTITY_V = new c();
    public static final CMap IDENTITY_UTF16BE = new d();
    private static final Map cache_ = new HashMap(20);
    public static final int LIGATURE_MAP_SIZE = 64263;
    private static final String[] LIGATURE_MAP = new String[64263];
    private char[][] toSel_;
    private int[] first_;
    private char[][] fromSel_;
    private StringBuilder[] fromSelStr;
    private int[] firstfrom_;
    private CMap usecmap_ = null;
    private boolean[] onebyte_ = null;
    private boolean oneByte;

    public CMap(char[] cArray) {
        this(new char[][]{cArray});
        if (cArray == null) {
            throw new IllegalArgumentException("Char[] can not be null");
        }
    }

    public CMap(char[][] cArray) {
        if (cArray == null) {
            throw new IllegalArgumentException("Segs can not be null");
        }
        this.compact(cArray);
    }

    CMap() {
    }

    public CMap(InputStream inputStream) {
        this(null, inputStream);
    }

    public boolean isOneByte(int n2) {
        return this.oneByte;
    }

    public CMap(CMap cMap, InputStream inputStream) {
        Object object;
        this.usecmap_ = cMap;
        char[][] cArrayArray = new char[256][];
        this.onebyte_ = new boolean[256];
        Arrays.fill(this.onebyte_, true);
        PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream, 5);
        Object[] objectArray = new Object[768];
        int n2 = 0;
        b.a(pushbackInputStream);
        while ((object = b.a(pushbackInputStream)) != null) {
            int n3;
            int n4;
            Object object2;
            int n5;
            Class<?> clazz = object.getClass();
            if (b.i == clazz) continue;
            if (b.b != clazz) {
                objectArray[n2++] = object;
                continue;
            }
            if (((String)object).startsWith("/")) {
                objectArray[n2++] = ((String)object).substring(1);
                continue;
            }
            String string = (String)object;
            int n6 = 0;
            if ("begincodespacerange".equals(string)) {
                n5 = ((Number)objectArray[n2 - 1]).intValue();
                for (int i2 = 0; i2 < n5; ++i2) {
                    int n7;
                    int n8;
                    StringBuilder stringBuilder = (StringBuilder)b.a(pushbackInputStream);
                    object2 = (StringBuilder)b.a(pushbackInputStream);
                    int n9 = stringBuilder.length();
                    if (n9 == 1) {
                        this.oneByte = true;
                    }
                    if (n9 != ((StringBuilder)object2).length()) {
                        throw new IllegalStateException(stringBuilder + " vs " + object2);
                    }
                    if (n9 == 1) {
                        n8 = ((StringBuilder)object2).charAt(0);
                        for (n7 = stringBuilder.charAt(0); n7 <= n8; ++n7) {
                            this.onebyte_[n7] = true;
                        }
                        continue;
                    }
                    if (n9 == 2) {
                        n8 = Math.min(((StringBuilder)object2).charAt(0), 255);
                        for (n7 = stringBuilder.charAt(0); n7 <= n8; ++n7) {
                            this.onebyte_[n7] = false;
                        }
                        continue;
                    }
                    if (n9 == 3) continue;
                }
                b.a(pushbackInputStream);
            } else if ("beginbfchar".equals(string)) {
                n5 = ((Number)objectArray[n2 - 1]).intValue();
                for (int i3 = 0; i3 < n5; ++i3) {
                    StringBuilder stringBuilder = (StringBuilder)b.a(pushbackInputStream);
                    object2 = (StringBuilder)b.a(pushbackInputStream);
                    int n10 = this.s2i(stringBuilder)[0];
                    char[] cArray = this.s2c((CharSequence)object2);
                    if (cArray.length == 1) {
                        int n11 = n10 >> 8;
                        if (cArrayArray[n11] == null) {
                            cArrayArray[n11] = new char[256];
                        }
                        cArrayArray[n11][n10 & 0xFF] = cArray[0];
                        continue;
                    }
                    if (this.fromSelStr == null) {
                        this.fromSelStr = new StringBuilder[256];
                    }
                    this.fromSelStr[n10 & 0xFF] = new StringBuilder().append(cArray);
                }
                b.a(pushbackInputStream);
            } else if ("beginbfrange".equals(string)) {
                n5 = ((Number)objectArray[n2 - 1]).intValue();
                for (int i4 = 0; i4 < n5; ++i4) {
                    char[] cArray;
                    Object object3 = b.a(pushbackInputStream);
                    object2 = b.a(pushbackInputStream);
                    if (!(object3 instanceof StringBuilder) || !(object2 instanceof StringBuilder)) break;
                    StringBuilder stringBuilder = (StringBuilder)object3;
                    StringBuilder stringBuilder2 = (StringBuilder)object2;
                    Object object4 = b.a(pushbackInputStream);
                    n4 = this.s2i(stringBuilder)[0];
                    n3 = this.s2i(stringBuilder2)[0];
                    if (b.c == object4.getClass()) {
                        cArray = this.s2c((StringBuilder)object4);
                        char c2 = '\u0000';
                        if (cArray.length > 0) {
                            c2 = cArray[0];
                        }
                        while (n4 <= n3) {
                            int n12 = n4 >> 8;
                            if (cArrayArray[n12] == null) {
                                cArrayArray[n12] = new char[256];
                            }
                            cArrayArray[n12][n4 & 0xFF] = c2;
                            ++n4;
                            c2 = (char)(c2 + '\u0001');
                        }
                        continue;
                    }
                    if ("[".equals(object4)) {
                        while (!"]".equals(object) && (object4 = b.a(pushbackInputStream)) instanceof StringBuilder) {
                            cArray = this.s2c((StringBuilder)object4);
                            if (this.fromSelStr == null) {
                                this.fromSelStr = new StringBuilder[256];
                            }
                            this.fromSelStr[n4 & 0xFF] = new StringBuilder().append(cArray);
                            ++n4;
                        }
                        continue;
                    }
                    if (!logger.isLoggable(Level.SEVERE)) continue;
                    logger.severe("Error parsing CMAP file ");
                }
                b.a(pushbackInputStream);
            } else if ("begincidrange".equals(string)) {
                n5 = ((Number)objectArray[n2 - 1]).intValue();
                for (int i5 = 0; i5 < n5; ++i5) {
                    StringBuilder stringBuilder = (StringBuilder)b.a(pushbackInputStream);
                    object2 = (StringBuilder)b.a(pushbackInputStream);
                    Object object5 = b.a(pushbackInputStream);
                    int n13 = this.s2i(stringBuilder)[0];
                    int n14 = this.s2i((CharSequence)object2)[0];
                    n4 = (char)((Number)object5).intValue();
                    while (n13 <= n14) {
                        n3 = n13 >> 8;
                        if (cArrayArray[n3] == null) {
                            cArrayArray[n3] = new char[256];
                        }
                        cArrayArray[n3][n13 & 0xFF] = n4;
                        ++n13;
                        n4 = (char)(n4 + 1);
                    }
                }
                b.a(pushbackInputStream);
            } else if ("beginnotdefrange".equals(string)) {
                n5 = ((Number)objectArray[n2 - 1]).intValue();
                for (int i6 = 0; i6 < n5; ++i6) {
                    StringBuilder stringBuilder = (StringBuilder)b.a(pushbackInputStream);
                    object2 = (StringBuilder)b.a(pushbackInputStream);
                    Object object6 = b.a(pushbackInputStream);
                    int n15 = this.s2i(stringBuilder)[0];
                    int n16 = this.s2i((CharSequence)object2)[0];
                    n4 = (char)((Number)object6).intValue();
                }
                b.a(pushbackInputStream);
            } else if (!"begincmap".equals(string)) {
                if ("endmap".equals(string)) break;
                if ("usecmap".equals(string)) {
                    if (this.usecmap_ != null) {
                        throw new IllegalStateException();
                    }
                    this.usecmap_ = CMap.getInstance((String)objectArray[n2 - 1]);
                } else if ("[".equals(string)) {
                    ArrayList<Object> arrayList = new ArrayList<Object>(10);
                    n5 = 1;
                    for (int i7 = 0; n5 > 0 && i7 < 10; ++i7) {
                        object = b.a(pushbackInputStream);
                        if ("]".equals(object)) {
                            if (--n5 <= 0) continue;
                            arrayList.add(object);
                            continue;
                        }
                        arrayList.add(object);
                    }
                    objectArray[n2++] = arrayList;
                    n6 = n2;
                }
            }
            n2 = n6;
        }
        pushbackInputStream.close();
        this.compact(cArrayArray);
    }

    private int[] s2i(CharSequence charSequence) {
        int[] nArray = new int[charSequence.length()];
        int n2 = 0;
        int n3 = 0;
        int n4 = charSequence.length();
        while (n3 < n4) {
            char c2;
            if (this.onebyte_[c2 = charSequence.charAt(n3++)]) {
                nArray[n2++] = c2;
                continue;
            }
            if (n3 == n4) {
                nArray[n2++] = c2;
                this.onebyte_[c2] = true;
                continue;
            }
            nArray[n2++] = c2 << 8 | charSequence.charAt(n3++);
        }
        return a.a(nArray, n2);
    }

    private char[] s2c(CharSequence charSequence) {
        if (charSequence == null && charSequence.length() % 2 != 0) {
            throw new IllegalArgumentException();
        }
        int n2 = charSequence.length();
        char[] cArray = new char[n2 / 2];
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2 - 1) {
            cArray[n4] = (char)(charSequence.charAt(n3) << 8 | charSequence.charAt(n3 + 1));
            n3 += 2;
            ++n4;
        }
        return cArray;
    }

    public static CMap getInstance(String string) {
        CMap cMap = null;
        if ("Identity".equals(string)) {
            cMap = IDENTITY;
        } else if ("Identity-H".equals(string)) {
            cMap = IDENTITY_H;
        } else if ("Identity-V".equals(string)) {
            cMap = IDENTITY_V;
        } else {
            SoftReference softReference = (SoftReference)cache_.get(string);
            if (softReference == null || (cMap = (CMap)softReference.get()) == null) {
                InputStream inputStream = CMap.class.getResourceAsStream("/org/icepdf/core/pobjects/fonts/nfont/cmap/" + string);
                if (inputStream != null) {
                    try {
                        if (logger.isLoggable(Level.FINER)) {
                            logger.finer("Loading CMAP file " + string);
                        }
                        cMap = new CMap(inputStream);
                        if (cMap.toSel_ == null) {
                            throw new IllegalStateException(string);
                        }
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        logger.log(Level.FINE, "Error getting cmap instance", iOException);
                        cMap = IDENTITY;
                    }
                    catch (Throwable throwable) {
                        logger.log(Level.FINE, "error reading cmap file " + string, throwable);
                    }
                    cache_.put(string, new SoftReference<CMap>(cMap));
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer("Successfully loaded CMAP file " + string);
                    }
                } else {
                    cMap = null;
                }
            }
        }
        return cMap;
    }

    public CMap reverse() {
        return new e(this);
    }

    private void compact(char[][] cArray) {
        int n2 = 0;
        int n3 = cArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (cArray[i2] == null) continue;
            ++n2;
        }
        char[][] cArrayArray = new char[n2][];
        int[] nArray = new int[n2];
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            if (cArray[n4] != null) {
                cArrayArray[n5] = cArray[n4];
                char[] cArray2 = cArrayArray[n5];
                int n6 = cArray2.length;
                if (n6 > 3) {
                    int n7;
                    int n8;
                    char c2;
                    if (cArray2[0] == cArray2[1]) {
                        c2 = cArray2[0];
                        n8 = 1;
                        for (n7 = 2; n7 < n6; ++n7) {
                            if (cArray2[n7] == c2) continue;
                            n8 = 0;
                            break;
                        }
                        if (n8 != 0) {
                            cArrayArray[n5] = new char[]{c2};
                        }
                    } else if ((cArray2[0] & 0xFFFF00) == (cArray2[1] & 0xFFFF00) && cArray2[1] - cArray2[0] == 1) {
                        c2 = '\u0001';
                        n8 = cArray2[0] & 0xFFFF00;
                        n7 = cArray2[0];
                        for (int i3 = 2; i3 < n6; ++i3) {
                            if ((cArray2[i3] & 0xFFFF00) == n8 && cArray2[i3] - n7 == i3) continue;
                            c2 = '\u0000';
                            break;
                        }
                        if (c2 != '\u0000') {
                            // empty if block
                        }
                    }
                }
                nArray[n5] = n4 << 8;
                ++n5;
            }
            ++n4;
        }
        this.toSel_ = cArrayArray;
        this.first_ = nArray;
    }

    public String toSelector(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (this.onebyte_ != null && !this.onebyte_[c2] && i2 + 1 < n2) {
                c2 = (char)(c2 << 8 | string.charAt(++i2));
            }
            stringBuilder.append(this.toSelector(c2));
        }
        return stringBuilder.toString();
    }

    public char toSelector(char c2) {
        char c3 = this.translate(c2, this.toSel_, this.first_);
        return c3 != '\u0000' || this.usecmap_ == null ? c3 : this.usecmap_.toSelector(c2);
    }

    public char toSelector(char c2, boolean bl2) {
        char c3 = this.translate(c2, this.toSel_, this.first_);
        return c3 != '\u0000' || this.usecmap_ == null ? c3 : this.usecmap_.toSelector(c2, bl2);
    }

    public String toUnicode(char c2) {
        StringBuilder stringBuilder;
        char c3 = this.translate(c2, this.toSel_, this.first_);
        if (c3 == '\u0000' && this.fromSelStr != null && (stringBuilder = this.fromSelStr[c2 & 0xFF]) != null) {
            return stringBuilder.toString();
        }
        if (c3 != '\u0000' || this.usecmap_ == null) {
            if (c3 < '\ufb07' && LIGATURE_MAP[c3] != null) {
                return LIGATURE_MAP[c3];
            }
            return String.valueOf(c3);
        }
        c2 = this.usecmap_.toSelector(c2);
        return String.valueOf(c2);
    }

    private char translate(int n2, char[][] cArray, int[] nArray) {
        char c2 = '\u0000';
        int n3 = cArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            char[] cArray2 = cArray[i2];
            int n4 = cArray2.length;
            if (n2 >= nArray[i2] + n4) continue;
            if (n4 == 1) {
                c2 = cArray2[0];
                break;
            }
            if (n4 == 2) {
                c2 = (char)(i2 + cArray2[0]);
                break;
            }
            c2 = cArray2[n2 & 0xFF];
            break;
        }
        return c2;
    }

    public String fromSelector(String string) {
        this.invert(true);
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = this.fromSelector(string.charAt(i2));
            if (!(this.onebyte_ == null || (c2 & 0xFF00) == 0 && this.onebyte_[c2])) {
                stringBuilder.append((char)(c2 >> 8)).append((char)(c2 & 0xFF));
                continue;
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    public char fromSelector(char c2) {
        return this.fromSelector(c2, false);
    }

    public char fromSelector(char c2, boolean bl2) {
        this.invert(bl2);
        char c3 = this.translate(c2, this.fromSel_, this.firstfrom_);
        return c3 != '\u0000' || this.usecmap_ == null ? c3 : this.usecmap_.fromSelector(c2);
    }

    private void invert(boolean bl2) {
        int n2;
        char c2;
        int n3;
        int n4;
        char[] cArray;
        int n5;
        int n6;
        int n7;
        if (this.fromSel_ != null) {
            return;
        }
        char[][] cArrayArray = new char[256][];
        int n8 = 0;
        if (bl2) {
            n7 = this.toSel_.length;
            for (n6 = 0; n6 < n7; ++n6) {
                n5 = this.first_[n6];
                cArray = this.toSel_[n6];
                n4 = cArray.length;
                for (n3 = 0; n3 < n4; ++n3) {
                    c2 = cArray[n3];
                    if (c2 == '\u0000') continue;
                    n2 = c2 >> 8;
                    if (cArrayArray[n2] == null) {
                        cArrayArray[n2] = new char[256];
                        ++n8;
                    }
                    cArrayArray[n2][c2 & 0xFF] = (char)(n5 | n3);
                }
            }
        } else {
            n7 = this.toSel_.length;
            for (n6 = 0; n6 < n7; ++n6) {
                n5 = this.first_[n6];
                cArray = this.toSel_[n6];
                n4 = cArray.length;
                for (n3 = 0; n3 < n4; ++n3) {
                    c2 = cArray[n3];
                    if (c2 == '\u0000') continue;
                    n2 = n3 >> 8;
                    if (cArrayArray[n2] == null) {
                        cArrayArray[n2] = new char[256];
                        ++n8;
                    }
                    cArrayArray[n2][n3 & 0xFF] = (char)(n5 | c2);
                }
            }
        }
        char[][] cArrayArray2 = new char[n8][];
        int[] nArray = new int[n8];
        n5 = 0;
        int n9 = 0;
        while (n9 < n8) {
            if (cArrayArray[n5] != null) {
                cArrayArray2[n9] = cArrayArray[n5];
                nArray[n9] = n5 << 8;
                ++n9;
            }
            ++n5;
        }
        this.fromSel_ = cArrayArray2;
        this.firstfrom_ = nArray;
    }

    static {
        CMap.LIGATURE_MAP[7531] = "ue";
        CMap.LIGATURE_MAP[6425] = "ff";
        CMap.LIGATURE_MAP[64257] = "fi";
        CMap.LIGATURE_MAP[64258] = "fl";
        CMap.LIGATURE_MAP[64259] = "ffi";
        CMap.LIGATURE_MAP[64260] = "ffl";
        CMap.LIGATURE_MAP[64261] = "?t";
        CMap.LIGATURE_MAP[64262] = "st";
        CMap.LIGATURE_MAP[306] = "IJ";
        CMap.LIGATURE_MAP[307] = "ij";
        CMap.LIGATURE_MAP[198] = "AE";
        CMap.LIGATURE_MAP[230] = "ae";
        CMap.LIGATURE_MAP[152] = "OE";
        CMap.LIGATURE_MAP[153] = "oe";
    }
}

