/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.geometra.gui.panels.sun;

import java.awt.Color;
import java.awt.Dimension;
import javax.swing.UIManager;
import se.sjobeck.geometra.gui.panels.sun.ProjectColors;
import se.sjobeck.geometra.gui.panels.sun.SwatchPanel;

class RecentSwatchPanel
extends SwatchPanel {
    private static final long serialVersionUID = 1L;
    private ProjectColors projectColors = new ProjectColors();

    RecentSwatchPanel() {
    }

    @Override
    protected void initValues() {
        this.swatchSize = new Dimension(20, 20);
        this.numSwatches = new Dimension(5, 7);
        this.gap = new Dimension(1, 1);
    }

    @Override
    protected void initColors() {
        Color[] loadColors;
        Color defaultRecentColor = UIManager.getColor("ColorChooser.swatchesDefaultRecentColor");
        int numColors = this.numSwatches.width * this.numSwatches.height;
        this.colors = new Color[numColors];
        for (int i = 0; i < numColors; ++i) {
            this.colors[i] = defaultRecentColor;
        }
        if (this.projectColors == null) {
            this.projectColors = new ProjectColors();
        }
        if ((loadColors = this.projectColors.getColors()) != null) {
            for (Color c : loadColors) {
                this.setMostRecentColor(c);
            }
        }
    }

    public void setMostRecentColor(Color c) {
        System.arraycopy(this.colors, 0, this.colors, 1, this.colors.length - 1);
        this.colors[0] = c;
        this.repaint();
        this.projectColors.setColors(this.colors);
    }
}

