/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.geometra.gui.panels.export;

import java.awt.Component;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.icepdf.ri.common.views.painting.drawings.GeometraDrawing;
import se.sjobeck.geometra.datastructures.blueprint.IcePDFBlueprint;
import se.sjobeck.geometra.datastructures.blueprint.IcePDFPage;
import se.sjobeck.geometra.datastructures.drawings.DotDrawing;
import se.sjobeck.geometra.datastructures.drawings.DotDrawingContainer;
import se.sjobeck.geometra.datastructures.drawings.GeometraScale;
import se.sjobeck.geometra.datastructures.drawings.HoleDrawing;
import se.sjobeck.geometra.datastructures.drawings.LineDrawing;
import se.sjobeck.geometra.datastructures.drawings.SmartDrawing;
import se.sjobeck.geometra.datastructures.drawings.SquareDrawing;
import se.sjobeck.geometra.datastructures.drawings.TotalDrawing;
import se.sjobeck.geometra.export.ExportListener;
import se.sjobeck.geometra.export.StructuredExport;
import se.sjobeck.geometra.gui.main.Geometra;
import se.sjobeck.geometra.gui.panels.export.NamnRadNode;
import se.sjobeck.geometra.gui.panels.export.Node;
import se.sjobeck.geometra.gui.panels.export.SidaKolumnRadNode;
import se.sjobeck.geometra.gui.panels.export.VardeRadNode;
import se.sjobeck.gui.DialogCreator;

public class TextExporter
implements ExportListener {
    private static final TextExporter te = new TextExporter();

    public String toString() {
        return "Export to txt file";
    }

    public static TextExporter getInstance() {
        return te;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void export(List<GeometraDrawing> values, StructuredExport export) {
        JFileChooser jfc = new JFileChooser();
        FileFilter ff = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().toLowerCase().endsWith(".txt");
            }

            @Override
            public String getDescription() {
                return "txt";
            }
        };
        jfc.addChoosableFileFilter(ff);
        int returnVal = jfc.showSaveDialog(Geometra.GEOMETRA_FRAME);
        if (returnVal == 0) {
            String message;
            String title;
            File selectedFile = jfc.getSelectedFile();
            if (!selectedFile.getName().toLowerCase().endsWith(".txt")) {
                try {
                    selectedFile = new File(selectedFile.getCanonicalPath() + ".txt");
                }
                catch (IOException ex) {
                    Logger.getLogger(TextExporter.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (selectedFile.exists()) {
                title = ResourceBundle.getBundle("se/sjobeck/Geometra").getString("TITLE_QUESTION_TEXT_EXPORTER");
                message = ResourceBundle.getBundle("se/sjobeck/Geometra").getString("MESSAGE_QUESTION_TEXT_EXPORTER");
                boolean showConfirm = DialogCreator.showConfirm((Component)Geometra.GEOMETRA_FRAME, (Object)message, (String)title);
                if (!showConfirm) {
                    return;
                }
            }
            if (values != null) {
                GrundNode gn = new GrundNode();
                HashMap<IcePDFPage, Node> map = new HashMap<IcePDFPage, Node>();
                for (GeometraDrawing tp : values) {
                    SidaKolumnRadNode skrn;
                    GeometraDrawing lastPathComponent = tp;
                    if (lastPathComponent instanceof TotalDrawing) {
                        TotalDrawing drawing = (TotalDrawing)lastPathComponent;
                        skrn = new SidaKolumnRadNode(drawing.getDescription(), export);
                        VardeRadNode vrn = new VardeRadNode(drawing.getDescription(), drawing, export);
                        skrn.addNode(vrn);
                        gn.addNode(skrn);
                        continue;
                    }
                    if (lastPathComponent instanceof SmartDrawing) {
                        this.adddrawing(gn, lastPathComponent, map, export);
                        continue;
                    }
                    if (lastPathComponent instanceof SquareDrawing) {
                        this.adddrawing(gn, lastPathComponent, map, export);
                        continue;
                    }
                    if (lastPathComponent instanceof HoleDrawing) {
                        this.adddrawing(gn, lastPathComponent, map, export);
                        continue;
                    }
                    if (lastPathComponent instanceof LineDrawing) {
                        this.adddrawing(gn, lastPathComponent, map, export);
                        continue;
                    }
                    if (lastPathComponent instanceof DotDrawing) {
                        this.adddrawing(gn, lastPathComponent, map, export);
                        continue;
                    }
                    if (lastPathComponent instanceof DotDrawingContainer) {
                        this.adddrawing(gn, lastPathComponent, map, export);
                        continue;
                    }
                    if (lastPathComponent instanceof IcePDFBlueprint) {
                        IcePDFBlueprint ipdfb = (IcePDFBlueprint)lastPathComponent;
                        NamnRadNode nrn = new NamnRadNode(ipdfb.getDescription());
                        gn.addNode(nrn);
                        for (int i = 0; i < ipdfb.getNumberOfPages(); ++i) {
                            IcePDFPage page = ipdfb.getPage(i);
                            SidaKolumnRadNode skrn2 = new SidaKolumnRadNode(page.getDescription(), export);
                            nrn.addNode(skrn2);
                            for (int j = 0; j < page.getNumberOfDrawings(); ++j) {
                                GeometraDrawing drawing = page.getDrawing(j);
                                if (drawing instanceof GeometraScale) continue;
                                VardeRadNode vrn = new VardeRadNode(drawing.getDescription(), drawing, export);
                                skrn2.addNode(vrn);
                            }
                        }
                        continue;
                    }
                    if (lastPathComponent instanceof IcePDFPage) {
                        IcePDFPage page = (IcePDFPage)lastPathComponent;
                        skrn = new SidaKolumnRadNode(page.getDescription(), export);
                        gn.addNode(skrn);
                        for (int j = 0; j < page.getNumberOfDrawings(); ++j) {
                            GeometraDrawing drawing = page.getDrawing(j);
                            if (drawing instanceof GeometraScale) continue;
                            VardeRadNode vrn = new VardeRadNode(drawing.getDescription(), drawing, export);
                            skrn.addNode(vrn);
                        }
                        continue;
                    }
                    if (!(lastPathComponent instanceof GeometraScale)) continue;
                }
                int k = gn.getNbrOfSemiColon();
                String toString = gn.toString(k);
                BufferedWriter out = null;
                try {
                    out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(selectedFile), "UTF8"));
                    out.write(toString, 0, toString.length());
                }
                catch (FileNotFoundException ex) {
                    Logger.getLogger(TextExporter.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (UnsupportedEncodingException ex) {
                    Logger.getLogger(TextExporter.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (IOException ex) {
                    Logger.getLogger(TextExporter.class.getName()).log(Level.SEVERE, null, ex);
                }
                finally {
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException ex) {
                            Logger.getLogger(TextExporter.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                }
            } else {
                title = ResourceBundle.getBundle("se/sjobeck/Geometra").getString("TITLE_MARK_IN_THE_TREE");
                message = ResourceBundle.getBundle("se/sjobeck/Geometra").getString("MESSAGE_MARK_IN_THE_TREE");
                DialogCreator.showInformation((Component)Geometra.GEOMETRA_FRAME, (Object)message, (String)title);
            }
        }
    }

    private TextExporter() {
    }

    private void adddrawing(GrundNode gn, GeometraDrawing geometraDrawing, Map<IcePDFPage, Node> map, StructuredExport export) {
        IcePDFPage bp = (IcePDFPage)geometraDrawing.getParent();
        if (map.containsKey(bp)) {
            Node get = map.get(bp);
            VardeRadNode vrn = new VardeRadNode(geometraDrawing.getDescription(), geometraDrawing, export);
            get.addNode(vrn);
        } else {
            SidaKolumnRadNode skrn = new SidaKolumnRadNode(bp.getDescription(), export);
            map.put(bp, skrn);
            VardeRadNode vrn = new VardeRadNode(geometraDrawing.getDescription(), geometraDrawing, export);
            skrn.addNode(vrn);
            gn.addNode(skrn);
        }
    }

    protected int nbrOfSemiColon(String name) {
        int k = 0;
        for (int i = 0; i < name.length(); ++i) {
            if (name.charAt(i) != ';') continue;
            ++k;
        }
        return k;
    }

    private class GrundNode
    extends Node {
        private GrundNode() {
        }

        @Override
        public int getNbrOfSemiColon() {
            int temp = 0;
            for (Node node : this.vn) {
                if (node.getNbrOfSemiColon() <= temp) continue;
                temp = node.getNbrOfSemiColon();
            }
            return temp;
        }

        @Override
        public String toString(int nbrOfExtraSemiColon) {
            String temp = "";
            for (Node node : this.vn) {
                temp = temp + node.toString(nbrOfExtraSemiColon);
            }
            return temp;
        }
    }
}

