/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.geometra.gui.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import se.sjobeck.GeometraConfiguration;
import se.sjobeck.geometra.datastructures.blueprint.TabManager;
import se.sjobeck.geometra.gui.main.Geometra;
import se.sjobeck.geometra.gui.main.GeometraMenu;
import se.sjobeck.geometra.gui.panels.ButtonPane;
import se.sjobeck.geometra.gui.panels.DoStuffWithServerProgressBar;
import se.sjobeck.geometra.gui.panels.InfoPanel;
import se.sjobeck.geometra.gui.panels.JListProjectPane;
import se.sjobeck.geometra.gui.panels.JTreePDFPane;
import se.sjobeck.geometra.gui.panels.SortingPanel;
import se.sjobeck.geometra.gui.panels.ToolbarDimensions2;
import se.sjobeck.gui.DialogCreator;
import se.sjobeck.images.IconLoader;
import se.sjobeck.network2.ClientThread;
import se.sjobeck.network2.FromServerMessage;
import se.sjobeck.network2.Message;
import se.sjobeck.util.StaticHelpers;
import se.sjobeck.versiontracker.NeedToBeReloadedException;
import se.sjobeck.versiontracker.VersionTracker;
import se.sjobeck.versiontracker.VersionTrackerFactory;

public class TreeTab
extends JTabbedPane {
    private static final long serialVersionUID = 1L;
    private final JListProjectPane jlProjectPane;
    private final JTreePDFPane treePane;
    private final JPanel workPanel = new JPanel(new BorderLayout());
    private final JList server_jlist = new JList();
    private final JScrollPane jsp;
    private final TreeTab tt = this;
    static final ImageIcon project_png = IconLoader.getIcon((String)"/se/sjobeck/geometra/gui/panels/icons/project.png");
    private JMenuItem jmi_server_load;
    private JMenuItem jmi_server_delete;
    private JMenuItem jmi_client_send;
    private JMenuItem jmi_client_update;
    private JMenuItem jmi_server_sync;
    private JMenuItem jmi_client_sync;
    public static final Icon DeleteIcon = IconLoader.getIcon((String)"/org/tangoProject/small/user-trash.png");
    public static final Icon SyncIcon = IconLoader.getIcon((String)"/org/tangoProject/small/network-transmit-receive.png");
    private ActionListener al = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource().equals(TreeTab.this.jmi_server_load)) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Object[] selectedValues = TreeTab.this.server_jlist.getSelectedValues();
                        Vector<String> vs = new Vector<String>();
                        block5: for (Object obj : selectedValues) {
                            if (!(obj instanceof String)) continue;
                            String s = (String)obj;
                            JListProjectPane.ProjectStatus status = TreeTab.this.jlProjectPane.getStatus(s);
                            if (status == null) continue;
                            switch (status) {
                                case NEED_DOWNLOAD: {
                                    vs.add(s);
                                    continue block5;
                                }
                                case DO_NOTHING: {
                                    vs.add(s);
                                    continue block5;
                                }
                                case NEED_UPLOAD: {
                                    String message = ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DO_YOU_WANT_TO_DOWNLOAD_A_OLD_VERSION");
                                    String title = ResourceBundle.getBundle("se/sjobeck/Geometra").getString("JMI_SERVER_LOAD");
                                    int showOptionDialog = JOptionPane.showOptionDialog(TreeTab.this.tt, message, title, 0, 3, JListProjectPane.needDownloadIcon, null, null);
                                    if (showOptionDialog != 0) continue block5;
                                    vs.add(s);
                                }
                            }
                        }
                        String[] fudo = new String[vs.size()];
                        vs.toArray(fudo);
                        ProjectLoader projectLoader = new ProjectLoader(fudo);
                        projectLoader.run();
                        TreeTab.this.jlProjectPane.changepaths();
                    }
                };
                new Thread(runnable).start();
            } else if (e.getSource().equals(TreeTab.this.jmi_server_delete)) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Object[] selectedValues = TreeTab.this.server_jlist.getSelectedValues();
                        Vector<String> fudo = new Vector<String>();
                        for (Object obj : selectedValues) {
                            if (!(obj instanceof String)) continue;
                            fudo.add((String)obj);
                        }
                        String removing = ResourceBundle.getBundle("se/sjobeck/Geometra").getString("STR_CONFIRM_REMOVE");
                        for (String project : fudo) {
                            int showConfirmDialog = JOptionPane.showConfirmDialog(Geometra.GEOMETRA_FRAME, removing + " " + project, TreeTab.this.jmi_server_delete.getText(), 0);
                            if (0 != showConfirmDialog) continue;
                            Vector<String> fudo2 = new Vector<String>();
                            fudo2.add(project);
                            boolean ok = ((FromServerMessage)ClientThread.sendMessage((Message)Message.DeleteGeometraProjects, (Object[])new Object[]{fudo2})).getBoolean();
                            if (ok) continue;
                            DialogCreator.showError((Object)"Could not remove Files, please call support", (String)"Call Support");
                        }
                        TreeTab.this.checkProjectOnServer();
                        TreeTab.this.checkVersionOnServer();
                    }
                };
                new Thread(runnable).start();
            } else if (e.getSource().equals(TreeTab.this.jmi_client_send)) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Object[] selectedValues = TreeTab.this.jlProjectPane.getSelectedValues();
                        Vector<String> finafisken = new Vector<String>();
                        for (Object obj : selectedValues) {
                            if (!(obj instanceof String)) continue;
                            finafisken.add((String)obj);
                        }
                        String[] fudo = new String[finafisken.size()];
                        finafisken.toArray(fudo);
                        Runnable projectUpLoader = TreeTab.this.getProjectUpLoader(fudo);
                        projectUpLoader.run();
                        TreeTab.this.checkVersionOnServer();
                    }
                };
                new Thread(runnable).start();
            } else if (e.getSource().equals(TreeTab.this.jmi_client_update)) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Vector<String> vs = new Vector<String>();
                        Object[] selectedValues = TreeTab.this.jlProjectPane.getSelectedValues();
                        Vector<String> finafisken = new Vector<String>();
                        for (Object obj : selectedValues) {
                            if (!(obj instanceof String)) continue;
                            finafisken.add((String)obj);
                        }
                        for (String projectName : finafisken) {
                            JListProjectPane.ProjectStatus status = TreeTab.this.jlProjectPane.getStatus(projectName);
                            if (status == null) continue;
                            switch (status) {
                                case NEED_DOWNLOAD: {
                                    vs.add(projectName);
                                    break;
                                }
                                case DO_NOTHING: {
                                    vs.add(projectName);
                                    break;
                                }
                                case NEED_UPLOAD: {
                                    String message = ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DO_YOU_WANT_TO_DOWNLOAD_A_OLD_VERSION");
                                    String title = ResourceBundle.getBundle("se/sjobeck/Geometra").getString("JMI_SERVER_LOAD");
                                    int showOptionDialog = JOptionPane.showOptionDialog(TreeTab.this.tt, message, title, 0, 3, JListProjectPane.needDownloadIcon, null, null);
                                    if (showOptionDialog != 0) break;
                                    vs.add(projectName);
                                }
                            }
                        }
                        String[] s = new String[vs.size()];
                        vs.toArray(s);
                        ProjectLoader pl = new ProjectLoader(s);
                        pl.run();
                    }
                };
                new Thread(runnable).start();
            } else if (e.getSource().equals(TreeTab.this.jmi_client_sync)) {
                Runnable runnable = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object[] selectedValues = TreeTab.this.jlProjectPane.getSelectedValues();
                        if (selectedValues != null) {
                            Vector<String> finafisken = new Vector<String>();
                            for (Object obj : selectedValues) {
                                if (!(obj instanceof String)) continue;
                                finafisken.add((String)obj);
                            }
                            for (String projectName : finafisken) {
                                boolean reload = true;
                                while (reload) {
                                    reload = false;
                                    VersionTracker lvt = VersionTrackerFactory.loadVersionTracker((String)(GeometraConfiguration.getSavePath() + File.separator + projectName));
                                    lvt.getLock();
                                    try {
                                        lvt.setSynchronized(!lvt.isSynchronized());
                                        lvt.setVersion(lvt.getVersion() + 1);
                                        VersionTrackerFactory.saveVersionTracker((String)(GeometraConfiguration.getSavePath() + File.separator + projectName), (VersionTracker)lvt);
                                    }
                                    catch (NeedToBeReloadedException ev) {
                                        reload = true;
                                    }
                                    finally {
                                        lvt.relaseLock();
                                    }
                                }
                            }
                        }
                        TreeTab.this.checkVersionOnServer();
                        TreeTab.this.jlProjectPane.repaint();
                        TreeTab.this.server_jlist.repaint();
                    }
                };
                new Thread(runnable).start();
            }
        }
    };

    public TreeTab(JTreePDFPane treePane, ToolbarDimensions2 toolbarDimensions, GeometraMenu geoMenu) {
        this.jlProjectPane = new JListProjectPane(geoMenu);
        super.addTab(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("TAB_DEFAULT_PROJECT_NAME"), this.workPanel);
        super.addTab(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("STR_PROJECT"), this.jlProjectPane);
        this.jsp = new JScrollPane(this.server_jlist);
        super.addTab("Server", this.jsp);
        this.jlProjectPane.setTreeTab(this.tt);
        this.workPanel.add((Component)new JLabel(), "West");
        this.workPanel.add((Component)new JLabel(), "East");
        this.workPanel.add((Component)treePane, "Center");
        this.workPanel.add((Component)new SortingPanel(), "North");
        this.workPanel.add((Component)toolbarDimensions, "South");
        this.treePane = treePane;
        this.setParentForTree();
        this.server_jlist.setCellRenderer(new MyCellRenderer());
        this.checkProjectOnServer();
        this.checkVersionOnServer();
        this.build_popup_menus();
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (TreeTab.this.tt.getSelectedIndex() == 1) {
                    TreeTab.this.checkProjectOnServer();
                    TreeTab.this.checkVersionOnServer();
                }
                if (TreeTab.this.tt.getSelectedIndex() == 2) {
                    TreeTab.this.checkProjectOnServer();
                    TreeTab.this.checkVersionOnServer();
                }
            }
        });
        this.setPreferredSize(new Dimension(258, 120));
    }

    public static void pathsMightHaveChanged(TreeTab treetab) {
        if (treetab != null) {
            treetab.changepaths();
        }
    }

    public void changepaths() {
        this.jlProjectPane.changepaths();
        this.jlProjectPane.dumpStatus();
        this.checkProjectOnServer();
        this.checkVersionOnServer();
    }

    public void setButtonPane(ButtonPane buttonPaneNorth) {
        this.jlProjectPane.setButtonPane(buttonPaneNorth);
    }

    public void setInfoPane(InfoPanel infoPane) {
        this.jlProjectPane.setInfoPanel(infoPane);
    }

    public void doSync(boolean dointhreads, Geometra geo) {
        this.doSyncUpload(dointhreads, geo);
        this.doSyncDownload(dointhreads, geo);
    }

    private void doSyncUpload(boolean dointhreads, Geometra geo) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Vector<String> allProjectsInNeedOfUpload = TreeTab.this.jlProjectPane.getAllProjectsInNeedOfUpload();
                String[] fudo = new String[allProjectsInNeedOfUpload.size()];
                allProjectsInNeedOfUpload.toArray(fudo);
                Runnable projectUpLoader = TreeTab.this.getProjectUpLoader(fudo);
                projectUpLoader.run();
            }
        };
        if (dointhreads) {
            new Thread(runnable).start();
        } else {
            runnable.run();
        }
    }

    private void doSyncDownload(boolean dointhreads, Geometra geo) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Vector<String> allProjectsInNeedOfDownload = TreeTab.this.jlProjectPane.getAllProjectsInNeedOfDownload();
                String[] fudo = new String[allProjectsInNeedOfDownload.size()];
                allProjectsInNeedOfDownload.toArray(fudo);
                Runnable projectLoader = TreeTab.this.getProjectLoader(fudo);
                projectLoader.run();
            }
        };
        if (dointhreads) {
            new Thread(runnable).start();
        } else {
            runnable.run();
        }
    }

    private void checkVersionOnServer() {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String savePath = GeometraConfiguration.getSavePath();
                File save_path = new File(savePath);
                File[] geometra_projects_on_client = save_path.listFiles(StaticHelpers.getGeometraProjectFileFilter());
                HashMap<String, VersionTracker> version_client = new HashMap<String, VersionTracker>();
                Vector<String> projects_on_client_to_check_on_server = new Vector<String>();
                if (geometra_projects_on_client != null) {
                    for (File project : geometra_projects_on_client) {
                        try {
                            VersionTracker loadVersionTracker = VersionTrackerFactory.loadVersionTracker((String)project.getCanonicalPath());
                            version_client.put(project.getName(), loadVersionTracker);
                            projects_on_client_to_check_on_server.add(project.getName());
                        }
                        catch (IOException ex) {
                            Logger.getLogger(TreeTab.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                }
                Map version_server = ((FromServerMessage)ClientThread.sendMessage((Message)Message.GetGeometraVersionTracker, (Object[])new Object[]{projects_on_client_to_check_on_server})).getProjectToVersionTrackerMap();
                if (geometra_projects_on_client != null) {
                    block14: for (File project : geometra_projects_on_client) {
                        String project_name = project.getName();
                        int client_version = 0;
                        boolean reload = true;
                        while (reload) {
                            reload = false;
                            VersionTracker vt = (VersionTracker)version_client.get(project_name);
                            vt.getLock();
                            try {
                                client_version = vt.getVersion();
                            }
                            catch (NeedToBeReloadedException ex) {
                                try {
                                    reload = true;
                                    try {
                                        version_client.put(project_name, VersionTrackerFactory.loadVersionTracker((String)project.getCanonicalPath()));
                                    }
                                    catch (IOException ex1) {
                                        Logger.getLogger(TreeTab.class.getName()).log(Level.SEVERE, null, ex1);
                                        vt.relaseLock();
                                        continue block14;
                                    }
                                }
                                catch (Throwable throwable) {
                                    vt.relaseLock();
                                    throw throwable;
                                }
                                vt.relaseLock();
                                continue;
                            }
                            vt.relaseLock();
                        }
                        int server_version = 0;
                        reload = true;
                        while (reload) {
                            reload = false;
                            VersionTracker vt = (VersionTracker)version_server.get(project_name);
                            vt.getLock();
                            try {
                                server_version = vt.getVersion();
                            }
                            catch (NeedToBeReloadedException ex) {
                                reload = true;
                                Vector<String> groda = new Vector<String>();
                                groda.add(project_name);
                                Map new_version_server = ((FromServerMessage)ClientThread.sendMessage((Message)Message.GetGeometraVersionTracker, (Object[])new Object[]{groda})).getProjectToVersionTrackerMap();
                                VersionTracker get = (VersionTracker)new_version_server.get(project_name);
                                version_server.put(project_name, get);
                            }
                            finally {
                                vt.relaseLock();
                            }
                        }
                        if (client_version == server_version) {
                            TreeTab.this.jlProjectPane.setStatus(project_name, JListProjectPane.ProjectStatus.DO_NOTHING);
                            continue;
                        }
                        if (client_version > server_version) {
                            TreeTab.this.jlProjectPane.setStatus(project_name, JListProjectPane.ProjectStatus.NEED_UPLOAD);
                            continue;
                        }
                        if (client_version >= server_version) continue;
                        TreeTab.this.jlProjectPane.setStatus(project_name, JListProjectPane.ProjectStatus.NEED_DOWNLOAD);
                    }
                }
                Vector project_on_server = ((FromServerMessage)ClientThread.sendMessage((Message)Message.GetGeometraProjects, (Object[])new Object[0])).getVectorWithStrings();
                for (String pos : project_on_server) {
                    if (projects_on_client_to_check_on_server.contains(pos)) continue;
                    TreeTab.this.jlProjectPane.setStatus(pos, JListProjectPane.ProjectStatus.NEED_DOWNLOAD);
                }
                TreeTab.this.server_jlist.repaint();
                TreeTab.this.jlProjectPane.repaint();
            }
        };
        new Thread(runnable).start();
    }

    private void checkProjectOnServer() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Vector fudo = ((FromServerMessage)ClientThread.sendMessage((Message)Message.GetGeometraProjects, (Object[])new Object[0])).getVectorWithStrings();
                JListProjectPane.sortList(fudo);
                TreeTab.this.server_jlist.setListData(fudo);
                TreeTab.this.server_jlist.validate();
            }
        };
        new Thread(runnable).start();
    }

    private void build_popup_menus() {
        JPopupMenu pm_server = new JPopupMenu();
        this.jmi_server_load = new JMenuItem(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("JMI_SERVER_LOAD"), JListProjectPane.needDownloadIcon);
        this.jmi_server_delete = new JMenuItem(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("JMI_SERVER_DELETE"), DeleteIcon);
        pm_server.add(this.jmi_server_load);
        pm_server.add(this.jmi_server_delete);
        this.server_jlist.setComponentPopupMenu(pm_server);
        JPopupMenu pm_client = new JPopupMenu();
        this.jmi_client_send = new JMenuItem(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("JMI_CLIENT_SEND"), JListProjectPane.needUploadIcon);
        this.jmi_client_update = new JMenuItem(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("JMI_CLIENT_UPDATE"), JListProjectPane.needDownloadIcon);
        this.jmi_client_sync = new JMenuItem(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("JMI_CLIENT_SYNC"), SyncIcon);
        pm_client.add(this.jmi_client_send);
        pm_client.add(this.jmi_client_update);
        this.jlProjectPane.setComponentPopupMenuOnTheList(pm_client);
        this.jmi_server_load.addActionListener(this.al);
        this.jmi_server_delete.addActionListener(this.al);
        this.jmi_client_send.addActionListener(this.al);
        this.jmi_client_update.addActionListener(this.al);
        this.jmi_client_sync.addActionListener(this.al);
    }

    public Runnable getProjectLoader(String[] projectNames) {
        return new ProjectLoader(projectNames);
    }

    public Runnable getProjectUpLoader(String[] projectNames) {
        return new ProjectUpLoader(projectNames);
    }

    @Override
    public void addTab(String str, Component jc) {
    }

    private void setParentForTree() {
        this.treePane.setParent(this);
    }

    public void setProjectName(final String name) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TreeTab.this.jlProjectPane.repaint();
                TreeTab.this.setTitleAt(0, name);
            }
        });
    }

    public void switchFocus() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TreeTab.this.setSelectedIndex(0);
            }
        });
    }

    private class JWindow_with_JLabel_and_JProgressBar
    extends JFrame {
        private static final long serialVersionUID = 1L;
        private DoStuffWithServerProgressBar dwsp = new DoStuffWithServerProgressBar();

        JWindow_with_JLabel_and_JProgressBar(String text, Component anchor) {
            this.dwsp.setText(text);
            this.add(this.dwsp);
            this.pack();
            this.setLocationRelativeTo(anchor);
            this.setVisible(true);
        }

        private void setMax(int length) {
            this.dwsp.setMax(length);
        }

        private void setValue(int m) {
            this.dwsp.setValue(m);
        }

        public void setText2(String txt) {
            this.dwsp.setText2(txt);
        }
    }

    private class ProjectUpLoader
    implements Runnable {
        String[] projectNames;

        public ProjectUpLoader(String[] projectNames) {
            this.projectNames = projectNames;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            for (String filename : this.projectNames) {
                JWindow_with_JLabel_and_JProgressBar jwjajp = new JWindow_with_JLabel_and_JProgressBar(TreeTab.this.jmi_client_send.getText(), Geometra.GEOMETRA_FRAME);
                jwjajp.setText2(filename);
                boolean send = false;
                JListProjectPane.ProjectStatus status = TreeTab.this.jlProjectPane.getStatus(filename);
                if (status != null) {
                    switch (status) {
                        case NEED_DOWNLOAD: {
                            String message = ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DO_YOU_WANT_TO_UPLOAD_AN_OLD_VERSION");
                            String title = ResourceBundle.getBundle("se/sjobeck/Geometra").getString("JMI_CLIENT_SEND");
                            int showOptionDialog = JOptionPane.showOptionDialog(Geometra.GEOMETRA_FRAME, message, title, 0, 3, JListProjectPane.needUploadIcon, null, null);
                            if (showOptionDialog != 0) break;
                            send = true;
                            break;
                        }
                        case DO_NOTHING: {
                            send = true;
                            break;
                        }
                        case NEED_UPLOAD: {
                            send = true;
                        }
                    }
                }
                if (send) {
                    String dontSave;
                    String save;
                    Object[] options;
                    Icon icon;
                    int messageType;
                    int optionType;
                    String title;
                    String message;
                    int showOptionDialog;
                    String projectName = TabManager.getInstance().getProjectName();
                    if (projectName != null && (projectName = projectName.substring(0, projectName.length() - 4)).equals(filename) && (showOptionDialog = JOptionPane.showOptionDialog(Geometra.GEOMETRA_FRAME, message = ResourceBundle.getBundle("se/sjobeck/Geometra").getString("OPTION_SAVE_PROJECT_BEFORE_UPLOADING_TO_SERVER"), title = ResourceBundle.getBundle("se/sjobeck/Geometra").getString("OPTION_SAVE_PROJECT_TITLE"), optionType = 2, messageType = 3, icon = null, options = new String[]{save = ResourceBundle.getBundle("se/sjobeck/Geometra").getString("OPTION_SAVE_PROJECT_SAVE"), dontSave = ResourceBundle.getBundle("se/sjobeck/Geometra").getString("OPTION_SAVE_PROJECT_DONT_SAVE")}, null)) == 0) {
                        TabManager.getInstance().startSaving(null, null);
                    }
                    File file = new File(GeometraConfiguration.getSavePath() + File.separator + filename);
                    File[] directory_content = file.listFiles(StaticHelpers.getGeometraFileFilter());
                    jwjajp.setMax(directory_content.length);
                    Vector<String> doda = new Vector<String>();
                    doda.add(filename);
                    FromServerMessage fsm = (FromServerMessage)ClientThread.sendMessage((Message)Message.CreateGeometraDirectory, (Object[])new Object[]{doda});
                    boolean test_map_created = false;
                    try {
                        test_map_created = fsm.getBoolean();
                    }
                    catch (Exception e) {
                        test_map_created = false;
                    }
                    finally {
                        if (!test_map_created) {
                            System.out.println("Could not create directory on server:" + filename);
                        }
                    }
                    int m = 0;
                    for (File pdf_or_geo : directory_content) {
                        String crc1 = "" + StaticHelpers.getCRC((File)pdf_or_geo);
                        String name = pdf_or_geo.getName();
                        String crc2 = ((FromServerMessage)ClientThread.sendMessage((Message)Message.GetGeometraCRC, (Object[])new Object[]{name, filename})).getString();
                        System.out.println("file-name: " + name + " crc client: " + crc1 + " crc server: " + crc2);
                        if (!crc1.equals(crc2)) {
                            System.out.println("Crc olika uppladdning sker");
                            byte[] data = StaticHelpers.getFileContent((File)pdf_or_geo);
                            String[] tjosimos = new String[]{file.getName(), pdf_or_geo.getName()};
                            fsm = (FromServerMessage)ClientThread.sendMessage((Message)Message.SendGeometraFile, (Object[])new Object[]{tjosimos, data});
                            boolean gick_bra = false;
                            try {
                                gick_bra = fsm.getBoolean();
                            }
                            catch (Exception e) {
                                gick_bra = false;
                            }
                            finally {
                                if (!gick_bra) {
                                    DialogCreator.showError((Object)("Error while saving file:" + pdf_or_geo.getName() + "on server, please call support"), (String)"Call support");
                                }
                            }
                        }
                        jwjajp.setValue(++m);
                    }
                }
                jwjajp.setVisible(false);
                jwjajp.dispose();
            }
        }
    }

    private class ProjectLoader
    implements Runnable {
        private String[] projectNames;

        public ProjectLoader(String[] projectName) {
            this.projectNames = projectName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            JWindow_with_JLabel_and_JProgressBar jwjajp = new JWindow_with_JLabel_and_JProgressBar(TreeTab.this.jmi_server_load.getText(), Geometra.GEOMETRA_FRAME);
            for (String project_name : this.projectNames) {
                System.out.println("download project: " + project_name);
                jwjajp.setText2(project_name);
                Vector allfiles_onserver = ((FromServerMessage)ClientThread.sendMessage((Message)Message.GetGeoemtraFilesFromProject, (Object[])new Object[]{project_name})).getVectorWithStrings();
                jwjajp.setMax(allfiles_onserver.size());
                Vector<String> allfiles_onserver_crc = new Vector<String>();
                for (String file : allfiles_onserver) {
                    String crc = ((FromServerMessage)ClientThread.sendMessage((Message)Message.GetGeometraCRC, (Object[])new Object[]{file, project_name})).getString();
                    allfiles_onserver_crc.add(crc);
                }
                String savePath = GeometraConfiguration.getSavePath();
                File project_onclient = new File(savePath + File.separator + project_name);
                if (!project_onclient.exists()) {
                    project_onclient.mkdir();
                }
                Vector<String> allfiles_onclient = new Vector<String>();
                if (project_onclient.isDirectory()) {
                    File[] listFiles;
                    for (File pdf_or_geo : listFiles = project_onclient.listFiles(StaticHelpers.getGeometraFileFilter())) {
                        allfiles_onclient.add(pdf_or_geo.getName());
                    }
                }
                Vector<String> allfiles_onclient_crc = new Vector<String>();
                for (String file : allfiles_onclient) {
                    String crc = "" + StaticHelpers.getCRC((File)new File(savePath + File.separator + project_name + File.separator + file));
                    allfiles_onclient_crc.add(crc);
                }
                for (int i = 0; i < allfiles_onserver.size(); ++i) {
                    String file_onserver = (String)allfiles_onserver.get(i);
                    System.out.println("fil p\u00e5 server" + file_onserver);
                    int k = allfiles_onclient.indexOf(file_onserver);
                    boolean ladda_hem = false;
                    if (k > -1) {
                        if (!((String)allfiles_onserver_crc.get(i)).equals(allfiles_onclient_crc.get(k))) {
                            ladda_hem = true;
                        }
                    } else {
                        ladda_hem = true;
                    }
                    if (ladda_hem) {
                        byte[] inneh\u00e5ll = ((FromServerMessage)ClientThread.sendMessage((Message)Message.GetGeometraFileContent, (Object[])new Object[]{file_onserver, project_name})).getByteArray();
                        String file_onclient = savePath + File.separator + project_name + File.separator + file_onserver;
                        File f0 = new File(savePath + File.separator + project_name);
                        File f1 = new File(file_onclient);
                        VersionTracker lvt = null;
                        if (file_onserver.equals(".versiontracker")) {
                            lvt = VersionTrackerFactory.loadVersionTracker((String)(savePath + File.separator + project_name));
                            lvt.getLock();
                        }
                        RandomAccessFile raf = null;
                        try {
                            if (!f0.exists()) {
                                f0.mkdir();
                            }
                            if (!f1.exists()) {
                                f1.createNewFile();
                            }
                            raf = new RandomAccessFile(f1, "rw");
                            raf.write(inneh\u00e5ll);
                            if (lvt != null) {
                                lvt.setNeedToBeReloaded();
                            }
                        }
                        catch (FileNotFoundException ex) {
                            Logger.getLogger(TreeTab.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        catch (IOException ex) {
                            Logger.getLogger(TreeTab.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        finally {
                            if (raf != null) {
                                try {
                                    raf.close();
                                }
                                catch (IOException ex) {
                                    Logger.getLogger(TreeTab.class.getName()).log(Level.SEVERE, null, ex);
                                }
                            }
                            if (lvt != null) {
                                lvt.relaseLock();
                            }
                        }
                    }
                    jwjajp.setValue(i);
                }
            }
            jwjajp.setVisible(false);
            jwjajp.dispose();
            TreeTab.this.checkVersionOnServer();
        }
    }

    private class MyCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = 1L;

        private MyCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String s = value.toString();
            this.setText(s);
            JListProjectPane.ProjectStatus status = TreeTab.this.jlProjectPane.getStatus(s);
            if (status == null) {
                this.setIcon(project_png);
            } else {
                switch (status) {
                    case NEED_DOWNLOAD: {
                        this.setIcon(JListProjectPane.needDownloadIcon);
                        break;
                    }
                    case DO_NOTHING: {
                        this.setIcon(project_png);
                        break;
                    }
                    case NEED_UPLOAD: {
                        this.setIcon(project_png);
                    }
                }
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }
}

