/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.geometra.gui.panels;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import se.sjobeck.geometra.datastructures.blueprint.IcePDFBlueprint;
import se.sjobeck.geometra.datastructures.blueprint.PDFController;
import se.sjobeck.geometra.datastructures.blueprint.PDFLoader;
import se.sjobeck.geometra.datastructures.drawings.GeometraDrawingImpl;
import se.sjobeck.geometra.printpdf.AbstractPDFWriter;
import se.sjobeck.geometra.printpdf.PDFWriter;
import se.sjobeck.geometra.printpdf.PrintPDF2;
import se.sjobeck.images.IconLoader;

public class SnurraPDFDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private JSlider areajSlider1;
    private JButton cancelButton;
    private JButton decrease;
    private JButton increase;
    private JButton jButton1;
    private JButton jButton2;
    private JCheckBox jCheckBox1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel5;
    private JSpinner jSpinner1;
    private JTextField jTextField1;
    private JTextField jTextField2;
    private JSlider linejSlider1;
    private JButton okButton;
    private JSlider textjSlider2;
    private int returnStatus = 0;
    private List<GeometraDrawingImpl> lgdi;
    private String inpdf;
    String outpdf;
    private AbstractPDFWriter.ROTATION rOTATION;
    private PDFWriter ppdf = new PrintPDF2();
    private PDFController pDFController = null;

    public SnurraPDFDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setPreferredSize(new Dimension(800, 600));
        this.setSize(new Dimension(800, 600));
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jButton1 = new JButton();
        this.jPanel2 = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.increase = new JButton();
        this.decrease = new JButton();
        this.jSpinner1 = new JSpinner();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jCheckBox1 = new JCheckBox();
        this.jButton2 = new JButton();
        this.jPanel3 = new JPanel();
        this.jLabel4 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jTextField2 = new JTextField();
        this.jLabel3 = new JLabel();
        this.jPanel5 = new JPanel();
        this.areajSlider1 = new JSlider();
        this.linejSlider1 = new JSlider();
        this.textjSlider2 = new JSlider();
        this.setAlwaysOnTop(true);
        this.setCursor(new Cursor(0));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                SnurraPDFDialog.this.closeDialog(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("PDF"));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 819, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 711, Short.MAX_VALUE));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.jButton1.setText(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("LABEL_PRINTPDF_ROTATE_BUTTON"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SnurraPDFDialog.this.jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.jButton1, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SnurraPDFDialog.this.okButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.okButton, gridBagConstraints);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SnurraPDFDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        this.jPanel2.add((Component)this.cancelButton, gridBagConstraints);
        this.increase.setIcon(IconLoader.getIcon((String)"/se/sjobeck/geometra/gui/panels/icons/increase.png"));
        this.increase.setToolTipText("zoom in");
        this.increase.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SnurraPDFDialog.this.increaseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.jPanel2.add((Component)this.increase, gridBagConstraints);
        this.decrease.setIcon(IconLoader.getIcon((String)"/se/sjobeck/geometra/gui/panels/icons/decrease.png"));
        this.decrease.setToolTipText("zoom out");
        this.decrease.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SnurraPDFDialog.this.decreaseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.decrease, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints);
        this.jSpinner1.setModel(new SpinnerNumberModel((Number)10, Integer.valueOf(1), null, (Number)1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        this.getContentPane().add((Component)this.jSpinner1, gridBagConstraints);
        this.jLabel1.setText(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("LABEL_PRINTPDF_TEXT_SIZE_SPINNER"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 0, 3);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setText(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("LABEL_PRINTPDF_TEXT_SIZE_CHECKBOX"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 0, 3);
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        this.getContentPane().add((Component)this.jCheckBox1, gridBagConstraints);
        this.jButton2.setText(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("LABEL_PRINTPDF_UPDATE_BUTTON"));
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SnurraPDFDialog.this.jButton2ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this.jButton2, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        this.jLabel4.setText("y offset");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        this.jPanel3.add((Component)this.jLabel4, gridBagConstraints);
        this.jTextField1.setText("0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        this.jPanel3.add((Component)this.jTextField1, gridBagConstraints);
        this.jTextField2.setText("0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        this.jPanel3.add((Component)this.jTextField2, gridBagConstraints);
        this.jLabel3.setText("x offset");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        this.jPanel3.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        this.getContentPane().add((Component)this.jPanel3, gridBagConstraints);
        this.jPanel5.setLayout(new GridBagLayout());
        this.areajSlider1.setMajorTickSpacing(10);
        this.areajSlider1.setOrientation(1);
        this.areajSlider1.setPaintLabels(true);
        this.areajSlider1.setPaintTicks(true);
        this.areajSlider1.setValue(30);
        this.areajSlider1.setBorder(BorderFactory.createTitledBorder(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("LABEL_PRINTPDF_AREASLIDER")));
        this.areajSlider1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                SnurraPDFDialog.this.areajSlider1MouseReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.jPanel5.add((Component)this.areajSlider1, gridBagConstraints);
        this.linejSlider1.setMajorTickSpacing(10);
        this.linejSlider1.setOrientation(1);
        this.linejSlider1.setPaintLabels(true);
        this.linejSlider1.setPaintTicks(true);
        this.linejSlider1.setValue(70);
        this.linejSlider1.setBorder(BorderFactory.createTitledBorder(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("LABEL_PRINTPDF_LINESLIDER")));
        this.linejSlider1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                SnurraPDFDialog.this.linejSlider1MouseReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        this.jPanel5.add((Component)this.linejSlider1, gridBagConstraints);
        this.textjSlider2.setMajorTickSpacing(10);
        this.textjSlider2.setOrientation(1);
        this.textjSlider2.setPaintLabels(true);
        this.textjSlider2.setPaintTicks(true);
        this.textjSlider2.setValue(99);
        this.textjSlider2.setBorder(BorderFactory.createTitledBorder(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("LABEL_PRINTPDF_TEXTSLIDER")));
        this.textjSlider2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                SnurraPDFDialog.this.textjSlider2MouseReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        this.jPanel5.add((Component)this.textjSlider2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jPanel5, gridBagConstraints);
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.doClose(1);
        this.desktopOpenFile(this.outpdf);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.doClose(0);
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(0);
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        switch (this.rOTATION) {
            case LowerLeft: {
                this.rOTATION = AbstractPDFWriter.ROTATION.LowerRight;
                break;
            }
            case LowerRight: {
                this.rOTATION = AbstractPDFWriter.ROTATION.UpperLeft;
                break;
            }
            case UpperLeft: {
                this.rOTATION = AbstractPDFWriter.ROTATION.UpperRight;
                break;
            }
            case UpperRight: {
                this.rOTATION = AbstractPDFWriter.ROTATION.MirrorLowerLeft;
                break;
            }
            case MirrorLowerLeft: {
                this.rOTATION = AbstractPDFWriter.ROTATION.MirrorLowerRight;
                break;
            }
            case MirrorLowerRight: {
                this.rOTATION = AbstractPDFWriter.ROTATION.MirrorUpperLeft;
                break;
            }
            case MirrorUpperLeft: {
                this.rOTATION = AbstractPDFWriter.ROTATION.MirrorUpperRight;
                break;
            }
            case MirrorUpperRight: {
                this.rOTATION = AbstractPDFWriter.ROTATION.LowerLeft;
            }
        }
        this.show_new_pdf();
    }

    private void areajSlider1MouseReleased(MouseEvent evt) {
        this.show_new_pdf();
    }

    private void linejSlider1MouseReleased(MouseEvent evt) {
        this.show_new_pdf();
    }

    private void textjSlider2MouseReleased(MouseEvent evt) {
        this.show_new_pdf();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.show_new_pdf();
    }

    private void decreaseActionPerformed(ActionEvent evt) {
        this.pDFController.setZoomOut();
    }

    private void increaseActionPerformed(ActionEvent evt) {
        this.pDFController.setZoomIn();
    }

    private void doClose(int retStatus) {
        this.returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
    }

    private void desktopOpenFile(String ef) {
        File exportFile = new File(ef);
        try {
            Desktop.getDesktop().open(exportFile);
        }
        catch (IOException e) {
            System.out.println("Du har inget program accosierat med filer av typen: " + exportFile);
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                SnurraPDFDialog dialog = new SnurraPDFDialog((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    public void set_a_lot_of_stuff(List<GeometraDrawingImpl> lgdi, String inpdf, String outpdf, AbstractPDFWriter.ROTATION rOTATION) {
        this.lgdi = lgdi;
        this.inpdf = inpdf;
        this.outpdf = outpdf;
        this.rOTATION = rOTATION;
        this.show_new_pdf();
        this.setSize(this.getPreferredSize());
    }

    private synchronized void show_new_pdf() {
        this.jButton1.setEnabled(false);
        this.areajSlider1.setEnabled(false);
        this.linejSlider1.setEnabled(false);
        this.textjSlider2.setEnabled(false);
        int area_opacity = this.areajSlider1.getValue();
        int text_opacity = this.textjSlider2.getValue();
        int line_opacity = this.linejSlider1.getValue();
        int textSize = (Integer)this.jSpinner1.getValue();
        System.out.println(this.jCheckBox1.isSelected());
        boolean nurSchwartz = this.jCheckBox1.isSelected();
        int x_offset = 0;
        try {
            x_offset = Integer.parseInt(this.jTextField1.getText());
        }
        catch (Exception e) {
            this.jTextField1.setText("0");
        }
        int y_offset = 0;
        try {
            y_offset = Integer.parseInt(this.jTextField2.getText());
        }
        catch (Exception e) {
            this.jTextField2.setText("0");
        }
        this.ppdf.setOpacity(area_opacity, line_opacity, text_opacity, textSize, nurSchwartz);
        this.ppdf.setOffset(x_offset, y_offset);
        this.ppdf.printPDF_pages_only(this.lgdi, this.inpdf, this.outpdf, this.rOTATION);
        this.dont_forget_to_dispose_the_last_shown_pdf();
        System.gc();
        this.jPanel1.removeAll();
        this.jPanel1.setLayout(new GridLayout(1, 1));
        IcePDFBlueprint loadPDF = PDFLoader.loadPDF(new File(this.outpdf));
        this.pDFController = loadPDF.getPDFController();
        this.pDFController.setZoom(0.005f);
        final Container viewContainer = this.pDFController.getViewContainer();
        Timer timer = new Timer(this.rOTATION.toString());
        TimerTask tt = new TimerTask(){

            @Override
            public void run() {
                if (viewContainer.isShowing()) {
                    SnurraPDFDialog.this.jButton1.setEnabled(true);
                    SnurraPDFDialog.this.areajSlider1.setEnabled(true);
                    SnurraPDFDialog.this.linejSlider1.setEnabled(true);
                    SnurraPDFDialog.this.textjSlider2.setEnabled(true);
                    this.cancel();
                }
            }
        };
        this.jPanel1.add(viewContainer);
        this.jPanel1.revalidate();
        this.jPanel1.repaint();
        viewContainer.repaint();
        viewContainer.validate();
        timer.scheduleAtFixedRate(tt, 3000L, 750L);
    }

    public void dont_forget_to_dispose_the_last_shown_pdf() {
        if (this.pDFController != null) {
            this.pDFController.dispose();
        }
    }
}

