/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.geometra.gui.panels;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import se.sjobeck.geometra.export.ExportSchema;
import se.sjobeck.images.IconLoader;

public class OrderChooser
extends JPanel {
    private static final long serialVersionUID = 1L;
    InnerPanel[] ip_vec = new InnerPanel[7];
    boolean vertical = true;
    boolean keepFormulas = false;
    boolean pageNameVisible = true;
    boolean headerVisible = true;
    boolean drawingNameVisible = true;
    String deci = ".";
    JLabel pdfName;
    private ImageIcon right_icon = IconLoader.getIcon((String)"/org/tangoProject/medium/go-next.png");
    private ImageIcon left_icon = IconLoader.getIcon((String)"/org/tangoProject/medium/go-previous.png");
    private ImageIcon up_icon = IconLoader.getIcon((String)"/org/tangoProject/medium/go-up.png");
    private ImageIcon down_icon = IconLoader.getIcon((String)"/org/tangoProject/medium/go-down.png");

    public void deActivate(boolean b) {
        for (InnerPanel ip : this.ip_vec) {
            ip.hideButtons(b);
        }
    }

    public void setRowOrder(ExportSchema.Row[] rowOrder) {
        InnerPanel[] ip = new InnerPanel[rowOrder.length];
        for (int i = 0; i < ip.length; ++i) {
            ip[i] = this.find(rowOrder[i]);
        }
        this.ip_vec = ip;
        this.buildMe();
    }

    private InnerPanel find(ExportSchema.Row row) {
        InnerPanel temp = this.ip_vec[0];
        for (int i = 0; i < this.ip_vec.length; ++i) {
            if (!this.ip_vec[i].getRow().equals((Object)row)) continue;
            temp = this.ip_vec[i];
        }
        return temp;
    }

    public OrderChooser() {
        this.pdfName = new JLabel(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DIM_PDF_NAME")){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isOpaque() {
                return true;
            }
        };
        this.pdfName.setBackground(Color.LIGHT_GRAY);
        this.ip_vec[0] = new InnerPanel(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DIM_TITLE"), ExportSchema.Row.DRAWING_NAMES, this, this.deci, fakeStrings.RUBRIK, this.keepFormulas, this.pageNameVisible, this.headerVisible, this.drawingNameVisible);
        this.ip_vec[1] = new InnerPanel(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DIM_AREA"), ExportSchema.Row.AREA, this, this.deci, fakeStrings.V\u00c4RDE, this.keepFormulas, this.pageNameVisible, this.headerVisible, this.drawingNameVisible);
        this.ip_vec[2] = new InnerPanel(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DIM_HEIGHT"), ExportSchema.Row.HEIGHT, this, this.deci, fakeStrings.V\u00c4RDE, this.keepFormulas, this.pageNameVisible, this.headerVisible, this.drawingNameVisible);
        this.ip_vec[3] = new InnerPanel(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DIM_VOLUME"), ExportSchema.Row.VOLUME, this, this.deci, fakeStrings.V\u00c4RDE, this.keepFormulas, this.pageNameVisible, this.headerVisible, this.drawingNameVisible);
        this.ip_vec[4] = new InnerPanel(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DIM_WALL_SURFACE"), ExportSchema.Row.WALLSURFACE, this, this.deci, fakeStrings.V\u00c4RDE, this.keepFormulas, this.pageNameVisible, this.headerVisible, this.drawingNameVisible);
        this.ip_vec[5] = new InnerPanel(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DIM_LENGTH"), ExportSchema.Row.LENGTH, this, this.deci, fakeStrings.V\u00c4RDE, this.keepFormulas, this.pageNameVisible, this.headerVisible, this.drawingNameVisible);
        this.ip_vec[6] = new InnerPanel(ExportSchema.Row.NUMBER_OF_DRAWING.toString(), ExportSchema.Row.NUMBER_OF_DRAWING, this, this.deci, fakeStrings.ANTAL, this.keepFormulas, this.pageNameVisible, this.headerVisible, this.drawingNameVisible);
        this.buildMe();
    }

    public void setPDFNameVisible(boolean visible) {
        if (visible) {
            this.pdfName.setText(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DIM_PDF_NAME"));
        } else {
            this.pdfName.setText(" ");
        }
    }

    void setDrawingNameVisible(boolean drawingNameVisible) {
        this.drawingNameVisible = drawingNameVisible;
        for (InnerPanel ip : this.ip_vec) {
            ip.setDrawingNameVisible(drawingNameVisible);
        }
        this.buildMe();
    }

    void setHeaderVisible(boolean headerVisible) {
        this.headerVisible = headerVisible;
        for (InnerPanel ip : this.ip_vec) {
            ip.setHeaderVisible(headerVisible);
        }
        this.buildMe();
    }

    public void setPageNameVisible(boolean pageNameVisible) {
        this.pageNameVisible = pageNameVisible;
        for (InnerPanel ip : this.ip_vec) {
            ip.setPageNameVisible(pageNameVisible);
        }
        this.buildMe();
    }

    public void setDecimalSign(String deci) {
        this.deci = deci;
        for (InnerPanel ip : this.ip_vec) {
            ip.setDecimalSign(deci);
        }
        this.buildMe();
    }

    public void setKeepFormulas(boolean keepFormulas) {
        this.keepFormulas = keepFormulas;
        for (InnerPanel ip : this.ip_vec) {
            ip.setKeepFormulas(keepFormulas);
        }
        this.buildMe();
    }

    public void setBeforeValue(String in) {
        for (InnerPanel ip : this.ip_vec) {
            ip.setBeforeValue(in);
        }
        this.buildMe();
    }

    public ExportSchema.Row[] getOrder() {
        ExportSchema.Row[] row = new ExportSchema.Row[this.ip_vec.length];
        for (int i = 0; i < this.ip_vec.length; ++i) {
            row[i] = this.ip_vec[i].getRow();
        }
        return row;
    }

    public void setVertical(boolean vertical) {
        this.vertical = vertical;
        for (InnerPanel ip : this.ip_vec) {
            ip.setVertical(!vertical);
        }
        this.buildMe();
    }

    private void MoveMeLeft(InnerPanel ip) {
        int pos = -1;
        for (int i = 0; i < this.ip_vec.length; ++i) {
            if (!this.ip_vec[i].equals(ip)) continue;
            pos = i;
        }
        if (pos > 0 && pos < this.ip_vec.length) {
            InnerPanel temp = this.ip_vec[pos];
            this.ip_vec[pos] = this.ip_vec[pos - 1];
            this.ip_vec[pos - 1] = temp;
        }
        this.buildMe();
    }

    private void MoveMeRight(InnerPanel ip) {
        int pos = -1;
        for (int i = 0; i < this.ip_vec.length; ++i) {
            if (!this.ip_vec[i].equals(ip)) continue;
            pos = i;
        }
        if (pos > -1 && pos < this.ip_vec.length - 1) {
            InnerPanel temp = this.ip_vec[pos];
            this.ip_vec[pos] = this.ip_vec[pos + 1];
            this.ip_vec[pos + 1] = temp;
        }
        this.buildMe();
    }

    private void buildMe() {
        this.removeAll();
        if (this.vertical) {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 18;
            gbc.fill = 1;
            gbc.gridx = 0;
            gbc.gridy = 0;
            this.add((Component)this.pdfName, gbc);
            JPanel temp = new JPanel();
            temp.setLayout(new GridLayout(this.ip_vec.length, 1));
            for (InnerPanel ip : this.ip_vec) {
                temp.add(ip);
            }
            gbc.gridy = 1;
            gbc.weighty = 1.0;
            gbc.weightx = 1.0;
            this.add((Component)temp, gbc);
        } else {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 18;
            gbc.fill = 1;
            gbc.gridx = 0;
            gbc.gridy = 0;
            this.add((Component)this.pdfName, gbc);
            JPanel temp = new JPanel();
            temp.setLayout(new GridLayout(1, this.ip_vec.length));
            for (InnerPanel ip : this.ip_vec) {
                temp.add(ip);
            }
            gbc.gridy = 1;
            gbc.weighty = 1.0;
            gbc.weightx = 1.0;
            this.add((Component)temp, gbc);
        }
        this.revalidate();
        this.repaint();
    }

    class InnerPanel
    extends JPanel
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        private JComponent[] comps = new JComponent[4];
        private JPanel button_name_button = new JPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isOpaque() {
                return true;
            }
        };
        private JButton left = new JButton(OrderChooser.access$400(OrderChooser.this));
        private JButton right = new JButton(OrderChooser.access$500(OrderChooser.this));
        private JLabel name;
        private OrderChooser oc;
        private ExportSchema.Row row;
        private boolean vertical_ = false;
        private boolean keepFormulas_;
        private String preValue = "";
        private String deci_ = "";
        private boolean pageNameVisible;
        private boolean headerVisible;
        private boolean drawingNameVisible;

        InnerPanel(String name, ExportSchema.Row row, OrderChooser oc, String deci, fakeStrings fs, boolean keepFormulas, boolean pageNameVisible, boolean headerVisible, boolean drawingNameVisible) {
            this.name = new JLabel(name);
            this.row = row;
            this.oc = oc;
            this.keepFormulas_ = keepFormulas;
            this.deci_ = deci;
            this.pageNameVisible = pageNameVisible;
            this.headerVisible = headerVisible;
            this.drawingNameVisible = drawingNameVisible;
            this.left.addActionListener(this);
            this.right.addActionListener(this);
            GridBagLayout gbl = new GridBagLayout();
            this.button_name_button.setLayout(gbl);
            this.button_name_button.setBackground(Color.LIGHT_GRAY);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 0;
            this.button_name_button.add((Component)this.left, gbc);
            this.button_name_button.add((Component)this.right, gbc);
            this.left.setSize(24, 24);
            this.right.setSize(24, 24);
            this.left.setPreferredSize(new Dimension(24, 24));
            this.left.setMaximumSize(new Dimension(24, 24));
            this.right.setPreferredSize(new Dimension(24, 24));
            this.right.setMaximumSize(new Dimension(24, 24));
            this.comps[0] = this.button_name_button;
            for (int i = 1; i < this.comps.length; ++i) {
                this.comps[i] = new ChangeAbleTextPanel(fs, i);
            }
            this.buildMe();
        }

        public void setKeepFormulas(boolean keepFormulas) {
            this.keepFormulas_ = keepFormulas;
            this.buildMe();
        }

        public void setBeforeValue(String beforeValue) {
            this.preValue = beforeValue;
            this.buildMe();
        }

        private void buildMe() {
            this.removeAll();
            if (this.vertical_) {
                this.setLayout(new GridLayout(4, 1));
                this.right.setIcon(OrderChooser.this.right_icon);
                this.left.setIcon(OrderChooser.this.left_icon);
            } else {
                this.setLayout(new GridLayout(1, 4));
                this.right.setIcon(OrderChooser.this.down_icon);
                this.left.setIcon(OrderChooser.this.up_icon);
            }
            for (JComponent jc : this.comps) {
                GridBagLayout gbl = new GridBagLayout();
                JPanel temp = new JPanel(gbl){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public boolean isOpaque() {
                        return true;
                    }
                };
                temp.setBackground(Color.LIGHT_GRAY);
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.fill = 1;
                gbc.anchor = 10;
                temp.add((Component)jc, gbc);
                if (jc instanceof ChangeAbleTextPanel) {
                    ((ChangeAbleTextPanel)jc).setText(this.preValue, this.deci_, this.keepFormulas_);
                }
                this.add(temp);
            }
            this.revalidate();
            this.repaint();
        }

        public ExportSchema.Row getRow() {
            return this.row;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource().equals(this.left)) {
                this.oc.MoveMeLeft(this);
            }
            if (e.getSource().equals(this.right)) {
                this.oc.MoveMeRight(this);
            }
        }

        public void setVertical(boolean vertical) {
            this.vertical_ = vertical;
            this.buildMe();
        }

        public void setHeaderVisible(boolean headerVisible) {
            this.headerVisible = headerVisible;
            this.buildMe();
        }

        public void setPageNameVisible(boolean pageNameVisible) {
            this.pageNameVisible = pageNameVisible;
            this.buildMe();
        }

        private void setDecimalSign(String deci) {
            this.deci_ = deci;
            this.buildMe();
        }

        private void hideButtons(boolean b) {
            this.left.setVisible(b);
            this.right.setVisible(b);
        }

        private void setDrawingNameVisible(boolean drawingNameVisible) {
            this.drawingNameVisible = drawingNameVisible;
            this.buildMe();
        }

        class ChangeAbleTextPanel
        extends JLabel {
            private static final long serialVersionUID = 1L;
            fakeStrings fs;
            int i;

            ChangeAbleTextPanel(fakeStrings fs, int i) {
                this.fs = fs;
                this.i = i;
                this.setBackground(Color.LIGHT_GRAY);
            }

            @Override
            public boolean isOpaque() {
                return true;
            }

            void setText(String preValue, String deci, boolean keepValues) {
                switch (this.i) {
                    case 1: {
                        this.setText(this.fs.get1(preValue, InnerPanel.this.row.toString(), deci, keepValues, InnerPanel.this.pageNameVisible, InnerPanel.this.headerVisible, InnerPanel.this.drawingNameVisible));
                        break;
                    }
                    case 2: {
                        this.setText(this.fs.get2(preValue, InnerPanel.this.row.toString(), deci, keepValues, InnerPanel.this.pageNameVisible, InnerPanel.this.headerVisible, InnerPanel.this.drawingNameVisible));
                        break;
                    }
                    case 3: {
                        this.setText(this.fs.get3(preValue, InnerPanel.this.row.toString(), deci, keepValues, InnerPanel.this.pageNameVisible, InnerPanel.this.headerVisible, InnerPanel.this.drawingNameVisible));
                    }
                }
            }
        }
    }

    private static enum fakeStrings {
        RUBRIK{

            @Override
            public String get1(String in, String name, String deci, boolean keepValues, boolean pageNameVisible, boolean headerVisible, boolean drawingNameVisible) {
                if (!pageNameVisible) {
                    return " ";
                }
                return ResourceBundle.getBundle("se/sjobeck/Geometra").getString("STR_PAGE") + " 1";
            }

            @Override
            public String get2(String in, String name, String deci, boolean keepValues, boolean pageNameVisible, boolean headerVisible, boolean drawingNameVisible) {
                if (drawingNameVisible) {
                    return ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DRAWING_DEFAULT") + " 1";
                }
                return " ";
            }

            @Override
            public String get3(String in, String name, String deci, boolean keepValues, boolean pageNameVisible, boolean headerVisible, boolean drawingNameVisible) {
                if (drawingNameVisible) {
                    return ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DRAWING_DEFAULT") + " 2";
                }
                return " ";
            }
        }
        ,
        V\u00c4RDE{

            @Override
            public String get1(String in, String name, String deci, boolean keepValues, boolean pageNameVisible, boolean headerVisible, boolean drawingNameVisible) {
                if (headerVisible) {
                    return name;
                }
                return " ";
            }

            @Override
            public String get2(String in, String name, String deci, boolean keepValues, boolean pageNameVisible, boolean headerVisible, boolean drawingNameVisible) {
                return keepValues ? in + "12" + deci + "00*3" : in + "36" + deci + "00";
            }

            @Override
            public String get3(String in, String name, String deci, boolean keepValues, boolean pageNameVisible, boolean headerVisible, boolean drawingNameVisible) {
                return keepValues ? in + "5" + deci + "00-4" : in + "1" + deci + "00";
            }
        }
        ,
        ANTAL{

            @Override
            public String get1(String in, String name, String deci, boolean keepValues, boolean pageNameVisible, boolean headerVisible, boolean drawingNameVisible) {
                if (headerVisible) {
                    return name;
                }
                return " ";
            }

            @Override
            public String get2(String in, String name, String deci, boolean keepValues, boolean pageNameVisible, boolean headerVisible, boolean drawingNameVisible) {
                return in + "1";
            }

            @Override
            public String get3(String in, String name, String deci, boolean keepValues, boolean pageNameVisible, boolean headerVisible, boolean drawingNameVisible) {
                return in + "3";
            }
        };


        public abstract String get1(String var1, String var2, String var3, boolean var4, boolean var5, boolean var6, boolean var7);

        public abstract String get2(String var1, String var2, String var3, boolean var4, boolean var5, boolean var6, boolean var7);

        public abstract String get3(String var1, String var2, String var3, boolean var4, boolean var5, boolean var6, boolean var7);
    }
}

