/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.geometra.gui.panels;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import se.sjobeck.GeometraConfiguration;
import se.sjobeck.geometra.datastructures.GeometraProperties;
import se.sjobeck.geometra.datastructures.blueprint.TabManager;
import se.sjobeck.geometra.export.ExportListener;
import se.sjobeck.geometra.gui.main.Geometra;
import se.sjobeck.geometra.gui.panels.ButtonPane;
import se.sjobeck.geometra.gui.panels.ExportCreatorPanel;
import se.sjobeck.geometra.gui.panels.datastructures.GeometraDocument;
import se.sjobeck.gui.DialogCreator;

public class OptionDialog2
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final Icon openIcon = ButtonPane.createIcon("open-mini.png");
    private Color defaultColor = GeometraConfiguration.getProjectColor();
    private JButton cancelButton;
    private JButton colorButton;
    private ExportCreatorPanel exportCreatorPanel1;
    private JTextField fontsizeField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel7;
    private JTabbedPane jTabbedPane1;
    private JTextField ndecimalField;
    private JButton okButton;
    private JButton openPathButton;
    private JTextField openTextField;
    private JButton savePathButton;
    private JTextField saveTextField;
    private JCheckBox soundBox;

    public OptionDialog2() {
        this.initComponents();
        this.exportCreatorPanel1.setJDialogOwner(this);
        this.exportCreatorPanel1.addExportListener(null);
    }

    public void addExportListener(List<ExportListener> lel) {
        this.exportCreatorPanel1.addExportListener(lel);
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.setLocationRelativeTo(Geometra.GEOMETRA_FRAME);
        }
        super.setVisible(visible);
    }

    public ExportListener getSelectedExportListener() {
        return this.exportCreatorPanel1.getSelectedExportListener();
    }

    public ExportListener[] getAllPossibleExportListener() {
        return this.exportCreatorPanel1.getAllPossibleExportListener();
    }

    public void setSelectedExportListener(int k) {
        this.exportCreatorPanel1.setSelectedExportListener(k);
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.jPanel5 = new JPanel();
        this.jLabel4 = new JLabel();
        this.fontsizeField = new JTextField();
        this.jPanel3 = new JPanel();
        this.jLabel2 = new JLabel();
        this.ndecimalField = new JTextField();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.colorButton = new JButton();
        this.jPanel4 = new JPanel();
        this.jLabel3 = new JLabel();
        this.soundBox = new JCheckBox();
        this.jPanel7 = new JPanel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.openTextField = new JTextField();
        this.saveTextField = new JTextField();
        this.openPathButton = new JButton();
        this.savePathButton = new JButton();
        this.exportCreatorPanel1 = new ExportCreatorPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel5.setBorder(BorderFactory.createTitledBorder(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("TAB_FONTSIZE_STR")));
        this.jPanel5.setLayout(new GridBagLayout());
        this.jLabel4.setText(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("LABEL_FONTSIZE"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.jPanel5.add((Component)this.jLabel4, gridBagConstraints);
        this.fontsizeField.setColumns(2);
        this.fontsizeField.setDocument(new GeometraDocument("0123456789"));
        this.fontsizeField.setText("" + GeometraConfiguration.getFontSize());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel5.add((Component)this.fontsizeField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jPanel5, gridBagConstraints);
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("TAB_DECIMAL_STR")));
        this.jPanel3.setLayout(new GridBagLayout());
        this.jLabel2.setText(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("LABEL_DECIMAL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.jPanel3.add((Component)this.jLabel2, gridBagConstraints);
        this.ndecimalField.setColumns(2);
        this.ndecimalField.setDocument(new GeometraDocument("0123456789"));
        this.ndecimalField.setText("" + GeometraConfiguration.getNDecimals());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel3.add((Component)this.ndecimalField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jPanel3, gridBagConstraints);
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("TAB_MEASUREMENTS_STR")));
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabel1.setText(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("LABEL_STANDARD_COLOR"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.jPanel2.add((Component)this.jLabel1, gridBagConstraints);
        this.colorButton.setText(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("STR_COLOR"));
        this.colorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionDialog2.this.colorButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel2.add((Component)this.colorButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        this.jPanel4.setBorder(BorderFactory.createTitledBorder(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("TAB_SOUND_STR")));
        this.jPanel4.setLayout(new GridBagLayout());
        this.jLabel3.setText(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("LABEL_SOUND"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.jPanel4.add((Component)this.jLabel3, gridBagConstraints);
        this.soundBox.setSelected(GeometraConfiguration.isSoundEnabled());
        this.soundBox.setText(GeometraConfiguration.isSoundEnabled() ? ResourceBundle.getBundle("se/sjobeck/Geometra").getString("LABEL_SOUND_ON") : ResourceBundle.getBundle("se/sjobeck/Geometra").getString("LABEL_SOUND_OFF"));
        this.soundBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionDialog2.this.soundBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel4.add((Component)this.soundBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jPanel4, gridBagConstraints);
        this.jPanel7.setBorder(BorderFactory.createTitledBorder(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("TAB_FILE_STR")));
        this.jPanel7.setLayout(new GridBagLayout());
        this.jLabel6.setText(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("LABEL_OPEN"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel7.add((Component)this.jLabel6, gridBagConstraints);
        this.jLabel7.setText(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("LABEL_SAVE"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        this.jPanel7.add((Component)this.jLabel7, gridBagConstraints);
        this.openTextField.setColumns(30);
        this.openTextField.setText(GeometraConfiguration.getOpenPath());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        this.jPanel7.add((Component)this.openTextField, gridBagConstraints);
        this.saveTextField.setColumns(30);
        this.saveTextField.setText(GeometraConfiguration.getSavePath());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        this.jPanel7.add((Component)this.saveTextField, gridBagConstraints);
        this.openPathButton.setIcon(this.openIcon);
        this.openPathButton.setMaximumSize(new Dimension(16, 16));
        this.openPathButton.setMinimumSize(new Dimension(16, 16));
        this.openPathButton.setPreferredSize(new Dimension(16, 16));
        this.openPathButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionDialog2.this.openPathButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        this.jPanel7.add((Component)this.openPathButton, gridBagConstraints);
        this.savePathButton.setIcon(this.openIcon);
        this.savePathButton.setMaximumSize(new Dimension(16, 16));
        this.savePathButton.setMinimumSize(new Dimension(16, 16));
        this.savePathButton.setPreferredSize(new Dimension(16, 16));
        this.savePathButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionDialog2.this.savePathButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        this.jPanel7.add((Component)this.savePathButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jPanel7, gridBagConstraints);
        this.jTabbedPane1.addTab(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("TAB_GENERAL_SETTINGS"), this.jPanel1);
        this.jTabbedPane1.addTab(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("TAB_OFFICE_STR"), this.exportCreatorPanel1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jTabbedPane1, gridBagConstraints);
        this.okButton.setText(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("BUTTON_OK"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionDialog2.this.okButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.okButton, gridBagConstraints);
        this.cancelButton.setText(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("BUTTON_CANCEL"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionDialog2.this.cancelButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.cancelButton, gridBagConstraints);
        this.pack();
    }

    private void colorButtonActionPerformed(ActionEvent evt) {
        this.defaultColor = Geometra.choseProjectColor();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        File openFile;
        File saveFile = new File(this.saveTextField.getText());
        if (!saveFile.exists()) {
            saveFile.mkdirs();
        }
        if (!(openFile = new File(this.openTextField.getText())).exists()) {
            openFile.mkdirs();
        }
        GeometraProperties.setProjectColor(this.defaultColor);
        this.saveProjectColorToPrefs();
        this.saveSavePathToPrefs();
        this.saveOpenPathToPrefs();
        this.saveNDecimalsToPrefs();
        this.saveFontSizeToPrefs();
        if (this.soundBox.isSelected()) {
            this.savePutSoundOnToPrefs();
        } else {
            this.savePutSoundOffToPrefs();
        }
        OptionDialog2.updateGeometraWithNewSettings();
        this.setVisible(false);
    }

    public static void updateGeometraWithNewSettings() {
        Geometra.updateSettings();
        TabManager.getInstance().updateSettings();
    }

    private final void saveProjectColorToPrefs() {
        GeometraConfiguration.putProjectColor(this.defaultColor);
    }

    private final void saveSavePathToPrefs() {
        GeometraConfiguration.putSavePath(this.saveTextField.getText());
    }

    private final void saveOpenPathToPrefs() {
        GeometraConfiguration.putOpenPath(this.openTextField.getText());
    }

    private final void saveNDecimalsToPrefs() {
        try {
            int nDecimals = Integer.parseInt(this.ndecimalField.getText());
            GeometraConfiguration.putNDecimals(nDecimals);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private final void saveFontSizeToPrefs() {
        try {
            int fontSize = Integer.parseInt(this.fontsizeField.getText());
            GeometraConfiguration.putFontSize(fontSize);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        TabManager.getInstance().repaintTab();
    }

    private final void savePutSoundOffToPrefs() {
        GeometraConfiguration.putSoundOff();
    }

    private final void savePutSoundOnToPrefs() {
        GeometraConfiguration.putSoundOn();
    }

    private void soundBoxActionPerformed(ActionEvent evt) {
        if (this.soundBox.isSelected()) {
            this.soundBox.setText(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("LABEL_SOUND_ON"));
        } else {
            this.soundBox.setText(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("LABEL_SOUND_OFF"));
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.defaultColor = GeometraConfiguration.getProjectColor();
        this.setVisible(false);
    }

    private void openPathButtonActionPerformed(ActionEvent evt) {
        try {
            Geometra.JFC_OPEN.setFileSelectionMode(1);
            int val = Geometra.JFC_OPEN.showOpenDialog(this);
            if (val != 0) {
                return;
            }
            String fileName = Geometra.JFC_OPEN.getSelectedFile().getCanonicalPath();
            this.openTextField.setText(fileName);
        }
        catch (IOException ex) {
            Logger.getLogger(OptionDialog2.class.getName()).log(Level.SEVERE, null, ex);
            DialogCreator.showError((Object)"Could not set new openpath due to an IO-error, please choose another openpath", (String)"IO-Error");
        }
    }

    private void savePathButtonActionPerformed(ActionEvent evt) {
        try {
            Geometra.JFC_SAVE.setFileSelectionMode(1);
            int val = Geometra.JFC_SAVE.showOpenDialog(this);
            if (val != 0) {
                return;
            }
            String fileName = Geometra.JFC_SAVE.getSelectedFile().getCanonicalPath();
            this.saveTextField.setText(fileName);
        }
        catch (IOException ex) {
            Logger.getLogger(OptionDialog2.class.getName()).log(Level.SEVERE, null, ex);
            DialogCreator.showError((Object)"Could not set new savepath due to an IO-error, please choose another savepath", (String)"IO-Error");
        }
    }
}

