/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.geometra.gui.panels;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.DropMode;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.icepdf.ri.common.views.painting.core.Blueprint;
import org.icepdf.ri.common.views.painting.core.BlueprintPage;
import org.icepdf.ri.common.views.painting.core.GeometraCollection;
import org.icepdf.ri.common.views.painting.drawings.GeometraDrawing;
import org.icepdf.ri.common.views.painting.drawings.ScaleDrawing;
import se.sjobeck.geometra.datastructures.PaintingStateMachine;
import se.sjobeck.geometra.datastructures.blueprint.GeometraManager;
import se.sjobeck.geometra.datastructures.blueprint.IcePDFBlueprint;
import se.sjobeck.geometra.datastructures.blueprint.ProjectFile;
import se.sjobeck.geometra.datastructures.blueprint.TabManager;
import se.sjobeck.geometra.datastructures.blueprint.observer.BlueprintSubject;
import se.sjobeck.geometra.datastructures.blueprint.observer.GeometraSubject;
import se.sjobeck.geometra.datastructures.blueprint.observer.Observer;
import se.sjobeck.geometra.datastructures.drawings.DotDrawing;
import se.sjobeck.geometra.datastructures.drawings.DotDrawingContainer;
import se.sjobeck.geometra.datastructures.drawings.HoleDrawing;
import se.sjobeck.geometra.datastructures.drawings.LineDrawing;
import se.sjobeck.geometra.datastructures.drawings.SmartDrawing;
import se.sjobeck.geometra.datastructures.drawings.SquareDrawing;
import se.sjobeck.geometra.datastructures.drawings.TextDrawing;
import se.sjobeck.geometra.datastructures.drawings.TotalDrawing;
import se.sjobeck.geometra.datastructures.drawings.ZoomDrawing;
import se.sjobeck.geometra.gui.main.Geometra;
import se.sjobeck.geometra.gui.panels.ButtonPane;
import se.sjobeck.geometra.gui.panels.InfoPanel;
import se.sjobeck.geometra.gui.panels.TreeObject;
import se.sjobeck.geometra.gui.panels.TreeTab;
import se.sjobeck.images.IconLoader;

public class JTreePDFPane
extends JPanel
implements Observer {
    private static final long serialVersionUID = 1L;
    public static int count = 1;
    private final GeometraSubject geoSubject = GeometraSubject.getInstance();
    private final GeometraManager geoManager = GeometraManager.getInstance();
    private volatile boolean init = false;
    private TreePath recentPath = null;
    private final TreeCellRenderer treeRenderer = new GeometraTreeCellRenderer();
    public static final Dimension TREEDIMENSION = new Dimension(180, 800);
    private final TabManager manager = TabManager.getInstance();
    MouseListener ml = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent e) {
            int selectionRow = JTreePDFPane.this.tree.getRowForLocation(e.getX(), e.getY());
            JTreePDFPane.this.tree.getPathForRow(selectionRow);
            if (e.getClickCount() == 2 && e.getButton() == 1) {
                Object ob = JTreePDFPane.this.tree.getLastSelectedPathComponent();
                JTreePDFPane.this.treeAction(ob);
            } else if (e.getClickCount() == 1 && e.getButton() == 1) {
                TreePath[] paths = JTreePDFPane.this.tree.getSelectionPaths();
                ArrayList<GeometraDrawing> currentDrawings = new ArrayList<GeometraDrawing>();
                if (paths != null) {
                    for (int i = 0; i < paths.length; ++i) {
                        TreePath path = paths[i];
                        Object ob = path.getLastPathComponent();
                        if (ob instanceof Blueprint) {
                            JTreePDFPane.this.updatePath((Blueprint)ob);
                            return;
                        }
                        if (ob instanceof GeometraDrawing && !(ob instanceof SmartDrawing)) {
                            GeometraDrawing gd = (GeometraDrawing)ob;
                            currentDrawings.add(gd);
                            continue;
                        }
                        if (!(ob instanceof SmartDrawing)) continue;
                        return;
                    }
                }
            }
        }
    };
    private final MutableTreeNode rootNode = new DefaultMutableTreeNode();
    private final JTree tree = new JTree(this.rootNode);
    private final JScrollPane treeScrollPane = new JScrollPane(this.tree);
    KeyListener treeKeylistener = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            Object ob = JTreePDFPane.this.tree.getLastSelectedPathComponent();
            JTreePDFPane.this.tree.getSelectionPaths();
            if (e.getKeyCode() == 10) {
                JTreePDFPane.this.treeAction(ob);
            } else if (e.getKeyCode() == 127) {
                Geometra.GEOMETRA_POPUP_MENU.removeItem();
            }
        }
    };
    private final GeometraTreeModel treeModel = new GeometraTreeModel();
    TreeSelectionListener treeSelectionListener = new TreeSelectionListener(){

        @Override
        public void valueChanged(TreeSelectionEvent selectionEvent) {
            TreePath[] paths = JTreePDFPane.this.tree.getSelectionPaths();
            GeometraCollection drawings = new GeometraCollection();
            if (paths != null) {
                for (int i = 0; i < paths.length; ++i) {
                    TreePath path = paths[i];
                    Object ob = path.getLastPathComponent();
                    if (ob instanceof Blueprint) {
                        JTreePDFPane.this.updatePath((Blueprint)ob);
                        return;
                    }
                    if (ob instanceof BlueprintPage) {
                        JTreePDFPane.this.updatePath((BlueprintPage)ob);
                        return;
                    }
                    if (ob instanceof SmartDrawing) {
                        SmartDrawing sd = (SmartDrawing)ob;
                        JTreePDFPane.this.geoSubject.select(sd, JTreePDFPane.this);
                        return;
                    }
                    if (!(ob instanceof GeometraDrawing)) continue;
                    GeometraDrawing gd = (GeometraDrawing)ob;
                    drawings.add((Object)gd);
                }
            }
            JTreePDFPane.this.geoSubject.select(drawings, JTreePDFPane.this);
        }
    };

    private void treeAction(Object ob) {
        if (ob instanceof Blueprint) {
            Blueprint bp = (Blueprint)ob;
            this.geoSubject.pageSwitch(bp, this);
            return;
        }
        if (ob instanceof BlueprintPage) {
            BlueprintPage page = (BlueprintPage)ob;
            this.geoSubject.pageSwitch(page, this);
            return;
        }
        if (ob instanceof SmartDrawing) {
            SmartDrawing sd = (SmartDrawing)ob;
            sd.setColor(sd.getColor());
            this.manager.setDrawingState(BlueprintPage.DrawingState.SMART_ONLY);
            return;
        }
        if (ob instanceof ScaleDrawing) {
            ScaleDrawing sd = (ScaleDrawing)ob;
            this.geoSubject.pageSwitch(sd, this);
            PaintingStateMachine machine = PaintingStateMachine.getInstance();
            machine.startSession(PaintingStateMachine.Session.SELECT);
            return;
        }
        if (ob instanceof HoleDrawing) {
            HoleDrawing hd = (HoleDrawing)ob;
            this.geoSubject.pageSwitch(hd.getOwner(), this);
            return;
        }
        if (ob instanceof DotDrawingContainer) {
            DotDrawingContainer ddc = (DotDrawingContainer)ob;
            this.geoSubject.pageSwitch(ddc, this);
            return;
        }
        if (ob instanceof GeometraDrawing && !(ob instanceof TotalDrawing)) {
            GeometraDrawing gd = (GeometraDrawing)ob;
            this.geoSubject.pageSwitch(gd, this);
            return;
        }
    }

    public JTreePDFPane(InfoPanel infoPane) {
        GridLayout gl = new GridLayout(0, 1);
        this.setLayout(gl);
        this.setBackground(Color.WHITE);
        this.tree.setExpandsSelectedPaths(true);
        this.tree.setModel(this.treeModel);
        this.tree.setInvokesStopCellEditing(true);
        this.tree.setToggleClickCount(0);
        this.tree.setEditable(false);
        this.tree.setDropMode(DropMode.ON);
        this.tree.setRootVisible(false);
        this.tree.setExpandsSelectedPaths(true);
        this.tree.setShowsRootHandles(true);
        this.tree.putClientProperty("JTree.lineStyle", "None");
        this.tree.addMouseListener(this.ml);
        this.tree.addTreeSelectionListener(this.treeSelectionListener);
        this.tree.getSelectionModel().setSelectionMode(4);
        this.tree.addKeyListener(this.treeKeylistener);
        this.tree.setCellRenderer(this.treeRenderer);
        this.add(this.treeScrollPane);
        this.geoSubject.addObserver(this);
        this.installKeys();
    }

    private void installKeys() {
        this.tree.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Geometra.GEOMETRA_POPUP_MENU.renameDrawing(JTreePDFPane.this);
            }
        }, ButtonPane.KEYSTROKE_RENAME, 0);
        this.tree.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Geometra.GEOMETRA_POPUP_MENU.lockDrawing(JTreePDFPane.this);
            }
        }, ButtonPane.KEYSTROKE_LOCK, 0);
        this.tree.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Geometra.GEOMETRA_POPUP_MENU.showTwoDimensions(JTreePDFPane.this);
            }
        }, ButtonPane.KEYSTROKE_SHOW2D, 0);
        this.tree.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Geometra.GEOMETRA_POPUP_MENU.showThreeDimensions(JTreePDFPane.this);
            }
        }, ButtonPane.KEYSTROKE_SHOW3D, 0);
        this.tree.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Geometra.GEOMETRA_POPUP_MENU.fillDrawings(JTreePDFPane.this);
            }
        }, ButtonPane.KEYSTROKE_FILL, 0);
    }

    private void addBlueprint(Blueprint bp) {
        if (!this.init) {
            this.tree.addMouseListener(Geometra.GEOMETRA_POPUP_MENU);
            this.init = true;
        }
        this.treeModel.addBlueprint(bp);
    }

    public void addDrawing(Blueprint bp, BlueprintPage page, GeometraDrawing gd) {
        this.treeModel.drawingAdded(bp, page, gd);
    }

    public void addNewRoot(Blueprint bp) {
        this.treeModel.addBlueprint(bp);
    }

    private void addToTree(Object object) {
        if (object instanceof Blueprint) {
            Blueprint bp = (Blueprint)object;
            this.addBlueprint(bp);
        } else if (object instanceof TotalDrawing) {
            this.addDrawing(null, null, (TotalDrawing)object);
        } else if (object instanceof GeometraDrawing) {
            GeometraDrawing gd = (GeometraDrawing)object;
            BlueprintPage page = gd.getParent();
            this.addDrawing(page.getParent(), page, gd);
        }
    }

    private void expandTreePath(TreePath path) {
        this.tree.expandPath(path);
    }

    private void expandTreePaths(TreePath[] path) {
        if (path.length > 0) {
            this.tree.expandPath(path[0]);
        }
    }

    public Dimension getDimension() {
        return TREEDIMENSION;
    }

    public Object getSelectionObject() {
        return this.tree.getLastSelectedPathComponent();
    }

    public String getSelectionString() {
        Object ob = this.tree.getLastSelectedPathComponent();
        if (ob instanceof Blueprint) {
            Blueprint bp = (Blueprint)ob;
            return bp.getDescription();
        }
        if (ob instanceof GeometraDrawing) {
            GeometraDrawing gd = (GeometraDrawing)ob;
            return gd.toString();
        }
        return "BUG in JTreePane, getSelectionString()";
    }

    public TreeModel getTreeModel() {
        return this.treeModel;
    }

    public void removeSelection(TreePath[] selectionPaths) {
    }

    public void fireRenameInTree(String str) {
        TreePath[] paths;
        for (TreePath path : paths = this.tree.getSelectionPaths()) {
            GeometraTreeModel model;
            Object ob = path.getLastPathComponent();
            if (ob instanceof HoleDrawing) {
                HoleDrawing hd = (HoleDrawing)ob;
                hd.setDescription(str);
                model = (GeometraTreeModel)this.getTreeModel();
                BlueprintPage page = hd.getParent();
                Blueprint bp = page.getParent();
                SquareDrawing sd = hd.getOwner();
                model.fireTreeNodesChanged(new TreeModelEvent((Object)this, new Object[]{model.getRoot(), bp, page, sd, hd}));
                continue;
            }
            if (!(ob instanceof GeometraDrawing)) continue;
            GeometraDrawing gd = (GeometraDrawing)ob;
            gd.setDescription(str);
            model = (GeometraTreeModel)this.getTreeModel();
            model.fireTreeNodesChanged(new TreeModelEvent((Object)this, new Object[]{model.getRoot(), gd.getParent().getParent(), gd.getParent(), gd}));
        }
    }

    public void fireRenameInTree() {
        TreePath path = this.tree.getSelectionPath();
        this.startEditingAtPath(path);
    }

    private void renameInTree(Object ob) {
        TreePath path;
        GeometraDrawing gd = (GeometraDrawing)ob;
        BlueprintPage page = gd.getParent();
        Blueprint bp = page.getParent();
        if (gd instanceof DotDrawing) {
            DotDrawing dd = (DotDrawing)ob;
            path = new TreePath(new Object[]{this.treeModel.getRoot(), bp, page, dd.getOwner(), dd});
        } else if (gd instanceof HoleDrawing) {
            HoleDrawing hd = (HoleDrawing)ob;
            path = new TreePath(new Object[]{this.treeModel.getRoot(), bp, page, hd.getOwner(), hd});
        } else {
            path = new TreePath(new Object[]{this.treeModel.getRoot(), bp, page, gd});
        }
        this.startEditingAtPath(path);
    }

    private void sortTree(Object ob) {
        this.treeModel.sortTreeModel(ob);
        this.tree.getSelectionModel().setSelectionMode(2);
    }

    private void selectInTree(GeometraCollection<GeometraDrawing> collection) {
        TreePath[] paths = new TreePath[collection.size()];
        int next = 0;
        for (GeometraDrawing gd : collection) {
            BlueprintPage page = gd.getParent();
            if (gd instanceof SquareDrawing || gd instanceof LineDrawing) {
                paths[next] = new TreePath(new Object[]{this.treeModel.getRoot(), page.getParent(), page, gd});
            } else if (gd instanceof DotDrawing) {
                DotDrawing dd = (DotDrawing)gd;
                paths[next] = new TreePath(new Object[]{this.treeModel.getRoot(), page.getParent(), page, dd.getOwner(), dd});
            } else if (gd instanceof HoleDrawing) {
                HoleDrawing hd = (HoleDrawing)gd;
                paths[next] = new TreePath(new Object[]{this.treeModel.getRoot(), page.getParent(), page, hd.getOwner(), hd});
            } else if (gd instanceof ScaleDrawing) {
                paths[next] = new TreePath(new Object[]{this.treeModel.getRoot(), page.getParent(), page, this.geoManager.getScaleDrawing(page)});
            }
            ++next;
        }
        this.setSelectionPaths(paths);
        this.expandTreePaths(paths);
    }

    private void selectTotalDrawingInTree(TotalDrawing td) {
        TreePath path = new TreePath(new Object[]{this.treeModel.getRoot(), td});
        this.setSelectionPath(path);
    }

    private void selectInTree(GeometraDrawing gd) {
        TreePath path;
        if (gd == null) {
            this.tree.clearSelection();
            return;
        }
        BlueprintPage page = gd.getParent();
        Blueprint bp = page.getParent();
        if (gd instanceof HoleDrawing) {
            HoleDrawing hd = (HoleDrawing)gd;
            path = new TreePath(new Object[]{this.treeModel.getRoot(), bp, page, hd.getOwner(), hd});
        } else if (gd instanceof DotDrawingContainer) {
            DotDrawingContainer ddc = (DotDrawingContainer)gd;
            path = new TreePath(new Object[]{this.treeModel.getRoot(), bp, page, ddc});
        } else if (gd instanceof DotDrawing) {
            DotDrawing dd = (DotDrawing)gd;
            path = new TreePath(new Object[]{this.treeModel.getRoot(), bp, page, dd.getOwner(), dd});
        } else {
            path = new TreePath(new Object[]{this.treeModel.getRoot(), bp, page, gd});
        }
        this.expandTreePath(path);
        this.setSelectionPath(path);
    }

    private void selectInTree(BlueprintPage page) {
        TreePath path = new TreePath(new Object[]{this.treeModel.getRoot(), page.getParent(), page});
        this.setSelectionPath(path);
    }

    private void selectInTree(Blueprint bp) {
        TreePath path = new TreePath(new Object[]{this.treeModel.getRoot(), bp});
        this.setSelectionPath(path);
    }

    public TreePath getPathForLocation(int x, int y) {
        return this.tree.getPathForLocation(x, y);
    }

    private void selectInTree(Object object) {
        if (object instanceof TreePath) {
            TreePath path = (TreePath)object;
            this.expandTreePath(path);
            this.setSelectionPath(path);
        } else if (object instanceof TotalDrawing) {
            TotalDrawing td = (TotalDrawing)object;
            this.selectTotalDrawingInTree(td);
        } else if (object instanceof GeometraDrawing) {
            GeometraDrawing gd = (GeometraDrawing)object;
            this.selectInTree(gd);
        } else if (object instanceof GeometraCollection) {
            GeometraCollection collection = (GeometraCollection)object;
            this.selectInTree((GeometraCollection<GeometraDrawing>)collection);
        } else if (object instanceof Point) {
            Point p = (Point)object;
            TreePath selectedPath = this.tree.getPathForLocation((int)p.getX(), (int)p.getY());
            if (selectedPath != null) {
                Object ob = selectedPath.getLastPathComponent();
                if (ob instanceof GeometraDrawing) {
                    GeometraDrawing gd = (GeometraDrawing)ob;
                    this.selectInTree(gd);
                } else if (ob instanceof BlueprintPage) {
                    BlueprintPage page = (BlueprintPage)ob;
                    this.selectInTree(page);
                } else if (ob instanceof Blueprint) {
                    Blueprint bp = (Blueprint)ob;
                    this.selectInTree(bp);
                }
            }
        } else if (object instanceof Blueprint) {
            this.selectInTree((Blueprint)object);
        } else if (object instanceof BlueprintPage) {
            this.selectInTree((BlueprintPage)object);
        } else if (object == null) {
            this.selectInTree((GeometraDrawing)null);
        }
    }

    public void setButtonPane(ButtonPane bp) {
    }

    public void setParent(TreeTab treeTab) {
    }

    private void setSelectionPath(TreePath path) {
        this.tree.setSelectionPath(path);
        this.tree.scrollPathToVisible(path);
    }

    private void setSelectionPaths(TreePath[] paths) {
        this.tree.setSelectionPaths(paths);
    }

    private void startEditingAtPath(TreePath path) {
        if (path != null) {
            Object ob = path.getLastPathComponent();
            if (ob instanceof DotDrawing) {
                this.tree.setEditable(true);
                this.tree.scrollPathToVisible(path);
                this.tree.expandPath(path);
            } else {
                this.tree.setEditable(true);
                this.tree.scrollPathToVisible(path);
                this.tree.expandPath(path);
                this.tree.setSelectionPath(path);
                this.tree.startEditingAtPath(path);
            }
        }
    }

    @Override
    public void update(BlueprintSubject.Action action, Object object, Object source) {
        if (!action.equals((Object)BlueprintSubject.Action.REPAINT)) {
            switch (action) {
                case SORT: {
                    this.sortTree(source);
                    break;
                }
                case PAGE_SWITCH: {
                    this.setActivePage(object);
                    this.tree.repaint();
                    break;
                }
                case ADD_TO_TOTAL: {
                    if (!(object instanceof GeometraCollection) || !(source instanceof TotalDrawing)) break;
                    this.addToTotal((GeometraCollection<GeometraDrawing>)((GeometraCollection)object), (TotalDrawing)source);
                    break;
                }
                case REMOVE_FROM_TOTAL: {
                    if (!(object instanceof GeometraDrawing) || !(source instanceof TotalDrawing)) break;
                    this.removeFromTotal((GeometraDrawing)object, (TotalDrawing)source);
                    break;
                }
                case REMOVE_FROM_SMART: {
                    if (!(object instanceof GeometraDrawing) || !(source instanceof SmartDrawing)) break;
                    this.removeFromSmart((GeometraDrawing)object, (SmartDrawing)source);
                    break;
                }
                case ADD_TO_SMART: {
                    if (object instanceof GeometraCollection && source instanceof SmartDrawing) {
                        this.addToSmart((GeometraCollection<GeometraDrawing>)((GeometraCollection)object), (SmartDrawing)source);
                        break;
                    }
                    if (!(object instanceof GeometraDrawing) || !(source instanceof SmartDrawing)) break;
                    this.addToSmart((GeometraDrawing)object, (SmartDrawing)source);
                    break;
                }
                case ADD_SMART_DRAWING: {
                    if (!(object instanceof SmartDrawing)) break;
                    this.addToTree(object);
                    this.selectInTree(object);
                    break;
                }
                case UPDATE: {
                    if (object instanceof ScaleDrawing) {
                        ScaleDrawing sd = (ScaleDrawing)object;
                        this.updateScaleDrawing(sd);
                    } else if (source instanceof ProjectFile && object == null) {
                        GeometraTreeModel model = (GeometraTreeModel)this.tree.getModel();
                        model.fireTreeStructureChanged(null);
                    }
                    this.tree.repaint();
                    break;
                }
                case ADD: {
                    if (source instanceof JTreePDFPane) break;
                    if (!(object instanceof ZoomDrawing) && !(source instanceof ProjectFile)) {
                        this.addToTree(object);
                        this.selectInTree(object);
                        break;
                    }
                    if (!(source instanceof ProjectFile)) break;
                    this.addToTree(object);
                    break;
                }
                case DISPOSE_ALL: {
                    ((GeometraTreeModel)this.tree.getModel()).resetTreeModel();
                    break;
                }
                case REMOVE: {
                    if (source instanceof JTreePDFPane) break;
                    this.removeObject(object);
                    break;
                }
                case SELECT: {
                    if (source instanceof JTreePDFPane) break;
                    this.selectInTree(object);
                    break;
                }
                case CLOSE: {
                    Boolean b;
                    if (source instanceof JTreePDFPane || !(source instanceof Boolean) || !(b = (Boolean)source).booleanValue()) break;
                    this.renameInTree(object);
                    break;
                }
                default: {
                    return;
                }
            }
        }
    }

    private void updateScaleDrawing(ScaleDrawing sd) {
        BlueprintPage page = sd.getParent();
        Blueprint bp = page.getParent();
        Object rootObject = ((GeometraTreeModel)this.tree.getModel()).getRoot();
        TreeModelEvent ev = new TreeModelEvent((Object)this, new Object[]{rootObject, bp, page, sd});
        ((GeometraTreeModel)this.tree.getModel()).fireTreeNodesChanged(ev);
    }

    private void setActivePage(Object ob) {
        BlueprintPage page = null;
        if (ob instanceof Blueprint) {
            IcePDFBlueprint pdf = (IcePDFBlueprint)ob;
            page = pdf.getActivePage();
        } else if (ob instanceof BlueprintPage) {
            page = (BlueprintPage)ob;
        }
        ((GeometraTreeCellRenderer)this.treeRenderer).setActivePage(page);
    }

    private void removeFromTotal(GeometraDrawing gd, TotalDrawing td) {
        this.treeModel.removeFromTotal(gd, td);
    }

    private void addToTotal(GeometraCollection<GeometraDrawing> collection, TotalDrawing td) {
        this.treeModel.addToTotal(collection, td);
    }

    private void removeFromSmart(GeometraDrawing gd, SmartDrawing sd) {
        this.treeModel.removeFromSmart(gd, sd);
    }

    private void addToSmart(GeometraDrawing gd, SmartDrawing sd) {
        this.treeModel.addToSmart(gd, sd);
    }

    private void addToSmart(GeometraCollection<GeometraDrawing> collection, SmartDrawing sd) {
        for (GeometraDrawing gd : collection) {
            this.treeModel.addToSmart(gd, sd);
        }
    }

    private void removeObject(Object object) {
        if (object instanceof GeometraCollection) {
            GeometraCollection col = (GeometraCollection)object;
            GeometraCollection scaleDrawings = new GeometraCollection();
            for (GeometraDrawing gd : col) {
                if (!(gd instanceof ScaleDrawing)) continue;
                scaleDrawings.add((Object)((ScaleDrawing)gd));
            }
            for (ScaleDrawing sd : scaleDrawings) {
                col.remove((Object)sd);
            }
            this.treeModel.removeCollection((GeometraCollection<GeometraDrawing>)col);
        } else if (object instanceof Blueprint) {
            this.treeModel.removeBlueprint((Blueprint)object);
        } else if (object instanceof HoleDrawing) {
            HoleDrawing hd = (HoleDrawing)object;
            SquareDrawing sd = hd.getOwner();
            BlueprintPage page = sd.getParent();
            Blueprint bp = page.getParent();
            this.treeModel.removeChildDrawing(bp, page, sd, hd);
        } else if (object instanceof DotDrawing) {
            DotDrawing dd = (DotDrawing)object;
            DotDrawingContainer ddc = dd.getOwner();
            BlueprintPage page = ddc.getParent();
            Blueprint bp = page.getParent();
            this.treeModel.removeChildDrawing(bp, page, ddc, dd);
        } else if (object instanceof TotalDrawing) {
            this.treeModel.removeTotalDrawing((TotalDrawing)object);
        } else if (object instanceof GeometraDrawing && !(object instanceof ZoomDrawing)) {
            GeometraDrawing gd = (GeometraDrawing)object;
            this.treeModel.removeDrawing(gd.getParent().getParent(), gd.getParent(), gd);
        }
    }

    public void updatePath(Blueprint bp) {
        GeometraTreeModel gtm = (GeometraTreeModel)this.tree.getModel();
        gtm.getRoot();
        TreePath path = new TreePath(new Object[]{gtm.getRoot(), bp});
        this.tree.setSelectionPath(path);
    }

    public void updatePath(BlueprintPage page) {
        GeometraTreeModel gtm = (GeometraTreeModel)this.tree.getModel();
        gtm.getRoot();
        TreePath path = new TreePath(new Object[]{gtm.getRoot(), page.getParent(), page});
        this.tree.setSelectionPath(path);
    }

    public void updatePath(GeometraCollection<GeometraDrawing> currentDrawings) {
        GeometraTreeModel gtm = (GeometraTreeModel)this.tree.getModel();
        TreePath[] treePaths = new TreePath[currentDrawings.size()];
        if (currentDrawings == null) {
            return;
        }
        for (int i = 0; i < currentDrawings.size(); ++i) {
            GeometraDrawing currentDrawing = (GeometraDrawing)currentDrawings.get(i);
            BlueprintPage page = currentDrawing.getParent();
            Blueprint bp = page.getParent();
            if (currentDrawing instanceof DotDrawing) {
                DotDrawing dotDrawing = (DotDrawing)currentDrawing;
                treePaths[i] = new TreePath(new Object[]{gtm.getRoot(), bp, page, dotDrawing.getOwner(), dotDrawing});
                continue;
            }
            if (currentDrawing instanceof HoleDrawing) {
                HoleDrawing holeDrawing = (HoleDrawing)currentDrawing;
                treePaths[i] = new TreePath(new Object[]{gtm.getRoot(), bp, page, holeDrawing.getOwner(), holeDrawing});
                continue;
            }
            treePaths[i] = new TreePath(new Object[]{gtm.getRoot(), bp, page, currentDrawing});
        }
        this.tree.setSelectionPaths(treePaths);
    }

    public void updatePath(GeometraDrawing currentDrawing) {
        TreePath path;
        GeometraTreeModel gtm = (GeometraTreeModel)this.tree.getModel();
        if (currentDrawing == null) {
            return;
        }
        BlueprintPage page = currentDrawing.getParent();
        Blueprint bp = page.getParent();
        if (currentDrawing instanceof DotDrawing) {
            DotDrawing dotDrawing = (DotDrawing)currentDrawing;
            path = new TreePath(new Object[]{gtm.getRoot(), bp, page, dotDrawing.getOwner(), dotDrawing});
        } else if (currentDrawing instanceof HoleDrawing) {
            HoleDrawing holeDrawing = (HoleDrawing)currentDrawing;
            path = new TreePath(new Object[]{gtm.getRoot(), bp, page, holeDrawing.getOwner(), holeDrawing});
        } else {
            path = new TreePath(new Object[]{gtm.getRoot(), bp, page, currentDrawing});
        }
        this.tree.setSelectionPath(path);
        this.tree.scrollPathToVisible(path);
        this.tree.expandPath(path);
    }

    public final TreePath[] getSelectedPaths() {
        return this.tree.getSelectionPaths();
    }

    public void clearSelection() {
        this.tree.clearSelection();
    }

    class GeometraTreeModel
    implements TreeModel {
        private final List<TreeModelListener> listenerList;
        private final Object rootObject = new Object();
        private final List<Object> rootList = new ArrayList<Object>();

        public GeometraTreeModel() {
            this.listenerList = new ArrayList<TreeModelListener>();
        }

        public void addToSmart(GeometraDrawing gd, SmartDrawing sd) {
            BlueprintPage page = gd.getParent();
            Blueprint bp = page.getParent();
            TreePath path = new TreePath(new Object[]{this.rootObject, bp, page, sd});
            this.fireTreeNodesInserted(new TreeModelEvent((Object)this, path, new int[]{sd.indexOf(gd)}, new Object[]{gd}));
        }

        public void addBlueprint(Blueprint bp) {
            this.rootList.add(bp);
            TreePath path = new TreePath(new Object[]{this.rootObject});
            TreeModelEvent event = new TreeModelEvent((Object)this, path, new int[]{this.rootList.indexOf(bp)}, new Object[]{this.rootObject});
            this.fireTreeNodesInserted(event);
        }

        @Override
        public void addTreeModelListener(TreeModelListener l) {
            this.listenerList.add(l);
        }

        public void drawingAdded(Blueprint b, BlueprintPage page, GeometraDrawing gd) {
            if (gd instanceof DotDrawingContainer) {
                DotDrawingContainer ddc = (DotDrawingContainer)gd;
                TreePath path = new TreePath(new Object[]{this.rootObject, b, page});
                TreeModelEvent event = new TreeModelEvent((Object)this, path, new int[]{page.indexOf((GeometraDrawing)ddc)}, new Object[]{ddc});
                this.fireTreeNodesInserted(event);
                if (JTreePDFPane.this.recentPath != null) {
                    JTreePDFPane.this.tree.collapsePath(JTreePDFPane.this.recentPath);
                }
                JTreePDFPane.this.recentPath = new TreePath(new Object[]{this.rootObject, b, page, ddc});
            } else if (gd instanceof SmartDrawing) {
                SmartDrawing sd = (SmartDrawing)gd;
                TreePath path = new TreePath(new Object[]{this.rootObject, b, page});
                System.out.println("path: " + path);
                System.out.println("index of: " + page.indexOf((GeometraDrawing)sd));
                TreeModelEvent event = new TreeModelEvent((Object)this, path, new int[]{page.indexOf((GeometraDrawing)sd)}, new Object[]{sd});
                this.fireTreeNodesInserted(event);
                if (JTreePDFPane.this.recentPath != null) {
                    JTreePDFPane.this.tree.collapsePath(JTreePDFPane.this.recentPath);
                }
                JTreePDFPane.this.recentPath = new TreePath(new Object[]{this.rootObject, b, page, sd});
            } else if (gd instanceof TotalDrawing) {
                TotalDrawing td = (TotalDrawing)gd;
                this.rootList.add(td);
                TreePath path = new TreePath(new Object[]{this.rootObject});
                TreeModelEvent event = new TreeModelEvent((Object)this, path, new int[]{this.rootList.indexOf(td)}, new Object[]{this.rootObject});
                this.fireTreeNodesInserted(event);
            } else if (gd instanceof HoleDrawing) {
                HoleDrawing hd = (HoleDrawing)gd;
                SquareDrawing sd = hd.getOwner();
                TreePath path = new TreePath(new Object[]{this.rootObject, b, page, sd});
                this.fireTreeNodesInserted(new TreeModelEvent((Object)this, path, new int[]{sd.indexOfChild(hd)}, new Object[]{hd}));
                if (JTreePDFPane.this.recentPath != null && !JTreePDFPane.this.recentPath.getLastPathComponent().equals(sd)) {
                    JTreePDFPane.this.tree.collapsePath(JTreePDFPane.this.recentPath);
                }
                JTreePDFPane.this.recentPath = new TreePath(new Object[]{this.rootObject, b, page, sd});
            } else if (gd instanceof SquareDrawing) {
                SquareDrawing sd = (SquareDrawing)gd;
                TreePath path = new TreePath(new Object[]{this.rootObject, b, page});
                TreeModelEvent event = new TreeModelEvent((Object)this, path, new int[]{page.indexOf((GeometraDrawing)sd)}, new Object[]{sd});
                this.fireTreeNodesInserted(event);
                if (JTreePDFPane.this.recentPath != null) {
                    JTreePDFPane.this.tree.collapsePath(JTreePDFPane.this.recentPath);
                }
                JTreePDFPane.this.recentPath = new TreePath(new Object[]{this.rootObject, b, page, sd});
            } else if (gd instanceof DotDrawing) {
                DotDrawing dd = (DotDrawing)gd;
                DotDrawingContainer ddc = dd.getOwner();
                TreePath path = new TreePath(new Object[]{this.rootObject, b, page, ddc});
                this.fireTreeNodesInserted(new TreeModelEvent((Object)this, path, new int[]{ddc.indexOfChild(dd)}, new Object[]{dd}));
                this.fireTreeNodesChanged(new TreeModelEvent((Object)this, new Object[]{this.rootObject, page.getParent(), page, ddc}));
                JTreePDFPane.this.recentPath = new TreePath(new Object[]{this.rootObject, b, page, ddc});
            } else {
                TreePath path = new TreePath(new Object[]{this.rootObject, b, page});
                this.fireTreeNodesInserted(new TreeModelEvent((Object)this, path, new int[]{page.indexOf(gd)}, new Object[]{gd}));
                if (JTreePDFPane.this.recentPath != null) {
                    JTreePDFPane.this.tree.collapsePath(JTreePDFPane.this.recentPath);
                }
            }
        }

        public void fireTreeStructureChanged(TreeModelEvent ev) {
            if (ev == null) {
                TreePath path = new TreePath(new Object[]{this.rootObject});
                ev = new TreeModelEvent((Object)this, path);
            }
            for (TreeModelListener list : this.listenerList) {
                list.treeStructureChanged(ev);
            }
        }

        public void fireTreeNodesInserted(TreeModelEvent ev) {
            for (TreeModelListener list : this.listenerList) {
                list.treeNodesInserted(ev);
            }
        }

        public void fireTreeNodesRemoved(TreeModelEvent ev) {
            for (TreeModelListener list : this.listenerList) {
                list.treeNodesRemoved(ev);
            }
        }

        public void fireTreeNodesChanged(TreeModelEvent ev) {
            for (TreeModelListener list : this.listenerList) {
                list.treeNodesChanged(ev);
            }
        }

        @Override
        public Object getChild(Object parent, int index) {
            if (parent.equals(this.rootObject)) {
                return this.rootList.get(index);
            }
            if (parent instanceof Blueprint) {
                return JTreePDFPane.this.geoManager.getPage((Blueprint)parent, index);
            }
            if (parent instanceof DotDrawingContainer) {
                DotDrawingContainer cont = (DotDrawingContainer)parent;
                return cont.getChild(index);
            }
            if (parent instanceof BlueprintPage) {
                return JTreePDFPane.this.geoManager.getDrawing((BlueprintPage)parent, index);
            }
            if (parent instanceof TotalDrawing) {
                TotalDrawing td = (TotalDrawing)parent;
                return td.getChild(index);
            }
            if (parent instanceof SmartDrawing) {
                SmartDrawing sd = (SmartDrawing)parent;
                return sd.getChild(index);
            }
            if (parent instanceof SquareDrawing) {
                SquareDrawing sd = (SquareDrawing)parent;
                return sd.getChild(index);
            }
            return null;
        }

        @Override
        public int getChildCount(Object parent) {
            if (parent.equals(this.rootObject)) {
                return this.rootList.size();
            }
            if (parent instanceof Blueprint) {
                return JTreePDFPane.this.geoManager.getNumberOfPages((Blueprint)parent);
            }
            if (parent instanceof TotalDrawing) {
                return ((TotalDrawing)parent).size();
            }
            if (parent instanceof BlueprintPage) {
                return ((BlueprintPage)parent).getNumberOfDrawings();
            }
            if (parent instanceof DotDrawingContainer) {
                return ((DotDrawingContainer)parent).getNumberOfDotDrawings();
            }
            if (parent instanceof SmartDrawing) {
                return ((SmartDrawing)parent).getChildCount();
            }
            if (parent instanceof SquareDrawing) {
                return ((SquareDrawing)parent).getChildCount();
            }
            return 0;
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            if (parent.equals(this.rootObject)) {
                return this.rootList.indexOf(child);
            }
            if (parent instanceof SquareDrawing) {
                return ((SquareDrawing)parent).indexOfChild((GeometraDrawing)child);
            }
            if (parent instanceof SmartDrawing) {
                return ((SmartDrawing)parent).indexOf(child);
            }
            if (parent instanceof Blueprint && child instanceof BlueprintPage) {
                return JTreePDFPane.this.geoManager.getPageIndex((Blueprint)parent, (BlueprintPage)child);
            }
            if (parent instanceof BlueprintPage && child instanceof GeometraDrawing) {
                return ((BlueprintPage)parent).indexOf((GeometraDrawing)child);
            }
            if (parent instanceof DotDrawingContainer && child instanceof DotDrawing) {
                return ((DotDrawingContainer)parent).indexOfChild((DotDrawing)child);
            }
            return 0;
        }

        @Override
        public Object getRoot() {
            return this.rootObject;
        }

        @Override
        public boolean isLeaf(Object node) {
            if (node instanceof DotDrawingContainer) {
                return ((DotDrawingContainer)node).getNumberOfDotDrawings() == 0;
            }
            if (node instanceof BlueprintPage) {
                BlueprintPage page = (BlueprintPage)node;
                if (page.getNumberOfDrawings() > 0) {
                    return false;
                }
            } else {
                if (node.equals(this.rootObject)) {
                    return false;
                }
                if (node instanceof Blueprint) {
                    return false;
                }
                if (node instanceof TotalDrawing) {
                    return false;
                }
                if (node instanceof SmartDrawing) {
                    return false;
                }
                if (node instanceof SquareDrawing && ((SquareDrawing)node).getChildCount() > 0) {
                    return false;
                }
            }
            return true;
        }

        public void removeTotalDrawing(TotalDrawing td) {
            TreePath path = new TreePath(new Object[]{this.rootObject});
            if (this.rootList.contains(td)) {
                this.fireTreeNodesRemoved(new TreeModelEvent((Object)this, path, new int[]{this.rootList.indexOf(td)}, new Object[]{td}));
                this.rootList.remove(td);
            }
        }

        public void removeBlueprint(Blueprint bp) {
            TreePath path = new TreePath(new Object[]{this.rootObject});
            int index = this.rootList.indexOf(bp);
            this.fireTreeNodesRemoved(new TreeModelEvent((Object)this, path, new int[]{index}, new Object[]{bp}));
            this.rootList.remove(bp);
        }

        public void removeChildDrawing(Blueprint b, BlueprintPage page, GeometraDrawing owner, GeometraDrawing child) {
            TreePath path = new TreePath(new Object[]{this.rootObject, b, page, owner});
            int index = 0;
            if (owner instanceof SquareDrawing) {
                SquareDrawing sd = (SquareDrawing)owner;
                index = sd.indexOfChild(child);
            } else if (owner instanceof DotDrawingContainer) {
                DotDrawingContainer ddc = (DotDrawingContainer)owner;
                index = ddc.indexOfChild(child);
            }
            TreeModelEvent event = new TreeModelEvent((Object)this, path, new int[]{index}, new Object[]{child});
            this.fireTreeNodesRemoved(event);
        }

        public void removeDrawing(Blueprint b, BlueprintPage page, GeometraDrawing gd) {
            TreePath path = new TreePath(new Object[]{this.rootObject, b, page});
            TreeModelEvent event = new TreeModelEvent((Object)this, path, new int[]{page.indexOf(gd)}, new Object[]{gd});
            this.fireTreeNodesRemoved(event);
        }

        @Override
        public void removeTreeModelListener(TreeModelListener l) {
            this.listenerList.remove(l);
        }

        public void resetTreeModel() {
            this.rootList.clear();
            this.fireTreeStructureChanged(new TreeModelEvent((Object)this, new Object[]{this.rootObject}));
        }

        private void sortTreeModel(Object ob) {
            this.fireTreeStructureChanged(null);
            if (ob instanceof BlueprintPage) {
                BlueprintPage page = (BlueprintPage)ob;
                TreePath oldPath = new TreePath(new Object[]{this.rootObject, page.getParent(), page});
                JTreePDFPane.this.tree.expandPath(oldPath);
                JTreePDFPane.this.tree.setSelectionPath(oldPath);
            } else if (ob instanceof Blueprint) {
                Blueprint bp = (Blueprint)ob;
                TreePath oldPath = new TreePath(new Object[]{this.rootObject, bp});
                JTreePDFPane.this.tree.expandPath(oldPath);
                JTreePDFPane.this.tree.setSelectionPath(oldPath);
            }
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
            if (newValue.toString().length() > 0) {
                Object obj = path.getLastPathComponent();
                if (obj instanceof Blueprint) {
                    Blueprint bp = (Blueprint)obj;
                    String newName = newValue.toString();
                    JTreePDFPane.this.geoManager.setDescription(bp, newName);
                    this.fireTreeNodesChanged(new TreeModelEvent((Object)this, new Object[]{this.rootObject, bp}));
                } else if (obj instanceof BlueprintPage) {
                    BlueprintPage page = (BlueprintPage)obj;
                    JTreePDFPane.this.geoManager.setDescription(page, newValue.toString());
                    this.fireTreeNodesChanged(new TreeModelEvent((Object)this, new Object[]{this.rootObject, page.getParent(), page}));
                } else if (obj instanceof HoleDrawing) {
                    HoleDrawing hd = (HoleDrawing)obj;
                    SquareDrawing owner = hd.getOwner();
                    hd.setDescription(newValue.toString());
                    this.fireTreeNodesChanged(new TreeModelEvent((Object)this, new Object[]{this.rootObject, owner.getParent(), owner, hd}));
                } else if (obj instanceof TotalDrawing) {
                    TotalDrawing td = (TotalDrawing)obj;
                    td.setDescription(newValue.toString());
                    this.fireTreeNodesChanged(new TreeModelEvent((Object)this, new Object[]{this.rootObject, td}));
                } else if (obj instanceof DotDrawingContainer) {
                    DotDrawingContainer ddc = (DotDrawingContainer)obj;
                    ddc.setDescription(newValue.toString());
                    BlueprintPage page = ddc.getParent();
                    Blueprint bp = page.getParent();
                    this.fireTreeNodesChanged(new TreeModelEvent((Object)this, new Object[]{this.rootObject, bp, page, ddc}));
                    List<DotDrawing> list = ddc.getChildren();
                    TreePath childPath = new TreePath(new Object[]{this.rootObject, bp, page, ddc});
                    int[] indices = new int[list.size()];
                    for (int i = 0; i < indices.length; ++i) {
                        indices[i] = i;
                    }
                    Object[] children = list.toArray();
                    this.fireTreeNodesChanged(new TreeModelEvent((Object)this, childPath, indices, children));
                } else if (obj instanceof GeometraDrawing) {
                    GeometraDrawing gd = (GeometraDrawing)obj;
                    gd.setDescription(newValue.toString());
                    BlueprintPage page = gd.getParent();
                    Blueprint bp = page.getParent();
                    this.fireTreeNodesChanged(new TreeModelEvent((Object)this, new Object[]{this.rootObject, bp, page, gd}));
                }
            } else {
                Geometra.createInfoDialog(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DIALOG_SHORT_NAME"));
            }
            JTreePDFPane.this.tree.setEditable(false);
        }

        public void removeCollection(GeometraCollection<GeometraDrawing> col) {
            HashMap map = new HashMap();
            for (GeometraDrawing gd : col) {
                List<TreeObject> list;
                TreeObject treeOb;
                TreePath path;
                if (gd instanceof TotalDrawing) {
                    JTreePDFPane.this.treeModel.removeTotalDrawing((TotalDrawing)gd);
                    continue;
                }
                if (gd instanceof TotalDrawing) continue;
                BlueprintPage page = gd.getParent();
                Blueprint bp = page.getParent();
                if (gd instanceof DotDrawing) {
                    DotDrawing dd = (DotDrawing)gd;
                    DotDrawingContainer ddc = dd.getOwner();
                    path = new TreePath(new Object[]{this.rootObject, bp, page, ddc});
                    treeOb = new TreeObject(ddc.indexOfChild(dd), dd);
                } else if (gd instanceof HoleDrawing) {
                    HoleDrawing hd = (HoleDrawing)gd;
                    SquareDrawing sd = hd.getOwner();
                    path = new TreePath(new Object[]{this.rootObject, bp, page, sd});
                    treeOb = new TreeObject(sd.indexOfChild(hd), hd);
                } else {
                    path = new TreePath(new Object[]{this.rootObject, bp, page});
                    treeOb = new TreeObject(page.indexOf(gd), gd);
                }
                if (map.containsKey(path)) {
                    list = (List)map.get(path);
                    list.add(treeOb);
                    continue;
                }
                list = new ArrayList();
                list.add(treeOb);
                map.put(path, list);
            }
            for (Map.Entry pairs : map.entrySet()) {
                TreePath path = (TreePath)pairs.getKey();
                List objects = (List)pairs.getValue();
                int[] indices = new int[objects.size()];
                Object[] drawings = new Object[objects.size()];
                for (int i = 0; i < objects.size(); ++i) {
                    TreeObject treeObject = (TreeObject)objects.get(i);
                    indices[i] = treeObject.getIndex();
                    drawings[i] = treeObject.getObject();
                }
                this.removeDrawings(drawings, indices, path);
            }
        }

        private void removeDrawings(Object[] objects, int[] indices, TreePath path) {
            String h = "";
            for (int j : indices) {
                h = h + j + ",";
            }
            Arrays.sort(indices);
            TreeModelEvent event = new TreeModelEvent((Object)this, path, indices, objects);
            this.fireTreeNodesRemoved(event);
        }

        public void removeSmartDrawing(SmartDrawing sd) {
            BlueprintPage page = sd.getParent();
            Blueprint bp = JTreePDFPane.this.geoManager.getParent(page);
            this.fireTreeStructureChanged(new TreeModelEvent((Object)this, new Object[]{this.rootObject, bp, page}));
        }

        public void removeDrawingFromSmart(SmartDrawing sd, GeometraDrawing gd) {
            BlueprintPage page = sd.getParent();
            Blueprint bp = page.getParent();
            this.fireTreeStructureChanged(new TreeModelEvent((Object)this, new Object[]{this.rootObject, bp, page, sd}));
        }

        public void removeFromSmart(GeometraDrawing gd, SmartDrawing sd) {
            BlueprintPage page = gd.getParent();
            Blueprint bp = page.getParent();
            this.fireTreeStructureChanged(new TreeModelEvent((Object)this, new Object[]{this.rootObject, bp, page, sd}));
        }

        public void addToTotal(GeometraCollection<GeometraDrawing> collection, TotalDrawing td) {
            TreePath path = new TreePath(new Object[]{this.rootObject, td});
            for (GeometraDrawing gd : collection) {
                this.fireTreeNodesInserted(new TreeModelEvent((Object)this, path, new int[]{td.indexOf(gd)}, new Object[]{gd}));
            }
        }

        public void removeFromTotal(GeometraDrawing gd, TotalDrawing td) {
            this.fireTreeStructureChanged(new TreeModelEvent((Object)this, new Object[]{this.rootObject, td}));
        }
    }

    private class GeometraTreeCellRenderer
    implements TreeCellRenderer {
        private final String ABSOLUTEPATHSTR = "/se/sjobeck/geometra/gui/panels/jtreeicons/";
        private final Icon totalDrawingIcon = IconLoader.getIcon((String)"/se/sjobeck/geometra/gui/panels/jtreeicons/totaldrawing.png");
        private final Icon pageIcon = IconLoader.getIcon((String)"/se/sjobeck/geometra/gui/panels/jtreeicons/page.png");
        private final Icon scaleDrawingIcon = IconLoader.getIcon((String)"/se/sjobeck/geometra/gui/panels/jtreeicons/Ruler.png");
        private final Icon holeDrawingIcon = IconLoader.getIcon((String)"/se/sjobeck/geometra/gui/panels/jtreeicons/hd-mini.png");
        private final Icon squareIcon = IconLoader.getIcon((String)"/se/sjobeck/geometra/gui/panels/jtreeicons/Area.png");
        private final Icon lineIcon = IconLoader.getIcon((String)"/se/sjobeck/geometra/gui/panels/jtreeicons/Line.png");
        private final Icon pointFoldIcon = IconLoader.getIcon((String)"/se/sjobeck/geometra/gui/panels/jtreeicons/Point-fold.png");
        private final Icon textIcon = IconLoader.getIcon((String)"/se/sjobeck/geometra/gui/panels/jtreeicons/text-drawing-small.png");
        private final JLabel label;
        private final Icon pdfIcon = ButtonPane.createIcon("pdf.gif");
        private final Icon smartDrawingIcon = ButtonPane.createIcon("smart.png");
        private BlueprintPage activePage = null;

        public GeometraTreeCellRenderer() {
            this.label = new JLabel();
            this.label.setOpaque(true);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, final Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (value instanceof Blueprint) {
                this.label.setIcon(this.pdfIcon);
                if (!this.label.getText().equals(((Blueprint)value).getDescription())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TabManager.getInstance().renameTab((Blueprint)value);
                        }
                    });
                }
                this.label.setText(((Blueprint)value).getDescription());
            } else if (value instanceof BlueprintPage) {
                BlueprintPage page = (BlueprintPage)value;
                this.label.setIcon(this.pageIcon);
                if (page.equals(this.activePage)) {
                    this.label.setText("<html><b><font color=\"3299CC\">" + page.getDescription() + "</font></b></html>");
                } else if (page.getNumberOfDrawings() > 1) {
                    this.label.setText("<html><b>" + page.getDescription() + "</b></html>");
                } else {
                    this.label.setText(((BlueprintPage)value).getDescription());
                }
            } else if (value instanceof SmartDrawing) {
                this.label.setText(((SmartDrawing)value).toString());
                this.label.setIcon(this.smartDrawingIcon);
            } else if (value instanceof GeometraDrawing) {
                GeometraDrawing gd = (GeometraDrawing)value;
                if (gd instanceof HoleDrawing) {
                    this.label.setIcon(this.holeDrawingIcon);
                } else if (gd instanceof LineDrawing) {
                    this.label.setIcon(this.lineIcon);
                } else if (gd instanceof TotalDrawing) {
                    this.label.setIcon(this.totalDrawingIcon);
                } else if (gd instanceof SquareDrawing) {
                    this.label.setIcon(this.squareIcon);
                } else if (gd instanceof TextDrawing) {
                    this.label.setIcon(this.textIcon);
                } else if (gd instanceof DotDrawing) {
                    this.label.setIcon(this.pointFoldIcon);
                } else if (gd instanceof DotDrawingContainer) {
                    this.label.setIcon(this.pointFoldIcon);
                } else if (gd instanceof ScaleDrawing) {
                    this.label.setIcon(this.scaleDrawingIcon);
                }
                if (!(gd.isClosed() || gd instanceof SmartDrawing || gd instanceof TotalDrawing || gd instanceof DotDrawingContainer)) {
                    this.label.setText("<html><font color=\"FF2400\">" + gd.toString() + "</font></html>");
                } else if (gd instanceof DotDrawingContainer) {
                    DotDrawingContainer cont = (DotDrawingContainer)gd;
                    if (gd.isClosed()) {
                        this.label.setText(cont.getDescription() + " [" + cont.getNumberOfDotDrawings() + "] ");
                    } else {
                        this.label.setText("<html><font color=\"FF2400\">" + cont.getDescription() + " [" + cont.getNumberOfDotDrawings() + "] " + "</font></html>");
                    }
                } else {
                    this.label.setText(gd.toString());
                }
            }
            if (selected) {
                this.label.setForeground(UIManager.getColor("Tree.selectionForeground"));
                this.label.setBackground(UIManager.getColor("Tree.selectionBackground"));
            } else {
                this.label.setForeground(UIManager.getColor("Tree.textForeground"));
                this.label.setBackground(UIManager.getColor("Tree.textBackground"));
                this.label.setBorder(BorderFactory.createEmptyBorder());
            }
            return this.label;
        }

        public void setActivePage(BlueprintPage page) {
            this.activePage = page;
        }
    }
}

