/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.geometra.gui.panels;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import se.sjobeck.GeometraConfiguration;
import se.sjobeck.geometra.datastructures.blueprint.TabManager;
import se.sjobeck.geometra.datastructures.blueprint.observer.GeometraSubject;
import se.sjobeck.geometra.gui.main.Geometra;
import se.sjobeck.geometra.gui.main.GeometraMenu;
import se.sjobeck.geometra.gui.panels.ButtonPane;
import se.sjobeck.geometra.gui.panels.InfoPanel;
import se.sjobeck.geometra.gui.panels.TreeTab;
import se.sjobeck.images.IconLoader;
import se.sjobeck.network2.ClientThread;
import se.sjobeck.network2.FromServerMessage;
import se.sjobeck.network2.Message;
import se.sjobeck.util.StaticHelpers;
import se.sjobeck.versiontracker.NeedToBeReloadedException;
import se.sjobeck.versiontracker.VersionTracker;
import se.sjobeck.versiontracker.VersionTrackerFactory;

public class JListProjectPane
extends JPanel {
    private static final long serialVersionUID = 1L;
    private String filter_string = "";
    private GeometraMenu geoMenu;
    private JListProjectPane jlpp = this;
    private TreeTab treeTab;
    private ButtonPane buttonPane;
    private InfoPanel infoPane;
    private JLabel jLabel1;
    private JList jList1;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTextField jTextField1;
    private JButton jbutton_open;
    private JButton jbutton_remove;
    private final Map<String, ProjectStatus> project_status = new HashMap<String, ProjectStatus>();
    private static final Icon projectIcon = ButtonPane.createIcon("project.png");
    public static final Icon needDownloadIcon = IconLoader.getIcon((String)"/org/tangoProject/small/format-indent-less.png");
    public static final Icon needUploadIcon = IconLoader.getIcon((String)"/org/tangoProject/small/format-indent-more.png");

    public JListProjectPane(GeometraMenu geometramenu) {
        this.initComponents();
        this.geoMenu = geometramenu;
        this.jList1.setCellRenderer(new MyCellRenderer());
        this.changepaths();
        System.out.println("autoscrolls projectpane " + this.jList1.getAutoscrolls());
        this.setSize(300, this.getHeight());
    }

    protected void setTreeTab(TreeTab tt) {
        this.treeTab = tt;
    }

    protected void setButtonPane(ButtonPane buttonPane) {
        this.buttonPane = buttonPane;
    }

    protected void setInfoPanel(InfoPanel infoPane) {
        this.infoPane = infoPane;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jbutton_open = new JButton();
        this.jbutton_remove = new JButton();
        this.setLayout(new GridBagLayout());
        this.jScrollPane1.setAutoscrolls(true);
        this.jList1.setMaximumSize(new Dimension(65000, 65000));
        this.jList1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JListProjectPane.this.jList1MouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel1.setText(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("LABEL_FILTER"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.jTextField1.setColumns(10);
        this.jTextField1.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                JListProjectPane.this.jTextField1KeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        this.jPanel1.add((Component)this.jTextField1, gridBagConstraints);
        this.jbutton_open.setText(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("STR_OPEN"));
        this.jbutton_open.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JListProjectPane.this.jbutton_openActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.jPanel1.add((Component)this.jbutton_open, gridBagConstraints);
        this.jbutton_remove.setText(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("STR_REMOVE"));
        this.jbutton_remove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JListProjectPane.this.jbutton_removeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.jPanel1.add((Component)this.jbutton_remove, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void jTextField1KeyReleased(KeyEvent evt) {
        this.filter_string = this.jTextField1.getText();
        this.changepaths();
    }

    private void jbutton_openActionPerformed(ActionEvent evt) {
        this.openFirstSelectedProject();
    }

    private void jbutton_removeActionPerformed(ActionEvent evt) {
        this.remove();
    }

    private void jList1MouseClicked(MouseEvent evt) {
        this.jlistopeend(evt);
    }

    private void openFirstSelectedProject() {
        this.geoMenu.enableAddPDFButton();
        Object obj = this.jList1.getSelectedValue();
        if (obj instanceof String) {
            this.openProject((String)obj);
        }
    }

    public Object[] getSelectedValues() {
        return this.jList1.getSelectedValues();
    }

    protected void changepaths() {
        String savePath = GeometraConfiguration.getSavePath();
        if (savePath == null) {
            System.out.println("savePath=null, s\u00e4tter savePath till userhome/geometra");
            System.out.println("var s\u00e4ll starta om programmet, PLEASE RESTART THE PROGRAM");
            String nysavepath = System.getProperty("user.home") + File.separator + "Geometra";
            GeometraConfiguration.putSavePath(nysavepath);
            savePath = GeometraConfiguration.getSavePath();
        }
        File save_path = new File(savePath);
        File[] listFiles = save_path.listFiles(StaticHelpers.getGeometraProjectFileFilter());
        Vector<String> snippsnapp = new Vector<String>();
        if (listFiles != null) {
            for (File project : listFiles) {
                if (project.getName().toLowerCase().indexOf(this.filter_string.toLowerCase()) <= -1) continue;
                snippsnapp.add(project.getName());
            }
        }
        JListProjectPane.sortList(snippsnapp);
        this.jList1.setListData(snippsnapp);
        this.jList1.invalidate();
        this.jList1.validate();
        this.jList1.repaint();
    }

    public static void sortList(List<String> list) {
        ArrayList<String> b\u00f6rjarp\u00e5siffror = new ArrayList<String>();
        ArrayList<String> b\u00f6rjarp\u00e5bokstav = new ArrayList<String>();
        String siffra = "0123456789";
        for (String projectName : list) {
            if ("0123456789".contains(projectName.charAt(0) + "")) {
                b\u00f6rjarp\u00e5siffror.add(projectName);
                continue;
            }
            b\u00f6rjarp\u00e5bokstav.add(projectName);
        }
        Collections.sort(b\u00f6rjarp\u00e5bokstav);
        Collections.sort(b\u00f6rjarp\u00e5siffror, Collections.reverseOrder());
        list.clear();
        list.addAll(b\u00f6rjarp\u00e5siffror);
        list.addAll(b\u00f6rjarp\u00e5bokstav);
    }

    protected void dumpStatus() {
        this.project_status.clear();
    }

    void setComponentPopupMenuOnTheList(JPopupMenu pm_client) {
        this.jList1.setComponentPopupMenu(pm_client);
    }

    private void remove() {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object[] selectedValues = JListProjectPane.this.jList1.getSelectedValues();
                Vector<String> finafisken = new Vector<String>();
                String savePath = GeometraConfiguration.getSavePath();
                for (Object obj : selectedValues) {
                    if (!(obj instanceof String)) continue;
                    String message = ResourceBundle.getBundle("se/sjobeck/Geometra").getString("STR_CONFIRM_REMOVE");
                    String removing2 = ResourceBundle.getBundle("se/sjobeck/Geometra").getString("STR_CONFIRM_REMOVE2");
                    String removing3 = ResourceBundle.getBundle("se/sjobeck/Geometra").getString("STR_CONFIRM_REMOVE3");
                    String title = ResourceBundle.getBundle("se/sjobeck/Geometra").getString("JMI_SERVER_DELETE");
                    int k = JOptionPane.showOptionDialog(JListProjectPane.this.jlpp, "<html>" + message + " " + (String)obj + "<br>" + removing2 + "<br>" + removing3 + "</html>", title, 2, 3, projectIcon, null, null);
                    if (k != 0) continue;
                    finafisken.add((String)obj);
                }
                for (String project : finafisken) {
                    VersionTracker lvt = VersionTrackerFactory.loadVersionTracker((String)(savePath + File.separator + project));
                    lvt.getLock();
                    try {
                        File f = new File(savePath + File.separator + project);
                        this.removeFile(f);
                        lvt.setNeedToBeReloaded();
                    }
                    finally {
                        lvt.relaseLock();
                    }
                }
                JListProjectPane.this.changepaths();
            }

            private void removeFile(File file) {
                if (file.isDirectory()) {
                    File[] listFiles;
                    for (File f : listFiles = file.listFiles()) {
                        this.removeFile(f);
                    }
                }
                file.delete();
            }
        };
        new Thread(runnable).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized Vector<String> getAllProjectsInNeedOfUpload() {
        Vector<String> finafisken = new Vector<String>();
        Set<String> keySet = this.project_status.keySet();
        for (String project : keySet) {
            if (this.project_status.get(project) != ProjectStatus.NEED_UPLOAD) continue;
            boolean reload = true;
            while (reload) {
                reload = false;
                VersionTracker lvt = VersionTrackerFactory.loadVersionTracker((String)(GeometraConfiguration.getSavePath() + File.separator + project));
                lvt.getLock();
                try {
                    if (!lvt.isSynchronized()) continue;
                    finafisken.add(project);
                }
                catch (NeedToBeReloadedException e) {
                    reload = true;
                }
                finally {
                    lvt.relaseLock();
                }
            }
        }
        return finafisken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized Vector<String> getAllProjectsInNeedOfDownload() {
        Vector<String> finafisken = new Vector<String>();
        Set<String> keySet = this.project_status.keySet();
        for (String project : keySet) {
            if (this.project_status.get(project) != ProjectStatus.NEED_DOWNLOAD) continue;
            boolean reload = true;
            while (reload) {
                reload = false;
                VersionTracker lvt = VersionTrackerFactory.loadVersionTracker((String)(GeometraConfiguration.getSavePath() + File.separator + project));
                lvt.getLock();
                try {
                    if (!lvt.isSynchronized()) continue;
                    finafisken.add(project);
                }
                catch (NeedToBeReloadedException e) {
                    reload = true;
                }
                finally {
                    lvt.relaseLock();
                }
            }
        }
        return finafisken;
    }

    private void jlistopeend(MouseEvent evt) {
        if (evt.getClickCount() > 1 && evt.getButton() == 1) {
            this.openFirstSelectedProject();
        }
    }

    public synchronized void setStatus(String project, ProjectStatus ps) {
        this.project_status.put(project, ps);
    }

    public synchronized ProjectStatus getStatus(String project) {
        return this.project_status.get(project);
    }

    protected void loadProject(String project_name) {
        this.treeTab.switchFocus();
        String save_path = GeometraConfiguration.getSavePath() + File.separator + project_name + File.separator + project_name;
        File toLoadFile = new File(save_path + ResourceBundle.getBundle("se/sjobeck/Geometra").getString("GEOMETRA_EXTENSION"));
        TabManager.getInstance().openProject(toLoadFile, this.buttonPane, this.infoPane);
        this.treeTab.setProjectName(toLoadFile.getName());
    }

    private void op(String project_name) {
        if (!TabManager.getInstance().isLastProject()) {
            this.loadProject(project_name);
        } else {
            int answer = Geometra.createSaveAndLoadDialog(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DIALOG_OPEN_NEW_PROJECT"));
            switch (answer) {
                case 0: {
                    TabManager.getInstance().startSaving(this.buttonPane, this.infoPane);
                }
                case 1: {
                    GeometraSubject.getInstance().disposeAll(this);
                    this.loadProject(project_name);
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openProject(String project_name_) {
        ProjectStatus ps = this.project_status.get(project_name_);
        if (ps == ProjectStatus.NEED_DOWNLOAD) {
            String title;
            String message = ResourceBundle.getBundle("se/sjobeck/Geometra").getString("CHOOSE_DOWNLOAD_OR_SET_VERSION");
            int showOptionDialog = JOptionPane.showOptionDialog(this, message, title = ResourceBundle.getBundle("se/sjobeck/Geometra").getString("PLEASE_UPDATE_PROJECT"), 0, 3, needDownloadIcon, null, null);
            if (0 == showOptionDialog) {
                String[] projects = new String[]{project_name_};
                Runnable projectLoader = this.treeTab.getProjectLoader(projects);
                projectLoader.run();
                this.op(project_name_);
            } else {
                Vector<String> vs = new Vector<String>();
                vs.add(project_name_);
                Map versiontracker_on_server = ((FromServerMessage)ClientThread.sendMessage((Message)Message.GetGeometraVersionTracker, (Object[])new Object[]{vs})).getProjectToVersionTrackerMap();
                VersionTracker vt_server = (VersionTracker)versiontracker_on_server.get(project_name_);
                String save_path = GeometraConfiguration.getSavePath() + File.separator + project_name_;
                boolean reload = true;
                while (reload) {
                    reload = false;
                    VersionTracker vt_client = VersionTrackerFactory.loadVersionTracker((String)save_path);
                    vt_client.getLock();
                    try {
                        vt_client.setVersion(vt_server.getVersion());
                    }
                    catch (NeedToBeReloadedException ex) {
                        Logger.getLogger(JListProjectPane.class.getName()).log(Level.SEVERE, null, ex);
                        if (ex.getVersionTracker() != vt_client) continue;
                        reload = true;
                    }
                    finally {
                        VersionTrackerFactory.saveVersionTracker((String)save_path, (VersionTracker)vt_client);
                        vt_client.relaseLock();
                    }
                }
                this.op(project_name_);
            }
        } else {
            this.op(project_name_);
        }
    }

    private class MyCellRenderer
    extends JPanel
    implements ListCellRenderer {
        private static final long serialVersionUID = 1L;
        private JLabel first;
        private JLabel second;
        private Dimension iconsize = null;
        private Dimension lsize = new Dimension(0, 0);

        public MyCellRenderer() {
            FlowLayout fl = new FlowLayout();
            fl.setAlignment(0);
            fl.setHgap(0);
            fl.setVgap(0);
            this.setLayout(fl);
            this.first = new JLabel();
            this.second = new JLabel();
            this.second.setLayout(new FlowLayout());
            this.add(this.first);
            this.add(this.second);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(this.first.getPreferredSize().width + this.lsize.width, this.first.getPreferredSize().height);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String text = (String)value;
            boolean reload = true;
            while (reload) {
                reload = false;
                VersionTracker lvt = VersionTrackerFactory.loadVersionTracker((String)(GeometraConfiguration.getSavePath() + File.separator + text));
                lvt.getLock();
                try {
                    if (lvt.isSynchronized()) {
                        this.first.setIcon(TreeTab.SyncIcon);
                        continue;
                    }
                    this.first.setIcon(null);
                    if (this.iconsize != null) {
                        this.first.setPreferredSize(this.iconsize);
                        continue;
                    }
                    this.iconsize = new Dimension(TreeTab.SyncIcon.getIconWidth(), TreeTab.SyncIcon.getIconHeight());
                    this.first.setPreferredSize(this.iconsize);
                }
                catch (NeedToBeReloadedException ex) {
                    Logger.getLogger(JListProjectPane.class.getName()).log(Level.SEVERE, null, ex);
                    reload = true;
                }
                finally {
                    lvt.relaseLock();
                }
            }
            this.second.setText(text);
            Dimension preferredLayoutSize = this.second.getLayout().preferredLayoutSize(this);
            if (this.lsize.width < preferredLayoutSize.width) {
                this.lsize = preferredLayoutSize;
            }
            this.second.validate();
            ProjectStatus status = JListProjectPane.this.getStatus(text);
            if (status == null) {
                this.second.setIcon(projectIcon);
            } else {
                switch (status) {
                    case NEED_DOWNLOAD: {
                        this.second.setIcon(needDownloadIcon);
                        break;
                    }
                    case DO_NOTHING: {
                        this.second.setIcon(projectIcon);
                        break;
                    }
                    case NEED_UPLOAD: {
                        this.second.setIcon(needUploadIcon);
                    }
                }
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            this.validate();
            return this;
        }
    }

    public static enum ProjectStatus {
        NEED_DOWNLOAD,
        DO_NOTHING,
        NEED_UPLOAD;

    }
}

