/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.geometra.gui.panels;

import java.awt.Color;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.NumberFormat;
import java.util.LinkedList;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;
import org.icepdf.ri.common.views.painting.core.Blueprint;
import org.icepdf.ri.common.views.painting.core.BlueprintPage;
import org.icepdf.ri.common.views.painting.core.GeometraCollection;
import org.icepdf.ri.common.views.painting.drawings.GeometraDrawing;
import org.icepdf.ri.common.views.painting.drawings.ScaleDrawing;
import se.sjobeck.geometra.datastructures.GeometraUtilities;
import se.sjobeck.geometra.datastructures.PaintingStateMachine;
import se.sjobeck.geometra.datastructures.blueprint.GeometraManager;
import se.sjobeck.geometra.datastructures.blueprint.TabManager;
import se.sjobeck.geometra.datastructures.blueprint.observer.BlueprintSubject;
import se.sjobeck.geometra.datastructures.blueprint.observer.GeometraSubject;
import se.sjobeck.geometra.datastructures.blueprint.observer.Observer;
import se.sjobeck.geometra.datastructures.core.BlueprintImpl;
import se.sjobeck.geometra.datastructures.drawings.GeometraDrawingImpl;
import se.sjobeck.geometra.datastructures.drawings.TotalDrawing;
import se.sjobeck.geometra.gui.main.Geometra;
import se.sjobeck.geometra.gui.main.GeometraMenu;
import se.sjobeck.geometra.gui.panels.BlueprintTab;
import se.sjobeck.geometra.gui.panels.DotDrawingDropDownButton;
import se.sjobeck.geometra.gui.panels.DropDownButton;
import se.sjobeck.geometra.gui.panels.GeometraButton;
import se.sjobeck.geometra.gui.panels.GeometraToggleButton;
import se.sjobeck.geometra.gui.panels.InfoPanel;
import se.sjobeck.geometra.gui.panels.JTreePDFPane;
import se.sjobeck.geometra.gui.panels.LineDrawingDropDownButton;
import se.sjobeck.geometra.gui.panels.SnurraPDFDialog;
import se.sjobeck.geometra.gui.panels.TreeTab;
import se.sjobeck.geometra.gui.panels.datastructures.GeometraDocument;
import se.sjobeck.geometra.printpdf.AbstractPDFWriter;
import se.sjobeck.gui.DialogCreator;
import se.sjobeck.images.IconLoader;

public class ButtonPane
extends JPanel
implements ActionListener,
Observer {
    private static final long serialVersionUID = 1L;
    public static int selectedTabIndex;
    private final ImageIcon decreaseIcon = ButtonPane.createIcon("decrease.png");
    private final ImageIcon fitToScreenIcon = ButtonPane.createIcon("view-fullscreen.png");
    private final ImageIcon helpIcon = ButtonPane.createIcon("help.png");
    private final ImageIcon increaseIcon = ButtonPane.createIcon("increase.png");
    private final ImageIcon moveIcon = ButtonPane.createIcon("transform-move.png");
    private final ImageIcon redoIcon = ButtonPane.createIcon("rotate-right.png");
    private final ImageIcon undoIcon = ButtonPane.createIcon("rotate-left.png");
    private final ImageIcon rotateLIcon = ButtonPane.createIcon("left-rotate.png");
    private final ImageIcon rotateRIcon = ButtonPane.createIcon("right-rotate.png");
    private final ImageIcon zoomIcon = ButtonPane.createIcon("page-magnifier.png");
    private final ImageIcon dotIcon = ButtonPane.createIcon("square-dot.png");
    private final ImageIcon holeIcon = ButtonPane.createIcon("HoleDrawing.png");
    private final ImageIcon measureIcon = ButtonPane.createIcon("SquareDrawing.png");
    private final ImageIcon textIcon = ButtonPane.createIcon("text-drawing.png");
    private final ImageIcon lineIcon = ButtonPane.createIcon("LineDrawing.png");
    private final ImageIcon standardIcon = ButtonPane.createIcon("cursorPic.png");
    private final ImageIcon printpdfIcon = IconLoader.getIcon((String)"/org/tangoProject/medium/document-print.png");
    private final ImageIcon saveIcon = IconLoader.getIcon((String)"/se/sjobeck/images/save.png");
    private final JButton printpdf = new GeometraButton(this.printpdfIcon);
    private final JButton rotateL = new GeometraButton(this.rotateLIcon);
    private final JButton undo = new GeometraButton(this.undoIcon);
    private final JButton redo = new GeometraButton(this.redoIcon);
    private final JButton increase = new GeometraButton(this.increaseIcon);
    private final JButton decrease = new GeometraButton(this.decreaseIcon);
    private final JButton saveButton = new GeometraButton(this.saveIcon, ResourceBundle.getBundle("se/sjobeck/Geometra").getString("TOOLTIP_SAVEBUTTON"));
    private final JButton help = new GeometraButton(this.helpIcon);
    private final JButton fitToScreen = new GeometraButton(this.fitToScreenIcon);
    private final JButton rotateR = new GeometraButton(this.rotateRIcon);
    private final JToggleButton line = new GeometraToggleButton(this.lineIcon);
    private final DropDownButton lineButton = new LineDrawingDropDownButton(this.line, this);
    private final JToggleButton hole = new GeometraToggleButton(this.holeIcon);
    private final JToggleButton text = new GeometraToggleButton(this.textIcon);
    private final JToggleButton move = new GeometraToggleButton(this.moveIcon);
    private final JToggleButton measure = new GeometraToggleButton(this.measureIcon);
    private final JToggleButton zoomToggle = new GeometraToggleButton(this.zoomIcon);
    private final JToggleButton standard = new GeometraToggleButton(this.standardIcon);
    private final JToggleButton dot = new GeometraToggleButton(this.dotIcon);
    private final DotDrawingDropDownButton dotbutton = new DotDrawingDropDownButton(this.dot, this);
    private JToggleButton recentToggle;
    private final ButtonGroup toggleGroup = new ButtonGroup();
    private JFormattedTextField skalstockTextField;
    private final JTextField zoomTextField = new JTextField(5);
    private final TabManager manager = TabManager.getInstance();
    private final GeometraSubject geoSubject = GeometraSubject.getInstance();
    private final GeometraManager geoManager = GeometraManager.getInstance();
    private final PaintingStateMachine machine = PaintingStateMachine.getInstance();
    private final NumberFormat skalstockFormat = NumberFormat.getNumberInstance();
    private final String helpKey = "F1";
    private final String dotKey = "F5";
    private final String lineKey = "F6";
    private final String measureKey = "F7";
    private final String holeKey = "F8";
    private final String standardKey = "F9";
    private final String fullscreenKey = "F4";
    private final String undoKey = "ctrl Z";
    private final String redoKey = "ctrl Y";
    private final String textKey = "F10";
    private final JLabel fakeFillLabel = new JLabel();
    private final JLabel fakeShow2dLabel = new JLabel();
    private final JLabel fakeShow3dLabel = new JLabel();
    private final JLabel fakeLockLabel = new JLabel();
    private final JLabel fakeRenameLabel = new JLabel();
    private final JLabel fakeChooseColorLabel = new JLabel();
    public static final KeyStroke KEYSTROKE_LOCK;
    public static final KeyStroke KEYSTROKE_FILL;
    public static final KeyStroke KEYSTROKE_RENAME;
    public static final KeyStroke KEYSTROKE_SHOW2D;
    public static final KeyStroke KEYSTROKE_SHOW3D;
    public static final KeyStroke KEYSTROKE_CHOOSECOLOR;
    private final GeometraMenu geometraMenu;

    public static final ImageIcon createIcon(String name) {
        return IconLoader.getIcon((String)("/se/sjobeck/geometra/gui/panels/icons/" + name));
    }

    public ButtonPane(InfoPanel infoPane, JTreePDFPane treePane, BlueprintTab pdfTabs, TreeTab treeTab, GeometraMenu geometraMenu) {
        this.geometraMenu = geometraMenu;
        this.geoSubject.addObserver(this);
        this.setLayout(new BoxLayout(this, 3));
        JPanel buttonPanel = new JPanel(new FlowLayout(0));
        this.saveButton.setToolTipText(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("TOOLTIP_SAVEBUTTON"));
        this.help.setToolTipText(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("TOOLTIP_HELP") + " (" + "F1" + ")");
        this.rotateL.setToolTipText(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("TOOLTIP_ROTATE_LEFT"));
        this.undo.setToolTipText(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("TOOLTIP_UNDO") + " (" + "ctrl Z" + ")");
        this.redo.setToolTipText(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("TOOLTIP_REDO") + " (" + "ctrl Y" + ")");
        this.rotateR.setToolTipText(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("TOOLTIP_ROTATE_RIGHT"));
        this.zoomTextField.setDocument(new GeometraDocument("0123456789%"));
        this.increase.setPreferredSize(new Dimension(22, 32));
        this.decrease.setPreferredSize(new Dimension(22, 32));
        this.skalstockFormat.setMinimumFractionDigits(2);
        this.skalstockFormat.setMaximumFractionDigits(2);
        this.skalstockTextField = new JFormattedTextField(this.skalstockFormat);
        this.skalstockTextField.setColumns(4);
        this.skalstockTextField.setDocument(new GeometraDocument("0123456789,."));
        this.skalstockTextField.setText("1,00");
        this.skalstockTextField.setEditable(false);
        JLabel skalstockLabel = new JLabel(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("LABEL_SCALE_DRAWING"));
        skalstockLabel.setLabelFor(this.skalstockTextField);
        this.zoomToggle.setToolTipText(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("TOOLTIP_ZOOM"));
        this.move.setToolTipText(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("TOOLTIP_MOVE"));
        this.hole.setToolTipText(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("TOOLTIP_HOLE") + " (" + "F8" + ")");
        this.text.setToolTipText(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("TOOLTIP_TEXTBUTTON"));
        this.standard.setToolTipText(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("TOOLTIP_STANDARD") + " (" + "F9" + ")");
        this.fitToScreen.setToolTipText(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("TOOLTIP_FULL_SCREEN") + " (" + "F4" + ")");
        this.dot.setToolTipText(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("TOOLTIP_DOT") + " (" + "F5" + ")");
        this.line.setToolTipText(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("TOOLTIP_LINE") + " (" + "F6" + ")");
        this.measure.setToolTipText(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("TOOLTIP_MEASURE") + " (" + "F7" + ")");
        this.saveButton.addActionListener(this);
        this.undo.addActionListener(this);
        this.redo.addActionListener(this);
        this.rotateL.addActionListener(this);
        this.rotateR.addActionListener(this);
        ZoomFieldListener zfl = new ZoomFieldListener();
        this.increase.addActionListener(zfl);
        this.decrease.addActionListener(zfl);
        this.zoomTextField.addActionListener(zfl);
        this.move.addActionListener(this);
        this.dot.addActionListener(this);
        this.line.addActionListener(this);
        this.zoomToggle.addActionListener(this);
        this.measure.addActionListener(this);
        this.fitToScreen.addActionListener(this);
        this.standard.addActionListener(this);
        this.hole.addActionListener(this);
        this.printpdf.addActionListener(this);
        this.text.addActionListener(this);
        this.help.addActionListener(this);
        JSeparator sep1 = new JSeparator(1);
        sep1.setPreferredSize(new Dimension(5, 32));
        JSeparator sep2 = new JSeparator(1);
        sep2.setPreferredSize(new Dimension(5, 32));
        JSeparator sep3 = new JSeparator(1);
        sep3.setPreferredSize(new Dimension(5, 32));
        JSeparator sep4 = new JSeparator(1);
        sep4.setPreferredSize(new Dimension(5, 32));
        JSeparator sep5 = new JSeparator(1);
        sep5.setPreferredSize(new Dimension(5, 32));
        JSeparator sep6 = new JSeparator(1);
        sep6.setPreferredSize(new Dimension(5, 32));
        buttonPanel.add(this.saveButton);
        buttonPanel.add(this.rotateL);
        buttonPanel.add(this.rotateR);
        buttonPanel.add(this.move);
        buttonPanel.add(sep3);
        buttonPanel.add(this.undo);
        buttonPanel.add(this.redo);
        buttonPanel.add(sep2);
        buttonPanel.add(this.zoomToggle);
        buttonPanel.add(this.decrease);
        buttonPanel.add(this.zoomTextField);
        buttonPanel.add(this.increase);
        buttonPanel.add(this.fitToScreen);
        buttonPanel.add(sep4);
        buttonPanel.add(this.dotbutton);
        buttonPanel.add(this.lineButton);
        buttonPanel.add(this.measure);
        buttonPanel.add(this.hole);
        buttonPanel.add(this.text);
        buttonPanel.add(this.standard);
        buttonPanel.add(sep5);
        buttonPanel.add(skalstockLabel);
        buttonPanel.add(this.skalstockTextField);
        buttonPanel.add(sep6);
        buttonPanel.add(this.printpdf);
        buttonPanel.add(this.help);
        buttonPanel.add(this.fakeFillLabel);
        buttonPanel.add(this.fakeShow2dLabel);
        buttonPanel.add(this.fakeShow3dLabel);
        buttonPanel.add(this.fakeLockLabel);
        buttonPanel.add(this.fakeRenameLabel);
        buttonPanel.add(this.fakeChooseColorLabel);
        this.add(buttonPanel);
        this.add(new JSeparator());
        this.disableButtons();
        this.installKeys();
        this.toggleGroup.add(this.line);
        this.toggleGroup.add(this.hole);
        this.toggleGroup.add(this.text);
        this.toggleGroup.add(this.move);
        this.toggleGroup.add(this.measure);
        this.toggleGroup.add(this.zoomToggle);
        this.toggleGroup.add(this.standard);
        this.toggleGroup.add(this.dot);
    }

    private void installKeys() {
        AbstractAction textAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ButtonPane.this.setSelection(ButtonPane.this.text);
                ButtonPane.this.machine.startSession(PaintingStateMachine.Session.TEXT);
            }
        };
        AbstractAction holeAction = new AbstractAction(){
            private static final long serialVersionUID = -2367173137017084715L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ButtonPane.this.setSelection(ButtonPane.this.hole);
                ButtonPane.this.machine.startSession(PaintingStateMachine.Session.HOLE);
            }
        };
        AbstractAction measureAction = new AbstractAction(){
            private static final long serialVersionUID = -2350091350637606440L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ButtonPane.this.setSelection(ButtonPane.this.measure);
                ButtonPane.this.machine.startSession(PaintingStateMachine.Session.SQUARE);
            }
        };
        AbstractAction standardAction = new AbstractAction(){
            private static final long serialVersionUID = 1435070524098786909L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ButtonPane.this.setSelection(ButtonPane.this.standard);
                ButtonPane.this.machine.startSession(PaintingStateMachine.Session.SELECT);
            }
        };
        AbstractAction lineAction = new AbstractAction(){
            private static final long serialVersionUID = 7991139536828879119L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ButtonPane.this.setSelection(ButtonPane.this.line);
                ButtonPane.this.machine.startSession(PaintingStateMachine.Session.LINE);
            }
        };
        AbstractAction fitToScreenAction = new AbstractAction(){
            private static final long serialVersionUID = 820031277558081327L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ButtonPane.this.fitToScreen();
            }
        };
        AbstractAction helpAction = new AbstractAction(){
            private static final long serialVersionUID = -5679123886756407210L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ButtonPane.this.showHelp();
            }
        };
        AbstractAction undoAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ButtonPane.this.undo();
            }
        };
        AbstractAction redoAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ButtonPane.this.redo();
            }
        };
        AbstractAction dotAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ButtonPane.this.setSelection(ButtonPane.this.dot);
                ButtonPane.this.machine.startSession(PaintingStateMachine.Session.DOT);
            }
        };
        AbstractAction fakeFillAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Geometra.GEOMETRA_POPUP_MENU.fillDrawings(ButtonPane.this);
            }
        };
        AbstractAction fakeShow2dAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Geometra.GEOMETRA_POPUP_MENU.showTwoDimensions(ButtonPane.this);
            }
        };
        AbstractAction fakeShow3dAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Geometra.GEOMETRA_POPUP_MENU.showThreeDimensions(ButtonPane.this);
            }
        };
        AbstractAction fakeLockAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Geometra.GEOMETRA_POPUP_MENU.lockDrawing(ButtonPane.this);
            }
        };
        AbstractAction fakeRenameAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Geometra.GEOMETRA_POPUP_MENU.renameDrawing(ButtonPane.this);
            }
        };
        AbstractAction fakeChooseColorAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Geometra.GEOMETRA_POPUP_MENU.chooseColor();
            }
        };
        this.fakeFillLabel.getActionMap().put("fakeFillAction", fakeFillAction);
        this.line.getInputMap(2).put(KeyStroke.getKeyStroke("F6"), "line");
        this.undo.getInputMap(2).put(KeyStroke.getKeyStroke("ctrl Z"), "undo");
        this.redo.getInputMap(2).put(KeyStroke.getKeyStroke("ctrl Y"), "redo");
        this.fitToScreen.getInputMap(2).put(KeyStroke.getKeyStroke("F4"), "fitToScreen");
        this.help.getInputMap(2).put(KeyStroke.getKeyStroke("F1"), "help");
        this.dot.getInputMap(2).put(KeyStroke.getKeyStroke("F5"), "dot");
        this.measure.getInputMap(2).put(KeyStroke.getKeyStroke("F7"), "measure");
        this.hole.getInputMap(2).put(KeyStroke.getKeyStroke("F8"), "hole");
        this.text.getInputMap(2).put(KeyStroke.getKeyStroke("F10"), "text");
        this.standard.getInputMap(2).put(KeyStroke.getKeyStroke("F9"), "standard");
        this.fakeFillLabel.getInputMap(2).put(KEYSTROKE_FILL, "fakeFillAction");
        this.fakeShow2dLabel.getInputMap(2).put(KEYSTROKE_SHOW2D, "fakeShow2dAction");
        this.fakeShow3dLabel.getInputMap(2).put(KEYSTROKE_SHOW3D, "fakeShow3dAction");
        this.fakeLockLabel.getInputMap(2).put(KEYSTROKE_LOCK, "fakeLockAction");
        this.fakeRenameLabel.getInputMap(2).put(KEYSTROKE_RENAME, "fakeRenameAction");
        this.fakeChooseColorLabel.getInputMap(2).put(KEYSTROKE_CHOOSECOLOR, "fakeChooseColorAction");
        this.fakeShow2dLabel.getActionMap().put("fakeShow2dAction", fakeShow2dAction);
        this.fakeShow3dLabel.getActionMap().put("fakeShow3dAction", fakeShow3dAction);
        this.fakeLockLabel.getActionMap().put("fakeLockAction", fakeLockAction);
        this.fakeRenameLabel.getActionMap().put("fakeRenameAction", fakeRenameAction);
        this.fakeChooseColorLabel.getActionMap().put("fakeChooseColorAction", fakeChooseColorAction);
        this.help.getActionMap().put("help", helpAction);
        this.fitToScreen.getActionMap().put("fitToScreen", fitToScreenAction);
        this.dot.getActionMap().put("dot", dotAction);
        this.line.getActionMap().put("line", lineAction);
        this.measure.getActionMap().put("measure", measureAction);
        this.hole.getActionMap().put("hole", holeAction);
        this.standard.getActionMap().put("standard", standardAction);
        this.redo.getActionMap().put("redo", redoAction);
        this.undo.getActionMap().put("undo", undoAction);
        this.text.getActionMap().put("text", textAction);
    }

    private void undo() {
        this.geoSubject.undo();
    }

    private void redo() {
        this.geoSubject.redo();
    }

    private void fitToScreen() {
        this.manager.setFitView(3, TabManager.Fit.SINGLE_FIT);
        this.updateZoomField();
    }

    private void showHelp() {
        Desktop dt = Desktop.getDesktop();
        try {
            dt.browse(new URI(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("HELP_FILE")));
        }
        catch (IOException e1) {
            Geometra.showErrorDialog(e1.getMessage());
        }
        catch (URISyntaxException e1) {
            Geometra.showErrorDialog(e1.getMessage());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JButton) {
            JButton buttonPressed = (JButton)e.getSource();
            if (buttonPressed.equals(this.saveButton)) {
                this.save();
            } else if (buttonPressed.equals(this.rotateL)) {
                this.manager.rotateLeft();
            } else if (buttonPressed.equals(this.rotateR)) {
                this.manager.rotateRight();
            } else if (buttonPressed.equals(this.fitToScreen)) {
                this.fitToScreen();
            } else if (buttonPressed.equals(this.undo)) {
                this.undo();
            } else if (buttonPressed.equals(this.redo)) {
                this.redo();
            } else if (buttonPressed.equals(this.printpdf)) {
                this.printpdf();
            } else if (buttonPressed.equals(this.help)) {
                this.showHelp();
            }
        } else if (e.getSource() instanceof JToggleButton) {
            JToggleButton buttonPressed = (JToggleButton)e.getSource();
            if (buttonPressed.isSelected()) {
                buttonPressed.setContentAreaFilled(true);
            } else {
                buttonPressed.setContentAreaFilled(false);
            }
            if (buttonPressed.equals(this.move)) {
                this.setSelection(this.move);
                this.machine.startSession(PaintingStateMachine.Session.FREE);
            } else if (buttonPressed.equals(this.measure)) {
                this.setSelection(this.measure);
                this.machine.startSession(PaintingStateMachine.Session.SQUARE);
            } else if (buttonPressed.equals(this.standard)) {
                this.setSelection(this.standard);
                this.machine.startSession(PaintingStateMachine.Session.SELECT);
            } else if (buttonPressed.equals(this.dot)) {
                this.setSelection(this.dot);
                this.machine.startSession(PaintingStateMachine.Session.DOT);
            } else if (buttonPressed.equals(this.line)) {
                this.setSelection(this.line);
                this.machine.startSession(PaintingStateMachine.Session.LINE);
            } else if (buttonPressed.equals(this.zoomToggle)) {
                this.setSelection(this.zoomToggle);
                this.machine.startSession(PaintingStateMachine.Session.ZOOM);
            } else if (buttonPressed.equals(this.hole)) {
                this.setSelection(this.hole);
                this.machine.startSession(PaintingStateMachine.Session.HOLE);
            } else if (buttonPressed.equals(this.text)) {
                this.setSelection(this.text);
                this.machine.startSession(PaintingStateMachine.Session.TEXT);
            }
        } else if (e.getSource() instanceof JFormattedTextField) {
            this.skalstockTextField = (JFormattedTextField)e.getSource();
            double skalstockDouble = ((Number)this.skalstockTextField.getValue()).doubleValue();
            this.geoSubject.updateRealDistance(new Double(skalstockDouble), this);
        }
    }

    public void activateButtons() {
        this.saveButton.setEnabled(true);
        this.undo.setEnabled(true);
        this.redo.setEnabled(true);
        this.rotateL.setEnabled(true);
        this.rotateR.setEnabled(true);
        this.zoomToggle.setEnabled(true);
        this.fitToScreen.setEnabled(true);
        this.increase.setEnabled(true);
        this.decrease.setEnabled(true);
        this.measure.setEnabled(true);
        this.move.setEnabled(true);
        this.standard.setEnabled(true);
        this.dot.setEnabled(true);
        this.line.setEnabled(true);
        this.hole.setEnabled(true);
        this.text.setEnabled(true);
        this.skalstockTextField.setEnabled(true);
        this.zoomTextField.setEnabled(true);
        this.updateZoomField();
        this.standard.setSelected(true);
        this.standard.setContentAreaFilled(true);
        this.recentToggle = this.standard;
        this.machine.startSession(PaintingStateMachine.Session.SELECT);
    }

    public void disableButtons() {
        this.saveButton.setEnabled(false);
        this.undo.setEnabled(false);
        this.redo.setEnabled(false);
        this.rotateL.setEnabled(false);
        this.rotateR.setEnabled(false);
        this.hole.setEnabled(false);
        this.text.setEnabled(false);
        this.rotateR.setEnabled(false);
        this.zoomToggle.setEnabled(false);
        this.fitToScreen.setEnabled(false);
        this.increase.setEnabled(false);
        this.decrease.setEnabled(false);
        this.measure.setEnabled(false);
        this.move.setEnabled(false);
        this.standard.setEnabled(false);
        this.dot.setEnabled(false);
        this.line.setEnabled(false);
        this.skalstockTextField.setEnabled(false);
        this.zoomTextField.setEnabled(false);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void setScaleText(String scaleText) {
        this.zoomTextField.setText(scaleText);
    }

    protected void setSelection(JToggleButton jtb) {
        if (this.recentToggle != null && !this.recentToggle.equals(jtb) && jtb != null) {
            jtb.setSelected(true);
            jtb.setContentAreaFilled(true);
            this.recentToggle.setContentAreaFilled(false);
        }
        this.recentToggle = jtb;
    }

    public void setSkalstockText(String skalstockText) {
        this.skalstockTextField.setText(skalstockText);
    }

    @Override
    public void update(BlueprintSubject.Action action, Object ob, Object source) {
        System.out.println("action: " + (Object)((Object)action));
        switch (action) {
            case PAGE_SWITCH: {
                if (ob instanceof BlueprintPage) {
                    BlueprintPage page = (BlueprintPage)ob;
                    this.updateZoomField(page);
                } else if (ob instanceof GeometraDrawing) {
                    GeometraDrawing gd = (GeometraDrawing)ob;
                    this.updateZoomField(gd.getParent());
                } else if (ob instanceof Blueprint) {
                    this.updateZoomField(this.geoManager.getActivePage());
                }
                this.skalstockTextField.setText("" + this.geoManager.getRealDistance());
                this.updateScaleColor();
                break;
            }
            case LISTENER_SWITCH: {
                break;
            }
            case ZOOM_UPDATE: {
                this.updateZoomField();
                break;
            }
            case ADD: {
                if (!(ob instanceof Blueprint)) break;
                this.updateScaleColor();
                break;
            }
            case UPDATE: {
                if (!(ob instanceof ScaleDrawing)) break;
                ScaleDrawing sd = (ScaleDrawing)ob;
                double d = sd.getRealDistance();
                this.skalstockTextField.setText("" + d);
                this.updateScaleColor();
                break;
            }
        }
    }

    private void updateScaleColor() {
        if (GeometraManager.getInstance().isRealDistanceSet()) {
            this.skalstockTextField.setBackground(Color.GREEN);
        } else {
            this.skalstockTextField.setBackground(Color.RED);
        }
    }

    private void updateZoomField(BlueprintPage page) {
        this.zoomTextField.setText(GeometraUtilities.scaleToString(this.manager.getScale(page)));
    }

    private void updateZoomField() {
        this.zoomTextField.setText(GeometraUtilities.scaleToString(this.manager.getScale()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printpdf() {
        JFileChooser fc;
        int showSaveDialog;
        BlueprintImpl bpi;
        Object selectionObject = this.geoManager.getTree().getSelectionObject();
        LinkedList<GeometraDrawingImpl> lgdi = new LinkedList<GeometraDrawingImpl>();
        String inpdf_filepath = "";
        if (selectionObject instanceof Blueprint) {
            Blueprint bp = (Blueprint)selectionObject;
            bpi = (BlueprintImpl)bp;
            inpdf_filepath = bpi.getFilePath();
            for (int i = 0; i < bp.getNumberOfPages(); ++i) {
                GeometraCollection drawings = bp.getPage(i).getDrawings();
                for (GeometraDrawing gd : drawings) {
                    lgdi.add((GeometraDrawingImpl)gd);
                }
            }
        } else if (selectionObject instanceof BlueprintPage) {
            BlueprintPage bpp = (BlueprintPage)selectionObject;
            bpi = (BlueprintImpl)bpp.getParent();
            inpdf_filepath = bpi.getFilePath();
            GeometraCollection drawings = bpp.getDrawings();
            for (GeometraDrawing gd : drawings) {
                lgdi.add((GeometraDrawingImpl)gd);
            }
        } else {
            try {
                GeometraCollection activeDrawings = new GeometraCollection();
                for (TreePath tp : this.geoManager.getTree().getSelectedPaths()) {
                    if (!(tp.getLastPathComponent() instanceof GeometraDrawing) || tp.getLastPathComponent() instanceof TotalDrawing) continue;
                    activeDrawings.add((Object)((GeometraDrawing)tp.getLastPathComponent()));
                }
                if (activeDrawings == null || activeDrawings.size() < 1) {
                    return;
                }
                bpi = (BlueprintImpl)((GeometraDrawing)activeDrawings.get(0)).getParent().getParent();
                inpdf_filepath = bpi.getFilePath();
                for (GeometraDrawing gd : activeDrawings) {
                    lgdi.add((GeometraDrawingImpl)gd);
                }
            }
            catch (NullPointerException npe) {
                String title = ResourceBundle.getBundle("se/sjobeck/Geometra").getString("ERROR_NODRAWINGSELECTEDWHENPRINTING_TITLE");
                String message = ResourceBundle.getBundle("se/sjobeck/Geometra").getString("ERROR_NODRAWINGSELECTEDWHENPRINTING_MESSAGE");
                DialogCreator.showInformation((Object)message, (String)title);
                return;
            }
        }
        if (0 == (showSaveDialog = (fc = new JFileChooser()).showSaveDialog(Geometra.GEOMETRA_FRAME))) {
            File selectedSaveFile = fc.getSelectedFile();
            SnurraPDFDialog spdfd = new SnurraPDFDialog((Frame)Geometra.GEOMETRA_FRAME, true);
            try {
                String outpdf = selectedSaveFile.getCanonicalPath();
                if (!outpdf.endsWith(".pdf")) {
                    outpdf = outpdf + ".pdf";
                }
                spdfd.set_a_lot_of_stuff(lgdi, inpdf_filepath, outpdf, AbstractPDFWriter.ROTATION.LowerLeft);
                spdfd.setVisible(true);
                if (spdfd.getReturnStatus() == 1) {
                } else {
                    File rrrrr = new File(outpdf);
                    rrrrr.delete();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(ButtonPane.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                spdfd.dont_forget_to_dispose_the_last_shown_pdf();
            }
        }
    }

    private void save() {
        this.geometraMenu.saveProject();
    }

    static {
        KEYSTROKE_LOCK = KeyStroke.getKeyStroke("ctrl S");
        KEYSTROKE_FILL = KeyStroke.getKeyStroke("ctrl 1");
        KEYSTROKE_RENAME = KeyStroke.getKeyStroke("F2");
        KEYSTROKE_SHOW2D = KeyStroke.getKeyStroke("ctrl 2");
        KEYSTROKE_SHOW3D = KeyStroke.getKeyStroke("ctrl 3");
        KEYSTROKE_CHOOSECOLOR = KeyStroke.getKeyStroke("F3");
    }

    private class ZoomFieldListener
    implements ActionListener {
        private ZoomFieldListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof JButton) {
                JButton button = (JButton)e.getSource();
                if (button.equals(ButtonPane.this.increase)) {
                    ButtonPane.this.manager.zoomIncrease();
                    ButtonPane.this.updateZoomField();
                } else if (button.equals(ButtonPane.this.decrease)) {
                    ButtonPane.this.manager.zoomDecrease();
                    ButtonPane.this.updateZoomField();
                }
            } else if (e.getSource() instanceof JTextField) {
                JTextField textField = (JTextField)e.getSource();
                String scaleText = textField.getText();
                if (scaleText.contains("%")) {
                    scaleText = scaleText.substring(0, scaleText.length() - 1);
                } else if (scaleText.length() == 0) {
                    return;
                }
                Double textDouble = new Double(scaleText);
                ButtonPane.this.manager.setUserZoom(textDouble.floatValue());
                ButtonPane.this.updateZoomField();
            }
        }
    }
}

