/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.geometra.export;

import java.awt.Robot;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import org.icepdf.ri.common.views.painting.core.Blueprint;
import org.icepdf.ri.common.views.painting.core.BlueprintPage;
import org.icepdf.ri.common.views.painting.drawings.GeometraDrawing;
import se.sjobeck.GeometraConfiguration;
import se.sjobeck.geometra.datastructures.ClipboardSender;
import se.sjobeck.geometra.datastructures.GeometraUtilities;
import se.sjobeck.geometra.datastructures.drawings.DotDrawingContainer;
import se.sjobeck.geometra.datastructures.drawings.GeometraDrawingImpl;
import se.sjobeck.geometra.datastructures.drawings.TotalDrawing;
import se.sjobeck.geometra.export.ExportListener;
import se.sjobeck.geometra.export.StructuredExport;

public class ExportSchema
implements ExportListener,
Serializable {
    private static final long serialVersionUID = 1L;
    private Row[] rowOrder = new Row[7];
    private String name;
    private CopyPaste cp;
    private boolean vertical;
    private String beforeValue;
    private boolean keepFormulas;
    private String decimalSign;
    private boolean headerVisible;
    private boolean pageVisible;
    private boolean pdfNameVisible;
    private boolean drawingNameVisible;

    public boolean isDrawingNameVisible() {
        return this.drawingNameVisible;
    }

    public void setDrawingNameVisible(boolean drawingNameVisible) {
        this.drawingNameVisible = drawingNameVisible;
    }

    public boolean isPageVisible() {
        return this.pageVisible;
    }

    public void setPageVisible(boolean pageVisible) {
        this.pageVisible = pageVisible;
    }

    public void setHeaderVisible(boolean headerVisible) {
        this.headerVisible = headerVisible;
    }

    public boolean isHeaderVisible() {
        return this.headerVisible;
    }

    public void setPDFNameVisible(boolean visible) {
        this.pdfNameVisible = visible;
    }

    public boolean isPDFNameVisible() {
        return this.pdfNameVisible;
    }

    public String getBeforeValue() {
        return this.beforeValue;
    }

    public void setBeforeValue(String beforeValue) {
        this.beforeValue = beforeValue;
    }

    public CopyPaste getCp() {
        return this.cp;
    }

    public void setCp(CopyPaste cp) {
        this.cp = cp;
    }

    public String getDecimalSign() {
        return this.decimalSign;
    }

    public void setDecimalSign(String decimalSign) {
        this.decimalSign = decimalSign;
    }

    public boolean isKeepFormulas() {
        return this.keepFormulas;
    }

    public void setKeepFormulas(boolean keepFormulas) {
        this.keepFormulas = keepFormulas;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Row[] getRowOrder() {
        return this.rowOrder;
    }

    public void setRowOrder(Row[] rowOrder) {
        this.rowOrder = rowOrder;
    }

    public boolean isVertical() {
        return this.vertical;
    }

    public void setVertical(boolean vertical) {
        this.vertical = vertical;
    }

    public ExportSchema(String name, String beforeValue, String decimalSign, Row[] rowOrder, CopyPaste cp, boolean vertical, boolean keepFormulas, boolean pdfNameVisible, boolean headerVisible, boolean pageVisible, boolean drawingNameVisible) {
        this.name = name;
        this.rowOrder = rowOrder;
        this.cp = cp;
        this.vertical = vertical;
        this.beforeValue = beforeValue;
        this.keepFormulas = keepFormulas;
        this.decimalSign = decimalSign;
        this.pdfNameVisible = pdfNameVisible;
        this.headerVisible = headerVisible;
        this.pageVisible = pageVisible;
        this.drawingNameVisible = drawingNameVisible;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public void export(List<GeometraDrawing> values, StructuredExport export) {
        String out = "";
        out = this.vertical ? this.formatVertical(values, export) : this.formatHorizontal(values, export);
        this.cp.copy_paste(out);
    }

    private String formatVertical(List<GeometraDrawing> values, StructuredExport export) {
        StringBuilder out = new StringBuilder();
        HashSet<Blueprint> addedBlueprints = new HashSet<Blueprint>();
        HashSet<BlueprintPage> addedPages = new HashSet<BlueprintPage>();
        int nbrOfDecimals = GeometraConfiguration.getNDecimals();
        for (GeometraDrawing gd : values) {
            if (!(gd instanceof TotalDrawing)) {
                BlueprintPage page = gd.getParent();
                Blueprint blueprint = page.getParent();
                if (addedBlueprints.add(blueprint) && this.pdfNameVisible) {
                    out.append(blueprint.getDescription());
                    out.append('\n');
                }
                if (addedPages.add(page)) {
                    if (this.pageVisible) {
                        out.append(page.getDescription());
                    } else if (this.drawingNameVisible) {
                        out.append("\t");
                    }
                    if (this.headerVisible) {
                        out.append(this.getTitles(export));
                    }
                    out.append('\n');
                }
            } else {
                if (this.pdfNameVisible) {
                    out.append('\n');
                }
                if (!this.pageVisible && this.drawingNameVisible) {
                    out.append("\t");
                }
                if (this.headerVisible) {
                    out.append(this.getTitles(export));
                }
                out.append('\n');
            }
            if (this.drawingNameVisible) {
                this.appendGeometraDrawingName(gd, out);
            } else if (this.pageVisible) {
                out.append("\t");
            }
            StringBuilder temp = new StringBuilder();
            block10: for (Row r : this.rowOrder) {
                switch (r) {
                    case AREA: {
                        if (!export.shouldExportArea()) continue block10;
                        temp.append(this.getFormatedValue(gd.getArea(), gd.getAreaMod(), nbrOfDecimals) + "\t");
                        continue block10;
                    }
                    case LENGTH: {
                        if (!export.shouldExportLength()) continue block10;
                        temp.append(this.getFormatedValue(gd.getDistance(), gd.getDistanceMod(), nbrOfDecimals) + "\t");
                        continue block10;
                    }
                    case VOLUME: {
                        if (!export.shouldExportVolume()) continue block10;
                        temp.append(this.getFormatedValue(gd.getVolume(), gd.getVolumeMod(), nbrOfDecimals) + "\t");
                        continue block10;
                    }
                    case HEIGHT: {
                        if (!export.shouldExportHeight()) continue block10;
                        temp.append(this.getFormatedValue(gd.getHeight(), "", nbrOfDecimals) + "\t");
                        continue block10;
                    }
                    case WALLSURFACE: {
                        if (!export.shouldExportWallArea()) continue block10;
                        temp.append(this.getFormatedValue(gd.getWallSurface(), gd.getWallSurfaceMod(), nbrOfDecimals) + "\t");
                        continue block10;
                    }
                    case DRAWING_NAMES: {
                        continue block10;
                    }
                    case NUMBER_OF_DRAWING: {
                        if (!export.shouldExportNumberOfDrawing()) continue block10;
                        temp.append(((GeometraDrawingImpl)gd).numberOfDrawings() + "\t");
                    }
                }
            }
            String t = temp.toString();
            t = this.replaceDecimalSign(t);
            out.append(t);
            out.append('\n');
        }
        return out.toString();
    }

    private String getTitles(StructuredExport export) {
        StringBuilder sb = new StringBuilder("");
        block9: for (Row r : this.rowOrder) {
            switch (r) {
                case AREA: {
                    if (!export.shouldExportArea()) continue block9;
                    sb.append("\t" + ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DIM_AREA"));
                    continue block9;
                }
                case LENGTH: {
                    if (!export.shouldExportLength()) continue block9;
                    sb.append("\t" + ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DIM_LENGTH"));
                    continue block9;
                }
                case VOLUME: {
                    if (!export.shouldExportVolume()) continue block9;
                    sb.append("\t" + ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DIM_VOLUME"));
                    continue block9;
                }
                case HEIGHT: {
                    if (!export.shouldExportHeight()) continue block9;
                    sb.append("\t" + ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DIM_HEIGHT"));
                    continue block9;
                }
                case WALLSURFACE: {
                    if (!export.shouldExportWallArea()) continue block9;
                    sb.append("\t" + ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DIM_WALL_SURFACE"));
                    continue block9;
                }
                case DRAWING_NAMES: {
                    continue block9;
                }
                case NUMBER_OF_DRAWING: {
                    if (!export.shouldExportNumberOfDrawing()) continue block9;
                    sb.append("\t" + Row.NUMBER_OF_DRAWING.toString());
                }
            }
        }
        return sb.toString();
    }

    private String formatHorizontal(List<GeometraDrawing> values, StructuredExport export) {
        StringBuilder out = new StringBuilder();
        BluePrintSorterList bpsl = null;
        for (GeometraDrawing gd : values) {
            if (bpsl != null) {
                bpsl.add(gd, export);
                continue;
            }
            bpsl = new BluePrintSorterList(gd, export);
        }
        if (bpsl != null) {
            out.append(bpsl.toString());
        }
        return out.toString();
    }

    private String getFormatedValue(double value, String mod, int nbrOfDecimals) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.beforeValue);
        if (this.keepFormulas) {
            sb.append(new BigDecimal(value).setScale(nbrOfDecimals, 4));
            sb.append(mod);
        } else {
            String s = "" + value + mod;
            double v = GeometraUtilities.solveExpression(s);
            sb.append(new BigDecimal(v).setScale(nbrOfDecimals, 4));
        }
        return sb.toString();
    }

    private String replaceDecimalSign(String in) {
        in = in.replace('.', this.decimalSign.charAt(0));
        in = in.replace(',', this.decimalSign.charAt(0));
        return in;
    }

    private void appendGeometraDrawingName(GeometraDrawing gd, StringBuilder out) {
        if (gd instanceof DotDrawingContainer) {
            DotDrawingContainer dd = (DotDrawingContainer)gd;
            out.append(dd.getDescription());
            out.append(" (");
            out.append(dd.getNumberOfDotDrawings());
            out.append(")\t");
        } else {
            out.append(gd.getDescription());
            out.append('\t');
        }
    }

    class PageSorterList {
        private List<GeometraDrawing> gdList = new ArrayList<GeometraDrawing>();
        private PageSorterList next = null;
        private StructuredExport export;

        PageSorterList(GeometraDrawing gd, StructuredExport export) {
            this.gdList.add(gd);
            this.export = export;
        }

        public final GeometraDrawing getFirst() {
            return this.gdList.get(0);
        }

        public final void add(GeometraDrawing gd, StructuredExport export) {
            BlueprintPage bp1;
            BlueprintPage bp0 = this.gdList.get(0).getParent();
            if (bp0.equals(bp1 = gd.getParent())) {
                this.gdList.add(gd);
            } else if (this.next == null) {
                this.next = new PageSorterList(gd, export);
            } else {
                this.next.add(gd, export);
            }
        }

        public final String toString() {
            String before;
            StringBuilder name_row = new StringBuilder();
            StringBuilder area_row = new StringBuilder();
            StringBuilder length_row = new StringBuilder();
            StringBuilder volume_row = new StringBuilder();
            StringBuilder wallsurface_row = new StringBuilder();
            StringBuilder height_row = new StringBuilder();
            StringBuilder counts_row = new StringBuilder();
            int nbrOfDecimals = GeometraConfiguration.getNDecimals();
            if (ExportSchema.this.pageVisible) {
                if (!(this.gdList.get(0) instanceof TotalDrawing)) {
                    name_row.append(this.gdList.get(0).getParent().getDescription() + "\t");
                } else {
                    name_row.append("\t");
                }
            } else {
                before = ExportSchema.this.headerVisible ? "\t" : "";
                name_row.append(before);
            }
            if (ExportSchema.this.headerVisible) {
                area_row.append(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DIM_AREA") + "\t");
                length_row.append(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DIM_LENGTH") + "\t");
                volume_row.append(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DIM_VOLUME") + "\t");
                wallsurface_row.append(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DIM_WALL_SURFACE") + "\t");
                height_row.append(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DIM_HEIGHT") + "\t");
                counts_row.append(Row.NUMBER_OF_DRAWING.toString() + "\t");
            } else {
                before = ExportSchema.this.pageVisible ? "\t" : "";
                area_row.append(before);
                length_row.append(before);
                volume_row.append(before);
                wallsurface_row.append(before);
                height_row.append(before);
                counts_row.append(before);
            }
            for (GeometraDrawing gd : this.gdList) {
                if (ExportSchema.this.drawingNameVisible) {
                    ExportSchema.this.appendGeometraDrawingName(gd, name_row);
                }
                area_row.append(ExportSchema.this.getFormatedValue(gd.getArea(), gd.getAreaMod(), nbrOfDecimals) + "\t");
                length_row.append(ExportSchema.this.getFormatedValue(gd.getDistance(), gd.getDistanceMod(), nbrOfDecimals) + "\t");
                volume_row.append(ExportSchema.this.getFormatedValue(gd.getVolume(), gd.getVolumeMod(), nbrOfDecimals) + "\t");
                wallsurface_row.append(ExportSchema.this.getFormatedValue(gd.getWallSurface(), gd.getWallSurfaceMod(), nbrOfDecimals) + "\t");
                height_row.append(ExportSchema.this.getFormatedValue(gd.getHeight(), "", nbrOfDecimals) + "\t");
                counts_row.append(((GeometraDrawingImpl)gd).numberOfDrawings() + "\t");
            }
            StringBuilder total = new StringBuilder();
            block10: for (Row r : ExportSchema.this.rowOrder) {
                switch (r) {
                    case AREA: {
                        if (!this.export.shouldExportArea()) continue block10;
                        total.append(area_row + "\n");
                        continue block10;
                    }
                    case LENGTH: {
                        if (!this.export.shouldExportLength()) continue block10;
                        total.append(length_row + "\n");
                        continue block10;
                    }
                    case VOLUME: {
                        if (!this.export.shouldExportVolume()) continue block10;
                        total.append(volume_row + "\n");
                        continue block10;
                    }
                    case HEIGHT: {
                        if (!this.export.shouldExportHeight()) continue block10;
                        total.append(height_row + "\n");
                        continue block10;
                    }
                    case WALLSURFACE: {
                        if (!this.export.shouldExportWallArea()) continue block10;
                        total.append(wallsurface_row + "\n");
                        continue block10;
                    }
                    case DRAWING_NAMES: {
                        if (!ExportSchema.this.drawingNameVisible && !ExportSchema.this.pageVisible) continue block10;
                        total.append(name_row + "\n");
                        continue block10;
                    }
                    case NUMBER_OF_DRAWING: {
                        if (!this.export.shouldExportNumberOfDrawing()) continue block10;
                        total.append(counts_row + "\n");
                    }
                }
            }
            String t = ExportSchema.this.replaceDecimalSign(total.toString());
            if (this.next != null) {
                t = t + this.next.toString();
            }
            return t;
        }
    }

    class BluePrintSorterList {
        PageSorterList psl = null;
        BluePrintSorterList next = null;
        StructuredExport export;

        BluePrintSorterList(GeometraDrawing gd, StructuredExport export) {
            this.psl = new PageSorterList(gd, export);
            this.export = export;
        }

        public void add(GeometraDrawing gd, StructuredExport export) {
            GeometraDrawing gd1 = this.psl.getFirst();
            BlueprintPage bp1 = gd1.getParent();
            Blueprint b1 = bp1.getParent();
            Blueprint b0 = gd.getParent().getParent();
            if (b0.equals(b1)) {
                this.psl.add(gd, export);
            } else if (this.next != null) {
                this.next.add(gd, export);
            } else {
                this.next = new BluePrintSorterList(gd, export);
            }
        }

        public final String toString() {
            String temp = "";
            if (ExportSchema.this.pdfNameVisible) {
                GeometraDrawing gd1 = this.psl.getFirst();
                if (gd1 instanceof TotalDrawing) {
                    temp = "\n";
                } else {
                    BlueprintPage bp1 = gd1.getParent();
                    Blueprint b1 = bp1.getParent();
                    temp = b1.getDescription() + "\n";
                }
            }
            temp = temp + this.psl.toString();
            if (this.next != null) {
                temp = temp + this.next.toString();
            }
            return temp;
        }
    }

    public static enum CopyPaste {
        WINDOWS{

            @Override
            public void copy_paste(String in) {
                ClipboardSender sender = new ClipboardSender();
                sender.sendToSystemClipboard(in);
                try {
                    int delay = 10;
                    Robot robot = new Robot();
                    robot.keyPress(18);
                    robot.delay(delay);
                    robot.keyPress(9);
                    robot.delay(delay);
                    robot.keyRelease(9);
                    robot.delay(delay);
                    robot.keyRelease(18);
                    robot.delay(delay);
                    robot.keyPress(17);
                    robot.delay(delay);
                    robot.keyPress(86);
                    robot.delay(delay);
                    robot.keyRelease(86);
                    robot.delay(delay);
                    robot.keyRelease(17);
                    robot.delay(delay);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            public String toString() {
                return ResourceBundle.getBundle("se/sjobeck/Geometra").getString("LABEL_ECP_COPYPASTE_WINDOW");
            }
        }
        ,
        MAC{

            @Override
            public void copy_paste(String in) {
                ClipboardSender sender = new ClipboardSender();
                sender.sendToSystemClipboard(in);
                try {
                    int delay = 10;
                    Robot robot = new Robot();
                    robot.keyPress(157);
                    robot.delay(delay);
                    robot.keyPress(9);
                    robot.delay(delay);
                    robot.keyRelease(9);
                    robot.delay(delay);
                    robot.keyRelease(157);
                    robot.delay(delay);
                    robot.keyPress(157);
                    robot.delay(delay);
                    robot.keyPress(86);
                    robot.delay(delay);
                    robot.keyRelease(86);
                    robot.delay(delay);
                    robot.keyRelease(157);
                    robot.delay(delay);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            public String toString() {
                return ResourceBundle.getBundle("se/sjobeck/Geometra").getString("LABEL_ECP_COPYPASTE_MAC");
            }
        }
        ,
        COPY_TO_CLIPBOARD{

            @Override
            public void copy_paste(String in) {
                ClipboardSender sender = new ClipboardSender();
                sender.sendToSystemClipboard(in);
            }

            public String toString() {
                return ResourceBundle.getBundle("se/sjobeck/Geometra").getString("LABEL_ECP_COPYPASTE_COPY");
            }
        };


        public abstract void copy_paste(String var1);
    }

    public static enum Row {
        AREA{

            public String toString() {
                return ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DIM_AREA");
            }
        }
        ,
        LENGTH{

            public String toString() {
                return ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DIM_LENGTH");
            }
        }
        ,
        VOLUME{

            public String toString() {
                return ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DIM_VOLUME");
            }
        }
        ,
        HEIGHT{

            public String toString() {
                return ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DIM_HEIGHT");
            }
        }
        ,
        WALLSURFACE{

            public String toString() {
                return ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DIM_WALL_SURFACE");
            }
        }
        ,
        DRAWING_NAMES{

            public String toString() {
                return ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DIM_TITLE");
            }
        }
        ,
        NUMBER_OF_DRAWING{

            public String toString() {
                return ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DIM_NUMBER_OF_DRAWINGS");
            }
        };

    }
}

