/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.geometra.datastructures.drawings;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.icepdf.ri.common.views.painting.core.BlueprintPage;
import org.icepdf.ri.common.views.painting.drawings.GeometraDrawing;
import org.icepdf.ri.common.views.painting.drawings.GeometraLine;
import org.icepdf.ri.common.views.painting.struct.GeometraShape;
import se.sjobeck.GeometraConfiguration;
import se.sjobeck.geometra.datastructures.drawings.GeometraContainer;
import se.sjobeck.geometra.datastructures.drawings.GeometraDrawingImpl;
import se.sjobeck.geometra.datastructures.drawings.HoleDrawing;
import se.sjobeck.geometra.datastructures.drawings.HoleDrawingCalculator;
import se.sjobeck.geometra.gui.main.Geometra;

public class SquareDrawing
extends GeometraDrawingImpl
implements GeometraContainer {
    private static transient int counter = 0;
    private List<HoleDrawing> holeDrawings = new ArrayList<HoleDrawing>();
    private final transient double distanceDifference = 5.0;
    private transient boolean hasBeenFinalized = false;
    private transient Stroke normalStroke = this.getStroke();

    @Override
    public String toString() {
        return this.getDescription();
    }

    private Stroke getStroke() {
        BasicStroke stroke = new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{4.0f, 2.0f}, 0.0f);
        return stroke;
    }

    @Override
    public double getWallSurface() {
        return super.getWallSurface() - this.getHoleDrawingSurface();
    }

    private double getHoleDrawingSurface() {
        double wallsurface = 0.0;
        for (HoleDrawing h : this.holeDrawings) {
            wallsurface += h.getWallSurface();
        }
        return wallsurface;
    }

    @Override
    public double getVolume() {
        return this.getUnmodifiedArea() * this.getHeight() - this.getHoleDrawingVolume();
    }

    private double getHoleDrawingVolume() {
        double volume = 0.0;
        for (HoleDrawing h : this.holeDrawings) {
            volume += h.getVolume();
        }
        return volume;
    }

    @Override
    public void init() {
        if (this.normalStroke == null) {
            this.normalStroke = this.getStroke();
        }
        if (!this.holeDrawings.isEmpty()) {
            for (HoleDrawing h : this.holeDrawings) {
                h.init(this);
            }
        }
        this.path = new GeneralPath();
        this.altPath = new GeneralPath();
        this.buildPath();
    }

    public SquareDrawing() {
    }

    public SquareDrawing(BlueprintPage page) {
        this.setParent(page);
        this.setVisible(true);
        this.setDescription(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DRAWING_SQUARE_SHORT") + ++counter);
    }

    public SquareDrawing(SquareDrawing sd, BlueprintPage page) {
        this.isClosed = false;
        this.setDescription(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DRAWING_SQUARE_SHORT") + ++counter);
        this.setParent(page);
    }

    @Override
    public void setDescription(String desc) {
        super.setDescription(desc);
    }

    @Override
    public void addPoint(Point2D point) {
        if (!this.isClosed) {
            if (!this.hasBeenFinalized) {
                this.points.add(this.componentToBlueprint(point));
            } else {
                int index;
                Point2D firstPoint = this.getClosestPoint(this.componentToBlueprint(point), this.points);
                ArrayList<Point2D> copy = new ArrayList<Point2D>();
                copy.addAll(this.points);
                copy.remove(firstPoint);
                Point2D secondPoint = this.getClosestPoint(this.componentToBlueprint(point), copy);
                int i = this.points.indexOf(firstPoint);
                int j = this.points.indexOf(secondPoint);
                if (i == 0 && j == this.points.size() - 1 || j == 0 && i == this.points.size() - 1) {
                    index = this.points.size();
                } else {
                    index = i < j ? i : j;
                    ++index;
                }
                this.points.add(index, this.componentToBlueprint(point));
            }
            this.buildPath();
        }
    }

    private Point2D getClosestPoint(Point2D point, List<Point2D> vertices) {
        Point2D closestPoint = new Point2D.Double(Double.MAX_VALUE, Double.MAX_VALUE);
        for (Point2D p : vertices) {
            if (!(p.distance(point) < closestPoint.distance(point))) continue;
            closestPoint = p;
        }
        return closestPoint;
    }

    @Override
    public void buildPath() {
        this.path.reset();
        if (this.points.size() > 0) {
            this.path.moveTo((float)((Point2D)this.points.get(0)).getX(), (float)((Point2D)this.points.get(0)).getY());
            for (Point2D point : this.points) {
                this.path.lineTo((float)point.getX(), (float)point.getY());
            }
            if (super.isClosed()) {
                this.path.closePath();
            }
        }
        this.altPath.reset();
        if (this.points.size() == 2) {
            this.altPath.moveTo((float)((Point2D)this.points.get(0)).getX(), (float)((Point2D)this.points.get(0)).getY());
            this.altPath.lineTo((float)((Point2D)this.points.get(this.points.size() - 1)).getX(), (float)((Point2D)this.points.get(0)).getY());
            this.altPath.lineTo((float)((Point2D)this.points.get(this.points.size() - 1)).getX(), (float)((Point2D)this.points.get(this.points.size() - 1)).getY());
            this.altPath.lineTo((float)((Point2D)this.points.get(0)).getX(), (float)((Point2D)this.points.get(this.points.size() - 1)).getY());
            this.altPath.closePath();
        } else if (!super.isClosed()) {
            this.altPath.moveTo((float)((Point2D)this.points.get(0)).getX(), (float)((Point2D)this.points.get(0)).getY());
            this.altPath.lineTo((float)((Point2D)this.points.get(this.points.size() - 1)).getX(), (float)((Point2D)this.points.get(this.points.size() - 1)).getY());
        }
        this.setCenterPoint(this.createCenterPoint());
    }

    @Override
    public void setStrokeWidth(float width) {
    }

    public HoleDrawing cloneHoleDrawing(Point2D startPoint) {
        if (this.holeDrawings.isEmpty()) {
            return null;
        }
        HoleDrawing hd = this.holeDrawings.size() > 0 ? this.holeDrawings.get(this.holeDrawings.size() - 1) : this.holeDrawings.get(0);
        HoleDrawing tempDrawing = new HoleDrawing(hd, startPoint);
        this.holeDrawings.add(tempDrawing);
        return tempDrawing;
    }

    private Point createCenterPoint() {
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double maxX = 0.0;
        double maxY = 0.0;
        for (Point2D point : this.points) {
            if (point.getX() < minX) {
                minX = point.getX();
            }
            if (point.getY() < minY) {
                minY = point.getY();
            }
            if (point.getX() > maxX) {
                maxX = point.getX();
            }
            if (!(point.getY() > maxY)) continue;
            maxY = point.getY();
        }
        double xDistance = maxX - minX;
        double yDistance = maxY - minY;
        Double xCor = new Double(minX + xDistance / 2.0);
        Double yCor = new Double(minY + yDistance / 2.0);
        return new Point(xCor.intValue(), yCor.intValue());
    }

    @Override
    public double getArea() {
        double area = this.getUnmodifiedArea() - HoleDrawingCalculator.getArea(this);
        return area;
    }

    private double getUnmodifiedArea() {
        double sum = 0.0;
        if (this.points.size() == 2) {
            BlueprintPage parent = this.getParent();
            if (parent != null) {
                Point2D startPoint = (Point2D)this.points.get(0);
                Point2D endPoint = (Point2D)this.points.get(1);
                double drawingWidth = Math.abs(startPoint.getX() - endPoint.getX());
                double drawingHeight = Math.abs(startPoint.getY() - endPoint.getY());
                double drawingArea = drawingWidth * drawingHeight;
                return parent.scaleToRealArea(Math.abs(drawingArea));
            }
            return -1.0;
        }
        if (this.points.size() > 2) {
            BlueprintPage parent = this.getParent();
            if (parent != null) {
                for (int i = 0; i < this.points.size() - 1; ++i) {
                    sum = sum + ((Point2D)this.points.get(i)).getX() * ((Point2D)this.points.get(i + 1)).getY() - ((Point2D)this.points.get(i)).getY() * ((Point2D)this.points.get(i + 1)).getX();
                }
                double lastX = ((Point2D)this.points.get(this.points.size() - 1)).getX() * ((Point2D)this.points.get(0)).getY();
                double lastY = ((Point2D)this.points.get(0)).getX() * ((Point2D)this.points.get(this.points.size() - 1)).getY();
                sum = sum + lastX - lastY;
                return parent.scaleToRealArea(Math.abs(0.5 * sum));
            }
            return -1.0;
        }
        return 0.0;
    }

    private double getHoleDrawingArea() {
        double area = 0.0;
        if (this.holeDrawings != null) {
            for (HoleDrawing hd : this.holeDrawings) {
                area += hd.getArea();
            }
        }
        return area;
    }

    @Override
    public double getDistance() {
        double distanceSum = 0.0;
        if (!this.points.isEmpty()) {
            Point2D last = (Point2D)this.points.get(this.points.size() - 1);
            for (Point2D current : this.points) {
                distanceSum += this.getParent().scaleToReal(current.distance(last));
                last = current;
            }
        }
        return distanceSum;
    }

    @Override
    public Line2D getLine(Point2D coord) {
        GeometraLine line = new GeometraLine();
        for (int i = 0; i < this.points.size() - 1; ++i) {
            Point2D p1 = (Point2D)this.points.get(i);
            Point2D p2 = (Point2D)this.points.get(i + 1);
            line.setLine(p1, p2);
            if (!(line.ptSegDist(coord) < 5.0)) continue;
            line.setLine((Point2D)this.points.get(i), (Point2D)this.points.get(i + 1));
            return line;
        }
        if (!this.points.isEmpty()) {
            line.setLine((Point2D)this.points.get(this.points.size() - 1), (Point2D)this.points.get(0));
            if (line.ptSegDist(coord) < 5.0) {
                return line;
            }
        }
        return null;
    }

    @Override
    public Rectangle getRectangle() {
        return null;
    }

    @Override
    public boolean isFilled() {
        return this.isFilled;
    }

    @Override
    public void paintAsSmartDrawing(Graphics2D g, BlueprintPage base, Rectangle clip) {
        g.setColor(this.getSmartDrawingColor());
        this.paintTheDrawing(g, base, clip);
    }

    @Override
    public void paintDistances(Graphics2D g, BlueprintPage base, BlueprintPage.ViewingState state) {
        int originalSize = GeometraConfiguration.getFontSize();
        g.setRenderingHints(GEOMETRA_RENDER_HINTS);
        if (!this.points.isEmpty()) {
            Rectangle2D bounds;
            Font font = g.getFont();
            g.setColor(Color.BLACK);
            this.drawingFont = new Font(font.getName(), 1, (int)((double)originalSize + this.getScaleFactor(base.getAffineTransform()) * 1.0));
            g.setFont(this.drawingFont);
            FontMetrics metrics = g.getFontMetrics(this.drawingFont);
            Point2D last = (Point2D)this.points.get(this.points.size() - 1);
            for (Point2D current : this.points) {
                GeometraShape shape;
                String distanceString;
                Point2D.Double center = new Point2D.Double(last.getX() + (current.getX() - last.getX()) / 2.0, last.getY() + (current.getY() - last.getY()) / 2.0);
                base.getAffineTransform().transform(center, center);
                double distance = base.scaleToReal(current.distance(last));
                double wall = distance * this.getHeight();
                if (state.equals((Object)BlueprintPage.ViewingState.SHOW_2D)) {
                    distanceString = Geometra.standardFormat.format(distance);
                    bounds = metrics.getStringBounds(distanceString, g);
                    shape = this.getGeometraShape(bounds, this.drawingFont.getSize(), center);
                    g.drawString(distanceString, (float)shape.getX(), (float)shape.getY());
                } else if (state.equals((Object)BlueprintPage.ViewingState.SHOW_3D)) {
                    String wallString = "(" + Geometra.standardFormat.format(wall) + ")";
                    bounds = metrics.getStringBounds(wallString, g);
                    shape = this.getGeometraShape(bounds, this.drawingFont.getSize(), center);
                    g.drawString(wallString, (float)shape.getX(), (float)shape.getY());
                } else if (state.equals((Object)BlueprintPage.ViewingState.SHOW_ALL)) {
                    distanceString = Geometra.standardFormat.format(distance);
                    String wallString = Geometra.standardFormat.format(wall);
                    String combinedString = distanceString + " (" + wallString + ")";
                    Rectangle2D distanceBounds = metrics.getStringBounds(combinedString, g);
                    GeometraShape distanceShape = this.getGeometraShape(distanceBounds, this.drawingFont.getSize(), center);
                    g.drawString(combinedString, (float)distanceShape.getX(), (float)distanceShape.getY());
                }
                last = current;
            }
            Point2D newCenter = base.blueprintToComponent((Point2D)this.getCenterPoint());
            if (state.equals((Object)BlueprintPage.ViewingState.SHOW_2D)) {
                double area = this.getArea();
                String areaString = Geometra.standardFormat.format(area);
                Rectangle2D bounds2 = metrics.getStringBounds(areaString, g);
                g.drawString(areaString, (float)(newCenter.getX() - bounds2.getWidth() / 2.0), (float)newCenter.getY());
            } else if (state.equals((Object)BlueprintPage.ViewingState.SHOW_3D)) {
                double wallArea = this.getArea() * this.getHeight();
                String wallString = "(" + Geometra.standardFormat.format(wallArea) + ")";
                Rectangle2D bounds3 = metrics.getStringBounds(wallString, g);
                g.drawString(wallString, (float)(newCenter.getX() - bounds3.getWidth() / 2.0), (float)newCenter.getY());
            } else if (state.equals((Object)BlueprintPage.ViewingState.SHOW_ALL)) {
                double area = this.getArea();
                double wall = area * this.getHeight();
                String areaString = Geometra.standardFormat.format(area);
                String wallString = " (" + Geometra.standardFormat.format(wall) + ")";
                String combinedString = areaString + wallString;
                bounds = metrics.getStringBounds(combinedString, g);
                g.drawString(combinedString, (float)(newCenter.getX() - bounds.getWidth() / 2.0), (float)newCenter.getY());
            }
        }
    }

    @Override
    public void paintDrawing(Graphics2D g, BlueprintPage base, Rectangle clip) {
        g.setColor(this.getColor());
        this.paintTheDrawing(g, base, clip);
    }

    private void paintTheDrawing(Graphics2D g, BlueprintPage base, Rectangle clip) {
        g.setRenderingHints(GEOMETRA_RENDER_HINTS);
        g.setStroke(this.normalStroke);
        if (this.path == null) {
            this.path = new GeneralPath();
            this.altPath = new GeneralPath();
            this.buildPath();
        }
        this.transformedPath = (GeneralPath)this.path.clone();
        this.transformedPath.transform(base.getAffineTransform());
        if (this.isFilled && this.points.size() > 2) {
            g.fill(this.transformedPath);
        } else {
            g.draw(this.transformedPath);
        }
        GeneralPath p = (GeneralPath)this.altPath.clone();
        p.transform(base.getAffineTransform());
        g.draw(p);
        if (this.holeDrawings != null) {
            for (HoleDrawing hd : this.holeDrawings) {
                hd.paintDrawing(g, base, clip);
            }
        }
    }

    @Override
    public void setClosed(boolean b) {
        this.hasBeenFinalized = true;
        this.isClosed = b;
        if (this.isClosed) {
            if (this.points.size() == 2) {
                Point2D start = (Point2D)this.points.get(0);
                Point2D end = (Point2D)this.points.get(1);
                this.points.add(1, new Point2D.Double(start.getX(), end.getY()));
                this.points.add(new Point2D.Double(end.getX(), start.getY()));
            }
            this.buildPath();
        }
    }

    public void setUnfinilized() {
        this.hasBeenFinalized = false;
    }

    @Override
    public void setFilled(boolean filled) {
        System.out.println("set filled " + filled);
        this.isFilled = filled;
    }

    @Override
    public void addChild(GeometraDrawing dd) {
        if (dd instanceof HoleDrawing) {
            HoleDrawing hd = (HoleDrawing)dd;
            if (this.holeDrawings == null) {
                this.holeDrawings = new ArrayList<HoleDrawing>();
            }
            this.holeDrawings.add(hd);
        }
    }

    @Override
    public GeometraDrawing getActiveChild() {
        return null;
    }

    public List<HoleDrawing> getChildren() {
        return this.holeDrawings;
    }

    @Override
    public int indexOfChild(GeometraDrawing child) {
        return this.holeDrawings.indexOf(child);
    }

    @Override
    public void removeChild(GeometraDrawing toBeRemoved) {
        this.holeDrawings.remove((HoleDrawing)toBeRemoved);
    }

    @Override
    public int getChildCount() {
        return this.holeDrawings.size();
    }

    @Override
    public GeometraDrawing getChild(int index) {
        return this.holeDrawings.get(index);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        SquareDrawing sq = (SquareDrawing)super.clone();
        HoleDrawing[] fudo = new HoleDrawing[this.holeDrawings.size()];
        this.holeDrawings.toArray(fudo);
        ArrayList<HoleDrawing> hDrawings = new ArrayList<HoleDrawing>();
        for (int i = 0; i < fudo.length; ++i) {
            hDrawings.add((HoleDrawing)fudo[i].clone());
        }
        sq.holeDrawings = hDrawings;
        return sq;
    }
}

