/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.geometra.datastructures.drawings;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.List;
import java.util.ResourceBundle;
import org.icepdf.ri.common.views.painting.core.BlueprintPage;
import org.icepdf.ri.common.views.painting.drawings.GeometraLine;
import org.icepdf.ri.common.views.painting.drawings.ScaleDrawing;
import se.sjobeck.geometra.datastructures.drawings.GeometraDrawingImpl;

public class GeometraScale
extends GeometraDrawingImpl
implements ScaleDrawing {
    private static final long serialVersionUID = 1L;
    private double realDistance = 1.0;
    private transient BasicStroke scaleStroke = new BasicStroke(3.0f);
    private static final String defaultName = ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DRAWING_SCALE");
    private static final String units = "meter";
    private boolean isRealDistanceSet = false;

    public GeometraScale() {
    }

    public GeometraScale(BlueprintPage page) {
        this.points.add(new Point2D.Double(20.0, 20.0));
        this.points.add(new Point2D.Double(40.0, 40.0));
        super.setParent(page);
        super.setDescription(defaultName);
        this.setVisible(true);
        this.buildPath();
        this.setClosed(true);
        super.setColor(Color.RED);
    }

    public GeometraScale(GeometraScale sd) {
        this.points.add((Point2D)sd.points.get(0));
        this.points.add((Point2D)sd.points.get(1));
        super.setParent(sd.getParent());
        super.setDescription(sd.getDescription());
        this.setVisible(true);
        this.buildPath();
        this.setClosed(true);
        super.setColor(Color.RED);
        this.isRealDistanceSet = sd.isRealDistanceSet;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    @Override
    public void setDescription(String str) throws IllegalArgumentException {
        try {
            String tempString = str.replace(',', '.');
            double scaleDrawingLength = Double.parseDouble(tempString);
            this.setRealDistance(scaleDrawingLength);
        }
        catch (Exception e) {
            throw new IllegalArgumentException();
        }
        super.setDescription(str);
        this.isRealDistanceSet = true;
    }

    public void moveScaleDrawing(Point2D point) {
        Point2D differencePoint;
        Point2D pickedPoint;
        Point2D p1 = (Point2D)this.points.get(0);
        Point2D p2 = (Point2D)this.points.get(1);
        if (p1.getX() > p2.getX()) {
            pickedPoint = p2;
            differencePoint = p1;
        } else {
            pickedPoint = p1;
            differencePoint = p2;
        }
        double newX = differencePoint.getX() - pickedPoint.getX();
        double newY = differencePoint.getY() - pickedPoint.getY();
        Point2D.Double newPoint = new Point2D.Double(newX + point.getX(), newY + point.getY());
        this.points.clear();
        this.points.add(point);
        this.points.add(newPoint);
        this.buildPath();
    }

    @Override
    public Rectangle getRectangle() {
        return null;
    }

    @Override
    public void addPoint(Point2D point) {
    }

    @Override
    public void buildPath() {
        if (this.path == null) {
            this.path = new GeneralPath();
            this.altPath = new GeneralPath();
        }
        this.path.reset();
        Point2D pStart = (Point2D)this.points.get(0);
        Point2D pEnd = (Point2D)this.points.get(1);
        this.path.moveTo((float)pStart.getX(), (float)pStart.getY());
        this.path.lineTo((float)pEnd.getX(), (float)pEnd.getY());
        double angle = Math.atan2(pEnd.getY() - pStart.getY(), pEnd.getX() - pStart.getX());
        this.path.moveTo((float)(pStart.getX() + 10.0 * Math.cos(angle - 1.5707963267948966)), (float)(pStart.getY() + 10.0 * Math.sin(angle - 1.5707963267948966)));
        this.path.lineTo((float)(pStart.getX() + 10.0 * Math.cos(angle + 1.5707963267948966)), (float)(pStart.getY() + 10.0 * Math.sin(angle + 1.5707963267948966)));
        this.path.moveTo((float)(pEnd.getX() + 10.0 * Math.cos(angle - 1.5707963267948966)), (float)(pEnd.getY() + 10.0 * Math.sin(angle - 1.5707963267948966)));
        this.path.lineTo((float)(pEnd.getX() + 10.0 * Math.cos(angle + 1.5707963267948966)), (float)(pEnd.getY() + 10.0 * Math.sin(angle + 1.5707963267948966)));
        this.path.moveTo((float)pStart.getX(), (float)pStart.getY());
        this.path.lineTo((float)(pStart.getX() + 10.0 * Math.cos(angle + 0.7853981633974483)), (float)(pStart.getY() + 10.0 * Math.sin(angle + 0.7853981633974483)));
        this.path.moveTo((float)pStart.getX(), (float)pStart.getY());
        this.path.lineTo((float)(pStart.getX() + 10.0 * Math.cos(angle - 0.7853981633974483)), (float)(pStart.getY() + 10.0 * Math.sin(angle - 0.7853981633974483)));
        this.path.moveTo((float)pEnd.getX(), (float)pEnd.getY());
        this.path.lineTo((float)(pEnd.getX() - 10.0 * Math.cos(angle + 0.7853981633974483)), (float)(pEnd.getY() - 10.0 * Math.sin(angle + 0.7853981633974483)));
        this.path.moveTo((float)pEnd.getX(), (float)pEnd.getY());
        this.path.lineTo((float)(pEnd.getX() - 10.0 * Math.cos(angle - 0.7853981633974483)), (float)(pEnd.getY() - 10.0 * Math.sin(angle - 0.7853981633974483)));
        this.setCenterPoint(this.createCenterPoint());
    }

    private Point createCenterPoint() {
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double maxX = 0.0;
        double maxY = 0.0;
        for (Point2D point : this.points) {
            if (point.getX() < minX) {
                minX = point.getX();
            }
            if (point.getY() < minY) {
                minY = point.getY();
            }
            if (point.getX() > maxX) {
                maxX = point.getX();
            }
            if (!(point.getY() > maxY)) continue;
            maxY = point.getY();
        }
        double xDistance = maxX - minX;
        double yDistance = maxY - minY;
        Double xCor = new Double(minX + xDistance / 2.0);
        Double yCor = new Double(minY + yDistance / 2.0);
        return new Point(xCor.intValue(), yCor.intValue());
    }

    @Override
    public void paintDrawing(Graphics2D g, BlueprintPage base, Rectangle clip) {
        g.setRenderingHints(GEOMETRA_RENDER_HINTS);
        g.setColor(super.getColor());
        g.setStroke(this.scaleStroke);
        if (this.path == null) {
            this.path = new GeneralPath();
            this.altPath = new GeneralPath();
            this.buildPath();
        }
        GeneralPath p = (GeneralPath)this.path.clone();
        AffineTransform affineTransform = base.getAffineTransform();
        p.transform(affineTransform);
        g.draw(p);
        p = (GeneralPath)this.altPath.clone();
        p.transform(affineTransform);
        g.draw(p);
    }

    @Override
    public void paintVertices(Graphics2D g, BlueprintPage base) {
    }

    @Override
    public void setClosed(boolean isClosed) {
        this.isClosed = isClosed;
    }

    public double scaleToReal(double d) {
        return d * this.realDistance / ((Point2D)this.points.get(0)).distance((Point2D)this.points.get(1));
    }

    public double scaleToRealArea(double d) {
        double scaleDistance = this.realDistance / ((Point2D)this.points.get(0)).distance((Point2D)this.points.get(1));
        double power2 = Math.pow(scaleDistance, 2.0);
        return d * power2;
    }

    @Override
    public Line2D getLine(Point2D coord) {
        GeometraLine line = new GeometraLine();
        for (int i = 0; i < this.points.size() - 1; ++i) {
            Point2D p1 = this.blueprintToComponent((Point2D)this.points.get(i));
            Point2D p2 = this.blueprintToComponent((Point2D)this.points.get(i + 1));
            line.setLine(p1, p2);
            if (!(line.ptSegDist(coord) < 5.0)) continue;
            line.setLine((Point2D)this.points.get(i), (Point2D)this.points.get(i + 1));
            return line;
        }
        if (this.points.size() != 0) {
            line.setLine((Point2D)this.points.get(this.points.size() - 1), (Point2D)this.points.get(0));
            if (line.ptSegDist(coord) < 5.0) {
                return line;
            }
        }
        return null;
    }

    public void setRealDistance(double newValue) {
        this.realDistance = newValue;
    }

    @Override
    public String toString() {
        return this.getDescription() + " " + units;
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    public double getRealDistance() {
        return this.realDistance;
    }

    @Override
    public double getArea() {
        return 0.0;
    }

    @Override
    public boolean isFilled() {
        return this.isFilled;
    }

    @Override
    public void setFilled(boolean b) {
    }

    @Override
    public double getDistance() {
        return 0.0;
    }

    public String getAreaString() {
        return "0";
    }

    public String getDistanceString() {
        return "";
    }

    @Override
    public void paintAsSmartDrawing(Graphics2D g, BlueprintPage base, Rectangle clip) {
    }

    @Override
    public void init() {
        if (this.scaleStroke == null) {
            this.scaleStroke = new BasicStroke(3.0f);
        }
    }

    @Override
    public void setStrokeWidth(float width) {
    }

    @Override
    public List<Point2D> getPoints() {
        return this.points;
    }

    public void setPoints(List<Point2D> points) {
        this.points = points;
    }

    public boolean isRealDistanceSet() {
        return this.isRealDistanceSet;
    }
}

