/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.geometra.datastructures.drawings;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.icepdf.ri.common.views.painting.core.BlueprintPage;
import org.icepdf.ri.common.views.painting.drawings.GeometraDrawing;
import org.icepdf.ri.common.views.painting.struct.GeometraShape;
import se.sjobeck.geometra.datastructures.GeometraProperties;

public abstract class GeometraDrawingImpl
implements GeometraDrawing,
Cloneable {
    public static final transient double FONT_SIZE_MOD = 1.0;
    public transient boolean isDescriptionSet = false;
    protected static final Map<RenderingHints.Key, Object> GEOMETRA_RENDER_HINTS = GeometraDrawingImpl.getRenderingHints();
    private String description;
    private Color smartColor = Color.BLUE;
    private Color color = GeometraProperties.getProjectColor();
    private int angle = 0;
    private double drawingHeight;
    private String areaMod = "";
    private String wallSurfaceMod = "";
    private String lengthMod = "";
    private String volumeMod = "";
    private boolean show2D;
    private boolean show3D;
    protected boolean isClosed = false;
    protected boolean isFilled = false;
    private transient boolean isVisible = true;
    private transient BlueprintPage parent;
    private transient Point centerPoint = null;
    public List<Point2D> points = new ArrayList<Point2D>();
    protected transient GeneralPath path = new GeneralPath();
    protected transient GeneralPath altPath = new GeneralPath();
    protected transient Font drawingFont;
    protected transient GeneralPath transformedPath;

    public void moveDrawing(Point2D deltaMove) {
        for (Point2D point : this.points) {
            point.setLocation(point.getX() + deltaMove.getX(), point.getY() + deltaMove.getY());
        }
        this.buildPath();
    }

    public Object clone() throws CloneNotSupportedException {
        GeometraDrawingImpl gdi = (GeometraDrawingImpl)super.clone();
        gdi.angle = new Integer(this.angle);
        gdi.areaMod = new String(this.areaMod);
        gdi.color = new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), this.color.getAlpha());
        gdi.description = new String(this.description);
        gdi.drawingHeight = new Double(this.drawingHeight);
        gdi.isClosed = new Boolean(this.isClosed);
        gdi.isFilled = new Boolean(this.isFilled);
        gdi.lengthMod = new String(this.lengthMod);
        Point2D[] fudo = new Point2D[this.points.size()];
        this.points.toArray(fudo);
        ArrayList<Point2D> al = new ArrayList<Point2D>();
        for (int i = 0; i < fudo.length; ++i) {
            al.add((Point2D)fudo[i].clone());
        }
        gdi.points = al;
        gdi.show2D = new Boolean(this.show2D);
        gdi.show3D = new Boolean(this.show3D);
        gdi.smartColor = new Color(this.smartColor.getRed(), this.smartColor.getGreen(), this.smartColor.getBlue(), this.smartColor.getAlpha());
        gdi.volumeMod = new String(this.volumeMod);
        gdi.wallSurfaceMod = new String(this.wallSurfaceMod);
        return gdi;
    }

    public abstract void init();

    private static Map<RenderingHints.Key, Object> getRenderingHints() {
        HashMap<RenderingHints.Key, Object> m = new HashMap<RenderingHints.Key, Object>();
        m.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        m.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        m.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        m.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DEFAULT);
        m.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        m.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        m.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        m.put(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
        m.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        return m;
    }

    public abstract void setClosed(boolean var1);

    public abstract void setFilled(boolean var1);

    public abstract boolean isFilled();

    public abstract double getArea();

    public abstract double getDistance();

    public abstract Rectangle getRectangle();

    public abstract void addPoint(Point2D var1);

    public abstract void buildPath();

    public abstract void paintDrawing(Graphics2D var1, BlueprintPage var2, Rectangle var3);

    public abstract void paintAsSmartDrawing(Graphics2D var1, BlueprintPage var2, Rectangle var3);

    public void setStrokeWidth(float width) {
    }

    public void setDescription(String s) {
        this.description = s;
    }

    public boolean contains(Point2D point) {
        Point2D newPoint = this.getParent().componentToBlueprint(point);
        return this.path.contains(newPoint);
    }

    public boolean boundsContains(Point2D point) {
        Point2D newPoint = this.getParent().componentToBlueprint(point);
        return this.path.getBounds2D().contains(newPoint);
    }

    protected GeometraShape getGeometraShape(Rectangle2D bounds, int size, Point2D center) {
        double stringSize = bounds.getWidth();
        int fontSize = size;
        double newX = center.getX() - stringSize / 2.0;
        double newY = center.getY();
        GeometraShape shape = new GeometraShape(newX, newY, stringSize, (double)fontSize);
        shape.setRect(newX, newY + (double)fontSize, stringSize, (double)fontSize);
        if (this.transformedPath.contains((Rectangle2D)shape)) {
            return shape;
        }
        shape.setRect(newX - (double)Math.round(stringSize / 2.0) - 1.0, newY, stringSize, (double)fontSize);
        if (this.transformedPath.contains((Rectangle2D)shape)) {
            return shape;
        }
        shape.setRect(newX + (double)Math.round(stringSize / 2.0) + 1.0, newY, stringSize, (double)fontSize);
        if (this.transformedPath.contains((Rectangle2D)shape)) {
            return shape;
        }
        shape.setRect(newX, newY, stringSize, (double)fontSize);
        return shape;
    }

    public void removeLastPoint() {
        int indexToBeRemoved = this.points.size() - 1;
        this.points.remove(indexToBeRemoved);
        this.buildPath();
    }

    public String getDescription() {
        return this.description;
    }

    public void setHeight(double height) {
        this.drawingHeight = height;
    }

    public double getHeight() {
        return this.drawingHeight;
    }

    public Color getColor() {
        return this.color;
    }

    public Color getSmartDrawingColor() {
        return this.smartColor;
    }

    public void setColor(Color newColor) {
        this.color = newColor;
    }

    public BlueprintPage getParent() {
        return this.parent;
    }

    public int getAngle() {
        return this.angle;
    }

    public void setAngle(int degrees) {
        this.angle = degrees;
    }

    public void setParent(BlueprintPage parent) {
        this.parent = parent;
    }

    public void setSmartDrawingColor(Color newColor) {
        this.smartColor = newColor;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean visible) {
        this.isVisible = visible;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public boolean isThreeDimensionsVisible() {
        return this.show3D;
    }

    public boolean isTwoDimensionsVisible() {
        return this.show2D;
    }

    public void setTwoDimensionsVisible(boolean isTwoDimensionsVisible) {
        this.show2D = isTwoDimensionsVisible;
    }

    public void setThreeDimensionsVisible(boolean isThreeDimensionsVisible) {
        this.show3D = isThreeDimensionsVisible;
    }

    public void setCenterPoint(Point p) {
        this.centerPoint = p;
    }

    public Point getCenterPoint() {
        return this.centerPoint;
    }

    public boolean isCloseTo(Point2D point) {
        for (Point2D vertex : this.points) {
            if (!(point.distance(vertex) < 5.0)) continue;
            return true;
        }
        return false;
    }

    public Point2D getVertex(Point2D coord) {
        for (Point2D vertex : this.points) {
            Point2D tempPoint = this.blueprintToComponent(vertex);
            if (!(coord.distance(tempPoint) < 5.0)) continue;
            return vertex;
        }
        return null;
    }

    public void paintDistances(Graphics2D g, BlueprintPage base, BlueprintPage.ViewingState state) {
    }

    protected double getScaleFactor(AffineTransform at) {
        double a = 0.0;
        double[] flatmatrix = new double[]{0.0, 0.0, 0.0, 0.0};
        at.getMatrix(flatmatrix);
        for (double m : flatmatrix) {
            if (!((m = Math.abs(m)) > a)) continue;
            a = m;
        }
        return a;
    }

    public void paintVertices(Graphics2D g, BlueprintPage base) {
        g.setColor(this.getColor());
        for (Point2D vertexOnBlueprint : this.points) {
            Point2D vertexOnScreen = base.getAffineTransform().transform(vertexOnBlueprint, null);
            g.drawRect((int)Math.round(vertexOnScreen.getX()) - 2, (int)Math.round(vertexOnScreen.getY()) - 2, 5, 5);
        }
    }

    public String toString() {
        return this.description;
    }

    public final String getAreaMod() {
        return this.areaMod;
    }

    public final String getDistanceMod() {
        return this.lengthMod;
    }

    public final String getVolumeMod() {
        return this.volumeMod;
    }

    public final String getWallSurfaceMod() {
        return this.wallSurfaceMod;
    }

    public final void setAreaMod(String dim) {
        this.areaMod = dim;
    }

    public final void setLengthMod(String dim) {
        this.lengthMod = dim;
    }

    public final void setVolumeMod(String dim) {
        this.volumeMod = dim;
    }

    public final void setWallSurfaceMod(String dim) {
        this.wallSurfaceMod = dim;
    }

    public double getVolume() {
        return this.getHeight() * this.getArea();
    }

    public double getWallSurface() {
        return this.getDistance() * this.getHeight();
    }

    public void setHeight(String string) {
        try {
            String newHeight = string.replace(',', '.');
            Double d = new Double(newHeight);
            this.drawingHeight = d;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected Point2D blueprintToComponent(Point2D point) {
        return this.getParent().blueprintToComponent(point);
    }

    protected Point2D componentToBlueprint(Point2D point) {
        return this.getParent().componentToBlueprint(point);
    }

    public abstract Line2D getLine(Point2D var1);

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.points == null ? 0 : ((Object)this.points).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GeometraDrawingImpl other = (GeometraDrawingImpl)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        return !(this.points == null ? other.points != null : !((Object)this.points).equals(other.points));
    }

    public List<Point2D> getPoints() {
        ArrayList<Point2D> list = new ArrayList<Point2D>(this.points.size());
        for (Point2D p : this.points) {
            list.add((Point2D)p.clone());
        }
        return list;
    }

    public int size() {
        return this.points.size();
    }

    public int numberOfDrawings() {
        return 1;
    }
}

