/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.geometra.datastructures.drawings;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ResourceBundle;
import org.icepdf.ri.common.views.painting.core.BlueprintPage;
import org.icepdf.ri.common.views.painting.core.GeometraCollection;
import org.icepdf.ri.common.views.painting.drawings.GeometraDrawing;
import se.sjobeck.geometra.datastructures.GeometraUtilities;
import se.sjobeck.geometra.datastructures.drawings.DotDrawingContainer;
import se.sjobeck.geometra.datastructures.drawings.GeometraDrawingImpl;
import se.sjobeck.gui.DialogCreator;

public abstract class ContainerDrawing
extends GeometraDrawingImpl {
    protected GeometraCollection<GeometraDrawing> collection = new GeometraCollection();
    private Double wallSurface = null;
    private Double volume = null;
    private Double distance = null;
    private Double area = null;

    @Override
    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public GeometraDrawing getChild(int index) {
        return (GeometraDrawing)this.collection.get(index);
    }

    @Override
    public void setFilled(boolean b) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getWallSurface() {
        if (this.wallSurface != null) {
            return Double.POSITIVE_INFINITY;
        }
        try {
            this.wallSurface = new Double(0.0);
            for (GeometraDrawing gd : this.collection) {
                double solveExpression = 0.0;
                try {
                    solveExpression = GeometraUtilities.solveExpression(gd.getWallSurface() + gd.getWallSurfaceMod());
                }
                catch (NumberFormatException nfe) {
                    solveExpression = 0.0;
                    ResourceBundle bundle = ResourceBundle.getBundle("se/sjobeck/Geometra");
                    String felaktigFormel = bundle.getString("DIALOG_WRONG_FORMULA");
                    String sida = bundle.getString("DIALOG_PAGE");
                    String pdf = bundle.getString("DIALOG_PDF");
                    String title = bundle.getString("DIALOG_TITLE_WRONG_FORMULA");
                    DialogCreator.showError((Object)(felaktigFormel + " " + this.getDescription() + " " + sida + " " + this.getParent().getDescription() + " " + pdf + " " + this.getParent().getParent().getDescription()), (String)title);
                }
                this.wallSurface = this.wallSurface + solveExpression;
            }
            double d = this.wallSurface;
            return d;
        }
        finally {
            this.wallSurface = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getVolume() {
        if (this.volume != null) {
            return Double.POSITIVE_INFINITY;
        }
        try {
            this.volume = new Double(0.0);
            for (GeometraDrawing gd : this.collection) {
                double solveExpression = 0.0;
                try {
                    solveExpression = GeometraUtilities.solveExpression(gd.getVolume() + gd.getVolumeMod());
                }
                catch (NumberFormatException nfe) {
                    solveExpression = 0.0;
                    ResourceBundle bundle = ResourceBundle.getBundle("se/sjobeck/Geometra");
                    String felaktigFormel = bundle.getString("DIALOG_WRONG_FORMULA");
                    String sida = bundle.getString("DIALOG_PAGE");
                    String pdf = bundle.getString("DIALOG_PDF");
                    String title = bundle.getString("DIALOG_TITLE_WRONG_FORMULA");
                    DialogCreator.showError((Object)(felaktigFormel + " " + this.getDescription() + " " + sida + " " + this.getParent().getDescription() + " " + pdf + " " + this.getParent().getParent().getDescription()), (String)title);
                }
                this.volume = this.volume + solveExpression;
            }
            double d = this.volume;
            return d;
        }
        finally {
            this.volume = null;
        }
    }

    @Override
    public void setClosed(boolean isClosed) {
    }

    @Override
    public void paintDrawing(Graphics2D g, BlueprintPage base, Rectangle clip) {
    }

    @Override
    public void paintAsSmartDrawing(Graphics2D g, BlueprintPage base, Rectangle clip) {
    }

    @Override
    public boolean isFilled() {
        return this.isFilled;
    }

    @Override
    public void init() {
    }

    @Override
    public Line2D getLine(Point2D coord) {
        return null;
    }

    @Override
    public Rectangle getRectangle() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getDistance() {
        if (this.distance != null) {
            return Double.POSITIVE_INFINITY;
        }
        try {
            this.distance = new Double(0.0);
            for (GeometraDrawing gd : this.collection) {
                double solveExpression = 0.0;
                try {
                    solveExpression = GeometraUtilities.solveExpression(gd.getDistance() + gd.getDistanceMod());
                }
                catch (NumberFormatException nfe) {
                    solveExpression = 0.0;
                    ResourceBundle bundle = ResourceBundle.getBundle("se/sjobeck/Geometra");
                    String felaktigFormel = bundle.getString("DIALOG_WRONG_FORMULA");
                    String sida = bundle.getString("DIALOG_PAGE");
                    String pdf = bundle.getString("DIALOG_PDF");
                    String title = bundle.getString("DIALOG_TITLE_WRONG_FORMULA");
                    DialogCreator.showError((Object)(felaktigFormel + " " + this.getDescription() + " " + sida + " " + this.getParent().getDescription() + " " + pdf + " " + this.getParent().getParent().getDescription()), (String)title);
                }
                this.distance = this.distance + solveExpression;
            }
            double d = this.distance;
            return d;
        }
        finally {
            this.distance = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getArea() {
        if (this.area != null) {
            return Double.POSITIVE_INFINITY;
        }
        try {
            this.area = new Double(0.0);
            for (GeometraDrawing gd : this.collection) {
                double solveExpression = 0.0;
                try {
                    solveExpression = GeometraUtilities.solveExpression(gd.getArea() + gd.getAreaMod());
                }
                catch (NumberFormatException nfe) {
                    solveExpression = 0.0;
                    ResourceBundle bundle = ResourceBundle.getBundle("se/sjobeck/Geometra");
                    String felaktigFormel = bundle.getString("DIALOG_WRONG_FORMULA");
                    String sida = bundle.getString("DIALOG_PAGE");
                    String pdf = bundle.getString("DIALOG_PDF");
                    String title = bundle.getString("DIALOG_TITLE_WRONG_FORMULA");
                    DialogCreator.showError((Object)(felaktigFormel + " " + this.getDescription() + " " + sida + " " + this.getParent().getDescription() + " " + pdf + " " + this.getParent().getParent().getDescription()), (String)title);
                }
                this.area = this.area + solveExpression;
            }
            double d = this.area;
            return d;
        }
        finally {
            this.area = null;
        }
    }

    @Override
    public void addPoint(Point2D point) {
    }

    @Override
    public void buildPath() {
    }

    @Override
    public void setStrokeWidth(float width) {
    }

    public void addDrawing(GeometraDrawing gd) {
        if (gd instanceof ContainerDrawing) {
            ContainerDrawing td = (ContainerDrawing)gd;
            System.out.println(td.nestedContains(this));
            if (!td.nestedContains(this)) {
                this.collection.add((Object)gd);
            }
        } else {
            this.collection.add((Object)gd);
        }
    }

    public void addCollection(GeometraCollection<GeometraDrawing> collection) {
        for (GeometraDrawing gd : collection) {
            this.addDrawing(gd);
        }
    }

    @Override
    public void setHeight(String height) {
    }

    @Override
    public void setHeight(double height) {
    }

    @Override
    public double getHeight() {
        return 0.0;
    }

    public void removeDrawing(GeometraDrawing gd) {
        this.collection.remove((Object)gd);
    }

    public int indexOf(GeometraDrawing gd) {
        return this.collection.indexOf((Object)gd);
    }

    public boolean contains(GeometraDrawing gd) {
        return this.collection.contains((Object)gd);
    }

    public boolean nestedContains(GeometraDrawing gd) {
        if (gd == this) {
            return true;
        }
        boolean bool = false;
        for (int i = 0; i < this.collection.size(); ++i) {
            GeometraDrawing f = (GeometraDrawing)this.collection.get(i);
            if (!(f instanceof ContainerDrawing)) continue;
            ContainerDrawing td = (ContainerDrawing)f;
            if (gd == td) {
                return true;
            }
            bool = td.nestedContains(gd);
        }
        return bool;
    }

    @Override
    public int numberOfDrawings() {
        int value = 0;
        for (GeometraDrawing gd : this.collection) {
            if (gd instanceof ContainerDrawing) {
                value += ((ContainerDrawing)gd).numberOfDrawings();
                continue;
            }
            if (!(gd instanceof DotDrawingContainer)) continue;
            value += ((DotDrawingContainer)gd).numberOfDrawings();
        }
        return value;
    }
}

