/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.geometra.datastructures.core;

import java.awt.AlphaComposite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.ri.common.views.painting.core.Blueprint;
import org.icepdf.ri.common.views.painting.core.BlueprintPage;
import org.icepdf.ri.common.views.painting.core.GeometraCollection;
import org.icepdf.ri.common.views.painting.drawings.GeometraDrawing;
import org.icepdf.ri.common.views.painting.drawings.ScaleDrawing;
import org.icepdf.ri.common.views.painting.struct.NameComparator;
import se.sjobeck.geometra.datastructures.drawings.DotDrawing;
import se.sjobeck.geometra.datastructures.drawings.DotDrawingContainer;
import se.sjobeck.geometra.datastructures.drawings.HoleDrawing;
import se.sjobeck.geometra.datastructures.drawings.LineDrawing;
import se.sjobeck.geometra.datastructures.drawings.SmartDrawing;
import se.sjobeck.geometra.datastructures.drawings.SquareDrawing;
import se.sjobeck.geometra.datastructures.drawings.TextDrawing;

public abstract class BlueprintPageImpl
implements BlueprintPage {
    private String description;
    private transient BlueprintPage.DrawingState currentDrawState = BlueprintPage.DrawingState.NORMAL;
    private transient BlueprintPage.ViewingState currentViewState = BlueprintPage.ViewingState.SHOW_SPECIFIC;
    private transient boolean isParentSet = false;
    private transient AffineTransform transform = new AffineTransform();
    private transient Blueprint blueprintParent;
    protected transient GeometraCollection<GeometraDrawing> activeDrawings = new GeometraCollection();
    protected GeometraCollection<GeometraDrawing> drawings = new GeometraCollection();
    protected ScaleDrawing scaleDrawing;
    private Dimension pageDimension;
    private transient double blueprintScale = 1.0;
    private int rotation = 0;

    protected void setLeftRotation() {
        this.rotation = this.rotation == 0 ? 3 : --this.rotation;
        this.updateState();
    }

    public int getRotation() {
        switch (this.rotation) {
            case 1: {
                return 270;
            }
            case 2: {
                return 180;
            }
            case 3: {
                return 90;
            }
        }
        return 0;
    }

    protected void setRightRotation() {
        this.rotation = this.rotation == 3 ? 0 : ++this.rotation;
        this.updateState();
    }

    protected void init() {
        if (this.activeDrawings == null) {
            this.activeDrawings = new GeometraCollection();
        }
        if (this.transform == null) {
            this.transform = new AffineTransform();
        }
        if (this.currentDrawState == null) {
            this.currentDrawState = BlueprintPage.DrawingState.NORMAL;
        }
        if (this.currentViewState == null) {
            this.currentViewState = BlueprintPage.ViewingState.SHOW_SPECIFIC;
        }
        if (this.drawings == null) {
            this.drawings = new GeometraCollection();
        }
    }

    private void addDrawing(GeometraCollection<GeometraDrawing> geometraDrawings) {
        for (GeometraDrawing gd : geometraDrawings) {
            if (this.activeDrawings.contains((Object)gd)) continue;
            this.activeDrawings.add((Object)gd);
        }
        for (GeometraDrawing gd : geometraDrawings) {
            if (!this.drawings.contains((Object)gd)) continue;
            geometraDrawings.remove((Object)gd);
        }
        for (GeometraDrawing gd : geometraDrawings) {
            if (gd instanceof DotDrawing) continue;
            this.drawings.add((Object)gd);
        }
    }

    public Blueprint getParent() {
        return this.blueprintParent;
    }

    protected void setParent(Blueprint bp) {
        if (!this.isParentSet) {
            this.blueprintParent = bp;
            this.isParentSet = true;
        }
    }

    private void addDrawing(GeometraDrawing gd) {
        if (gd instanceof DotDrawing) {
            DotDrawing dd = (DotDrawing)gd;
            DotDrawingContainer cont = dd.getOwner();
            cont.addChild(dd);
        } else {
            this.activeDrawings.clear();
            this.activeDrawings.add((Object)gd);
            this.drawings.add((Object)gd);
        }
    }

    public GeometraCollection<GeometraDrawing> getUnlockedDrawings() {
        GeometraCollection unlocked = new GeometraCollection();
        for (GeometraDrawing gd : this.drawings) {
            if (!(gd instanceof SquareDrawing) && !gd.isClosed()) {
                unlocked.add((Object)gd);
                continue;
            }
            if (!(gd instanceof SquareDrawing)) continue;
            SquareDrawing sd = (SquareDrawing)gd;
            List<HoleDrawing> drawings_ = sd.getChildren();
            for (HoleDrawing hd : drawings_) {
                if (hd.isClosed()) continue;
                unlocked.add((Object)hd);
            }
            if (sd.isClosed()) continue;
            unlocked.add((Object)sd);
        }
        return unlocked;
    }

    public void addDrawing(Object object) {
        if (object instanceof GeometraDrawing) {
            GeometraDrawing gd = (GeometraDrawing)object;
            this.addDrawing(gd);
        } else if (object instanceof GeometraCollection) {
            GeometraCollection geoVector = (GeometraCollection)object;
            this.addDrawing((GeometraCollection<GeometraDrawing>)geoVector);
        }
    }

    protected void addSmartDrawing(SmartDrawing sd) {
        this.drawings.add((Object)sd);
    }

    public void addToSmartDrawing(GeometraCollection<GeometraDrawing> collection, String description) {
        for (GeometraDrawing gd : this.drawings) {
            if (!(gd instanceof SmartDrawing) || !gd.getDescription().equals(description)) continue;
            SmartDrawing sd = (SmartDrawing)gd;
            sd.addCollection(collection);
            break;
        }
    }

    public final Point2D blueprintToComponent(Point2D point) {
        return this.transform.transform(point, null);
    }

    public final Point2D componentToBlueprint(Point2D point) {
        try {
            return this.transform.inverseTransform(point, null);
        }
        catch (NoninvertibleTransformException ex) {
            Logger.getLogger(BlueprintPageImpl.class.getName()).info("point is " + point);
            Logger.getLogger(BlueprintPageImpl.class.getName()).log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException();
        }
    }

    public final GeometraCollection<GeometraDrawing> getActiveDrawings() {
        return this.activeDrawings;
    }

    private void updateState() {
        switch (this.rotation) {
            case 0: {
                this.transform = new AffineTransform(this.blueprintScale, 0.0, 0.0, this.blueprintScale, 0.0, 0.0);
                break;
            }
            case 1: {
                this.transform = new AffineTransform(0.0, this.blueprintScale, -this.blueprintScale, 0.0, this.blueprintScale * (double)this.getPageDimension().height, 0.0);
                break;
            }
            case 2: {
                this.transform = new AffineTransform(-this.blueprintScale, 0.0, 0.0, -this.blueprintScale, this.blueprintScale * (double)this.getPageDimension().width, this.blueprintScale * (double)this.getPageDimension().height);
                break;
            }
            case 3: {
                this.transform = new AffineTransform(0.0, -this.blueprintScale, this.blueprintScale, 0.0, 0.0, this.blueprintScale * (double)this.getPageDimension().width);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public final AffineTransform getAffineTransform() {
        if (this.transform == null) {
            this.transform = new AffineTransform();
        }
        return new AffineTransform(this.transform);
    }

    protected double getBlueprintScale() {
        return this.blueprintScale;
    }

    public String getDescription() {
        return this.description;
    }

    public GeometraDrawing getDrawing(int which) {
        return (GeometraDrawing)this.drawings.get(which);
    }

    public abstract GeometraDrawing getDrawing(Point2D var1);

    public GeometraCollection<GeometraDrawing> getDrawings() {
        return this.drawings;
    }

    public int indexOf(GeometraDrawing gd) {
        return this.drawings.indexOf((Object)gd);
    }

    public int getNumberOfDrawings() {
        return this.drawings.size();
    }

    private BlueprintPage.ViewingState getSpecificViewState(boolean is2D, boolean is3D) {
        BlueprintPage.ViewingState specificState = is2D && is3D ? BlueprintPage.ViewingState.SHOW_ALL : (!is2D && !is3D ? BlueprintPage.ViewingState.SHOW_NONE : (is3D ? BlueprintPage.ViewingState.SHOW_3D : BlueprintPage.ViewingState.SHOW_2D));
        return specificState;
    }

    public ScaleDrawing getScaleDrawing() {
        return this.scaleDrawing;
    }

    public void paintBlueprintPage(Graphics g) {
        block26: {
            GeometraCollection activeDrawingsToBePainted;
            GeometraCollection drawingsToBePainted;
            Graphics2D g2d;
            block25: {
                BlueprintPage.ViewingState state;
                boolean d2;
                boolean d3;
                g2d = (Graphics2D)g;
                g2d.setComposite(AlphaComposite.getInstance(3, 0.25f));
                this.scaleDrawing.paintDrawing(g2d, (BlueprintPage)this, null);
                drawingsToBePainted = new GeometraCollection();
                activeDrawingsToBePainted = new GeometraCollection();
                if (this.currentDrawState.equals((Object)BlueprintPage.DrawingState.NORMAL)) {
                    g2d.setComposite(AlphaComposite.getInstance(3, 0.75f));
                    for (GeometraDrawing active : this.activeDrawings) {
                        if (active == null) continue;
                        activeDrawingsToBePainted.add((Object)active);
                        if (active instanceof SmartDrawing) {
                            active.paintAsSmartDrawing(g2d, (BlueprintPage)this, null);
                        } else {
                            active.paintDrawing(g2d, (BlueprintPage)this, null);
                        }
                        active.paintVertices(g2d, (BlueprintPage)this);
                    }
                    g2d.setComposite(AlphaComposite.getInstance(3, 0.25f));
                    for (GeometraDrawing d : this.drawings) {
                        if (this.activeDrawings.contains((Object)d)) continue;
                        drawingsToBePainted.add((Object)d);
                        d.paintDrawing(g2d, (BlueprintPage)this, null);
                    }
                } else if (this.currentDrawState.equals((Object)BlueprintPage.DrawingState.SMART)) {
                    for (GeometraDrawing gd : this.drawings) {
                        gd.paintDrawing(g2d, (BlueprintPage)this, null);
                    }
                    g2d.setComposite(AlphaComposite.getInstance(3, 0.75f));
                    for (GeometraDrawing gd : this.drawings) {
                        if (!(gd instanceof SmartDrawing) || !this.activeDrawings.contains((Object)gd)) continue;
                        gd.paintAsSmartDrawing(g2d, (BlueprintPage)this, null);
                    }
                } else if (this.currentDrawState.equals((Object)BlueprintPage.DrawingState.SMART_ONLY)) {
                    for (GeometraDrawing gd : this.drawings) {
                        if (!(gd instanceof SmartDrawing) || !this.activeDrawings.contains((Object)gd)) continue;
                        g2d.setComposite(AlphaComposite.getInstance(3, 0.75f));
                        gd.paintAsSmartDrawing(g2d, (BlueprintPage)this, null);
                        gd.paintVertices(g2d, (BlueprintPage)this);
                    }
                } else if (this.currentDrawState.equals((Object)BlueprintPage.DrawingState.LINE_DRAWING)) {
                    g2d.setComposite(AlphaComposite.getInstance(3, 0.75f));
                    for (GeometraDrawing gd : this.drawings) {
                        if (!(gd instanceof LineDrawing)) continue;
                        activeDrawingsToBePainted.add((Object)gd);
                        gd.paintDrawing(g2d, (BlueprintPage)this, null);
                        gd.paintVertices(g2d, (BlueprintPage)this);
                    }
                } else if (this.currentDrawState.equals((Object)BlueprintPage.DrawingState.DOT_DRAWING)) {
                    g2d.setComposite(AlphaComposite.getInstance(3, 0.75f));
                    for (GeometraDrawing gd : this.drawings) {
                        if (!(gd instanceof DotDrawingContainer)) continue;
                        activeDrawingsToBePainted.add((Object)gd);
                        gd.paintDrawing(g2d, (BlueprintPage)this, null);
                        gd.paintVertices(g2d, (BlueprintPage)this);
                    }
                } else if (this.currentDrawState.equals((Object)BlueprintPage.DrawingState.SQUARE_DRAWING)) {
                    g2d.setComposite(AlphaComposite.getInstance(3, 0.75f));
                    for (GeometraDrawing gd : this.drawings) {
                        if (!(gd instanceof SquareDrawing)) continue;
                        activeDrawingsToBePainted.add((Object)gd);
                        gd.paintDrawing(g2d, (BlueprintPage)this, null);
                        gd.paintVertices(g2d, (BlueprintPage)this);
                    }
                }
                if (!this.currentViewState.equals((Object)BlueprintPage.ViewingState.SHOW_SPECIFIC)) break block25;
                g2d.setComposite(AlphaComposite.getInstance(3, 0.75f));
                for (GeometraDrawing gd : activeDrawingsToBePainted) {
                    d3 = gd.isThreeDimensionsVisible();
                    d2 = gd.isTwoDimensionsVisible();
                    state = this.getSpecificViewState(d2, d3);
                    if (state.equals((Object)BlueprintPage.ViewingState.SHOW_NONE)) continue;
                    gd.paintDistances(g2d, (BlueprintPage)this, state);
                }
                g2d.setComposite(AlphaComposite.getInstance(3, 0.25f));
                for (GeometraDrawing gd : drawingsToBePainted) {
                    if (this.activeDrawings.contains((Object)gd)) continue;
                    d3 = gd.isThreeDimensionsVisible();
                    d2 = gd.isTwoDimensionsVisible();
                    state = this.getSpecificViewState(d2, d3);
                    if (state.equals((Object)BlueprintPage.ViewingState.SHOW_NONE)) continue;
                    gd.paintDistances(g2d, (BlueprintPage)this, state);
                }
                break block26;
            }
            if (this.currentViewState.equals((Object)BlueprintPage.ViewingState.SHOW_NONE)) break block26;
            g2d.setComposite(AlphaComposite.getInstance(3, 0.75f));
            for (GeometraDrawing gd : activeDrawingsToBePainted) {
                gd.paintDistances(g2d, (BlueprintPage)this, this.currentViewState);
            }
            g2d.setComposite(AlphaComposite.getInstance(3, 0.25f));
            for (GeometraDrawing gd : drawingsToBePainted) {
                if (this.activeDrawings.contains((Object)gd)) continue;
                gd.paintDistances(g2d, (BlueprintPage)this, this.currentViewState);
            }
        }
    }

    public double scaleToReal(double d) {
        return this.scaleDrawing.scaleToReal(d);
    }

    public abstract void removeDrawing(Object var1);

    public double scaleToRealArea(double d) {
        return this.scaleDrawing.scaleToRealArea(d);
    }

    private void setActiveDrawing(GeometraCollection<GeometraDrawing> currentDrawings) {
        this.activeDrawings.clear();
        if (currentDrawings == null) {
            return;
        }
        for (GeometraDrawing gd : currentDrawings) {
            if (this.activeDrawings.contains((Object)gd)) {
                this.activeDrawings.remove((Object)gd);
                continue;
            }
            this.activeDrawings.add((Object)gd);
        }
    }

    private void setActiveDrawing(GeometraDrawing gd) {
        this.activeDrawings.clear();
        if (gd != null) {
            this.activeDrawings.add((Object)gd);
        }
    }

    public void setActiveDrawing(Object object) {
        if (object instanceof GeometraDrawing) {
            GeometraDrawing gd = (GeometraDrawing)object;
            this.setActiveDrawing(gd);
        } else if (object instanceof GeometraCollection) {
            GeometraCollection geoVector = (GeometraCollection)object;
            this.setActiveDrawing((GeometraCollection<GeometraDrawing>)geoVector);
        } else if (object == null) {
            this.setActiveDrawing((GeometraDrawing)null);
        }
    }

    public void setBlueprintScale(double newScale) {
        this.blueprintScale = newScale;
        this.updateState();
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public void setViewingState(BlueprintPage.ViewingState vs) {
        this.currentViewState = vs;
    }

    public void setDrawingState(BlueprintPage.DrawingState ds) {
        this.currentDrawState = ds;
    }

    public void setScaleDrawing(ScaleDrawing sd) {
        this.scaleDrawing.setPoints(sd.getPoints());
        this.scaleDrawing.setRealDistance(sd.getRealDistance());
        this.scaleDrawing.setDescription(sd.getDescription());
        this.scaleDrawing.buildPath();
    }

    private void listDrawings(int sortType) {
        if (sortType == 0) {
            for (int i = 0; i < this.drawings.size(); ++i) {
                System.out.println("index: " + i + " name: " + this.drawings.get(i));
            }
        } else {
            for (int i = 0; i < this.drawings.size(); ++i) {
                System.err.println("index: " + i + " name: " + this.drawings.get(i));
            }
        }
    }

    public void sort(int sortType) {
        System.out.println("sort in blueprintPage!");
        if (sortType == 0) {
            this.sortByName();
            this.listDrawings(sortType);
        } else if (sortType == 1) {
            this.sortByDrawing();
            this.listDrawings(sortType);
        }
    }

    private void sortByName() {
        List list = this.drawings.getList();
        ScaleDrawing sd = null;
        for (int i = 0; i < list.size(); ++i) {
            if (!(list.get(i) instanceof ScaleDrawing)) continue;
            sd = (ScaleDrawing)list.get(i);
            break;
        }
        NameComparator nc = new NameComparator();
        list.remove(sd);
        Collections.sort(list, nc);
        list.add(0, sd);
    }

    private void sortByDrawing() {
        GeometraCollection collection = new GeometraCollection();
        GeometraCollection square = new GeometraCollection();
        GeometraCollection line = new GeometraCollection();
        GeometraCollection dot = new GeometraCollection();
        GeometraCollection smart = new GeometraCollection();
        GeometraCollection text = new GeometraCollection();
        GeometraCollection theRest = new GeometraCollection();
        ScaleDrawing sd = null;
        for (GeometraDrawing gd : this.drawings) {
            if (gd instanceof SmartDrawing) {
                smart.add((Object)gd);
                continue;
            }
            if (gd instanceof LineDrawing) {
                line.add((Object)gd);
                continue;
            }
            if (gd instanceof SquareDrawing) {
                square.add((Object)gd);
                continue;
            }
            if (gd instanceof DotDrawingContainer) {
                dot.add((Object)gd);
                continue;
            }
            if (gd instanceof ScaleDrawing) {
                sd = (ScaleDrawing)gd;
                continue;
            }
            if (gd instanceof TextDrawing) {
                text.add((Object)gd);
                continue;
            }
            theRest.add((Object)gd);
        }
        collection.add(sd);
        collection.addAll(square);
        collection.addAll(line);
        collection.addAll(dot);
        collection.addAll(text);
        collection.addAll(smart);
        collection.addAll(theRest);
        this.drawings = collection;
    }

    public void setPageDimension(Dimension d) {
        this.pageDimension = d;
    }

    public Dimension getPageDimension() {
        return this.pageDimension;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.drawings == null ? 0 : this.drawings.hashCode());
        result = 31 * result + (this.scaleDrawing == null ? 0 : this.scaleDrawing.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BlueprintPageImpl other = (BlueprintPageImpl)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.drawings == null ? other.drawings != null : !this.drawings.equals(other.drawings)) {
            return false;
        }
        return !(this.scaleDrawing == null ? other.scaleDrawing != null : !this.scaleDrawing.equals(other.scaleDrawing));
    }
}

