/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.geometra.datastructures.core;

import java.awt.Graphics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.icepdf.ri.common.views.painting.core.Blueprint;
import org.icepdf.ri.common.views.painting.core.BlueprintPage;
import org.icepdf.ri.common.views.painting.core.GeometraCollection;
import org.icepdf.ri.common.views.painting.drawings.GeometraDrawing;
import org.icepdf.ri.common.views.painting.drawings.ScaleDrawing;

public abstract class BlueprintImpl
implements Blueprint {
    private String description;
    protected String filePath;
    protected GeometraCollection<BlueprintPage> pages;
    private transient BlueprintPage activePage;

    public String getFilePath() {
        return this.filePath;
    }

    public void sort(int sortType) {
        for (BlueprintPage page : this.pages) {
            page.sort(sortType);
        }
    }

    protected void setPage(BlueprintPage page) {
        this.activePage = page;
    }

    protected AffineTransform getAffineTransform() {
        return this.activePage.getAffineTransform();
    }

    protected double scaleToReal(double d) {
        return this.activePage.scaleToReal(d);
    }

    protected void setScaleDrawing(ScaleDrawing sd) {
        if (this.activePage != null) {
            this.activePage.setScaleDrawing(sd);
        }
    }

    protected void setDescription(String description) {
        this.description = description;
    }

    protected GeometraDrawing getDrawing(Point2D screenCoord) {
        return this.activePage.getDrawing(screenCoord);
    }

    protected Point2D blueprintToComponent(Point2D point) {
        return this.activePage.blueprintToComponent(point);
    }

    protected Point2D componentToBlueprint(Point2D point) {
        return this.activePage.componentToBlueprint(point);
    }

    protected void addToSmartDrawing(GeometraCollection<GeometraDrawing> coll, String description) {
        this.activePage.addToSmartDrawing(coll, description);
    }

    protected void setBlueprintScale(double scale) {
        this.activePage.setBlueprintScale(scale);
    }

    public BlueprintPage getPage(int index) {
        return (BlueprintPage)this.pages.get(index);
    }

    protected BlueprintPage getActivePage() {
        return this.activePage;
    }

    public int indexOf(BlueprintPage page) {
        return this.pages.indexOf((Object)page);
    }

    public int getNumberOfPages() {
        return this.pages.size();
    }

    protected void init() {
    }

    protected void setPageNumber(int pageNumber) {
    }

    public String getDescription() {
        return this.description;
    }

    protected ScaleDrawing getScaleDrawing() {
        return this.activePage.getScaleDrawing();
    }

    protected GeometraCollection<GeometraDrawing> getDrawings() {
        return this.activePage.getDrawings();
    }

    public String[] getPageNames() {
        String[] names = new String[this.pages.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = ((BlueprintPage)this.pages.get(i)).getDescription();
        }
        return names;
    }

    protected GeometraCollection<GeometraDrawing> getAllDrawings() {
        GeometraCollection allDrawings = new GeometraCollection();
        for (BlueprintPage page : this.pages) {
            GeometraCollection temp = page.getDrawings();
            allDrawings.addAll(temp);
        }
        return allDrawings;
    }

    protected void addDrawing(Object object) {
        if (object instanceof GeometraDrawing) {
            GeometraDrawing gd = (GeometraDrawing)object;
            BlueprintPage parent = gd.getParent();
            if (parent.equals(this.activePage)) {
                this.activePage.addDrawing(object);
            } else {
                for (BlueprintPage page : this.pages) {
                    if (!page.equals(parent)) continue;
                    page.addDrawing(object);
                    return;
                }
            }
        }
    }

    protected void moveScaleDrawing(Point2D point) {
        this.activePage.getScaleDrawing().moveScaleDrawing(point);
    }

    protected GeometraCollection<GeometraDrawing> getUnlockedDrawings() {
        return this.activePage.getUnlockedDrawings();
    }

    protected void setDrawingState(BlueprintPage.DrawingState state) {
        this.activePage.setDrawingState(state);
    }

    protected void setViewingState(BlueprintPage.ViewingState state) {
        this.activePage.setViewingState(state);
    }

    protected GeometraCollection<GeometraDrawing> getActiveDrawings() {
        return this.activePage.getActiveDrawings();
    }

    public void paintBlueprint(Graphics g) {
        this.activePage.paintBlueprintPage(g);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(BLUEPRINT_ID ^ BLUEPRINT_ID >>> 32);
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.filePath == null ? 0 : this.filePath.hashCode());
        result = 31 * result + (this.pages == null ? 0 : this.pages.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BlueprintImpl other = (BlueprintImpl)obj;
        if (BLUEPRINT_ID != Blueprint.BLUEPRINT_ID) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.filePath == null ? other.filePath != null : !this.filePath.equals(other.filePath)) {
            return false;
        }
        return !(this.pages == null ? other.pages != null : !this.pages.equals(other.pages));
    }
}

