/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.geometra.datastructures.blueprint.listeners;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import org.icepdf.ri.common.views.painting.core.Blueprint;
import org.icepdf.ri.common.views.painting.core.BlueprintPage;
import org.icepdf.ri.common.views.painting.drawings.GeometraDrawing;
import se.sjobeck.geometra.datastructures.blueprint.PDFController;
import se.sjobeck.geometra.datastructures.blueprint.listeners.GeometraMouseAdapter;
import se.sjobeck.geometra.datastructures.drawings.ZoomDrawing;

public class ZoomListener
extends GeometraMouseAdapter {
    private final PDFController controller;
    private GeometraDrawing zoomDrawing;
    private final Blueprint blueprint;
    private double zoomIn;
    private Point2D centerPoint;
    private final Runnable doZoom = new Runnable(){

        @Override
        public void run() {
            ZoomListener.this.controller.setZoom((float)ZoomListener.this.zoomIn, new Point((int)ZoomListener.this.centerPoint.getX(), (int)ZoomListener.this.centerPoint.getY()), false);
        }
    };
    private final Runnable doZoomUpdate = new Runnable(){

        @Override
        public void run() {
            ZoomListener.this.geoSubject.zoomUpdate(ZoomListener.this.controller.getUserZoom(), ZoomListener.this);
        }
    };

    public ZoomListener(PDFController controller) {
        this.controller = controller;
        this.blueprint = controller.getBlueprint();
    }

    public String toString() {
        return "ZoomDrawingListener";
    }

    @Override
    public void mousePressed(MouseEvent event) {
        if (event.getButton() == 1) {
            this.geoManager.setDrawingState(this.blueprint, BlueprintPage.DrawingState.NORMAL);
            if (this.zoomDrawing == null) {
                this.zoomDrawing = new ZoomDrawing();
                this.geoSubject.add(this.zoomDrawing, this);
            }
            this.zoomDrawing.addPoint((Point2D)event.getPoint());
            this.geoSubject.update(this.zoomDrawing, (Object)this);
        }
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        if (this.zoomDrawing == null) {
            this.zoomDrawing = new ZoomDrawing();
            this.geoSubject.add(this.zoomDrawing, this);
        }
        this.zoomDrawing.addPoint((Point2D)event.getPoint());
        this.geoSubject.update(this.zoomDrawing, (Object)this);
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        if (this.zoomDrawing != null) {
            this.zoomDrawing.addPoint((Point2D)event.getPoint());
            Point2D startP = (Point2D)this.zoomDrawing.getPoints().get(0);
            Point2D endP = (Point2D)this.zoomDrawing.getPoints().get(1);
            this.geoSubject.remove(this.zoomDrawing, this);
            if (startP.distance(endP) > (double)(10.0f / this.controller.getUserZoom())) {
                this.doZoom();
            }
            this.zoomDrawing = null;
        }
    }

    private void doZoom() {
        Point2D endP;
        Point2D startP;
        double scaleModifier = 0.6;
        float userZoom = this.controller.getUserZoom();
        if (this.controller.getUserRotation() != 0.0f && Math.abs(this.controller.getUserRotation()) != 360.0f && this.controller.getUserZoom() == 1.0f) {
            startP = (Point2D)this.zoomDrawing.getPoints().get(0);
            endP = (Point2D)this.zoomDrawing.getPoints().get(1);
        } else if (this.controller.getUserRotation() != 0.0f && Math.abs(this.controller.getUserRotation()) != 360.0f && this.controller.getUserZoom() > 1.0f) {
            startP = (Point2D)this.zoomDrawing.getPoints().get(0);
            endP = (Point2D)this.zoomDrawing.getPoints().get(1);
            userZoom = 1.0f;
        } else if (this.controller.getUserRotation() != 0.0f && Math.abs(this.controller.getUserRotation()) != 360.0f && this.controller.getUserZoom() < 1.0f) {
            startP = (Point2D)this.zoomDrawing.getPoints().get(0);
            endP = (Point2D)this.zoomDrawing.getPoints().get(1);
            userZoom = 0.0f;
        } else if (this.controller.getUserZoom() == 1.0f && (this.controller.getUserRotation() == 0.0f || Math.abs(this.controller.getUserRotation()) == 360.0f)) {
            startP = this.geoManager.blueprintToComponent((Point2D)this.zoomDrawing.getPoints().get(0));
            endP = this.geoManager.blueprintToComponent((Point2D)this.zoomDrawing.getPoints().get(1));
        } else {
            startP = (Point2D)this.zoomDrawing.getPoints().get(0);
            endP = (Point2D)this.zoomDrawing.getPoints().get(1);
        }
        if (userZoom == 1.0f) {
            scaleModifier = 0.6;
            double width = Math.abs(startP.getX() - endP.getX());
            double height = Math.abs(startP.getY() - endP.getY());
            double pWidth = startP.getX() > endP.getX() ? startP.getX() : endP.getX();
            double pHeight = startP.getY() > endP.getY() ? startP.getY() : endP.getY();
            float viewHeight = this.controller.getViewContainer().getHeight();
            float viewWidth = this.controller.getViewContainer().getWidth();
            double drawingFactor = width > height ? width : height;
            double controllFactor = viewWidth > viewHeight ? (double)viewWidth : (double)viewHeight;
            double ff1 = controllFactor / drawingFactor;
            double ff2 = drawingFactor / controllFactor;
            double scaleFactor = ff1 > ff2 ? ff1 : ff2;
            double realZoom = (double)this.controller.getUserZoom() * scaleFactor * scaleModifier;
            if (realZoom < 1.0) {
                realZoom = (double)this.controller.getUserZoom() * scaleFactor;
            }
            double middleX = pWidth - width / 2.0;
            double middleY = pHeight - height / 2.0;
            this.centerPoint = new Point2D.Double(middleX, middleY);
            System.out.println("CENTER POINT: " + this.centerPoint);
            this.zoomIn = realZoom;
            Thread zoomThread = new Thread(){

                @Override
                public void run() {
                    try {
                        SwingUtilities.invokeAndWait(ZoomListener.this.doZoom);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                }
            };
            zoomThread.start();
            Thread zoomUpdateThread = new Thread(){

                @Override
                public void run() {
                    try {
                        SwingUtilities.invokeAndWait(ZoomListener.this.doZoomUpdate);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                }
            };
            zoomUpdateThread.start();
        } else {
            double width = Math.abs(startP.getX() - endP.getX());
            double height = Math.abs(startP.getY() - endP.getY());
            double pWidth = startP.getX() > endP.getX() ? startP.getX() : endP.getX();
            double pHeight = startP.getY() > endP.getY() ? startP.getY() : endP.getY();
            float viewHeight = this.controller.getViewContainer().getHeight();
            float viewWidth = this.controller.getViewContainer().getWidth();
            double drawingFactor = width > height ? width : height;
            double controllFactor = viewWidth > viewHeight ? (double)viewWidth : (double)viewHeight;
            double ff1 = controllFactor / drawingFactor;
            double ff2 = drawingFactor / controllFactor;
            double scaleFactor = ff1 > ff2 ? ff1 : ff2;
            double realZoom = 1.0 * scaleFactor * scaleModifier;
            double middleX = pWidth - width / 2.0;
            double middleY = pHeight - height / 2.0;
            Point2D.Double middlePoint = new Point2D.Double(middleX, middleY);
            this.controller.setZoom(1.0f);
            this.zoomIn = realZoom;
            this.centerPoint = middlePoint;
            Thread zoomThread = new Thread(){

                @Override
                public void run() {
                    try {
                        SwingUtilities.invokeAndWait(ZoomListener.this.doZoom);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                }
            };
            zoomThread.start();
            Thread zoomUpdateThread = new Thread(){

                @Override
                public void run() {
                    try {
                        SwingUtilities.invokeAndWait(ZoomListener.this.doZoomUpdate);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                }
            };
            zoomUpdateThread.start();
        }
    }
}

