/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.geometra.datastructures.blueprint.listeners;

import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import org.icepdf.ri.common.views.painting.core.Blueprint;
import org.icepdf.ri.common.views.painting.core.BlueprintPage;
import org.icepdf.ri.common.views.painting.core.GeometraCollection;
import org.icepdf.ri.common.views.painting.drawings.GeometraDrawing;
import se.sjobeck.geometra.datastructures.GeometraProperties;
import se.sjobeck.geometra.datastructures.blueprint.GeometraManager;
import se.sjobeck.geometra.datastructures.blueprint.listeners.GeometraMouseAdapter;
import se.sjobeck.geometra.datastructures.drawings.SmartDrawing;
import se.sjobeck.geometra.datastructures.drawings.SquareDrawing;

public class SquareDrawingListener
extends GeometraMouseAdapter {
    private final Blueprint blueprint;
    private GeometraDrawing currentDrawing;
    private final GeometraManager manager = GeometraManager.getInstance();

    public SquareDrawingListener(Blueprint blueprint) {
        this.blueprint = blueprint;
    }

    private void closeCurrentDrawing(GeometraDrawing gd, boolean shouldClose) {
        gd.setClosed(shouldClose);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 1) {
            if (this.geoManager.getUnlockedDrawings().size() != 0) {
                GeometraCollection<GeometraDrawing> unlocked = this.geoManager.getUnlockedDrawings();
                for (GeometraDrawing gd : unlocked) {
                    if (!(gd instanceof SquareDrawing)) continue;
                    this.currentDrawing = gd;
                    break;
                }
            }
            if (this.currentDrawing == null || this.currentDrawing.isClosed() || this.currentDrawing instanceof SmartDrawing || this.manager.indexOf(this.currentDrawing) == -1) {
                this.newDrawing(e.getPoint());
            } else if (e.getClickCount() >= 2 && !this.currentDrawing.isClosed()) {
                if (this.currentDrawing.size() > 1) {
                    this.closeCurrentDrawing(this.currentDrawing, true);
                    this.geoSubject.close(this.currentDrawing, true);
                }
            } else if (!this.currentDrawing.isClosed() && e.getClickCount() == 1) {
                this.currentDrawing.addPoint((Point2D)e.getPoint());
                this.currentDrawing.setFilled(GeometraProperties.isFilled());
                this.currentDrawing.setTwoDimensionsVisible(GeometraProperties.isTwoDimensionsVisible());
                this.currentDrawing.setThreeDimensionsVisible(GeometraProperties.isThreeDimensionsVisible());
                this.geoSubject.addPoint(this.currentDrawing, (Object)this);
            } else {
                this.currentDrawing.addPoint((Point2D)e.getPoint());
                this.currentDrawing.setFilled(GeometraProperties.isFilled());
                this.currentDrawing.setTwoDimensionsVisible(GeometraProperties.isTwoDimensionsVisible());
                this.currentDrawing.setThreeDimensionsVisible(GeometraProperties.isThreeDimensionsVisible());
                this.geoSubject.addPoint(this.currentDrawing, (Object)this);
            }
        }
    }

    private void newDrawing(Point2D firstVertex) {
        this.geoManager.setDrawingState(this.blueprint, BlueprintPage.DrawingState.NORMAL);
        if (this.currentDrawing == null) {
            this.currentDrawing = new SquareDrawing(this.geoManager.getActivePage());
        } else {
            this.currentDrawing = null;
            this.currentDrawing = new SquareDrawing((SquareDrawing)this.currentDrawing, this.geoManager.getActivePage());
        }
        this.currentDrawing.setHeight(GeometraProperties.getDrawingHeight());
        this.currentDrawing.setColor(GeometraProperties.getColor());
        this.currentDrawing.addPoint(firstVertex);
        this.geoSubject.add(this.currentDrawing, this);
    }
}

