/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.geometra.datastructures.blueprint.listeners;

import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import org.icepdf.ri.common.views.painting.core.Blueprint;
import org.icepdf.ri.common.views.painting.core.BlueprintPage;
import org.icepdf.ri.common.views.painting.core.GeometraCollection;
import org.icepdf.ri.common.views.painting.drawings.GeometraDrawing;
import se.sjobeck.geometra.datastructures.GeometraProperties;
import se.sjobeck.geometra.datastructures.blueprint.listeners.GeometraMouseAdapter;
import se.sjobeck.geometra.datastructures.drawings.HoleDrawing;
import se.sjobeck.geometra.datastructures.drawings.SmartDrawing;
import se.sjobeck.geometra.datastructures.drawings.SquareDrawing;

public class HoleDrawingListener
extends GeometraMouseAdapter {
    private final Blueprint blueprint;
    private GeometraDrawing currentDrawing;
    private GeometraDrawing lastDrawing;

    public HoleDrawingListener(Blueprint bp) {
        this.blueprint = bp;
    }

    private void closeCurrentDrawing(GeometraDrawing gd, boolean shouldClose) {
        gd.setClosed(shouldClose);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        HoleDrawing newHole;
        HoleDrawing hd;
        SquareDrawing sd;
        SquareDrawing firstOwner;
        GeometraDrawing gd;
        if (e.getButton() == 1 && !e.isControlDown()) {
            if (this.geoManager.getUnlockedDrawings().size() != 0) {
                GeometraCollection<GeometraDrawing> unlocked = this.geoManager.getUnlockedDrawings();
                for (GeometraDrawing gd2 : unlocked) {
                    if (!(gd2 instanceof HoleDrawing)) continue;
                    this.currentDrawing = gd2;
                    break;
                }
            }
            this.geoManager.getDrawing(e.getPoint());
            if (this.currentDrawing == null || this.currentDrawing.isClosed() || this.currentDrawing instanceof SmartDrawing) {
                this.newDrawing(e.getPoint());
            } else if (!this.currentDrawing.isClosed() && e.getClickCount() == 1) {
                this.currentDrawing.addPoint((Point2D)e.getPoint());
                this.geoSubject.update(this.currentDrawing, (Object)this);
            } else if (e.getClickCount() >= 2 && !this.currentDrawing.isClosed()) {
                if (this.currentDrawing.size() > 1) {
                    this.closeCurrentDrawing(this.currentDrawing, true);
                    this.currentDrawing.setTwoDimensionsVisible(false);
                    this.lastDrawing = this.currentDrawing;
                    this.geoSubject.close(this.currentDrawing, true);
                    this.currentDrawing = null;
                }
            } else {
                this.currentDrawing.addPoint((Point2D)e.getPoint());
                this.geoSubject.update(this.currentDrawing, (Object)this);
            }
        } else if (e.getButton() == 1 && e.isControlDown() && this.lastDrawing != null && (gd = this.geoManager.getDrawing(e.getPoint())) instanceof SquareDrawing && (firstOwner = (SquareDrawing)gd).equals(sd = (hd = (HoleDrawing)this.lastDrawing).getOwner()) && (newHole = sd.cloneHoleDrawing(this.geoManager.componentToBlueprint(e.getPoint()))) != null) {
            this.geoSubject.add(newHole, this);
        }
    }

    private void newDrawing(Point2D vertex) {
        GeometraDrawing gd = this.geoManager.getDrawing(vertex);
        if (gd != null && gd instanceof SquareDrawing) {
            this.geoManager.setDrawingState(this.blueprint, BlueprintPage.DrawingState.NORMAL);
            SquareDrawing sd = (SquareDrawing)gd;
            if (this.currentDrawing == null || this.currentDrawing.isClosed()) {
                this.currentDrawing = new HoleDrawing(this.geoManager.getActivePage(), sd);
                this.currentDrawing.setClosed(false);
            }
            this.currentDrawing.setFilled(GeometraProperties.isFilled());
            this.currentDrawing.addPoint(vertex);
            sd.addChild(this.currentDrawing);
            this.geoSubject.add(this.currentDrawing, this);
        }
    }
}

