/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.geometra.datastructures.blueprint.listeners;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;
import org.icepdf.ri.common.views.painting.core.Blueprint;
import org.icepdf.ri.common.views.painting.core.BlueprintPage;
import org.icepdf.ri.common.views.painting.core.GeometraCollection;
import org.icepdf.ri.common.views.painting.drawings.GeometraDrawing;
import org.icepdf.ri.common.views.painting.drawings.ScaleDrawing;
import se.sjobeck.geometra.datastructures.FileRemover;
import se.sjobeck.geometra.datastructures.GeometraProperties;
import se.sjobeck.geometra.datastructures.PaintingStateMachine;
import se.sjobeck.geometra.datastructures.blueprint.GeometraManager;
import se.sjobeck.geometra.datastructures.blueprint.IcePDFPage;
import se.sjobeck.geometra.datastructures.blueprint.listeners.GeometraPopupMenuListener;
import se.sjobeck.geometra.datastructures.blueprint.listeners.SmartDrawingMenuItem;
import se.sjobeck.geometra.datastructures.blueprint.listeners.TotalDrawingMenuItem;
import se.sjobeck.geometra.datastructures.blueprint.observer.GeometraSubject;
import se.sjobeck.geometra.datastructures.drawings.DotDrawing;
import se.sjobeck.geometra.datastructures.drawings.DotDrawingContainer;
import se.sjobeck.geometra.datastructures.drawings.HoleDrawing;
import se.sjobeck.geometra.datastructures.drawings.LineDrawing;
import se.sjobeck.geometra.datastructures.drawings.SmartDrawing;
import se.sjobeck.geometra.datastructures.drawings.TextDrawing;
import se.sjobeck.geometra.datastructures.drawings.TotalDrawing;
import se.sjobeck.geometra.gui.main.Geometra;
import se.sjobeck.geometra.gui.panels.ButtonPane;
import se.sjobeck.geometra.gui.panels.ExportScaleDialog;
import se.sjobeck.geometra.gui.panels.JTreePDFPane;
import se.sjobeck.gui.DialogCreator;

public class GeometraPopupMenu
extends GeometraPopupMenuListener {
    private static JPopupMenu menu;
    private final JMenuItem descriptionItem = new JMenuItem();
    private final JMenuItem skalstockItem = new JMenuItem();
    private final JMenuItem lockItem = new JMenuItem();
    private final JMenuItem colorItem = new JMenuItem();
    private final JMenuItem fillItem = new JCheckBoxMenuItem();
    private final JMenuItem twoDimensionItem = new JCheckBoxMenuItem();
    private final JMenuItem threeDimensionItem = new JCheckBoxMenuItem();
    private final JMenuItem createSmartDrawingItem = new JMenuItem();
    private final JMenuItem createTotalDrawingItem = new JMenuItem();
    private final JMenuItem removeItem = new JMenuItem();
    private final JMenuItem renameItem = new JMenuItem();
    private final JMenuItem exportScaleItem = new JMenuItem();
    private final JMenuItem moveItem = new JMenuItem();
    private final JMenuItem lineSize1 = new JMenuItem("1");
    private final JMenuItem lineSize2 = new JMenuItem("2");
    private final JMenuItem lineSize3 = new JMenuItem("3");
    private final JMenuItem lineSize4 = new JMenuItem("4");
    private final JMenuItem lineSize5 = new JMenuItem("5");
    private final JMenuItem lineSize6 = new JMenuItem("6");
    private final JMenuItem lineSize7 = new JMenuItem("7");
    private final JMenuItem lineSize8 = new JMenuItem("8");
    private final JMenuItem lineSize9 = new JMenuItem("9");
    private final JMenuItem lineSize10 = new JMenuItem("10");
    private final JMenuItem rotation0 = new JMenuItem("0");
    private final JMenuItem rotation90 = new JMenuItem("90");
    private final JMenuItem rotation180 = new JMenuItem("180");
    private final JMenuItem rotation270 = new JMenuItem("270");
    private final JMenuItem textSize10 = new JMenuItem("10");
    private final JMenuItem textSize12 = new JMenuItem("12");
    private final JMenuItem textSize14 = new JMenuItem("14");
    private final JMenuItem textSize16 = new JMenuItem("16");
    private final JMenu smartDrawingMenu = new JMenu();
    private final JMenu totalDrawingMenu = new JMenu();
    private final JMenu thicknessItemMenu = new JMenu();
    private final JMenu rotationMenu = new JMenu();
    private final JMenu textSizeMenu = new JMenu();
    private Object clickedSource = null;
    private final JSeparator one = new JSeparator(0);
    private final JSeparator two = new JSeparator(0);
    private final JSeparator three = new JSeparator(0);
    private final JSeparator four = new JSeparator(0);
    private final JSeparator five = new JSeparator(0);
    private final JSeparator six = new JSeparator(0);
    private GeometraDrawing clickedDrawing = null;
    private Point2D rightClickPoint = null;
    private final PaintingStateMachine machine = PaintingStateMachine.getInstance();
    private final JTreePDFPane geometraTree;
    private final GeometraSubject geoSubject = GeometraSubject.getInstance();
    private final GeometraManager geoManager = GeometraManager.getInstance();
    private JDialog scaleDrawingDialog;
    private final String fillKey = "ctrl 1";
    private final String twodKey = "ctrl 2";
    private final String threedKey = "ctrl 3";
    private final String lockKey = "ctrl S";
    private final String renameKey = "F2";
    private final String choseColorKey = "F3";
    private Object currentSource = null;
    private final ActionListener totalDrawingListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource() instanceof TotalDrawingMenuItem) {
                TotalDrawingMenuItem menuItem = (TotalDrawingMenuItem)event.getSource();
                TreePath[] paths = GeometraPopupMenu.this.geometraTree.getSelectedPaths();
                GeometraCollection coll = new GeometraCollection();
                for (TreePath path : paths) {
                    Object ob = path.getLastPathComponent();
                    if (!(ob instanceof GeometraDrawing) || ob instanceof ScaleDrawing) continue;
                    GeometraDrawing gd = (GeometraDrawing)ob;
                    coll.add((Object)gd);
                }
                GeometraPopupMenu.this.geoSubject.addToTotal((GeometraCollection<GeometraDrawing>)coll, menuItem.getTotalDrawing());
            }
        }
    };
    private final ActionListener smartDrawingListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource() instanceof SmartDrawingMenuItem) {
                SmartDrawingMenuItem menuItem = (SmartDrawingMenuItem)event.getSource();
                GeometraCollection<GeometraDrawing> active = GeometraPopupMenu.this.geoManager.getActiveDrawings();
                ScaleDrawing sd = null;
                for (GeometraDrawing gd : active) {
                    if (!(gd instanceof ScaleDrawing)) continue;
                    sd = (ScaleDrawing)gd;
                }
                if (sd != null) {
                    active.remove(sd);
                }
                GeometraPopupMenu.this.geoSubject.addToSmart(active, menuItem.getSmartDrawing());
            }
        }
    };
    private final MouseAdapter menuItemListener = new MouseAdapter(){

        @Override
        public void mouseReleased(MouseEvent event) {
            if (event.getSource().equals(GeometraPopupMenu.this.removeItem)) {
                GeometraPopupMenu.this.removeItem();
            } else if (event.getSource().equals(GeometraPopupMenu.this.moveItem)) {
                GeometraPopupMenu.this.moveItem();
            } else if (event.getSource().equals(GeometraPopupMenu.this.colorItem)) {
                GeometraPopupMenu.this.chooseColor();
            } else if (event.getSource().equals(GeometraPopupMenu.this.renameItem)) {
                GeometraPopupMenu.this.renameDrawing();
            } else if (event.getSource().equals(GeometraPopupMenu.this.fillItem)) {
                GeometraPopupMenu.this.fillItem.setSelected(GeometraPopupMenu.this.fillItem.isSelected());
            } else if (event.getSource().equals(GeometraPopupMenu.this.lineSize1)) {
                GeometraPopupMenu.this.setLineSize(2);
            } else if (event.getSource().equals(GeometraPopupMenu.this.lineSize2)) {
                GeometraPopupMenu.this.setLineSize(3);
            } else if (event.getSource().equals(GeometraPopupMenu.this.lineSize3)) {
                GeometraPopupMenu.this.setLineSize(4);
            } else if (event.getSource().equals(GeometraPopupMenu.this.lineSize4)) {
                GeometraPopupMenu.this.setLineSize(5);
            } else if (event.getSource().equals(GeometraPopupMenu.this.lineSize5)) {
                GeometraPopupMenu.this.setLineSize(6);
            } else if (event.getSource().equals(GeometraPopupMenu.this.lineSize6)) {
                GeometraPopupMenu.this.setLineSize(7);
            } else if (event.getSource().equals(GeometraPopupMenu.this.lineSize7)) {
                GeometraPopupMenu.this.setLineSize(8);
            } else if (event.getSource().equals(GeometraPopupMenu.this.lineSize8)) {
                GeometraPopupMenu.this.setLineSize(9);
            } else if (event.getSource().equals(GeometraPopupMenu.this.lineSize9)) {
                GeometraPopupMenu.this.setLineSize(10);
            } else if (event.getSource().equals(GeometraPopupMenu.this.lineSize10)) {
                GeometraPopupMenu.this.setLineSize(11);
            } else if (event.getSource().equals(GeometraPopupMenu.this.rotation0)) {
                GeometraPopupMenu.this.setRotation(0);
            } else if (event.getSource().equals(GeometraPopupMenu.this.rotation90)) {
                GeometraPopupMenu.this.setRotation(90);
            } else if (event.getSource().equals(GeometraPopupMenu.this.rotation180)) {
                GeometraPopupMenu.this.setRotation(180);
            } else if (event.getSource().equals(GeometraPopupMenu.this.rotation270)) {
                GeometraPopupMenu.this.setRotation(270);
            } else if (event.getSource().equals(GeometraPopupMenu.this.textSize10)) {
                GeometraPopupMenu.this.setTextSize(10);
            } else if (event.getSource().equals(GeometraPopupMenu.this.textSize12)) {
                GeometraPopupMenu.this.setTextSize(12);
            } else if (event.getSource().equals(GeometraPopupMenu.this.textSize14)) {
                GeometraPopupMenu.this.setTextSize(14);
            } else if (event.getSource().equals(GeometraPopupMenu.this.textSize16)) {
                GeometraPopupMenu.this.setTextSize(16);
            }
        }
    };
    private final ActionListener menuItemActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            JMenuItem tempItem;
            if (event.getSource() instanceof JMenuItem && !(tempItem = (JMenuItem)event.getSource()).isEnabled()) {
                return;
            }
            if (event.getSource().equals(GeometraPopupMenu.this.moveItem)) {
                GeometraPopupMenu.this.moveItem();
            }
            if (event.getSource().equals(GeometraPopupMenu.this.lockItem)) {
                GeometraPopupMenu.this.lockDrawing();
            } else if (event.getSource().equals(GeometraPopupMenu.this.fillItem)) {
                GeometraPopupMenu.this.fillDrawings();
            } else if (event.getSource().equals(GeometraPopupMenu.this.threeDimensionItem)) {
                GeometraPopupMenu.this.showThreeDimensions();
            } else if (event.getSource().equals(GeometraPopupMenu.this.twoDimensionItem)) {
                GeometraPopupMenu.this.showTwoDimensions();
            } else if (event.getSource().equals(GeometraPopupMenu.this.createSmartDrawingItem)) {
                GeometraPopupMenu.this.createSmartDrawing();
            } else if (event.getSource().equals(GeometraPopupMenu.this.createTotalDrawingItem)) {
                GeometraPopupMenu.this.createTotalDrawing();
            } else if (event.getSource().equals(GeometraPopupMenu.this.skalstockItem)) {
                GeometraPopupMenu.this.moveScaleDrawing();
            } else if (event.getSource().equals(GeometraPopupMenu.this.exportScaleItem)) {
                GeometraPopupMenu.this.exportScaleItem();
            } else if (event.getSource().equals(GeometraPopupMenu.this.lineSize1)) {
                GeometraPopupMenu.this.setLineSize(2);
            } else if (event.getSource().equals(GeometraPopupMenu.this.lineSize2)) {
                GeometraPopupMenu.this.setLineSize(3);
            } else if (event.getSource().equals(GeometraPopupMenu.this.lineSize3)) {
                GeometraPopupMenu.this.setLineSize(4);
            } else if (event.getSource().equals(GeometraPopupMenu.this.lineSize4)) {
                GeometraPopupMenu.this.setLineSize(5);
            } else if (event.getSource().equals(GeometraPopupMenu.this.lineSize5)) {
                GeometraPopupMenu.this.setLineSize(6);
            } else if (event.getSource().equals(GeometraPopupMenu.this.lineSize6)) {
                GeometraPopupMenu.this.setLineSize(7);
            } else if (event.getSource().equals(GeometraPopupMenu.this.lineSize7)) {
                GeometraPopupMenu.this.setLineSize(8);
            } else if (event.getSource().equals(GeometraPopupMenu.this.lineSize8)) {
                GeometraPopupMenu.this.setLineSize(9);
            } else if (event.getSource().equals(GeometraPopupMenu.this.lineSize9)) {
                GeometraPopupMenu.this.setLineSize(10);
            } else if (event.getSource().equals(GeometraPopupMenu.this.lineSize10)) {
                GeometraPopupMenu.this.setLineSize(11);
            } else if (event.getSource().equals(GeometraPopupMenu.this.rotation0)) {
                GeometraPopupMenu.this.setRotation(0);
            } else if (event.getSource().equals(GeometraPopupMenu.this.rotation90)) {
                GeometraPopupMenu.this.setRotation(90);
            } else if (event.getSource().equals(GeometraPopupMenu.this.rotation180)) {
                GeometraPopupMenu.this.setRotation(180);
            } else if (event.getSource().equals(GeometraPopupMenu.this.rotation270)) {
                GeometraPopupMenu.this.setRotation(270);
            } else if (event.getSource().equals(GeometraPopupMenu.this.textSize10)) {
                GeometraPopupMenu.this.setTextSize(10);
            } else if (event.getSource().equals(GeometraPopupMenu.this.textSize12)) {
                GeometraPopupMenu.this.setTextSize(12);
            } else if (event.getSource().equals(GeometraPopupMenu.this.textSize14)) {
                GeometraPopupMenu.this.setTextSize(14);
            } else if (event.getSource().equals(GeometraPopupMenu.this.textSize16)) {
                GeometraPopupMenu.this.setTextSize(16);
            } else if (event.getSource() instanceof JMenuItem && !event.getSource().equals(GeometraPopupMenu.this.colorItem) && !event.getSource().equals(GeometraPopupMenu.this.removeItem) && !event.getSource().equals(GeometraPopupMenu.this.smartDrawingMenu)) {
                JMenuItem temp = (JMenuItem)event.getSource();
                GeometraPopupMenu.this.geoManager.getActiveDrawings();
                temp.getText();
            }
        }
    };

    public GeometraPopupMenu(JPopupMenu menu, JTreePDFPane tree) {
        super(menu);
        JPopupMenu popupMenu = this.totalDrawingMenu.getPopupMenu();
        popupMenu.setLayout(new GridLayout(35, 10));
        JPopupMenu popupMenu1 = this.smartDrawingMenu.getPopupMenu();
        popupMenu1.setLayout(new GridLayout(35, 10));
        GeometraPopupMenu.menu = menu;
        this.geometraTree = tree;
        this.populateMenu();
        this.createScaleDrawingDialog();
        this.moveItem.setVisible(false);
    }

    private void anpassat_till_andra_plattformar(MouseEvent e) {
        this.currentSource = e.getSource();
        if (this.currentSource instanceof JTree) {
            this.sourceJTree(e);
        } else {
            this.clickedSource = e.getSource();
            this.rightClickPoint = e.getPoint();
            this.clickedDrawing = this.geoManager.getDrawing(this.rightClickPoint);
            boolean isFilled = false;
            boolean isTwoDimensionsVisible = false;
            boolean isThreeDimensionsVisible = false;
            if (this.clickedDrawing != null) {
                isFilled = this.clickedDrawing.isFilled();
                isTwoDimensionsVisible = this.clickedDrawing.isTwoDimensionsVisible();
                isThreeDimensionsVisible = this.clickedDrawing.isThreeDimensionsVisible();
                if (!e.isControlDown()) {
                    this.geoSubject.select(this.clickedDrawing, this);
                }
            }
            if (this.clickedDrawing == null) {
                this.showNullMenu();
                super.mousePressed(e);
            }
            if (this.clickedDrawing instanceof GeometraDrawing && !(this.clickedDrawing instanceof ScaleDrawing)) {
                if (this.geoManager.getActiveDrawings().size() == 1) {
                    this.showSingleMenu(this.clickedDrawing.getDescription());
                    if (this.clickedDrawing instanceof DotDrawing) {
                        this.fillItem.setEnabled(false);
                        this.twoDimensionItem.setEnabled(false);
                        this.threeDimensionItem.setEnabled(false);
                    }
                    if (this.clickedDrawing instanceof LineDrawing) {
                        this.thicknessItemMenu.setEnabled(true);
                    }
                    if (this.clickedDrawing instanceof TextDrawing) {
                        this.rotationMenu.setEnabled(true);
                        this.textSizeMenu.setEnabled(true);
                    }
                    System.out.println("fudo ");
                } else {
                    this.showMultiMenu();
                }
                this.fillItem.setSelected(isFilled);
                this.twoDimensionItem.setSelected(isTwoDimensionsVisible);
                this.threeDimensionItem.setSelected(isThreeDimensionsVisible);
                ResourceBundle rBundle = ResourceBundle.getBundle("se/sjobeck/Geometra");
                if (this.clickedDrawing.isClosed()) {
                    this.lockItem.setText(rBundle.getString("POPUP_UNLOCK_MEASURE"));
                } else {
                    this.lockItem.setText(rBundle.getString("POPUP_LOCK_MEASURE"));
                }
                this.updateSmartMenu(this.clickedDrawing.getParent());
                super.mousePressed(e);
            } else if (this.clickedDrawing instanceof ScaleDrawing) {
                this.showScaleDrawingTreeMenu();
                ResourceBundle rBundle = ResourceBundle.getBundle("se/sjobeck/Geometra");
                if (this.clickedDrawing.isClosed()) {
                    this.lockItem.setText(rBundle.getString("POPUP_UNLOCK_MEASURE"));
                } else {
                    this.lockItem.setText(rBundle.getString("POPUP_LOCK_MEASURE"));
                }
                super.mousePressed(e);
            } else if (this.clickedDrawing == null) {
                this.showNullMenu();
            }
        }
    }

    public void clearMenus() {
        this.smartDrawingMenu.removeAll();
        this.totalDrawingMenu.removeAll();
    }

    public void addSmartToMenu(SmartDrawing sd) {
        Component[] components;
        for (Component c : components = this.smartDrawingMenu.getMenuComponents()) {
            SmartDrawingMenuItem sdmi;
            if (!(c instanceof SmartDrawingMenuItem) || !(sdmi = (SmartDrawingMenuItem)c).getSmartDrawing().equals(sd)) continue;
            return;
        }
        SmartDrawingMenuItem smartDrawingItem = new SmartDrawingMenuItem(sd);
        smartDrawingItem.addActionListener(this.smartDrawingListener);
        this.smartDrawingMenu.add(smartDrawingItem);
    }

    private void createScaleDrawingDialog() {
        this.scaleDrawingDialog = new JDialog();
        JComboBox<ScaleDrawingOption> box = new JComboBox<ScaleDrawingOption>(ScaleDrawingOption.values());
        this.scaleDrawingDialog.add(box);
    }

    private void createTotalDrawing() {
        ResourceBundle rBundle = ResourceBundle.getBundle("se/sjobeck/Geometra");
        String name = Geometra.showInputDialog(rBundle.getString("DIALOG_CREATE_TOTAL_DRAWING"));
        if (name == null) {
            return;
        }
        TreePath[] paths = this.geometraTree.getSelectedPaths();
        GeometraCollection totalDrawings = new GeometraCollection();
        if (paths != null) {
            for (TreePath tp : paths) {
                Object ob = tp.getLastPathComponent();
                if (ob == null || !(ob instanceof GeometraDrawing) || ob instanceof ScaleDrawing) continue;
                GeometraDrawing gd = (GeometraDrawing)ob;
                totalDrawings.add((Object)gd);
            }
        }
        TotalDrawing td = new TotalDrawing((GeometraCollection<GeometraDrawing>)totalDrawings);
        td.setDescription(GeometraManager.getInstance().getValidName(name));
        this.geoSubject.add(td, this);
    }

    public void addTotalDrawingToMenu(TotalDrawing td) {
        TotalDrawingMenuItem totalDrawingItem = new TotalDrawingMenuItem(td);
        totalDrawingItem.addActionListener(this.totalDrawingListener);
        this.totalDrawingMenu.add(totalDrawingItem);
    }

    private void createSmartDrawing() {
        SmartDrawing sd;
        ResourceBundle rBundle = ResourceBundle.getBundle("se/sjobeck/Geometra");
        String name = Geometra.showInputDialog(rBundle.getString("DIALOG_CREATE_SMART_DRAWING"));
        if (name == null) {
            return;
        }
        BlueprintPage parent = null;
        TreePath[] paths = this.geometraTree.getSelectedPaths();
        GeometraCollection smartDrawing = new GeometraCollection();
        if (paths != null) {
            for (TreePath path : paths) {
                Object ob = path.getLastPathComponent();
                if (ob != null && ob instanceof GeometraDrawing && !(ob instanceof SmartDrawing) && !(ob instanceof ScaleDrawing)) {
                    GeometraDrawing gd = (GeometraDrawing)ob;
                    smartDrawing.add((Object)gd);
                    continue;
                }
                if (ob instanceof BlueprintPage) {
                    parent = (BlueprintPage)ob;
                    smartDrawing = null;
                    continue;
                }
                if (!(ob instanceof SmartDrawing) || parent != null) continue;
                parent = ((SmartDrawing)ob).getParent();
            }
        }
        if (smartDrawing != null) {
            if (smartDrawing.size() > 0) {
                BlueprintPage smartPage = ((GeometraDrawing)smartDrawing.get(0)).getParent();
                if (smartPage == null) {
                    return;
                }
                for (GeometraDrawing gd : smartDrawing) {
                    if (smartPage.equals(gd.getParent())) continue;
                    return;
                }
            }
            if (smartDrawing.size() != 0) {
                sd = new SmartDrawing(name, (GeometraCollection<GeometraDrawing>)smartDrawing);
            } else {
                sd = new SmartDrawing(name);
                sd.setParent(parent);
            }
        } else {
            sd = new SmartDrawing(name);
            sd.setParent(parent);
        }
        sd.setColor(GeometraProperties.getSmartColor());
        SmartDrawingMenuItem smartDrawingItem = new SmartDrawingMenuItem(sd);
        smartDrawingItem.addActionListener(this.smartDrawingListener);
        this.smartDrawingMenu.add(smartDrawingItem);
        this.geoSubject.add(sd, this);
    }

    private void updateSmartMenu(BlueprintPage page) {
        int count1 = this.smartDrawingMenu.getItemCount();
        if (page == null) {
            for (int i = 0; i < count1; ++i) {
                this.smartDrawingMenu.getItem(i).setEnabled(false);
                this.smartDrawingMenu.getItem(i).setVisible(false);
            }
            return;
        }
        for (int index = 0; index < count1; ++index) {
            SmartDrawingMenuItem menuItem = (SmartDrawingMenuItem)this.smartDrawingMenu.getItem(index);
            if (menuItem.getPage().equals(page)) {
                menuItem.setEnabled(true);
                menuItem.setVisible(true);
                continue;
            }
            menuItem.setEnabled(false);
            menuItem.setVisible(false);
        }
    }

    private void populateMenu() {
        ResourceBundle rBundle = ResourceBundle.getBundle("se/sjobeck/Geometra");
        this.descriptionItem.setEnabled(false);
        this.skalstockItem.setText(rBundle.getString("POPUP_MOVE_SCALEDRAWING"));
        this.skalstockItem.addMouseListener(this.menuItemListener);
        this.skalstockItem.addActionListener(this.menuItemActionListener);
        this.renameItem.setText(rBundle.getString("POPUP_RENAME"));
        this.renameItem.addMouseListener(this.menuItemListener);
        this.renameItem.addActionListener(this.menuItemActionListener);
        this.renameItem.setAccelerator(KeyStroke.getKeyStroke("F2"));
        this.lockItem.setText(rBundle.getString("POPUP_UNLOCK_MEASURE"));
        this.lockItem.addMouseListener(this.menuItemListener);
        this.lockItem.setAccelerator(KeyStroke.getKeyStroke("ctrl S"));
        this.lockItem.addActionListener(this.menuItemActionListener);
        this.exportScaleItem.setText(rBundle.getString("STR_EXPORT") + " " + rBundle.getString("DRAWING_SCALE"));
        this.exportScaleItem.addMouseListener(this.menuItemListener);
        this.exportScaleItem.addActionListener(this.menuItemActionListener);
        this.colorItem.setText(rBundle.getString("POPUP_PICK_COLOR"));
        this.colorItem.addMouseListener(this.menuItemListener);
        this.colorItem.setAccelerator(KeyStroke.getKeyStroke("F3"));
        this.colorItem.addActionListener(this.menuItemActionListener);
        this.thicknessItemMenu.setText(rBundle.getString("POPUP_PICK_THICKNES"));
        this.thicknessItemMenu.add(this.lineSize1);
        this.lineSize1.addMouseListener(this.menuItemListener);
        this.lineSize1.addActionListener(this.menuItemActionListener);
        this.thicknessItemMenu.add(this.lineSize2);
        this.lineSize2.addMouseListener(this.menuItemListener);
        this.lineSize2.addActionListener(this.menuItemActionListener);
        this.thicknessItemMenu.add(this.lineSize3);
        this.lineSize3.addMouseListener(this.menuItemListener);
        this.lineSize3.addActionListener(this.menuItemActionListener);
        this.thicknessItemMenu.add(this.lineSize4);
        this.lineSize4.addMouseListener(this.menuItemListener);
        this.lineSize4.addActionListener(this.menuItemActionListener);
        this.thicknessItemMenu.add(this.lineSize5);
        this.lineSize5.addMouseListener(this.menuItemListener);
        this.lineSize5.addActionListener(this.menuItemActionListener);
        this.thicknessItemMenu.add(this.lineSize6);
        this.lineSize6.addMouseListener(this.menuItemListener);
        this.lineSize6.addActionListener(this.menuItemActionListener);
        this.thicknessItemMenu.add(this.lineSize7);
        this.lineSize7.addMouseListener(this.menuItemListener);
        this.lineSize7.addActionListener(this.menuItemActionListener);
        this.thicknessItemMenu.add(this.lineSize8);
        this.lineSize8.addMouseListener(this.menuItemListener);
        this.lineSize8.addActionListener(this.menuItemActionListener);
        this.thicknessItemMenu.add(this.lineSize9);
        this.lineSize9.addMouseListener(this.menuItemListener);
        this.lineSize9.addActionListener(this.menuItemActionListener);
        this.thicknessItemMenu.add(this.lineSize10);
        this.lineSize10.addMouseListener(this.menuItemListener);
        this.lineSize10.addActionListener(this.menuItemActionListener);
        this.rotationMenu.setText(rBundle.getString("POPUP_PICK_ROTATION"));
        this.rotationMenu.add(this.rotation0);
        this.rotation0.addMouseListener(this.menuItemListener);
        this.rotation0.addActionListener(this.menuItemActionListener);
        this.rotationMenu.add(this.rotation90);
        this.rotation90.addMouseListener(this.menuItemListener);
        this.rotation90.addActionListener(this.menuItemActionListener);
        this.rotationMenu.add(this.rotation180);
        this.rotation180.addMouseListener(this.menuItemListener);
        this.rotation180.addActionListener(this.menuItemActionListener);
        this.rotationMenu.add(this.rotation270);
        this.rotation270.addMouseListener(this.menuItemListener);
        this.rotation270.addActionListener(this.menuItemActionListener);
        this.textSizeMenu.setText(rBundle.getString("POPUP_PICK_TEXTSIZE"));
        this.textSizeMenu.add(this.textSize10);
        this.textSize10.addMouseListener(this.menuItemListener);
        this.textSize10.addActionListener(this.menuItemActionListener);
        this.textSizeMenu.add(this.textSize12);
        this.textSize12.addMouseListener(this.menuItemListener);
        this.textSize12.addActionListener(this.menuItemActionListener);
        this.textSizeMenu.add(this.textSize14);
        this.textSize14.addMouseListener(this.menuItemListener);
        this.textSize14.addActionListener(this.menuItemActionListener);
        this.textSizeMenu.add(this.textSize16);
        this.textSize16.addMouseListener(this.menuItemListener);
        this.textSize16.addActionListener(this.menuItemActionListener);
        this.fillItem.setText(rBundle.getString("STR_FILL") + " " + rBundle.getString("DRAWING_DEFAULT"));
        this.fillItem.addMouseListener(this.menuItemListener);
        this.fillItem.setAccelerator(KeyStroke.getKeyStroke("ctrl 1"));
        this.fillItem.addActionListener(this.menuItemActionListener);
        this.twoDimensionItem.setText(rBundle.getString("POPUP_SHOW_2D"));
        this.twoDimensionItem.addMouseListener(this.menuItemListener);
        this.twoDimensionItem.setAccelerator(KeyStroke.getKeyStroke("ctrl 2"));
        this.twoDimensionItem.addActionListener(this.menuItemActionListener);
        this.threeDimensionItem.setText(rBundle.getString("POPUP_SHOW_3D"));
        this.threeDimensionItem.addMouseListener(this.menuItemListener);
        this.threeDimensionItem.setAccelerator(KeyStroke.getKeyStroke("ctrl 3"));
        this.threeDimensionItem.addActionListener(this.menuItemActionListener);
        this.createTotalDrawingItem.setText(rBundle.getString("POPUP_CREATE_TOTALDRAWING"));
        this.createTotalDrawingItem.addMouseListener(this.menuItemListener);
        this.createTotalDrawingItem.addActionListener(this.menuItemActionListener);
        this.createSmartDrawingItem.setText(rBundle.getString("POPUP_CREATE_SMARTDRAWING"));
        this.createSmartDrawingItem.addMouseListener(this.menuItemListener);
        this.createSmartDrawingItem.addActionListener(this.menuItemActionListener);
        this.totalDrawingMenu.setText(rBundle.getString("POPUP_ADD_TO_TOTALDRAWING"));
        this.totalDrawingMenu.addMouseListener(this.menuItemListener);
        this.totalDrawingMenu.addActionListener(this.menuItemActionListener);
        this.smartDrawingMenu.setText(rBundle.getString("POPUP_ADD_TO_SMARTDRAWING"));
        this.smartDrawingMenu.addMouseListener(this.menuItemListener);
        this.smartDrawingMenu.addActionListener(this.menuItemActionListener);
        this.removeItem.setText(rBundle.getString("STR_REMOVE") + " " + rBundle.getString("DRAWING_DEFAULT"));
        this.removeItem.addMouseListener(this.menuItemListener);
        this.removeItem.addActionListener(this.menuItemActionListener);
        this.moveItem.setText(rBundle.getString("STR_MOVE_ITEM"));
        this.moveItem.addActionListener(this.menuItemActionListener);
        menu.add(this.descriptionItem);
        menu.add(this.one);
        menu.add(this.renameItem);
        menu.add(this.lockItem);
        menu.add(this.colorItem);
        menu.add(this.thicknessItemMenu);
        menu.add(this.rotationMenu);
        menu.add(this.textSizeMenu);
        menu.add(this.three);
        menu.add(this.fillItem);
        menu.add(this.twoDimensionItem);
        menu.add(this.threeDimensionItem);
        menu.add(this.four);
        menu.add(this.createSmartDrawingItem);
        menu.add(this.smartDrawingMenu);
        menu.add(this.five);
        menu.add(this.createTotalDrawingItem);
        menu.add(this.totalDrawingMenu);
        menu.add(this.two);
        menu.add(this.skalstockItem);
        menu.add(this.six);
        menu.add(this.removeItem);
        menu.add(this.moveItem);
    }

    private void showBlueprintPageTreeMenu(String pageName) {
        ResourceBundle rBundle = ResourceBundle.getBundle("se/sjobeck/Geometra");
        this.descriptionItem.setText(pageName);
        this.renameItem.setEnabled(true);
        this.descriptionItem.setVisible(true);
        this.skalstockItem.setEnabled(false);
        this.lockItem.setEnabled(false);
        this.colorItem.setEnabled(false);
        this.thicknessItemMenu.setEnabled(false);
        this.rotationMenu.setEnabled(false);
        this.textSizeMenu.setEnabled(false);
        this.fillItem.setEnabled(false);
        this.twoDimensionItem.setEnabled(false);
        this.threeDimensionItem.setEnabled(false);
        this.createSmartDrawingItem.setEnabled(true);
        this.smartDrawingMenu.setEnabled(false);
        this.totalDrawingMenu.setEnabled(false);
        this.createTotalDrawingItem.setEnabled(true);
        this.removeItem.setEnabled(false);
        this.removeItem.setText(rBundle.getString("STR_REMOVE") + " " + rBundle.getString("STR_PAGE"));
    }

    private void showReductionMenu() {
        this.renameItem.setEnabled(true);
        this.descriptionItem.setVisible(true);
        this.skalstockItem.setEnabled(false);
        this.lockItem.setEnabled(true);
        this.colorItem.setEnabled(true);
        this.thicknessItemMenu.setEnabled(false);
        this.rotationMenu.setEnabled(false);
        this.textSizeMenu.setEnabled(false);
        this.fillItem.setEnabled(true);
        this.twoDimensionItem.setEnabled(false);
        this.threeDimensionItem.setEnabled(false);
        this.createSmartDrawingItem.setEnabled(true);
        this.smartDrawingMenu.setEnabled(true);
        this.totalDrawingMenu.setEnabled(true);
        this.createTotalDrawingItem.setEnabled(true);
        this.removeItem.setEnabled(true);
    }

    private void showBlueprintTreeMenu(String blueprintName) {
        ResourceBundle rBundle = ResourceBundle.getBundle("se/sjobeck/Geometra");
        this.descriptionItem.setText(blueprintName);
        this.renameItem.setEnabled(true);
        this.descriptionItem.setEnabled(false);
        this.skalstockItem.setEnabled(false);
        this.lockItem.setEnabled(false);
        this.colorItem.setEnabled(false);
        this.thicknessItemMenu.setEnabled(false);
        this.rotationMenu.setEnabled(false);
        this.textSizeMenu.setEnabled(false);
        this.fillItem.setEnabled(false);
        this.twoDimensionItem.setEnabled(false);
        this.threeDimensionItem.setEnabled(false);
        this.createSmartDrawingItem.setEnabled(false);
        this.totalDrawingMenu.setEnabled(false);
        this.createTotalDrawingItem.setEnabled(true);
        this.smartDrawingMenu.setEnabled(false);
        this.removeItem.setEnabled(true);
        this.removeItem.setText(rBundle.getString("POPUP_REMOVE_BLUEPRINT"));
    }

    private void showNullMenu() {
        ResourceBundle rBundle = ResourceBundle.getBundle("se/sjobeck/Geometra");
        this.descriptionItem.setText(rBundle.getString("POPUP_NO_MARKING"));
        this.renameItem.setEnabled(false);
        this.skalstockItem.setEnabled(true);
        this.lockItem.setEnabled(false);
        this.colorItem.setEnabled(false);
        this.thicknessItemMenu.setEnabled(false);
        this.rotationMenu.setEnabled(false);
        this.textSizeMenu.setEnabled(false);
        this.fillItem.setEnabled(false);
        this.twoDimensionItem.setEnabled(false);
        this.threeDimensionItem.setEnabled(false);
        this.smartDrawingMenu.setEnabled(false);
        this.removeItem.setEnabled(false);
        this.removeItem.setText(rBundle.getString("STR_REMOVE") + " " + rBundle.getString("DRAWING_SCALE"));
        this.removeItem.setEnabled(false);
        this.totalDrawingMenu.setEnabled(false);
        this.createTotalDrawingItem.setEnabled(true);
        this.createSmartDrawingItem.setEnabled(false);
    }

    private void showScaleDrawingTreeMenu() {
        ResourceBundle rBundle = ResourceBundle.getBundle("se/sjobeck/Geometra");
        this.descriptionItem.setText(rBundle.getString("DRAWING_SCALE"));
        this.renameItem.setEnabled(false);
        this.skalstockItem.setEnabled(false);
        this.lockItem.setEnabled(true);
        this.colorItem.setEnabled(true);
        this.thicknessItemMenu.setEnabled(false);
        this.rotationMenu.setEnabled(false);
        this.textSizeMenu.setEnabled(false);
        this.fillItem.setEnabled(false);
        this.twoDimensionItem.setEnabled(false);
        this.threeDimensionItem.setEnabled(false);
        this.createSmartDrawingItem.setEnabled(false);
        this.smartDrawingMenu.setEnabled(false);
        this.removeItem.setEnabled(false);
        this.removeItem.setText(rBundle.getString("STR_REMOVE") + " " + rBundle.getString("DRAWING_SCALE"));
        this.removeItem.setEnabled(false);
        this.totalDrawingMenu.setEnabled(false);
        this.createTotalDrawingItem.setEnabled(false);
    }

    private void showSingleTreeMenu() {
        this.renameItem.setEnabled(true);
        this.descriptionItem.setEnabled(false);
        this.skalstockItem.setEnabled(false);
        this.lockItem.setEnabled(true);
        this.colorItem.setEnabled(true);
        this.thicknessItemMenu.setEnabled(false);
        this.rotationMenu.setEnabled(false);
        this.textSizeMenu.setEnabled(false);
        this.fillItem.setEnabled(true);
        this.twoDimensionItem.setEnabled(true);
        this.threeDimensionItem.setEnabled(true);
        this.createSmartDrawingItem.setEnabled(true);
        this.smartDrawingMenu.setEnabled(true);
        this.removeItem.setEnabled(true);
        this.totalDrawingMenu.setEnabled(true);
        this.createTotalDrawingItem.setEnabled(true);
    }

    private void showMultiMenu() {
        ResourceBundle rBundle = ResourceBundle.getBundle("se/sjobeck/Geometra");
        this.descriptionItem.setText(rBundle.getString("POPUP_MULTI_MARK"));
        this.renameItem.setEnabled(true);
        this.descriptionItem.setVisible(true);
        this.skalstockItem.setEnabled(false);
        this.lockItem.setEnabled(false);
        this.colorItem.setEnabled(true);
        this.thicknessItemMenu.setEnabled(true);
        this.rotationMenu.setEnabled(true);
        this.textSizeMenu.setEnabled(true);
        this.fillItem.setEnabled(true);
        this.twoDimensionItem.setEnabled(true);
        this.threeDimensionItem.setEnabled(true);
        this.createSmartDrawingItem.setEnabled(true);
        this.smartDrawingMenu.setEnabled(true);
        this.removeItem.setEnabled(true);
        this.removeItem.setText(rBundle.getString("STR_REMOVE") + " " + rBundle.getString("DRAWING_DEFAULT"));
        this.totalDrawingMenu.setEnabled(true);
        this.createTotalDrawingItem.setEnabled(true);
    }

    private void showSingleMenu(String geoName) {
        ResourceBundle rBundle = ResourceBundle.getBundle("se/sjobeck/Geometra");
        this.descriptionItem.setText(geoName);
        this.descriptionItem.setVisible(true);
        this.skalstockItem.setEnabled(false);
        this.renameItem.setEnabled(true);
        this.lockItem.setEnabled(true);
        this.colorItem.setEnabled(true);
        this.thicknessItemMenu.setEnabled(false);
        this.rotationMenu.setEnabled(false);
        this.textSizeMenu.setEnabled(false);
        this.fillItem.setEnabled(true);
        this.twoDimensionItem.setEnabled(true);
        this.threeDimensionItem.setEnabled(true);
        this.createSmartDrawingItem.setEnabled(true);
        this.smartDrawingMenu.setEnabled(true);
        this.removeItem.setEnabled(true);
        this.removeItem.setText(rBundle.getString("STR_REMOVE") + " " + rBundle.getString("DRAWING_DEFAULT"));
        this.totalDrawingMenu.setEnabled(true);
        this.createTotalDrawingItem.setEnabled(true);
    }

    private void showDotDrawingTreeMenu() {
        this.showSingleTreeMenu();
        this.fillItem.setEnabled(false);
        this.rotationMenu.setEnabled(false);
        this.textSizeMenu.setEnabled(false);
        this.twoDimensionItem.setEnabled(false);
        this.threeDimensionItem.setEnabled(false);
    }

    private boolean isValidScaleDrawing(ScaleDrawing sd) {
        String sdLength = Geometra.showScaleDialog(sd.getRealDistance());
        if (sdLength == null) {
            return false;
        }
        try {
            sd.setDescription(sdLength);
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
        return true;
    }

    public void chooseColor() {
        if (this.colorItem.isEnabled()) {
            this.geoManager.getActiveDrawings().get(0);
            Geometra.showColorChooser(this.geoManager.getActiveDrawings());
        }
    }

    private void setRotation(int i) {
        TreePath[] paths;
        for (TreePath path : paths = this.geometraTree.getSelectedPaths()) {
            Object aClass = path.getLastPathComponent();
            if (!(aClass instanceof TextDrawing)) continue;
            TextDrawing td = (TextDrawing)aClass;
            td.setRotation(i);
            Geometra.GEOMETRA_FRAME.repaint();
        }
    }

    private void setTextSize(int i) {
        TreePath[] paths;
        for (TreePath path : paths = this.geometraTree.getSelectedPaths()) {
            Object aClass = path.getLastPathComponent();
            if (!(aClass instanceof TextDrawing)) continue;
            TextDrawing td = (TextDrawing)aClass;
            td.setTextSize(i);
            Geometra.GEOMETRA_FRAME.repaint();
        }
    }

    private void setLineSize(int i) {
        TreePath[] paths;
        for (TreePath path : paths = this.geometraTree.getSelectedPaths()) {
            Object aClass = path.getLastPathComponent();
            if (!(aClass instanceof LineDrawing)) continue;
            LineDrawing ld = (LineDrawing)aClass;
            ld.setStrokeWidth(i);
            Geometra.GEOMETRA_FRAME.repaint();
        }
    }

    public void removeItem() {
        TreePath[] paths = this.geometraTree.getSelectedPaths();
        GeometraCollection geometraDrawings = new GeometraCollection();
        HashMap<GeometraDrawing, SmartDrawing> geoInSmartMap = new HashMap<GeometraDrawing, SmartDrawing>();
        HashMap<GeometraDrawing, TotalDrawing> geoInTotalMap = new HashMap<GeometraDrawing, TotalDrawing>();
        GeometraCollection geoInTotal = new GeometraCollection();
        GeometraCollection geoInSmart = new GeometraCollection();
        for (int i = 0; i < paths.length; ++i) {
            Object lastPathObject = paths[i].getLastPathComponent();
            TreePath parentPath = paths[i].getParentPath();
            Object parentObject = parentPath.getLastPathComponent();
            if (lastPathObject instanceof GeometraDrawing) {
                GeometraDrawing gd = (GeometraDrawing)paths[i].getLastPathComponent();
                if (parentObject instanceof SmartDrawing) {
                    geoInSmartMap.put(gd, (SmartDrawing)parentObject);
                    geoInSmart.add((Object)gd);
                    continue;
                }
                if (parentObject instanceof TotalDrawing) {
                    geoInTotalMap.put(gd, (TotalDrawing)parentObject);
                    geoInTotal.add((Object)gd);
                    continue;
                }
                geometraDrawings.add((Object)gd);
                continue;
            }
            if (!(lastPathObject instanceof Blueprint)) continue;
            Blueprint bp = (Blueprint)lastPathObject;
            ResourceBundle rBundle = ResourceBundle.getBundle("se/sjobeck/Geometra");
            int answer = Geometra.createQuery(rBundle.getString("DIALOG_REMOVE_BLUEPRINT"));
            if (answer == 0) {
                this.removeFromSmartMenu(bp);
                this.geoSubject.remove(bp, this);
                FileRemover fr = new FileRemover();
                if (fr.removeFile(bp)) {
                    return;
                }
                Geometra.showErrorDialog(rBundle.getString("DIALOG_COULD_NOT_REMOVE_PDF"));
                return;
            }
            return;
        }
        GeometraCollection finalColl = new GeometraCollection();
        finalColl.addAll(geometraDrawings);
        finalColl.addAll(geoInTotal);
        finalColl.addAll(geoInSmart);
        int answer = Geometra.removeDrawingsDialog((GeometraCollection<GeometraDrawing>)finalColl);
        if (answer == 0) {
            Set set;
            for (GeometraDrawing gd : geometraDrawings) {
                if (gd instanceof SmartDrawing) {
                    this.removeFromSmartMenu((SmartDrawing)gd);
                    continue;
                }
                if (!(gd instanceof TotalDrawing)) continue;
                this.removeFromTotalMenu((TotalDrawing)gd);
            }
            if (geometraDrawings.size() > 0) {
                this.geoSubject.remove(geometraDrawings, this);
            }
            if (geoInSmartMap.size() > 0) {
                set = geoInSmartMap.keySet();
                for (GeometraDrawing gd : set) {
                    SmartDrawing sd = (SmartDrawing)geoInSmartMap.get(gd);
                    this.geoSubject.removeFromSmart(gd, sd);
                }
            }
            if (geoInTotalMap.size() > 0) {
                set = geoInTotalMap.keySet();
                for (GeometraDrawing gd : set) {
                    TotalDrawing td = (TotalDrawing)geoInTotalMap.get(gd);
                    this.geoSubject.removeFromTotal(gd, td);
                }
            }
        }
    }

    private void renameDrawing() {
        TreePath[] paths = this.geometraTree.getSelectedPaths();
        if (paths != null) {
            if (this.renameItem.isEnabled() && paths.length == 1) {
                this.geometraTree.fireRenameInTree();
            } else if (this.renameItem.isEnabled() && paths.length > 1) {
                ResourceBundle rBundle = ResourceBundle.getBundle("se/sjobeck/Geometra");
                String input = Geometra.showInputDialog(rBundle.getString("DIALOG_RENAME_DRAWINGS"));
                if (input == null) {
                    return;
                }
                this.geometraTree.fireRenameInTree(input);
            }
        }
    }

    protected void exportScaleItem() {
        ScaleDrawing sd = null;
        Object selectedObject = this.geometraTree.getSelectionObject();
        if (this.clickedDrawing != null && this.clickedDrawing instanceof ScaleDrawing) {
            sd = (ScaleDrawing)this.clickedDrawing;
        } else if (selectedObject != null) {
            if (selectedObject instanceof ScaleDrawing) {
                sd = (ScaleDrawing)selectedObject;
            } else if (selectedObject instanceof IcePDFPage) {
                IcePDFPage page = (IcePDFPage)selectedObject;
                sd = page.getScaleDrawing();
            } else {
                sd = null;
            }
        }
        if (sd != null) {
            ResourceBundle rBundle = ResourceBundle.getBundle("se/sjobeck/Geometra");
            if (!sd.getDescription().equals(rBundle.getString("DRAWING_SCALE"))) {
                GeometraCollection<BlueprintPage> sdColl = this.geoManager.getAllPages();
                new ExportScaleDialog(sd, sdColl);
            } else {
                Geometra.showErrorDialog(rBundle.getString("DIALOG_CALIBRATE_SCALE"));
            }
        }
    }

    protected void moveScaleDrawing() {
        Point2D point = GeometraPopupMenu.super.getPoint();
        this.geoManager.moveScaleDrawing(this.geoManager.componentToBlueprint(point));
        this.geoSubject.update((GeometraDrawing)null, (Object)this);
    }

    private void showTwoDimensions() {
        TreePath path;
        Object ob;
        GeometraProperties.setTwoDimensionsVisible(this.twoDimensionItem.isSelected());
        TreePath[] paths = this.geometraTree.getSelectedPaths();
        if (paths != null && paths.length > 1) {
            for (TreePath path2 : paths) {
                Object ob2 = path2.getLastPathComponent();
                if (!(ob2 instanceof GeometraDrawing)) continue;
                GeometraDrawing gd = (GeometraDrawing)ob2;
                gd.setTwoDimensionsVisible(this.twoDimensionItem.isSelected());
                this.geoSubject.update(gd, (Object)this);
            }
        } else if (paths != null && paths.length == 1 && (ob = (path = paths[0]).getLastPathComponent()) instanceof GeometraDrawing) {
            GeometraDrawing gd;
            gd.setTwoDimensionsVisible(!(gd = (GeometraDrawing)ob).isTwoDimensionsVisible());
            this.geoSubject.update(gd, (Object)this);
        }
    }

    public void renameDrawing(Object ob) {
        if (ob instanceof JTreePDFPane || ob instanceof ButtonPane) {
            this.renameDrawing();
        } else {
            System.err.println("NOT AUTHORIZED!" + ob.getClass().getName());
        }
    }

    public void showThreeDimensions(Object source) {
        if (source instanceof ButtonPane || source instanceof JTreePDFPane) {
            this.threeDimensionItem.setSelected(!this.threeDimensionItem.isSelected());
            this.showThreeDimensions();
        }
    }

    public void showTwoDimensions(Object source) {
        if (source instanceof ButtonPane || source instanceof JTreePDFPane) {
            this.twoDimensionItem.setSelected(!this.twoDimensionItem.isSelected());
            this.showTwoDimensions();
        }
    }

    private void showThreeDimensions() {
        TreePath path;
        Object ob;
        GeometraProperties.setThreeDimensionsVisible(this.threeDimensionItem.isSelected());
        TreePath[] paths = this.geometraTree.getSelectedPaths();
        if (paths != null && paths.length > 1) {
            for (TreePath path2 : paths) {
                Object ob2 = path2.getLastPathComponent();
                if (!(ob2 instanceof GeometraDrawing)) continue;
                GeometraDrawing gd = (GeometraDrawing)ob2;
                gd.setThreeDimensionsVisible(this.threeDimensionItem.isSelected());
                this.geoSubject.update(gd, (Object)this);
            }
        } else if (paths != null && paths.length == 1 && (ob = (path = paths[0]).getLastPathComponent()) instanceof GeometraDrawing) {
            GeometraDrawing gd;
            gd.setThreeDimensionsVisible(!(gd = (GeometraDrawing)ob).isThreeDimensionsVisible());
            this.geoSubject.update(gd, (Object)this);
        }
    }

    public void fillDrawings(Object source) {
        if (source instanceof ButtonPane || source instanceof JTreePDFPane) {
            this.fillItem.setSelected(!this.fillItem.isSelected());
            this.fillDrawings();
        }
    }

    private void fillDrawings() {
        TreePath path;
        Object ob;
        GeometraProperties.setFilled(this.fillItem.isSelected());
        TreePath[] paths = this.geometraTree.getSelectedPaths();
        if (paths != null && paths.length > 1) {
            for (TreePath path2 : paths) {
                Object ob2 = path2.getLastPathComponent();
                if (!(ob2 instanceof GeometraDrawing)) continue;
                GeometraDrawing gd = (GeometraDrawing)ob2;
                gd.setFilled(this.fillItem.isSelected());
                this.geoSubject.update(gd, (Object)this);
            }
        } else if (paths != null && paths.length == 1 && (ob = (path = paths[0]).getLastPathComponent()) instanceof GeometraDrawing) {
            GeometraDrawing gd;
            gd.setFilled(!(gd = (GeometraDrawing)ob).isFilled());
            this.geoSubject.update(gd, (Object)this);
        }
    }

    public void lockDrawing(Object source) {
        if (source instanceof ButtonPane || source instanceof JTreePDFPane) {
            this.lockDrawing();
        }
    }

    private void lockDrawing() {
        if (this.geometraTree.getSelectionObject() != null && this.geometraTree.getSelectionObject() instanceof GeometraDrawing) {
            GeometraDrawing gd;
            gd.setClosed(!(gd = (GeometraDrawing)this.geometraTree.getSelectionObject()).isClosed());
            if (gd instanceof ScaleDrawing && gd.isClosed()) {
                ScaleDrawing sd = (ScaleDrawing)gd;
                while (!this.isValidScaleDrawing(sd)) {
                    ResourceBundle rBundle = ResourceBundle.getBundle("se/sjobeck/Geometra");
                    Geometra.showErrorDialog(rBundle.getString("DIALOG_ILLEGAL_SCALEDRAWING_LENGTH"));
                }
                this.geoSubject.update(gd, (Object)(!gd.isClosed() ? 1 : 0));
            } else if (gd.isClosed()) {
                this.geoSubject.close(gd, gd.isClosed());
            }
        }
    }

    private void removeFromTotalMenu(TotalDrawing td) {
        for (int j = 0; j < this.totalDrawingMenu.getItemCount(); ++j) {
            TotalDrawingMenuItem item = (TotalDrawingMenuItem)this.totalDrawingMenu.getItem(j);
            if (!item.getTotalDrawing().equals(td)) continue;
            this.totalDrawingMenu.remove(j);
            break;
        }
    }

    private void removeFromSmartMenu(Blueprint bp) {
        for (int i = 0; i < this.smartDrawingMenu.getItemCount(); ++i) {
            SmartDrawingMenuItem item = (SmartDrawingMenuItem)this.smartDrawingMenu.getItem(i);
            if (!item.getSmartDrawing().getParent().getParent().equals(bp)) continue;
            this.smartDrawingMenu.remove(i);
            break;
        }
    }

    private void removeFromSmartMenu(SmartDrawing sd) {
        for (int i = 0; i < this.smartDrawingMenu.getItemCount(); ++i) {
            SmartDrawingMenuItem item = (SmartDrawingMenuItem)this.smartDrawingMenu.getItem(i);
            if (!item.getSmartDrawing().equals(sd)) continue;
            this.smartDrawingMenu.remove(i);
            break;
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.anpassat_till_andra_plattformar(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.anpassat_till_andra_plattformar(e);
        }
    }

    private void sourceJTree(MouseEvent e) {
        this.clickedSource = e.getSource();
        TreePath path = this.geometraTree.getPathForLocation(e.getX(), e.getY());
        if (!e.isControlDown() && !e.isShiftDown() && path != null) {
            Object ob = path.getLastPathComponent();
            if (ob instanceof DotDrawing || ob instanceof DotDrawingContainer) {
                this.showDotDrawingTreeMenu();
                this.clickedDrawing = (GeometraDrawing)path.getLastPathComponent();
                boolean isFilled = this.clickedDrawing.isFilled();
                boolean isTwoDimensionsVisible = this.clickedDrawing.isTwoDimensionsVisible();
                boolean isThreeDimensionsVisible = this.clickedDrawing.isThreeDimensionsVisible();
                this.descriptionItem.setText(this.clickedDrawing.getDescription());
                this.fillItem.setSelected(isFilled);
                this.twoDimensionItem.setSelected(isTwoDimensionsVisible);
                this.threeDimensionItem.setSelected(isThreeDimensionsVisible);
                ResourceBundle rBundle = ResourceBundle.getBundle("se/sjobeck/Geometra");
                this.removeItem.setText(rBundle.getString("STR_REMOVE") + " " + rBundle.getString("DRAWING_DEFAULT"));
                if (this.clickedDrawing.isClosed()) {
                    this.lockItem.setText(rBundle.getString("POPUP_UNLOCK_MEASURE"));
                } else {
                    this.lockItem.setText(rBundle.getString("POPUP_LOCK_MEASURE"));
                }
                this.updateSmartMenu(this.clickedDrawing.getParent());
                this.geoSubject.select(path, this);
                super.mousePressed(e);
            } else if (ob instanceof GeometraDrawing && !(ob instanceof ScaleDrawing) && !(ob instanceof HoleDrawing)) {
                this.showSingleTreeMenu();
                if (ob instanceof TotalDrawing) {
                    this.createSmartDrawingItem.setEnabled(false);
                    this.smartDrawingMenu.setEnabled(false);
                }
                this.clickedDrawing = (GeometraDrawing)path.getLastPathComponent();
                boolean isFilled = this.clickedDrawing.isFilled();
                boolean isTwoDimensionsVisible = this.clickedDrawing.isTwoDimensionsVisible();
                boolean isThreeDimensionsVisible = this.clickedDrawing.isThreeDimensionsVisible();
                this.descriptionItem.setText(this.clickedDrawing.getDescription());
                this.fillItem.setSelected(isFilled);
                this.twoDimensionItem.setSelected(isTwoDimensionsVisible);
                this.threeDimensionItem.setSelected(isThreeDimensionsVisible);
                ResourceBundle rBundle = ResourceBundle.getBundle("se/sjobeck/Geometra");
                this.removeItem.setText(rBundle.getString("STR_REMOVE") + " " + rBundle.getString("DRAWING_DEFAULT"));
                if (this.clickedDrawing.isClosed()) {
                    this.lockItem.setText(rBundle.getString("POPUP_UNLOCK_MEASURE"));
                } else {
                    this.lockItem.setText(rBundle.getString("POPUP_LOCK_MEASURE"));
                }
                if (this.clickedDrawing instanceof LineDrawing) {
                    this.thicknessItemMenu.setEnabled(true);
                }
                if (this.clickedDrawing instanceof TextDrawing) {
                    this.rotationMenu.setEnabled(true);
                    this.textSizeMenu.setEnabled(true);
                }
                this.updateSmartMenu(this.clickedDrawing.getParent());
                this.geoSubject.select(path, this);
                super.mousePressed(e);
            } else if (ob instanceof HoleDrawing) {
                this.showReductionMenu();
                this.clickedDrawing = (GeometraDrawing)path.getLastPathComponent();
                boolean isFilled = this.clickedDrawing.isFilled();
                this.descriptionItem.setText(this.clickedDrawing.getDescription());
                this.fillItem.setSelected(isFilled);
                ResourceBundle rBundle = ResourceBundle.getBundle("se/sjobeck/Geometra");
                this.removeItem.setText(rBundle.getString("STR_REMOVE") + " " + rBundle.getString("DRAWING_DEFAULT"));
                if (this.clickedDrawing.isClosed()) {
                    this.lockItem.setText(rBundle.getString("POPUP_UNLOCK_MEASURE"));
                } else {
                    this.lockItem.setText(rBundle.getString("POPUP_LOCK_MEASURE"));
                }
                this.updateSmartMenu(this.clickedDrawing.getParent());
                this.geoSubject.select(path, this);
                super.mousePressed(e);
            } else if (ob instanceof ScaleDrawing) {
                this.showScaleDrawingTreeMenu();
                this.clickedDrawing = (ScaleDrawing)ob;
                ResourceBundle rBundle = ResourceBundle.getBundle("se/sjobeck/Geometra");
                if (this.clickedDrawing.isClosed()) {
                    this.lockItem.setText(rBundle.getString("POPUP_UNLOCK_MEASURE"));
                } else {
                    this.lockItem.setText(rBundle.getString("POPUP_LOCK_MEASURE"));
                }
                this.geoSubject.select(this.clickedDrawing, this);
                super.mousePressed(e);
            } else if (ob instanceof Blueprint) {
                Blueprint bp = (Blueprint)ob;
                this.showBlueprintTreeMenu(bp.getDescription());
                this.geoSubject.select(bp, this);
                super.mousePressed(e);
            } else if (ob instanceof BlueprintPage) {
                BlueprintPage page = (BlueprintPage)ob;
                this.showBlueprintPageTreeMenu(page.getDescription());
                this.geoSubject.select(page, this);
                super.mousePressed(e);
            }
        } else if (e.isControlDown() || e.isShiftDown() && path != null) {
            TreePath[] paths = this.geometraTree.getSelectedPaths();
            BlueprintPage page = null;
            if (paths[0].getLastPathComponent() instanceof GeometraDrawing) {
                page = ((GeometraDrawing)paths[0].getLastPathComponent()).getParent();
            }
            for (TreePath selectionPath : paths) {
                Object ob = selectionPath.getLastPathComponent();
                if (ob instanceof TotalDrawing || ob instanceof GeometraDrawing && ((GeometraDrawing)ob).getParent().equals(page)) continue;
                this.updateSmartMenu(null);
                return;
            }
            this.updateSmartMenu(page);
            this.showMultiMenu();
            super.mousePressed(e);
        } else if (path == null) {
            this.geometraTree.clearSelection();
            this.showNullMenu();
            super.mousePressed(e);
        }
    }

    private void moveItem() {
        System.out.println("move it!");
        Point2D deltaMove = DialogCreator.showDeltaMoveDialog((JFrame)Geometra.GEOMETRA_FRAME);
        TreePath[] paths = this.geometraTree.getSelectedPaths();
        if (paths != null && paths.length > 0) {
            for (TreePath path : paths) {
                Object ob = path.getLastPathComponent();
                if (!(ob instanceof GeometraDrawing)) continue;
                GeometraDrawing gd = (GeometraDrawing)ob;
                gd.moveDrawing(deltaMove);
                this.geoSubject.update(gd, (Object)this);
            }
        }
    }

    private static enum ScaleDrawingOption {
        Skala,
        L\u00e4ngd;

    }
}

