/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.geometra.datastructures.blueprint.listeners;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import org.icepdf.ri.common.views.painting.core.Blueprint;
import org.icepdf.ri.common.views.painting.core.BlueprintPage;
import org.icepdf.ri.common.views.painting.core.GeometraCollection;
import org.icepdf.ri.common.views.painting.drawings.GeometraDrawing;
import se.sjobeck.geometra.datastructures.GeometraProperties;
import se.sjobeck.geometra.datastructures.blueprint.IcePDFBlueprint;
import se.sjobeck.geometra.datastructures.blueprint.IcePDFPage;
import se.sjobeck.geometra.datastructures.blueprint.listeners.GeometraMouseAdapter;
import se.sjobeck.geometra.datastructures.drawings.DotDrawing;
import se.sjobeck.geometra.datastructures.drawings.DotDrawingContainer;

public class DotDrawingListener
extends GeometraMouseAdapter {
    private final Blueprint blueprint;
    private GeometraDrawing currentDrawing;
    private DotDrawingContainer parent;

    public DotDrawingListener(Blueprint bp) {
        this.blueprint = bp;
    }

    private void closeCurrentDrawing(GeometraDrawing gd, boolean shouldClose) {
        if (gd instanceof DotDrawing) {
            DotDrawing dd = (DotDrawing)gd;
            DotDrawingContainer ddc = dd.getOwner();
            ddc.setClosed(shouldClose);
            this.geoSubject.close(ddc, shouldClose);
        } else {
            gd.setClosed(shouldClose);
            this.geoSubject.close(gd, shouldClose);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.geoManager.getUnlockedDrawings().size() != 0) {
            GeometraCollection<GeometraDrawing> unlocked = this.geoManager.getUnlockedDrawings();
            for (GeometraDrawing gd : unlocked) {
                if (!(gd instanceof DotDrawingContainer)) continue;
                this.currentDrawing = gd;
                this.parent = (DotDrawingContainer)this.currentDrawing;
                break;
            }
        }
        if (e.getButton() == 1) {
            if (e.getClickCount() >= 2) {
                this.closeCurrentDrawing(this.currentDrawing, true);
            } else {
                this.newDrawing(e.getPoint());
            }
        }
    }

    private void newDrawing(Point firstVertex) {
        this.geoManager.setDrawingState(this.blueprint, BlueprintPage.DrawingState.NORMAL);
        if (this.parent == null && this.currentDrawing != null && this.currentDrawing instanceof DotDrawingContainer) {
            DotDrawingContainer ddc = (DotDrawingContainer)this.currentDrawing;
            if (!ddc.isClosed()) {
                this.parent = ddc;
                this.currentDrawing = new DotDrawing(this.geoManager.getActivePage(), ddc);
                this.geoSubject.add(this.currentDrawing, this);
            }
        } else if (this.parent == null || this.parent.isClosed()) {
            this.parent = new DotDrawingContainer(this.geoManager.getActivePage());
            this.currentDrawing = new DotDrawing(this.geoManager.getActivePage(), this.parent);
            this.geoSubject.add(this.parent, this);
            this.geoSubject.add(this.currentDrawing, this);
        } else if (!this.parent.isClosed()) {
            IcePDFBlueprint pdf = (IcePDFBlueprint)this.blueprint;
            IcePDFPage page = (IcePDFPage)pdf.getActivePage();
            int index = page.indexOf(this.parent);
            if (index < 0) {
                this.parent = new DotDrawingContainer(this.geoManager.getActivePage());
                this.geoSubject.add(this.parent, this);
            }
            this.currentDrawing = new DotDrawing(this.geoManager.getActivePage(), this.parent);
            this.geoSubject.add(this.currentDrawing, this);
        }
        this.currentDrawing.setHeight(GeometraProperties.getDrawingHeight());
        this.currentDrawing.setColor(GeometraProperties.getColor());
        this.currentDrawing.addPoint((Point2D)firstVertex);
    }
}

