/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.geometra.datastructures.blueprint;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.icepdf.core.exceptions.PDFException;
import org.icepdf.core.exceptions.PDFSecurityException;
import org.icepdf.ri.common.views.painting.core.Blueprint;
import org.icepdf.ri.common.views.painting.core.GeometraCollection;
import org.icepdf.ri.common.views.painting.drawings.GeometraDrawing;
import org.icepdf.ri.common.views.painting.drawings.ScaleDrawing;
import se.sjobeck.GeometraConfiguration;
import se.sjobeck.geometra.datastructures.blueprint.BlueprintList;
import se.sjobeck.geometra.datastructures.blueprint.GeometraManager;
import se.sjobeck.geometra.datastructures.blueprint.IcePDFBlueprint;
import se.sjobeck.geometra.datastructures.blueprint.IcePDFPage;
import se.sjobeck.geometra.datastructures.blueprint.PDFController;
import se.sjobeck.geometra.datastructures.blueprint.PDFLoader;
import se.sjobeck.geometra.datastructures.blueprint.ProjectWorker;
import se.sjobeck.geometra.datastructures.blueprint.TabManager;
import se.sjobeck.geometra.datastructures.blueprint.XStreamManager;
import se.sjobeck.geometra.datastructures.blueprint.observer.GeometraSubject;
import se.sjobeck.geometra.datastructures.drawings.TotalDrawing;
import se.sjobeck.geometra.gui.main.Geometra;
import se.sjobeck.geometra.gui.panels.ButtonPane;
import se.sjobeck.geometra.gui.panels.InfoPanel;
import se.sjobeck.gui.DialogCreator;
import se.sjobeck.versiontracker.NeedToBeReloadedException;
import se.sjobeck.versiontracker.VersionTracker;
import se.sjobeck.versiontracker.VersionTrackerFactory;

public class ProjectFile {
    public static int counter = 0;
    private static final Logger projectLogger = Logger.getLogger(ProjectFile.class.getName());
    private ButtonPane buttonPane;
    private String currentFilename;
    private File currentProjectFile;
    private final TabManager tabManager = TabManager.getInstance();
    private final GeometraManager geoManager = GeometraManager.getInstance();
    private InfoPanel infoPane;
    private int currentSave;
    private final XStreamManager xstreamManager = new XStreamManager();
    private static final Object only_one_thread_allowed_to_save_at_one_time = new Object();

    protected ProjectFile() {
    }

    private Blueprint loadPDF(File currentPDFFile) {
        IcePDFBlueprint pdf = PDFLoader.loadPDF(currentPDFFile);
        PDFController controller = pdf.getPDFController();
        String desc = controller.getDocumentDescription();
        if (desc.length() > 30) {
            desc = currentPDFFile.getName();
        }
        pdf.setDescription(desc);
        this.tabManager.addController(controller);
        this.tabManager.addToTab(controller);
        if (BlueprintList.getInstance().size() == 0) {
            this.buttonPane.activateButtons();
        }
        GeometraSubject.getInstance().add(pdf, this);
        return pdf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fixaBakKopia(String finalPath) {
        String bakFileName = finalPath + ".bak";
        File bakFile = new File(bakFileName);
        bakFile.delete();
        File orig = new File(finalPath);
        if (orig.exists()) {
            FileInputStream in = null;
            OutputStream out = null;
            try {
                int len;
                in = new FileInputStream(orig);
                out = new FileOutputStream(new File(bakFileName));
                byte[] buf = new byte[1024];
                while ((len = ((InputStream)in).read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
            }
            catch (IOException ex) {
                Logger.getLogger(ProjectFile.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException ex) {
                    Logger.getLogger(ProjectFile.class.getName()).log(Level.SEVERE, null, ex);
                }
                try {
                    out.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(ProjectFile.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public void addButtonPane(ButtonPane buttons) {
        this.buttonPane = buttons;
    }

    public void addInfoPane(InfoPanel infoPane) {
        this.infoPane = infoPane;
    }

    private void rebuildProject(BlueprintList list) {
        int totalDrawingSize = list.totalDrawingSize();
        for (int i = 0; i < totalDrawingSize; ++i) {
            TotalDrawing td = list.getTotalDrawing(i);
            this.geoManager.addTotalDrawing(td);
        }
        for (Blueprint bp : list) {
            this.geoManager.addBlueprint(bp);
            for (int i = 0; i < bp.getNumberOfPages(); ++i) {
                GeometraCollection drawings = bp.getPage(i).getDrawings();
                for (GeometraDrawing gd : drawings) {
                    gd.buildPath();
                }
                ScaleDrawing scaleDrawing = bp.getPage(i).getScaleDrawing();
                if (scaleDrawing == null) continue;
                scaleDrawing.buildPath();
            }
        }
    }

    public boolean startLoadingPDFFile(File currentPDFFile) {
        if (currentPDFFile != null && currentPDFFile.getName().toLowerCase().endsWith("pdf")) {
            this.loadPDF(currentPDFFile);
            return true;
        }
        Geometra.createInfoDialog(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DIALOG_HAVE_TO_BE_PDF"));
        return false;
    }

    public boolean startLoadingPDFFiles(File[] currentPDFFiles) {
        for (File file : currentPDFFiles) {
            if (file != null && file.getName().toLowerCase().endsWith("pdf")) continue;
            Geometra.createInfoDialog(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DIALOG_HAVE_TO_BE_PDF"));
            return false;
        }
        Blueprint start = null;
        for (int i = 0; i < currentPDFFiles.length; ++i) {
            if (i == 0) {
                start = this.loadPDF(currentPDFFiles[0]);
                continue;
            }
            this.loadPDF(currentPDFFiles[i]);
        }
        GeometraSubject.getInstance().pageSwitch(start, this);
        return true;
    }

    public void startLoadingProjectFile(File file, ProjectWorker pw) {
        this.currentProjectFile = file;
        if (this.currentProjectFile != null && this.currentProjectFile.getName().toLowerCase().endsWith(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("GEOMETRA_EXTENSION"))) {
            this.infoPane.showInfo(this.currentProjectFile, InfoPanel.Info.LOAD);
            this.currentFilename = this.currentProjectFile.getName();
            LoadProjectWorker loadProjectWorker = new LoadProjectWorker(pw);
            loadProjectWorker.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void startSaving(String str, ButtonPane buttonPane, InfoPanel infoPane, int save) throws IOException {
        Object object = only_one_thread_allowed_to_save_at_one_time;
        synchronized (object) {
            this.buttonPane = buttonPane;
            this.infoPane = infoPane;
            this.currentSave = save;
            this.currentFilename = str;
            if (this.currentFilename != null) {
                this.writeToFile(this.currentFilename);
                infoPane.showInfo(GeometraConfiguration.getSavePath() + File.separator + this.currentFilename, InfoPanel.Info.SAVE);
            }
        }
    }

    public void startSaving(String str, int save) throws IOException {
        this.startSaving(str, this.buttonPane, this.infoPane, save);
    }

    public void startSaving() throws IOException {
        this.startSaving(this.currentFilename, this.buttonPane, this.infoPane, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void writeToFile(String filename) throws IOException {
        String directoryName;
        System.out.println("f\u00f6rs\u00f6ker spara : " + filename);
        String tempPath = GeometraConfiguration.getSavePath() + File.separator + filename;
        if (!tempPath.toLowerCase().endsWith(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("GEOMETRA_EXTENSION"))) {
            directoryName = filename;
            tempPath = tempPath.concat(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("GEOMETRA_EXTENSION"));
            filename = filename + ResourceBundle.getBundle("se/sjobeck/Geometra").getString("GEOMETRA_EXTENSION");
        } else {
            directoryName = filename.replace(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("GEOMETRA_EXTENSION"), "");
        }
        File directory = new File(GeometraConfiguration.getSavePath() + File.separator + directoryName);
        if (directory.exists() && this.currentSave == 2) {
            int result = Geometra.createQuery(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DIALOG_FILE_ALREADY_EXIST"));
            switch (result) {
                case 0: {
                    break;
                }
                case 1: {
                    String newName = Geometra.showProjectDialog(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DIALOG_NAME_PROJECT"), ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DIALOG_TITLE_NAME_PROJECT"));
                    this.writeToFile(newName);
                    return;
                }
                case 2: {
                    return;
                }
            }
        }
        directory.mkdir();
        String finalPath = directory.getAbsolutePath() + File.separator + filename;
        for (Blueprint bp : BlueprintList.getInstance()) {
            if (!(bp instanceof IcePDFBlueprint)) continue;
            IcePDFBlueprint pdf = (IcePDFBlueprint)bp;
            String copyFrom = pdf.getPDFFilepath();
            File f = new File(copyFrom);
            String fileName = f.getName();
            String copyTo = directory.getAbsolutePath() + File.separator + fileName;
            this.copyFile(copyFrom, copyTo);
            pdf.setPDFFilePath(copyTo);
        }
        this.fixaBakKopia(finalPath);
        String xml = this.xstreamManager.getString();
        System.out.println(finalPath);
        FileWriter writer = null;
        try {
            writer = new FileWriter(finalPath);
            writer.write(xml);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        this.infoPane.hideInfo();
        this.currentFilename = filename;
        ProjectFile projectFile = this;
        synchronized (projectFile) {
            boolean reload = true;
            while (reload) {
                reload = false;
                VersionTracker vt = VersionTrackerFactory.loadVersionTracker((String)directory.getPath());
                vt.getLock();
                try {
                    int version = vt.getVersion() + 1;
                    vt.setVersion(version);
                    VersionTrackerFactory.saveVersionTracker((String)directory.getPath(), (VersionTracker)vt);
                }
                catch (NeedToBeReloadedException ntbre) {
                    reload = true;
                }
                finally {
                    vt.relaseLock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void copyFile(String src, String dest) throws IOException {
        File source = new File(src);
        File destination = new File(dest);
        if (!source.exists()) {
            String message = "<html>" + ResourceBundle.getBundle("se/sjobeck/Geometra").getString("ERROR_COPY_SOURCE_DOES_NOT_EXIST") + "<br><br>" + src + "<br></html>";
            String title = "Source file unavailable";
            DialogCreator.showInformation((Object)message, (String)title);
            File errormsg = new File(destination.getParent() + File.separator + "Error_missing_files.txt");
            errormsg.createNewFile();
            RandomAccessFile raf = null;
            try {
                raf = new RandomAccessFile(errormsg, "rw");
                raf.skipBytes((int)raf.length());
                String fudo = src + "\n";
                raf.writeUTF(fudo);
            }
            catch (IOException ioe) {
                throw ioe;
            }
            finally {
                if (raf != null) {
                    try {
                        raf.close();
                    }
                    catch (IOException ex) {
                        Logger.getLogger(ProjectFile.class.getName()).log(Level.SEVERE, null, ex);
                        DialogCreator.showError((Object)ex.toString(), (String)"Call support");
                    }
                }
            }
        }
        if (!destination.exists()) {
            FileInputStream in = null;
            FileOutputStream out = null;
            try {
                int len;
                in = new FileInputStream(source);
                out = new FileOutputStream(destination);
                byte[] buffer = new byte[1024];
                while ((len = ((InputStream)in).read(buffer)) > 0) {
                    ((OutputStream)out).write(buffer, 0, len);
                }
            }
            finally {
                try {
                    if (in != null) {
                        ((InputStream)in).close();
                    }
                }
                catch (Exception e) {
                    DialogCreator.showError((Object)e.toString(), (String)"Call support");
                }
                try {
                    if (out != null) {
                        ((OutputStream)out).close();
                    }
                }
                catch (Exception e) {
                    DialogCreator.showError((Object)e.toString(), (String)"Call support");
                }
            }
        }
    }

    public String getLastSaveName() {
        return this.currentFilename;
    }

    public void closeProject() {
        this.buttonPane.disableButtons();
    }

    private class LoadProjectWorker
    extends SwingWorker<BlueprintList, Void> {
        final ProjectWorker pWorker;

        LoadProjectWorker(ProjectWorker pw) {
            this.pWorker = pw;
        }

        @Override
        public BlueprintList doInBackground() throws Exception {
            try {
                FileReader reader = new FileReader(ProjectFile.this.currentProjectFile);
                ProjectFile.this.rebuildProject(ProjectFile.this.xstreamManager.getList(reader));
            }
            catch (Exception e) {
                e.printStackTrace();
                String title = ResourceBundle.getBundle("se/sjobeck/Geometra").getString("TITLE_LOADING_ERROR");
                String message = ResourceBundle.getBundle("se/sjobeck/Geometra").getString("MESSAGE_LOADING_ERROR");
                DialogCreator.showError((Object)message, (String)title);
                System.exit(1);
                throw e;
            }
            return BlueprintList.getInstance();
        }

        @Override
        public void done() {
            boolean startaAutosave = true;
            try {
                boolean soundStatus = GeometraConfiguration.isSoundEnabled();
                GeometraConfiguration.putSoundOff();
                BlueprintList doneList = null;
                try {
                    doneList = (BlueprintList)this.get();
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
                catch (ExecutionException ex) {
                    ex.printStackTrace();
                }
                GeometraSubject geoSubject = GeometraSubject.getInstance();
                for (Blueprint bp : doneList) {
                    if (!(bp instanceof IcePDFBlueprint)) continue;
                    IcePDFBlueprint pdf = (IcePDFBlueprint)bp;
                    PDFController controller = new PDFController(pdf);
                    ProjectFile.this.tabManager.addController(controller);
                    File pdfFile = new File(pdf.getPDFFilepath());
                    if (!pdfFile.exists()) {
                        System.out.println(ProjectFile.this.currentProjectFile.getParent());
                        System.out.println("current project file: " + ProjectFile.this.currentProjectFile);
                        File parentFile = new File(ProjectFile.this.currentProjectFile.getParent() + File.separator + pdfFile.getName());
                        if (!parentFile.exists()) {
                            String in = "<html>" + ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DIALOG_PDF_NOT_FOUND") + "<br><br>";
                            in = in + ProjectFile.this.currentProjectFile.getParent() + "<br><br>" + pdfFile.getName();
                            Geometra.createInfoDialog(in, "File Not Found");
                            pdfFile = Geometra.createSingleLoadDialog();
                        } else {
                            pdfFile = parentFile;
                        }
                        pdf.setPDFFilePath(pdfFile.getAbsolutePath());
                    }
                    try {
                        controller.openDocument(pdfFile);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    catch (PDFException e) {
                        e.printStackTrace();
                    }
                    catch (PDFSecurityException e) {
                        e.printStackTrace();
                    }
                    ProjectFile.this.tabManager.addToTab(controller);
                    geoSubject.add(pdf, ProjectFile.this);
                    for (int i = 0; i < pdf.getNumberOfPages(); ++i) {
                        IcePDFPage page = pdf.getPage(i);
                        page.setParent(pdf);
                        geoSubject.add(page, ProjectFile.this);
                        geoSubject.pageSwitch(page, this);
                        ScaleDrawing sd = page.getScaleDrawing();
                        sd.init();
                        geoSubject.add(sd, ProjectFile.this);
                        page.init();
                        ArrayList<GeometraDrawing> drawings = new ArrayList<GeometraDrawing>();
                        for (GeometraDrawing gd : page.getDrawings()) {
                            if (gd instanceof ScaleDrawing) continue;
                            drawings.add(gd);
                        }
                        for (GeometraDrawing gd : drawings) {
                            geoSubject.add(gd, ProjectFile.this);
                        }
                    }
                }
                for (int index = 0; index < doneList.totalDrawingSize(); ++index) {
                    TotalDrawing td = doneList.getTotalDrawing(index);
                    geoSubject.add(td, ProjectFile.this);
                }
                ProjectFile.this.buttonPane.activateButtons();
                IcePDFPage page = ((IcePDFBlueprint)doneList.getBlueprint(0)).getPage(0);
                geoSubject.pageSwitch(page, this);
                ProjectFile.this.infoPane.hideInfo();
                final int rotation = page.getRotation();
                final PDFController controller = ProjectFile.this.tabManager.getActiveController();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        controller.setRotation(rotation);
                    }
                });
                geoSubject.update((GeometraDrawing)null, (Object)ProjectFile.this);
                if (soundStatus) {
                    GeometraConfiguration.putSoundOn();
                } else {
                    GeometraConfiguration.putSoundOff();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                String title = ResourceBundle.getBundle("se/sjobeck/Geometra").getString("TITLE_LOADING_ERROR");
                String message = ResourceBundle.getBundle("se/sjobeck/Geometra").getString("MESSAGE_LOADING_ERROR");
                DialogCreator.showError((Object)message, (String)title);
                System.exit(1);
                startaAutosave = false;
            }
            if (startaAutosave) {
                this.pWorker.startAutosaveProcess();
            }
        }
    }
}

