/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.geometra.datastructures.blueprint;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import org.icepdf.core.exceptions.PDFException;
import org.icepdf.core.exceptions.PDFSecurityException;
import org.icepdf.core.pobjects.Document;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.pobjects.PageTree;
import org.icepdf.core.search.DocumentSearchController;
import org.icepdf.ri.common.SwingController;
import org.icepdf.ri.common.search.DocumentSearchControllerImpl;
import org.icepdf.ri.common.views.Controller;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.PageViewComponent;
import org.icepdf.ri.common.views.painting.core.Blueprint;
import org.icepdf.ri.common.views.painting.drawings.GeometraDrawing;
import se.sjobeck.geometra.datastructures.FileDescription;
import se.sjobeck.geometra.datastructures.blueprint.GeometraManager;
import se.sjobeck.geometra.datastructures.blueprint.IcePDFBlueprint;
import se.sjobeck.geometra.datastructures.blueprint.PDFViewController;
import se.sjobeck.geometra.datastructures.blueprint.listeners.GeometraMouseAdapter;
import se.sjobeck.geometra.datastructures.blueprint.listeners.MiddleButtonListener;
import se.sjobeck.geometra.datastructures.blueprint.listeners.MouseScrollListener;
import se.sjobeck.geometra.gui.main.Geometra;

public class PDFController
implements Controller {
    private File pdfFile;
    private final Blueprint blueprint;
    private boolean isInitialized = false;
    private final MouseScrollListener scrollListener = new MouseScrollListener();
    private final MiddleButtonListener middleButtonListener = new MiddleButtonListener();
    private Document pdfDocument;
    private String fileName = "";
    private DocumentViewController pdfViewController;
    private PageTree pageTree;
    private final float MAX_ZOOM = 64.0f;
    private final float MIN_ZOOM = 0.25f;
    private final float ZOOM_IN = 1.25f;
    private final float ZOOM_OUT = 0.8f;
    private static int count = 0;
    private final GeometraManager geometraManager = GeometraManager.getInstance();
    DocumentSearchController dsc = new DocumentSearchControllerImpl(new SwingController());

    public PDFController(Blueprint pdf) {
        this.blueprint = pdf;
    }

    public String toString() {
        return "controller for " + count + " " + this.blueprint;
    }

    public void dispose() {
        this.pdfViewController.closeDocument();
        PageViewComponent view = ((PDFViewController)this.pdfViewController).getComp();
        JComponent jView = (JComponent)view;
        jView.getMouseListeners();
    }

    public void setFitMode(int view) {
        this.pdfViewController.setFitMode(view);
    }

    public void setPageNumber(int pageIndex) {
        this.pdfViewController.setCurrentPageIndex(pageIndex);
        this.addMenuListener();
        this.addMiddleButtonListener();
    }

    public void removeAllListeners() {
        MouseListener[] mListeners;
        MouseMotionListener[] mmListeners;
        MouseWheelListener[] mouseWheelListeners;
        PageViewComponent view = ((PDFViewController)this.pdfViewController).getComp();
        JComponent jView = (JComponent)view;
        for (MouseWheelListener ml : mouseWheelListeners = jView.getMouseWheelListeners()) {
            jView.removeMouseWheelListener(ml);
        }
        for (MouseMotionListener ml : mmListeners = jView.getMouseMotionListeners()) {
            jView.removeMouseMotionListener(ml);
        }
        for (MouseListener ml : mListeners = jView.getMouseListeners()) {
            jView.removeMouseListener(ml);
        }
    }

    private void addScrollButtonListener() {
        MouseWheelListener[] mmListeners;
        PageViewComponent view = ((PDFViewController)this.pdfViewController).getComp();
        JComponent jView = (JComponent)view;
        for (MouseWheelListener ml : mmListeners = jView.getMouseWheelListeners()) {
            if (!ml.equals(this.scrollListener)) continue;
            jView.removeMouseWheelListener(ml);
        }
        this.pdfViewController.getViewContainer().addMouseWheelListener(this.scrollListener);
    }

    private void addMiddleButtonListener() {
        MouseListener[] mListeners;
        MouseMotionListener[] mmListeners;
        PageViewComponent view = ((PDFViewController)this.pdfViewController).getComp();
        JComponent jView = (JComponent)view;
        for (MouseMotionListener ml : mmListeners = jView.getMouseMotionListeners()) {
            if (ml.equals(this.middleButtonListener)) break;
        }
        for (MouseListener ml : mListeners = jView.getMouseListeners()) {
            if (!ml.equals(this.middleButtonListener)) continue;
            return;
        }
        jView.addMouseMotionListener(this.middleButtonListener);
        jView.addMouseListener(this.middleButtonListener);
    }

    public void disableMenu() {
        PageViewComponent view = ((PDFViewController)this.pdfViewController).getComp();
        JComponent jView = (JComponent)view;
        jView.removeMouseListener(Geometra.GEOMETRA_POPUP_MENU);
    }

    public void enableMenu() {
        this.addMenuListener();
    }

    private void addMenuListener() {
        MouseListener[] mListeners;
        PageViewComponent view = ((PDFViewController)this.pdfViewController).getComp();
        JComponent jView = (JComponent)view;
        for (MouseListener ml : mListeners = jView.getMouseListeners()) {
            if (!ml.equals(Geometra.GEOMETRA_POPUP_MENU)) continue;
            return;
        }
        jView.addMouseListener(Geometra.GEOMETRA_POPUP_MENU);
    }

    public boolean addPaintingListener(MouseListener ml, MouseMotionListener mml) {
        if (this.isInitialized) {
            PageViewComponent view = ((PDFViewController)this.pdfViewController).getComp();
            if (ml != null) {
                ((JComponent)view).addMouseListener(ml);
            }
            if (mml != null) {
                ((JComponent)view).addMouseMotionListener(mml);
            }
            return true;
        }
        return false;
    }

    public void centerViewport(GeometraDrawing gd) {
        Point centerPoint = gd.getCenterPoint();
        JScrollPane scroll = (JScrollPane)this.pdfViewController.getViewContainer();
        Point2D point2d = this.geometraManager.blueprintToComponent(gd.getParent(), centerPoint);
        Point2D.Double viewPoint = new Point2D.Double(point2d.getX(), point2d.getY());
        JViewport viewport = scroll.getViewport();
        Dimension d = scroll.getSize();
        double newX = ((Point2D)viewPoint).getX() - d.getWidth() / 2.0;
        double newY = ((Point2D)viewPoint).getY() - d.getHeight() / 2.0;
        double changePosX = newX < 0.0 ? 0.0 : newX;
        double changePosY = newY < 0.0 ? 0.0 : newY;
        Point newCenter = new Point((int)changePosX, (int)changePosY);
        viewport.setViewPosition(newCenter);
        viewport.revalidate();
    }

    public Blueprint getBlueprint() {
        return this.blueprint;
    }

    public Dimension getDimension() {
        float zoom = this.pdfViewController.getZoom();
        return this.pdfDocument.getPageDimension(this.pdfViewController.getCurrentPageIndex(), this.getUserRotation(), zoom).toDimension();
    }

    public Document getDocument() {
        return this.pdfDocument;
    }

    public String getDocumentDescription() {
        return this.fileName;
    }

    public String getDescription() {
        return this.blueprint.getDescription();
    }

    public float getUserRotation() {
        return this.pdfViewController.getRotation();
    }

    public float getUserZoom() {
        return this.pdfViewController.getZoom();
    }

    public Container getViewContainer() {
        return this.pdfViewController.getViewContainer();
    }

    public PageTree getPageTree() {
        return this.pageTree;
    }

    public void openDocument(File pdfFile) throws IOException, PDFException, PDFSecurityException {
        this.pdfFile = pdfFile;
        this.pdfDocument = new Document();
        this.pdfDocument.setFile(pdfFile.getAbsolutePath());
        this.fileName = pdfFile.getName();
        this.pdfViewController = new PDFViewController(this);
        this.pdfViewController.setDocument(this.pdfDocument);
        this.pdfViewController.requestViewFocusInWindow();
        this.isInitialized = true;
        this.addMenuListener();
        this.addScrollButtonListener();
        this.addMiddleButtonListener();
    }

    public void removePaintingListeners() {
        MouseMotionListener[] mmls;
        MouseListener[] mls;
        PageViewComponent view = ((PDFViewController)this.pdfViewController).getComp();
        JComponent listenerlessComponent = (JComponent)view;
        for (MouseListener ml : mls = listenerlessComponent.getMouseListeners()) {
            if (ml.equals(Geometra.GEOMETRA_POPUP_MENU) || ml.equals(this.middleButtonListener) || !(ml instanceof GeometraMouseAdapter)) continue;
            listenerlessComponent.removeMouseListener(ml);
        }
        for (MouseMotionListener mml : mmls = listenerlessComponent.getMouseMotionListeners()) {
            if (mml.equals(Geometra.GEOMETRA_POPUP_MENU) || mml.equals(this.middleButtonListener) || mml.equals(this.scrollListener) || !(mml instanceof GeometraMouseAdapter)) continue;
            listenerlessComponent.removeMouseMotionListener(mml);
        }
    }

    public void setRotateLeft() {
        if (this.pdfViewController != null) {
            this.pdfViewController.setRotateRight();
        }
    }

    public void setRotateRight() {
        if (this.pdfViewController != null) {
            this.pdfViewController.setRotateLeft();
        }
    }

    public void setRotation(float rotation) {
        this.pdfViewController.setRotation(rotation);
    }

    public void setViewCursor(int type) {
        this.pdfViewController.setViewCursor(type);
    }

    public void setViewPosition(Point p) {
        JScrollPane cont = (JScrollPane)this.getViewContainer();
        JViewport view = cont.getViewport();
        view.setViewPosition(p);
    }

    public void setZoom(float zoom, Point centerPoint, boolean b) {
        if (this.pdfViewController != null) {
            Point2D tempPoint = ((IcePDFBlueprint)this.blueprint).getActivePage().blueprintToComponent((Point2D)centerPoint);
            Point scaledPoint = new Point((int)tempPoint.getX(), (int)tempPoint.getY());
            float userZoom = this.getRealZoom(zoom);
            ((PDFViewController)this.pdfViewController).setZoom(userZoom, scaledPoint, b);
            this.geometraManager.setBlueprintScale(this.blueprint, this.pdfViewController.getZoom());
        }
    }

    private float getRealZoom(float zoom) {
        float tempZoom = zoom;
        if (tempZoom > 64.0f) {
            tempZoom = 64.0f;
        } else if (tempZoom < 0.25f) {
            tempZoom = 0.25f;
        }
        return tempZoom;
    }

    public void setZoom(float zoom) {
        if (this.pdfViewController != null) {
            float userZoom = this.getRealZoom(zoom);
            this.pdfViewController.setZoom(userZoom);
            this.geometraManager.setBlueprintScale(this.blueprint, this.pdfViewController.getZoom());
        }
    }

    public void setZoomIn() {
        if (this.pdfViewController != null) {
            if (this.getRealZoom(this.pdfViewController.getZoom() * 1.25f) < 64.0f) {
                this.pdfViewController.setZoomIn();
                this.geometraManager.setBlueprintScale(this.blueprint, this.pdfViewController.getZoom());
            } else {
                this.setZoom(64.0f);
            }
        }
    }

    public void setZoomOut() {
        if (this.pdfViewController != null) {
            if (this.getRealZoom(this.pdfViewController.getZoom() * 0.8f) > 0.25f) {
                this.pdfViewController.setZoomOut();
                this.geometraManager.setBlueprintScale(this.blueprint, this.pdfViewController.getZoom());
            } else {
                this.setZoom(0.25f);
            }
        }
    }

    public FileDescription getFileDescription() {
        FileDescription desc = new FileDescription(this.pdfFile.getName(), this.pdfFile.getAbsolutePath());
        return desc;
    }

    public boolean isFirstPageInit() {
        Page p;
        return this.pageTree != null && (p = this.pageTree.getPage(0)).isInitiated();
    }

    public int getCurrentPageNumber() {
        return this.pdfViewController.getCurrentPageIndex();
    }

    public DocumentViewController getDocumentViewController() {
        return this.pdfViewController;
    }

    public DocumentSearchController getDocumentSearchController() {
        return this.dsc;
    }

    public void setDocumentToolMode(int arg0) {
    }

    public ResourceBundle getMessageBundle() {
        System.out.println(" bundle returned");
        return ResourceBundle.getBundle("se/sjobeck/Geometra");
    }
}

