/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.geometra.datastructures.blueprint;

import java.awt.geom.Point2D;
import java.util.ResourceBundle;
import org.icepdf.core.pobjects.Document;
import org.icepdf.ri.common.views.painting.core.BlueprintPage;
import org.icepdf.ri.common.views.painting.core.GeometraCollection;
import org.icepdf.ri.common.views.painting.drawings.GeometraDrawing;
import se.sjobeck.geometra.datastructures.blueprint.IcePDFPage;
import se.sjobeck.geometra.datastructures.blueprint.PDFController;
import se.sjobeck.geometra.datastructures.core.BlueprintImpl;
import se.sjobeck.geometra.datastructures.drawings.TotalDrawing;

public class IcePDFBlueprint
extends BlueprintImpl {
    private transient PDFController pdfController;

    public void setDocument(Document pdf) {
        this.initDoc(pdf);
        this.filePath = pdf.getDocumentLocation();
    }

    @Override
    public BlueprintPage getActivePage() {
        if (super.getActivePage() == null) {
            return this.getPage(0);
        }
        return super.getActivePage();
    }

    @Override
    public IcePDFPage getPage(int index) {
        return (IcePDFPage)super.getPage(index);
    }

    public String toString() {
        return this.getDescription();
    }

    protected void replace(String from, String to) {
        IcePDFPage page = (IcePDFPage)this.getActivePage();
        GeometraCollection<GeometraDrawing> col = page.getDrawings();
        boolean fromFound = false;
        int fromIndex = 0;
        boolean toFound = false;
        int toIndex = 0;
        for (int i = 0; i < col.size(); ++i) {
            if (((GeometraDrawing)col.get(i)).getDescription().equals(from)) {
                fromFound = true;
                fromIndex = i;
            }
            if (!((GeometraDrawing)col.get(i)).getDescription().equals(to)) continue;
            toFound = true;
            toIndex = i;
        }
        if (toFound && fromFound) {
            GeometraDrawing original = page.getDrawing(toIndex);
            GeometraDrawing toBeRemoved = page.getDrawing(fromIndex);
            if (!original.getParent().equals(toBeRemoved.getParent())) {
                return;
            }
            page.removeDrawingTemporary(toBeRemoved);
            page.add(toIndex, toBeRemoved);
        }
    }

    public void setActiveDrawing(Object ob) {
        IcePDFPage page = (IcePDFPage)this.getActivePage();
        if (ob instanceof GeometraDrawing) {
            GeometraDrawing gd = (GeometraDrawing)ob;
            if (gd.getParent().equals(page)) {
                page.setActiveDrawing(ob);
            }
        } else if (ob instanceof GeometraCollection) {
            GeometraCollection col = (GeometraCollection)ob;
            GeometraCollection cols = new GeometraCollection();
            for (GeometraDrawing gd : col) {
                if (gd == null || gd instanceof TotalDrawing || !gd.getParent().equals(page)) continue;
                cols.add((Object)gd);
            }
            if (cols.size() > 0) {
                page.setActiveDrawing(cols);
            }
        } else if (ob == null) {
            page.setActiveDrawing(null);
        }
    }

    @Override
    public int getNumberOfPages() {
        return super.getNumberOfPages();
    }

    public void initDoc(Document pdfDoc) {
        int numPages = pdfDoc.getNumberOfPages();
        this.pages = new GeometraCollection(numPages);
        for (int i = 1; i <= numPages; ++i) {
            IcePDFPage bpPage = new IcePDFPage(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("STR_PAGE") + i);
            pdfDoc.getPageDimension(i - 1, 0.0f);
            bpPage.setPageDimension(pdfDoc.getPageDimension(i - 1, 0.0f));
            bpPage.setParent(this);
            this.pages.add((Object)bpPage);
        }
        if (numPages > 0) {
            this.setPage((BlueprintPage)this.pages.get(0));
        }
    }

    @Override
    protected void setPage(BlueprintPage page) {
        super.setPage(page);
    }

    @Override
    protected void addDrawing(Object ob) {
        GeometraDrawing gd;
        if (ob instanceof GeometraDrawing && (gd = (GeometraDrawing)ob).getParent() == null) {
            gd.setParent(this.getActivePage());
        }
        super.addDrawing(ob);
    }

    public String getPDFFilepath() {
        return this.filePath;
    }

    public void setPDFFilePath(String str) {
        this.filePath = str;
    }

    @Override
    protected void setViewingState(BlueprintPage.ViewingState state) {
        super.setViewingState(state);
    }

    @Override
    protected GeometraCollection<GeometraDrawing> getAllDrawings() {
        return super.getAllDrawings();
    }

    @Override
    protected void setBlueprintScale(double scale) {
        if (super.getActivePage() != null) {
            super.setBlueprintScale(scale);
        }
    }

    @Override
    protected GeometraDrawing getDrawing(Point2D point) {
        return super.getDrawing(point);
    }

    @Override
    protected GeometraCollection<GeometraDrawing> getActiveDrawings() {
        return super.getActiveDrawings();
    }

    @Override
    protected GeometraCollection<GeometraDrawing> getUnlockedDrawings() {
        return super.getUnlockedDrawings();
    }

    @Override
    protected void setDrawingState(BlueprintPage.DrawingState state) {
        super.setDrawingState(state);
    }

    @Override
    protected void moveScaleDrawing(Point2D point) {
        super.moveScaleDrawing(point);
    }

    @Override
    protected void setDescription(String description) {
        super.setDescription(description);
    }

    protected void rotateRight() {
        IcePDFPage page = (IcePDFPage)this.getActivePage();
        page.setRightRotation();
    }

    protected void rotateLeft() {
        IcePDFPage page = (IcePDFPage)this.getActivePage();
        page.setLeftRotation();
    }

    public void setPDFController(PDFController controller) {
        this.pdfController = controller;
    }

    public PDFController getPDFController() {
        return this.pdfController;
    }
}

