/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.geometra.datastructures.blueprint;

import java.awt.geom.Point2D;
import java.io.File;
import java.util.HashSet;
import javax.swing.tree.TreePath;
import org.icepdf.ri.common.views.painting.core.Blueprint;
import org.icepdf.ri.common.views.painting.core.BlueprintPage;
import org.icepdf.ri.common.views.painting.core.GeometraCollection;
import org.icepdf.ri.common.views.painting.drawings.GeometraDrawing;
import org.icepdf.ri.common.views.painting.drawings.ScaleDrawing;
import se.sjobeck.GeometraConfiguration;
import se.sjobeck.geometra.datastructures.blueprint.BlueprintList;
import se.sjobeck.geometra.datastructures.blueprint.Command;
import se.sjobeck.geometra.datastructures.blueprint.IcePDFBlueprint;
import se.sjobeck.geometra.datastructures.blueprint.IcePDFPage;
import se.sjobeck.geometra.datastructures.blueprint.ProjectFile;
import se.sjobeck.geometra.datastructures.blueprint.observer.BlueprintSubject;
import se.sjobeck.geometra.datastructures.blueprint.observer.GeometraSubject;
import se.sjobeck.geometra.datastructures.blueprint.observer.Observer;
import se.sjobeck.geometra.datastructures.drawings.DotDrawing;
import se.sjobeck.geometra.datastructures.drawings.SmartDrawing;
import se.sjobeck.geometra.datastructures.drawings.TotalDrawing;
import se.sjobeck.geometra.gui.main.Geometra;
import se.sjobeck.geometra.gui.panels.JTreePDFPane;
import se.sjobeck.util.StaticHelpers;

public final class GeometraManager
implements Observer {
    private static GeometraManager instance = new GeometraManager();
    private final BlueprintList blueprintList = BlueprintList.getInstance();
    private IcePDFBlueprint activeBlueprint;
    private final GeometraSubject geoSubject = GeometraSubject.getInstance();
    private JTreePDFPane tree;
    static int count = 0;
    public static final int WALLSURFACE = 0;
    public static final int VOLUME = 1;
    public static final int LENGTH = 2;
    public static final int AREA = 3;

    public void setTree(JTreePDFPane tree) {
        this.tree = tree;
    }

    public JTreePDFPane getTree() {
        return this.tree;
    }

    public static GeometraManager getInstance() {
        return instance;
    }

    public String getValidName(String tdName) {
        return this.blueprintList.getValidName(tdName);
    }

    public Point2D blueprintToComponent(Point2D point) {
        if (point != null) {
            return this.activeBlueprint.getActivePage().blueprintToComponent(point);
        }
        return null;
    }

    public Point2D blueprintToComponent(BlueprintPage page, Point2D centerPoint) {
        if (page != null) {
            return page.blueprintToComponent(centerPoint);
        }
        return null;
    }

    public Point2D componentToBlueprint(Point2D point) {
        if (this.activeBlueprint != null) {
            return this.activeBlueprint.getActivePage().componentToBlueprint(point);
        }
        return null;
    }

    public Point2D componentToBlueprint(Blueprint blueprint, Point2D centerPoint) {
        if (blueprint != null) {
            IcePDFBlueprint pdf = (IcePDFBlueprint)blueprint;
            return pdf.getActivePage().componentToBlueprint(centerPoint);
        }
        return null;
    }

    public GeometraDrawing getDrawing(Point2D point) {
        if (this.activeBlueprint != null) {
            return this.activeBlueprint.getDrawing(point);
        }
        return null;
    }

    private GeometraManager() {
        this.geoSubject.addMainObserver(this);
    }

    public final GeometraCollection<GeometraDrawing> getTotalDrawings() {
        GeometraCollection totalCollection = new GeometraCollection();
        for (Blueprint bp : this.blueprintList) {
            IcePDFBlueprint pdf = (IcePDFBlueprint)bp;
            for (int i = 0; i < pdf.getNumberOfPages(); ++i) {
                IcePDFPage page = pdf.getPage(i);
                if (page.getNumberOfDrawings() <= 0) continue;
                totalCollection.addAll(page.getDrawings());
            }
        }
        GeometraCollection finalCollection = new GeometraCollection();
        for (GeometraDrawing gd : totalCollection) {
            if (gd instanceof ScaleDrawing) continue;
            finalCollection.add((Object)gd);
        }
        return finalCollection;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void update(BlueprintSubject.Action action, Object ob, Object source) {
        if (source instanceof GeometraManager) {
            return;
        }
        switch (1.$SwitchMap$se$sjobeck$geometra$datastructures$blueprint$observer$BlueprintSubject$Action[action.ordinal()]) {
            case 1: {
                if (ob instanceof GeometraDrawing && source instanceof TotalDrawing) {
                    this.removeFromTotal((GeometraDrawing)ob, (TotalDrawing)source);
                }
            }
            case 2: {
                if (!(ob instanceof GeometraCollection) || !(source instanceof TotalDrawing)) break;
                coll = (GeometraCollection)ob;
                td = (TotalDrawing)source;
                td.addCollection((GeometraCollection<GeometraDrawing>)coll);
                break;
            }
            case 3: {
                if (!(ob instanceof GeometraDrawing) || !(source instanceof SmartDrawing)) break;
                this.removeFromSmart((GeometraDrawing)ob, (SmartDrawing)source);
                break;
            }
            case 4: {
                if (!(source instanceof String) || !(ob instanceof String)) break;
                this.replace((String)ob, (String)source);
                break;
            }
            case 5: {
                if (ob instanceof Blueprint) {
                    this.activeBlueprint = bp = (IcePDFBlueprint)ob;
                    break;
                }
                if (ob instanceof BlueprintPage) {
                    page = (BlueprintPage)ob;
                    bp = page.getParent();
                    this.activeBlueprint = (IcePDFBlueprint)bp;
                    this.activeBlueprint.setPage(page);
                    break;
                }
                if (!(ob instanceof GeometraDrawing)) break;
                gd = (GeometraDrawing)ob;
                page = gd.getParent();
                bp = page.getParent();
                this.activeBlueprint = (IcePDFBlueprint)bp;
                this.activeBlueprint.setPage(page);
                break;
            }
            case 6: {
                this.getActivePage().addCommand((GeometraDrawing)ob, action);
                break;
            }
            case 7: {
                if (!(ob instanceof GeometraDrawing) || !(source instanceof SmartDrawing)) ** GOTO lbl45
                this.addToSmart((GeometraDrawing)ob, (SmartDrawing)source);
                ** GOTO lbl47
lbl45:
                // 1 sources

                if (ob instanceof GeometraCollection && source instanceof SmartDrawing) {
                    this.addToSmart((GeometraCollection<GeometraDrawing>)((GeometraCollection)ob), (SmartDrawing)source);
                }
            }
lbl47:
            // 5 sources

            case 8: {
                if (!(ob instanceof SmartDrawing)) break;
                sd = (SmartDrawing)ob;
                Geometra.GEOMETRA_POPUP_MENU.addSmartToMenu(sd);
                bp = sd.getParent().getParent();
                ((IcePDFBlueprint)bp).addDrawing(sd);
                break;
            }
            case 9: {
                if (!(ob instanceof GeometraDrawing) || source instanceof Command) break;
                gd = (GeometraDrawing)ob;
                this.getActivePage().addCommand(gd, action);
                break;
            }
            case 10: {
                if (ob instanceof TotalDrawing) {
                    this.blueprintList.add((TotalDrawing)ob);
                    Geometra.GEOMETRA_POPUP_MENU.addTotalDrawingToMenu((TotalDrawing)ob);
                    break;
                }
                if (ob instanceof IcePDFBlueprint) {
                    if (this.blueprintList.size() == 0) {
                        this.activeBlueprint = (IcePDFBlueprint)ob;
                    }
                    this.blueprintList.add((Blueprint)ob);
                    break;
                }
                if (ob instanceof GeometraDrawing && !(ob instanceof DotDrawing)) {
                    gd = (GeometraDrawing)ob;
                    this.activeBlueprint.addDrawing(gd);
                    if (source instanceof Command || source instanceof ProjectFile) break;
                    this.getActivePage().addCommand(gd, action);
                    break;
                }
                if (!(ob instanceof DotDrawing)) break;
                dd = (DotDrawing)ob;
                ddc = dd.getOwner();
                ddc.addChild(dd);
                if (source instanceof Command || source instanceof ProjectFile) break;
                this.getActivePage().addCommand(dd, action);
                break;
            }
            case 11: {
                this.updateScaleDrawing(ob);
                break;
            }
            case 12: {
                this.activeBlueprint.setActiveDrawing(ob);
                break;
            }
            case 13: {
                this.removeObject(ob);
                break;
            }
            case 14: {
                this.undo();
                break;
            }
            case 15: {
                this.redo();
                break;
            }
        }
    }

    private void updateScaleDrawing(Object ob) {
        ScaleDrawing sd = this.getActivePage().getScaleDrawing();
        if (ob instanceof String) {
            try {
                String s = (String)ob;
                sd.setRealDistance(Double.parseDouble(s));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void removeFromTotal(GeometraDrawing gd, TotalDrawing td) {
        td.removeDrawing(gd);
    }

    private void removeFromSmart(GeometraDrawing gd, SmartDrawing sd) {
        sd.removeDrawing(gd);
    }

    private void replace(String from, String to) {
        Object selectionOb = this.tree.getSelectionObject();
        if (selectionOb instanceof GeometraDrawing) {
            GeometraDrawing gd = (GeometraDrawing)selectionOb;
            IcePDFBlueprint bp = (IcePDFBlueprint)gd.getParent().getParent();
            bp.replace(from, to);
        }
    }

    public void updateModField(String in, int modField) {
        TreePath[] paths = this.tree.getSelectedPaths();
        GeometraCollection coll = new GeometraCollection();
        if (paths.length == 1) {
            for (int i = 0; i < paths.length; ++i) {
                Object selectedObject = paths[i].getLastPathComponent();
                if (!(selectedObject instanceof GeometraDrawing)) continue;
                GeometraDrawing gd = (GeometraDrawing)selectedObject;
                switch (modField) {
                    case 0: {
                        gd.setWallSurfaceMod(in);
                        break;
                    }
                    case 1: {
                        gd.setVolumeMod(in);
                        break;
                    }
                    case 2: {
                        gd.setLengthMod(in);
                        break;
                    }
                    case 3: {
                        gd.setAreaMod(in);
                        break;
                    }
                }
                coll.add((Object)gd);
            }
            if (coll.size() > 1) {
                this.geoSubject.update(coll, (Object)this);
            } else {
                this.geoSubject.update((GeometraDrawing)coll.get(0), (Object)this);
            }
        }
    }

    public void updateWallSurface(Object ob) {
        TreePath[] paths = this.tree.getSelectedPaths();
        GeometraCollection coll = new GeometraCollection();
        for (int i = 0; i < paths.length; ++i) {
            Object selectedObject = paths[i].getLastPathComponent();
            if (!(selectedObject instanceof GeometraDrawing)) continue;
            GeometraDrawing gd = (GeometraDrawing)selectedObject;
            gd.setWallSurfaceMod((String)ob);
            coll.add((Object)gd);
        }
        if (coll.size() > 1) {
            this.geoSubject.update(coll, (Object)this);
        } else {
            this.geoSubject.update((GeometraDrawing)coll.get(0), (Object)this);
        }
    }

    public void updateVolume(Object ob) {
        TreePath[] paths = this.tree.getSelectedPaths();
        GeometraCollection coll = new GeometraCollection();
        for (int i = 0; i < paths.length; ++i) {
            Object selectedObject = paths[i].getLastPathComponent();
            if (!(selectedObject instanceof GeometraDrawing)) continue;
            GeometraDrawing gd = (GeometraDrawing)selectedObject;
            gd.setVolumeMod((String)ob);
            coll.add((Object)gd);
        }
        if (coll.size() > 1) {
            this.geoSubject.update(coll, (Object)this);
        } else {
            this.geoSubject.update((GeometraDrawing)coll.get(0), (Object)this);
        }
    }

    public void updateDistance(Object ob) {
        TreePath[] paths = this.tree.getSelectedPaths();
        GeometraCollection coll = new GeometraCollection();
        for (int i = 0; i < paths.length; ++i) {
            Object selectedObject = paths[i].getLastPathComponent();
            if (!(selectedObject instanceof GeometraDrawing)) continue;
            GeometraDrawing gd = (GeometraDrawing)selectedObject;
            gd.setLengthMod((String)ob);
            coll.add((Object)gd);
        }
        if (coll.size() > 1) {
            this.geoSubject.update(coll, (Object)this);
        } else {
            this.geoSubject.update((GeometraDrawing)coll.get(0), (Object)this);
        }
    }

    public void updateArea(Object ob) {
        TreePath[] paths = this.tree.getSelectedPaths();
        GeometraCollection coll = new GeometraCollection();
        if (paths != null) {
            for (int i = 0; i < paths.length; ++i) {
                Object selectedObject = paths[i].getLastPathComponent();
                if (!(selectedObject instanceof GeometraDrawing)) continue;
                GeometraDrawing gd = (GeometraDrawing)selectedObject;
                gd.setAreaMod((String)ob);
                coll.add((Object)gd);
            }
            if (coll.size() > 1) {
                this.geoSubject.update(coll, (Object)this);
            } else {
                this.geoSubject.update((GeometraDrawing)coll.get(0), (Object)this);
            }
        }
    }

    public void updateHeight(Object ob) {
        TreePath[] paths = this.tree.getSelectedPaths();
        GeometraCollection coll = new GeometraCollection();
        String height = (String)ob;
        if (height.length() == 0) {
            return;
        }
        if (paths != null) {
            for (int i = 0; i < paths.length; ++i) {
                Object selectedObject = paths[i].getLastPathComponent();
                if (!(selectedObject instanceof GeometraDrawing)) continue;
                GeometraDrawing gd = (GeometraDrawing)selectedObject;
                gd.setHeight((String)ob);
                coll.add((Object)gd);
            }
            if (coll.size() > 1) {
                this.geoSubject.update(coll, (Object)this);
            } else {
                this.geoSubject.update((GeometraDrawing)coll.get(0), (Object)this);
            }
        }
    }

    private void addToSmart(GeometraCollection<GeometraDrawing> collection, SmartDrawing sd) {
        sd.addCollection(collection);
    }

    private void addToSmart(GeometraDrawing gd, SmartDrawing sd) {
        sd.addDrawing(gd);
    }

    private void redo() {
        this.getActivePage().redo();
    }

    private void undo() {
        this.getActivePage().undo();
    }

    private void removeDrawing(GeometraDrawing gd) {
        if (!(gd instanceof ScaleDrawing)) {
            if (gd instanceof TotalDrawing) {
                this.blueprintList.remove((TotalDrawing)gd);
            } else {
                BlueprintPage page = gd.getParent();
                IcePDFBlueprint bp = (IcePDFBlueprint)page.getParent();
                page.removeDrawing((Object)gd);
                for (int i = 0; i < this.blueprintList.totalDrawingSize(); ++i) {
                    TotalDrawing td = this.blueprintList.getTotalDrawing(i);
                    if (td.contains(gd)) {
                        td.removeDrawing(gd);
                    }
                    if (td.size() != 0) continue;
                    this.blueprintList.remove(td);
                }
            }
        }
    }

    private void removeObject(Object toBeRemoved) {
        if (toBeRemoved instanceof GeometraDrawing) {
            GeometraDrawing gd = (GeometraDrawing)toBeRemoved;
            this.removeDrawing(gd);
        } else if (toBeRemoved instanceof GeometraCollection) {
            GeometraCollection coll = (GeometraCollection)toBeRemoved;
            for (GeometraDrawing gd : coll) {
                this.removeDrawing(gd);
            }
        }
    }

    public ScaleDrawing getScaleDrawing(BlueprintPage page) {
        ScaleDrawing sd = null;
        if (page instanceof IcePDFPage) {
            sd = ((IcePDFPage)page).getScaleDrawing();
        }
        return sd;
    }

    public void setViewingState(Blueprint bp, BlueprintPage.ViewingState viewingState) {
        if (bp != null) {
            ((IcePDFBlueprint)bp).setViewingState(viewingState);
        }
    }

    public void setBlueprintScale(Blueprint bp, float zoom) {
        if (bp != null) {
            ((IcePDFBlueprint)bp).setBlueprintScale(zoom);
        }
    }

    public GeometraCollection<GeometraDrawing> getUnlockedDrawings() {
        if (this.activeBlueprint != null) {
            return this.activeBlueprint.getUnlockedDrawings();
        }
        return null;
    }

    public IcePDFPage getActivePage() {
        if (this.activeBlueprint != null) {
            return (IcePDFPage)this.activeBlueprint.getActivePage();
        }
        return null;
    }

    public void setDrawingState(Blueprint bp, BlueprintPage.DrawingState ds) {
        if (bp != null) {
            ((IcePDFBlueprint)bp).setDrawingState(ds);
        }
    }

    public GeometraCollection<GeometraDrawing> getActiveDrawings() {
        if (this.activeBlueprint != null) {
            return this.activeBlueprint.getActiveDrawings();
        }
        return null;
    }

    public double getRealDistance() {
        if (this.activeBlueprint != null) {
            return ((IcePDFPage)this.activeBlueprint.getActivePage()).getScaleDrawing().getRealDistance();
        }
        return 0.0;
    }

    public Object getPage(Blueprint parent, int index) {
        if (parent != null) {
            return ((IcePDFBlueprint)parent).getPage(index);
        }
        return null;
    }

    public int getNumberOfPages(Blueprint parent) {
        if (parent != null) {
            return ((IcePDFBlueprint)parent).getNumberOfPages();
        }
        return 0;
    }

    public int getPageIndex(Blueprint parent, BlueprintPage child) {
        if (parent != null) {
            IcePDFBlueprint pdf = (IcePDFBlueprint)parent;
            return pdf.indexOf(child);
        }
        return 0;
    }

    public void setDescription(Blueprint bp, String string) {
        IcePDFBlueprint pdf = (IcePDFBlueprint)bp;
        pdf.setDescription(string);
    }

    public void moveScaleDrawing(Point2D point) {
        if (this.activeBlueprint != null) {
            this.activeBlueprint.moveScaleDrawing(point);
        }
    }

    public int getBlueprintListSize() {
        return this.blueprintList.size();
    }

    public int getTotalDrawingListSize() {
        return this.blueprintList.totalDrawingSize();
    }

    public GeometraDrawing getDrawing(BlueprintPage page, int index) {
        return ((IcePDFPage)page).getDrawing(index);
    }

    public Blueprint getParent(BlueprintPage page) {
        if (page != null) {
            return page.getParent();
        }
        return null;
    }

    public void setDescription(BlueprintPage page, String desc) {
        if (page != null) {
            IcePDFPage geoPage = (IcePDFPage)page;
            geoPage.setDescription(desc);
        }
    }

    public GeometraCollection<BlueprintPage> getAllPages() {
        GeometraCollection coll = new GeometraCollection();
        for (int index = 0; index < this.blueprintList.size(); ++index) {
            IcePDFBlueprint bp = (IcePDFBlueprint)this.blueprintList.getBlueprint(index);
            int pages = bp.getNumberOfPages();
            for (int i = 0; i < pages; ++i) {
                IcePDFPage page = bp.getPage(i);
                coll.add((Object)page);
            }
        }
        return coll;
    }

    protected void addBlueprint(Blueprint bp) {
        this.blueprintList.add(bp);
        int numberOfPages = bp.getNumberOfPages();
        for (int i = 0; i < numberOfPages; ++i) {
            IcePDFBlueprint pdf = (IcePDFBlueprint)bp;
            IcePDFPage page = pdf.getPage(i);
            page.init();
            GeometraCollection<GeometraDrawing> col = page.getDrawings();
            for (GeometraDrawing gd : col) {
                gd.init();
                gd.setParent((BlueprintPage)page);
            }
        }
    }

    public boolean projectExists(String inputName) {
        File[] listFiles;
        String savePath = GeometraConfiguration.getSavePath();
        File f = new File(savePath);
        for (File project : listFiles = f.listFiles(StaticHelpers.getGeometraProjectFileFilter())) {
            if (!project.getName().equals(inputName)) continue;
            return true;
        }
        return false;
    }

    protected void addTotalDrawing(TotalDrawing td) {
        this.blueprintList.add(td);
    }

    public void exportScaleDrawing(ScaleDrawing sd, Object[] pages) {
        for (Object ob : pages) {
            if (!(ob instanceof IcePDFPage)) continue;
            IcePDFPage page = (IcePDFPage)ob;
            page.setScaleDrawing(sd);
        }
    }

    protected void rotateLeft() {
        if (this.activeBlueprint != null) {
            this.activeBlueprint.rotateLeft();
        }
    }

    protected void rotateRight() {
        if (this.activeBlueprint != null) {
            this.activeBlueprint.rotateRight();
        }
    }

    public int indexOf(GeometraDrawing currentDrawing) {
        if (this.activeBlueprint != null) {
            return this.activeBlueprint.getActivePage().indexOf(currentDrawing);
        }
        return -1;
    }

    public boolean isRealDistanceSet() {
        if (this.activeBlueprint != null && this.getActivePage() != null) {
            return this.getActivePage().getScaleDrawing().isRealDistanceSet();
        }
        return false;
    }

    public void sort(int sortType) {
        TreePath[] paths = this.tree.getSelectedPaths();
        HashSet<Object> set = new HashSet<Object>();
        if (paths == null) {
            return;
        }
        for (TreePath path : paths) {
            Object ob = path.getLastPathComponent();
            if (ob instanceof GeometraDrawing) {
                GeometraDrawing gd = (GeometraDrawing)ob;
                System.out.println(gd + ", " + gd.getParent() + ", " + gd.getClass());
                set.add(gd.getParent());
                continue;
            }
            set.add(ob);
        }
        for (Object e : set) {
            if (!(e instanceof Blueprint)) continue;
            this.blueprintList.sort(sortType, e);
            this.geoSubject.sort(sortType, (Blueprint)e);
            return;
        }
        for (Object e : set) {
            if (!(e instanceof BlueprintPage)) continue;
            this.blueprintList.sort(sortType, e);
            this.geoSubject.sort(sortType, (BlueprintPage)e);
        }
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$se$sjobeck$geometra$datastructures$blueprint$observer$BlueprintSubject$Action;

        static {
            $SwitchMap$se$sjobeck$geometra$datastructures$blueprint$observer$BlueprintSubject$Action = new int[BlueprintSubject.Action.values().length];
            try {
                1.$SwitchMap$se$sjobeck$geometra$datastructures$blueprint$observer$BlueprintSubject$Action[BlueprintSubject.Action.REMOVE_FROM_TOTAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$se$sjobeck$geometra$datastructures$blueprint$observer$BlueprintSubject$Action[BlueprintSubject.Action.ADD_TO_TOTAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$se$sjobeck$geometra$datastructures$blueprint$observer$BlueprintSubject$Action[BlueprintSubject.Action.REMOVE_FROM_SMART.ordinal()] = 3;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$se$sjobeck$geometra$datastructures$blueprint$observer$BlueprintSubject$Action[BlueprintSubject.Action.REPLACE.ordinal()] = 4;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$se$sjobeck$geometra$datastructures$blueprint$observer$BlueprintSubject$Action[BlueprintSubject.Action.PAGE_SWITCH.ordinal()] = 5;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$se$sjobeck$geometra$datastructures$blueprint$observer$BlueprintSubject$Action[BlueprintSubject.Action.CLOSE.ordinal()] = 6;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$se$sjobeck$geometra$datastructures$blueprint$observer$BlueprintSubject$Action[BlueprintSubject.Action.ADD_TO_SMART.ordinal()] = 7;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$se$sjobeck$geometra$datastructures$blueprint$observer$BlueprintSubject$Action[BlueprintSubject.Action.ADD_SMART_DRAWING.ordinal()] = 8;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$se$sjobeck$geometra$datastructures$blueprint$observer$BlueprintSubject$Action[BlueprintSubject.Action.ADD_POINT.ordinal()] = 9;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$se$sjobeck$geometra$datastructures$blueprint$observer$BlueprintSubject$Action[BlueprintSubject.Action.ADD.ordinal()] = 10;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$se$sjobeck$geometra$datastructures$blueprint$observer$BlueprintSubject$Action[BlueprintSubject.Action.SCALEDRAWING_UPDATE.ordinal()] = 11;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$se$sjobeck$geometra$datastructures$blueprint$observer$BlueprintSubject$Action[BlueprintSubject.Action.SELECT.ordinal()] = 12;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$se$sjobeck$geometra$datastructures$blueprint$observer$BlueprintSubject$Action[BlueprintSubject.Action.REMOVE.ordinal()] = 13;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$se$sjobeck$geometra$datastructures$blueprint$observer$BlueprintSubject$Action[BlueprintSubject.Action.UNDO.ordinal()] = 14;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$se$sjobeck$geometra$datastructures$blueprint$observer$BlueprintSubject$Action[BlueprintSubject.Action.REDO.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

