/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.parser2;

import se.sjobeck.parser2.Operation;

class BinaryOperation
implements Operation {
    private Operation leftNode;
    private Operation rightNode;
    private char operator;

    BinaryOperation(char op, Operation leftSide, Operation rightSide) {
        this.leftNode = leftSide;
        this.rightNode = rightSide;
        this.operator = op;
    }

    @Override
    public double valueOf() {
        switch (this.operator) {
            case '*': {
                return this.leftNode.valueOf() * this.rightNode.valueOf();
            }
            case '/': {
                return this.leftNode.valueOf() / this.rightNode.valueOf();
            }
            case '-': {
                return this.leftNode.valueOf() - this.rightNode.valueOf();
            }
            case '+': {
                return this.leftNode.valueOf() + this.rightNode.valueOf();
            }
            case ':': {
                return this.leftNode.valueOf() + this.rightNode.valueOf() / 60.0;
            }
            case '^': {
                return Math.pow(this.leftNode.valueOf(), this.rightNode.valueOf());
            }
        }
        throw new IllegalArgumentException(this.operator + " is not an infix operator!");
    }
}

