/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.gui.multilinetable2;

import java.awt.Component;
import java.awt.Dimension;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import se.sjobeck.gui.multilinetable2.TextAreaRenderer;

public class MultilineAwareRowHeader
extends JList
implements Observer,
TableModelListener {
    static final long serialVersionUID = 0L;
    private VirtualListModel model;
    private JTable table;

    public MultilineAwareRowHeader(JTable table) {
        this.table = table;
        this.setBackground(table.getTableHeader().getBackground());
        this.setFixedCellWidth(40);
        this.model = new VirtualListModel(table.getRowCount());
        super.setModel(this.model);
        this.setCellRenderer(new RowHeaderRenderer(table));
        table.getModel().addTableModelListener(this);
        this.setSelectionModel(table.getSelectionModel());
        TextAreaRenderer.delegateObserver.addObserver(this);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.model.setSize(this.table.getRowCount());
    }

    @Override
    public void update(Observable o, Object arg) {
        if (this.table.equals(arg)) {
            Logger.getLogger("se.sjobeck.gui.multilinetable2").finer("Table row updated!");
            this.model.setSize(this.table.getRowCount());
        }
    }

    class VirtualListModel
    extends AbstractListModel {
        static final long serialVersionUID = 0L;
        int size;

        VirtualListModel(int i) {
            this.size = i;
        }

        @Override
        public Object getElementAt(int index) {
            return index + 1;
        }

        @Override
        public int getSize() {
            return this.size;
        }

        protected void setSize(int newSize) {
            this.size = newSize;
            this.fireContentsChanged(this, 0, this.size);
        }
    }

    class RowHeaderRenderer
    implements ListCellRenderer,
    TableCellRenderer {
        TableCellRenderer defaultRenderer;
        JTable table;

        RowHeaderRenderer(JTable table) {
            this.table = table;
            this.defaultRenderer = table.getTableHeader().getDefaultRenderer();
            table.getTableHeader().setDefaultRenderer(this);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component renderer = this.defaultRenderer.getTableCellRendererComponent(this.table, value, isSelected, cellHasFocus, -1, 0);
            Dimension newSize = new Dimension(40, TextAreaRenderer.findTotalMaximumRowSize(this.table, index));
            renderer.setPreferredSize(newSize);
            Logger.getLogger("se.sjobeck.gui.multilinetable2").finest("Row #" + index + ", maxHeight: " + newSize.getHeight());
            return renderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean cellHasFocus, int row, int col) {
            Component renderer = this.defaultRenderer.getTableCellRendererComponent(table, value, isSelected, cellHasFocus, row, col);
            renderer.setPreferredSize(null);
            return renderer;
        }
    }
}

