/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.gui.dndtree;

import java.awt.Container;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import se.sjobeck.gui.dndtree.DefaultTreeTransferHandler;
import se.sjobeck.gui.dndtree.VisibleTreeModel;

public class DNDTree
extends JTree {
    static final long serialVersionUID = 0L;
    Insets autoscrollInsets = new Insets(20, 20, 20, 20);

    public DNDTree(DefaultMutableTreeNode root) {
        this(root, true);
    }

    public DNDTree(DefaultMutableTreeNode root, boolean installDefaultTransferHandler) {
        this.setAutoscrolls(true);
        VisibleTreeModel treemodel = new VisibleTreeModel(root);
        this.setModel(treemodel);
        this.setRootVisible(true);
        this.setShowsRootHandles(false);
        this.getSelectionModel().setSelectionMode(1);
        this.setEditable(false);
        if (installDefaultTransferHandler) {
            new DefaultTreeTransferHandler(this, 3);
        }
    }

    public void autoscroll(Point cursorLocation) {
        Insets insets = this.getAutoscrollInsets();
        Rectangle outer = this.getVisibleRect();
        Rectangle inner = new Rectangle(outer.x + insets.left, outer.y + insets.top, outer.width - (insets.left + insets.right), outer.height - (insets.top + insets.bottom));
        if (!inner.contains(cursorLocation)) {
            Rectangle scrollRect = new Rectangle(cursorLocation.x - insets.left, cursorLocation.y - insets.top, insets.left + insets.right, insets.top + insets.bottom);
            this.scrollRectToVisible(scrollRect);
        }
    }

    public Insets getAutoscrollInsets() {
        return this.autoscrollInsets;
    }

    private static DefaultMutableTreeNode createTree() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("root", true);
        DefaultMutableTreeNode node1 = new DefaultMutableTreeNode("node1", true);
        DefaultMutableTreeNode node2 = new DefaultMutableTreeNode("node2", true);
        root.add(node1);
        root.add(node2);
        node1.add(new DefaultMutableTreeNode("sub1_1", false));
        node1.add(new DefaultMutableTreeNode("sub1_2", false));
        node1.add(new DefaultMutableTreeNode("sub1_3", false));
        node2.add(new DefaultMutableTreeNode("sub2_1", false));
        node2.add(new DefaultMutableTreeNode("sub2_2", false));
        node2.add(new DefaultMutableTreeNode("sub2_3", false));
        return root;
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            JFrame frame = new JFrame();
            Container contentPane = frame.getContentPane();
            contentPane.setLayout(new GridLayout(1, 2));
            DefaultMutableTreeNode root1 = DNDTree.createTree();
            DNDTree tree1 = new DNDTree(root1);
            DefaultMutableTreeNode root2 = DNDTree.createTree();
            DNDTree tree2 = new DNDTree(root2);
            contentPane.add(new JScrollPane(tree1));
            contentPane.add(new JScrollPane(tree2));
            frame.setDefaultCloseOperation(3);
            frame.setSize(400, 400);
            frame.setVisible(true);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void filter(String text) {
        TreeModel model = this.getModel();
        if (model instanceof VisibleTreeModel) {
            ((VisibleTreeModel)model).filter(text);
        }
    }
}

