/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.gui;

import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import se.sjobeck.datastructures.utilities.Pair;

public class PairListCellRenderer
extends DefaultListCellRenderer {
    static final long serialVersionUID = 0L;
    private RenderingOption type;
    private String delimiter;

    public PairListCellRenderer() {
        this(RenderingOption.Both);
    }

    public PairListCellRenderer(RenderingOption type) {
        this(type, " - ");
    }

    public PairListCellRenderer(RenderingOption _type, String _delimiter) {
        this.type = _type;
        this.delimiter = _delimiter;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
        switch (this.type) {
            case First: {
                value = ((Pair)value).first;
                break;
            }
            case Second: {
                value = ((Pair)value).second;
                break;
            }
            case Both: {
                value = ((Pair)value).first.toString() + this.delimiter + ((Pair)value).second.toString();
            }
        }
        return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, hasFocus);
    }

    public static enum RenderingOption {
        First,
        Second,
        Both;

    }
}

