/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.digitizer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.TooManyListenersException;
import javax.comm.CommDriver;
import javax.comm.CommPortIdentifier;
import javax.comm.PortInUseException;
import javax.comm.SerialPort;
import javax.comm.SerialPortEvent;
import javax.comm.SerialPortEventListener;
import se.sjobeck.digitizer.ReaderThread;
import se.sjobeck.digitizer.SerialPortReaderThread;
import se.sjobeck.digitizer.serial.SerialPortDigitizer;
import se.sjobeck.reflect.ClassFinder;

public class TestSerialPorts {
    protected static OutputStream out;
    protected static InputStream in;
    private static List<SerialPortDigitizer> drivers;
    private static SerialPortReaderThread readerThread;
    private static SerialPortEventListener notifier;

    public static ReaderThread getReaderThread() {
        SerialPortDigitizer digitizer = null;
        CommPortIdentifier port = null;
        readerThread = new SerialPortReaderThread();
        readerThread.setDaemon(true);
        readerThread.start();
        Class[] driverList = new Class[]{};
        try {
            driverList = new Class[]{Class.forName("se.sjobeck.digitizer.serial.RollUp"), Class.forName("se.sjobeck.digitizer.serial.DrawingSlate")};
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        drivers = new ArrayList<SerialPortDigitizer>(driverList.length);
        for (Class driver : driverList) {
            System.out.println("Adding: " + driver);
            drivers.add((SerialPortDigitizer)ClassFinder.getInstance(driver));
        }
        Enumeration ports = CommPortIdentifier.getPortIdentifiers();
        while (ports.hasMoreElements() && digitizer == null) {
            port = (CommPortIdentifier)ports.nextElement();
            System.out.println("Checking " + port.getName() + "...");
            if (port.isCurrentlyOwned()) {
                System.out.println("Skipping " + port.getName() + ", it is owned by '" + port.getCurrentOwner() + "'");
                continue;
            }
            if (port.getPortType() == 1) {
                digitizer = TestSerialPorts.checkSerialPort(port);
            } else if (port.getPortType() == 2) {
                System.out.println("Parallell port not supported");
            }
            if (digitizer == null) {
                System.out.println("Found nothing on " + port.getName());
                continue;
            }
            System.out.println("Found '" + digitizer.getDescription() + "' on " + port.getName() + "!");
        }
        if (port != null && port.getPortType() == 1) {
            try {
                SerialPort p = (SerialPort)port.open("ePrisbok", 1000);
                TestSerialPorts.addListener(p);
                readerThread.setDigitizer(digitizer);
                return readerThread;
            }
            catch (PortInUseException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private static void addListener(SerialPort p) {
        try {
            p.addEventListener(notifier);
            p.notifyOnCTS(false);
            p.notifyOnDSR(false);
            p.notifyOnRingIndicator(false);
            p.notifyOnCarrierDetect(false);
            p.notifyOnOverrunError(false);
            p.notifyOnParityError(false);
            p.notifyOnFramingError(false);
            p.notifyOnBreakInterrupt(false);
            p.notifyOnDataAvailable(true);
            p.notifyOnOutputEmpty(false);
            readerThread.setInputStream(p.getInputStream());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TooManyListenersException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized SerialPortDigitizer checkSerialPort(CommPortIdentifier cport) {
        SerialPort port = null;
        try {
            port = (SerialPort)cport.open("Serial port scanner", 2000);
            TestSerialPorts.addListener(port);
            out = port.getOutputStream();
            for (SerialPortDigitizer driver : drivers) {
                byte[] id = driver.getIdentifierCommand();
                out.write(id);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (readerThread.getBuffer().length <= 0 || !driver.identifyDigitizer(readerThread.getBuffer())) continue;
                SerialPortDigitizer serialPortDigitizer = driver;
                return serialPortDigitizer;
            }
        }
        catch (PortInUseException e) {
        }
        catch (IOException iOException) {
        }
        finally {
            if (port != null) {
                port.removeEventListener();
                port.close();
            }
        }
        return null;
    }

    static {
        try {
            String driverName = "com.sun.comm.Win32Driver";
            CommDriver commDriver = (CommDriver)Class.forName(driverName).newInstance();
            commDriver.initialize();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        notifier = new SerialPortEventListener(){

            public void serialEvent(SerialPortEvent e) {
                readerThread.dataAvailable();
            }
        };
    }
}

