/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.datastructures.kalkylering;

import se.sjobeck.datastructures.kalkylering.ProjektInfo;

public class TimprisStruct {
    private double restidKrPerDag;
    private double restidKmPerDag;
    private int antalMedAkande;
    private transient double fastkostSumma;
    private transient double arbskostSumma;
    private transient double timpris;
    private transient double l\u00f6nebikostnad;
    private transient double resorochtraktamente;
    private double timlon;
    private double overtidsTlg;
    private double reskostKmPerDag;
    private double reskostKrPerDag;
    private double traktamentePerDag;
    private double traktamentePerNatt;
    private double fastKostnad;
    private double vinst;
    private transient ProjektInfo owner;
    private double tidlonPct;
    private double matpristlg;
    private boolean utlandstraktamente = false;

    public Object readResolve() {
        return this;
    }

    public void setOwner(ProjektInfo newOwner) {
        this.owner = newOwner;
        this.updateTimpris();
    }

    public TimprisStruct() {
    }

    public TimprisStruct(ProjektInfo owner) {
        this.owner = owner;
        this.timlon = 200.0;
        this.fastKostnad = 100.0;
        this.vinst = 10.0;
        this.tidlonPct = 13.0;
        this.traktamentePerNatt = 0.0;
        this.traktamentePerDag = 0.0;
        this.reskostKmPerDag = 0.0;
        this.overtidsTlg = 0.0;
        this.matpristlg = 0.0;
        this.l\u00f6nebikostnad = 0.0;
        this.resorochtraktamente = 0.0;
        this.updateTimpris();
    }

    public void updateTimpris() {
        TimprisStruct.updateTimpris(this);
        this.getOwner().getRadHanterare().pricesChanged();
    }

    public void setUtlandsTraktamente(boolean bol) {
        this.utlandstraktamente = bol;
    }

    public boolean getUtlandsTraktamente() {
        return this.utlandstraktamente;
    }

    public static void updateTimpris(TimprisStruct pris) {
        double T = 0.0;
        double S = 0.0;
        double R = 0.0;
        double Q = 0.0;
        double P = 0.0;
        double O = 0.0;
        double N = 0.0;
        double M = 0.0;
        double L = 0.0;
        double K = 0.0;
        double J = 0.0;
        double I = 0.0;
        double H = 0.0;
        double G = 0.0;
        double F = 0.0;
        double C = 0.0;
        double A = 0.0;
        A = pris.getTimlon();
        C = pris.getOvertidsTlg();
        F = pris.getReskostKmPerDag() / 8.0 * pris.getOwner().getDatabaseInstance().getReskostnadKrPerKm();
        G = pris.getReskostKrPerDag() / 8.0;
        if (pris.utlandstraktamente) {
            H = 0.0;
        } else {
            H = pris.getTraktamentePerDag();
            if (H > 100.0) {
                H += (H - 100.0) * pris.getOwner().getDatabaseInstance().getArbetsgivarAvgift();
                H += (H - 100.0) * 0.04 * pris.getOwner().getDatabaseInstance().getL\u00f6neskatt();
            }
            H /= 8.0;
        }
        I = pris.getTraktamentePerNatt();
        if (!pris.utlandstraktamente && I > 200.0) {
            I += (I - 200.0) * pris.getOwner().getDatabaseInstance().getArbetsgivarAvgift();
            I += (I - 200.0) * 0.04 * pris.getOwner().getDatabaseInstance().getL\u00f6neskatt();
        }
        I = I * 7.0 / 40.0;
        J = pris.getFastKostnad();
        L = pris.getOwner().getDatabaseInstance().getHelgl\u00f6n() * (A + C);
        M = pris.getOwner().getDatabaseInstance().getArbetstidsF\u00f6rkortning() * (A + C);
        N = pris.getOwner().getDatabaseInstance().getSjukl\u00f6n() * (A + C);
        O = pris.getOwner().getDatabaseInstance().getInternaL\u00f6neBikostnader() * (A + C);
        P = pris.getOwner().getDatabaseInstance().getSemesterL\u00f6n() * (A + C + L + M + N + O);
        Q = pris.getOwner().getDatabaseInstance().getArbetsgivarAvgift() * (A + C + L + M + N + O + P);
        R = pris.getOwner().getDatabaseInstance().getL\u00f6neskatt() * (A + C + L + M + N + O + P);
        S = 0.01 * pris.getOwner().getDatabaseInstance().getMkaAvgift() * (A + C + P + L + M + O + N);
        T = 0.0;
        pris.setTimpris(1.0 / (1.0 - pris.getVinst() / 100.0) * (A + C + F + G + H + I + J + L + M + N + O + P + Q + R + S + T));
        pris.setArbskostSumma(A + C + L + M + N + O + P + Q + R + S + T);
        pris.setFastkostSumma(J);
        pris.setL\u00f6nebikostnad(L + M + N + O + P + Q + R + S);
        pris.setResorochtraktamente(F + G + H + I);
    }

    public double getFastkostSumma() {
        return this.fastkostSumma;
    }

    public void setFastkostSumma(double fastkostSumma) {
        this.fastkostSumma = fastkostSumma;
    }

    public double getArbskostSumma() {
        return this.arbskostSumma;
    }

    public void setArbskostSumma(double arbskostSumma) {
        this.arbskostSumma = arbskostSumma;
    }

    public double getTimpris() {
        return this.timpris;
    }

    public void setTimpris(double timpris) {
        this.timpris = timpris;
    }

    public double getL\u00f6nebikostnad() {
        return this.l\u00f6nebikostnad;
    }

    public void setL\u00f6nebikostnad(double l\u00f6nebikostnad) {
        this.l\u00f6nebikostnad = l\u00f6nebikostnad;
    }

    public double getResorochtraktamente() {
        return this.resorochtraktamente;
    }

    public void setResorochtraktamente(double resorochtraktamente) {
        this.resorochtraktamente = resorochtraktamente;
    }

    public double getTimlon() {
        return this.timlon;
    }

    public void setTimlon(double timlon) {
        this.timlon = timlon;
    }

    public double getOvertidsTlg() {
        return this.overtidsTlg;
    }

    public void setOvertidsTlg(double overtidsTlg) {
        this.overtidsTlg = overtidsTlg;
    }

    public double getReskostKmPerDag() {
        return this.reskostKmPerDag;
    }

    public void setReskostKmPerDag(double reskostKmPerDag) {
        this.reskostKmPerDag = reskostKmPerDag;
    }

    public double getReskostKrPerDag() {
        return this.reskostKrPerDag;
    }

    public void setReskostKrPerDag(double reskostKrPerDag) {
        this.reskostKrPerDag = reskostKrPerDag;
    }

    public double getTraktamentePerDag() {
        return this.traktamentePerDag;
    }

    public void setTraktamentePerDag(double traktamentePerDag) {
        this.traktamentePerDag = traktamentePerDag;
    }

    public double getTraktamentePerNatt() {
        return this.traktamentePerNatt;
    }

    public void setTraktamentePerNatt(double traktamentePerNatt) {
        this.traktamentePerNatt = traktamentePerNatt;
    }

    public double getFastKostnad() {
        return this.fastKostnad;
    }

    public void setFastKostnad(double fastKostnad) {
        this.fastKostnad = fastKostnad;
    }

    public double getVinst() {
        return this.vinst;
    }

    public void setVinst(double vinst) {
        this.vinst = vinst;
    }

    public ProjektInfo getOwner() {
        return this.owner;
    }

    public double getTidlonPct() {
        return this.tidlonPct;
    }

    public void setTidlonPct(double tidlonPct) {
        this.tidlonPct = tidlonPct;
    }

    public double getMatpristlg() {
        return this.matpristlg;
    }

    public void setMatpristlg(double matpristlg) {
        this.matpristlg = matpristlg;
    }

    public double getRestidKrPerDag() {
        return this.restidKrPerDag;
    }

    public double getRestidKmPerDag() {
        return this.restidKmPerDag;
    }

    public int getAntalMedAkande() {
        return this.antalMedAkande;
    }

    public void setRestidKrPerDag(double restidKrPerDag) {
        this.restidKrPerDag = restidKrPerDag;
    }

    public void setRestidKmPerDag(double restidKmPerDag) {
        this.restidKmPerDag = restidKmPerDag;
    }

    public void setAntalMedAkande(int antalMedAkande) {
        this.antalMedAkande = antalMedAkande;
    }
}

