/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.util.pdf;

import com.itextpdf.text.Document;
import com.itextpdf.text.Element;
import com.itextpdf.text.FontFactory;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.pdf.PdfContentByte;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import se.sjobeck.datastructures.Projekt;
import se.sjobeck.network2.ClientThread;
import se.sjobeck.util.pdf.Content;
import se.sjobeck.util.pdf.DirectContent;
import se.sjobeck.util.pdf.HorizontalAlignment;
import se.sjobeck.util.pdf.VerticalAlignment;

public class Text
implements Content,
DirectContent {
    private HorizontalAlignment align;
    private float x = 20.0f;
    private float y = 30.0f;
    private String text;
    private static DateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd");

    public Text() {
    }

    public Text(String text) {
        this(text, HorizontalAlignment.Left);
    }

    public Text(String text, HorizontalAlignment align) {
        this(text, align, 20.0f, 30.0f);
    }

    public Text(String text, HorizontalAlignment align, float x, float y) {
        this.align = align;
        this.x = x;
        this.y = y;
        this.text = text;
    }

    @Override
    public void addContent(Document doc, Projekt proj, File outFile, boolean printFolders) {
        Paragraph p = new Paragraph(Text.parseDynamic(this.text, proj, doc, outFile), FontFactory.getFont((String)"Times-Bold", (float)11.0f));
        switch (this.align) {
            case Right: {
                p.setAlignment(2);
                break;
            }
            case Left: {
                p.setAlignment(0);
                break;
            }
            default: {
                p.setAlignment(1);
            }
        }
        try {
            doc.add((Element)p);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addContent(Document doc, Projekt proj, PdfContentByte cb, VerticalAlignment valign, File outFile) {
        float _y;
        cb.beginText();
        switch (valign) {
            case Top: {
                _y = doc.getPageSize().getHeight() - this.y;
                break;
            }
            case Bottom: {
                _y = this.y;
                break;
            }
            default: {
                _y = doc.getPageSize().getHeight() / 2.0f;
            }
        }
        switch (this.align) {
            case Left: {
                cb.showTextAligned(0, Text.parseDynamic(this.text, proj, doc, outFile), this.x, _y, 0.0f);
                break;
            }
            case Right: {
                cb.showTextAligned(2, Text.parseDynamic(this.text, proj, doc, outFile), doc.getPageSize().getWidth() - this.x, _y, 0.0f);
                break;
            }
            default: {
                cb.showTextAligned(1, Text.parseDynamic(this.text, proj, doc, outFile), doc.getPageSize().getWidth() / 2.0f + this.x, _y, 0.0f);
            }
        }
        cb.endText();
    }

    private static String parseDynamic(String template, Projekt proj, Document doc, File outputFile) {
        if (template == null) {
            return "<null>";
        }
        String ret = template;
        ret = ret.replaceAll("\\$SidaTotal", "");
        ret = ret.replaceAll("\\$Sida", "" + doc.getPageNumber());
        ret = ret.replaceAll("\\$F\u00f6retagsnamn", ClientThread.getUserFullName());
        ret = ret.replaceAll("\\$ProgramNamn", ClientThread.getApplicationType().toString() + "\u2122");
        ret = ret.replaceAll("\\$UtskriftsDatum", dateFormatter.format(new Date()));
        ret = ret.replaceAll("\\$Projektnamn", proj.getFileReference().getName());
        ret = ret.replaceAll("\\$Filnamn", outputFile.getName());
        return ret;
    }
}

