/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.util.pdf;

import com.itextpdf.text.pdf.PdfPTable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import se.sjobeck.datastructures.EditableRadTable;
import se.sjobeck.datastructures.Projekt;
import se.sjobeck.datastructures.RowHandlerStrategyImplEkalkyl;
import se.sjobeck.datastructures.kalkylering.BehandlingsTyp;
import se.sjobeck.datastructures.kalkylering.RadHanterare;
import se.sjobeck.datastructures.kalkylering.RadStruct;
import se.sjobeck.datastructures.kalkylering.RowHandlerStrategy;
import se.sjobeck.datastructures.kalkylering.Underlag;
import se.sjobeck.datastructures.kalkylering.Ytmaterial;
import se.sjobeck.util.MappingUtilities;
import se.sjobeck.util.StaticHelpers;
import se.sjobeck.util.pdf.AbstractTabell;
import se.sjobeck.util.pdf.Kolumn;

public class ProjektTabell
extends AbstractTabell {
    @Override
    void addRows(PdfPTable tabell, Kolumn[] cols, List<RadStruct> rader, Projekt proj) {
        boolean gray = false;
        double total_pris = 0.0;
        double total_tid = 0.0;
        double totalMtrl = 0.0;
        double total_ackr = 0.0;
        boolean lastRow = false;
        for (int radNr = 0; radNr < rader.size(); ++radNr) {
            try {
                if (gray) {
                    tabell.getDefaultCell().setGrayFill(0.95f);
                } else {
                    tabell.getDefaultCell().setGrayFill(1.0f);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            for (Kolumn k : cols) {
                if (k == Kolumn.TotalPris) {
                    total_pris += this.addRow(tabell, k, rader.get(radNr), proj, radNr);
                    lastRow = true;
                    continue;
                }
                if (k == Kolumn.TotalTid) {
                    total_tid += this.addRow(tabell, k, rader.get(radNr), proj, radNr);
                    lastRow = true;
                    continue;
                }
                if (k == Kolumn.AckgrL\u00f6n_Samman_till\u00e4gg) {
                    total_ackr += this.addRow(tabell, k, rader.get(radNr), proj, radNr);
                    lastRow = true;
                    continue;
                }
                if (k == Kolumn.MtrlPris_Antal) {
                    totalMtrl += this.addRow(tabell, k, rader.get(radNr), proj, radNr);
                    lastRow = true;
                    continue;
                }
                this.addRow(tabell, k, rader.get(radNr), proj, radNr);
            }
            gray = !gray;
        }
        if (lastRow) {
            if (gray) {
                tabell.getDefaultCell().setGrayFill(1.0f);
            } else {
                tabell.getDefaultCell().setGrayFill(0.95f);
            }
            String value = "";
            block10: for (int i = 0; i < cols.length; ++i) {
                switch (cols[i]) {
                    case TotalPris: {
                        value = StaticHelpers.format2Dec((double)total_pris);
                        this.cellFontGrayAdding(tabell, value, 2);
                        continue block10;
                    }
                    case TotalTid: {
                        String beta = String.valueOf(total_tid);
                        String[] split = new String[]{beta.substring(0, beta.indexOf(46)), beta.substring(beta.indexOf(46), beta.length())};
                        int kobra_kai = (int)Math.ceil(Double.parseDouble(split[1].replaceAll(" ", "")) * 0.6 * 100.0);
                        value = split[0] + ":" + String.valueOf(kobra_kai);
                        this.cellFontGrayAdding(tabell, value, 2);
                        continue block10;
                    }
                    case AckgrL\u00f6n_Samman_till\u00e4gg: {
                        value = StaticHelpers.format2Dec((double)total_ackr);
                        this.cellFontGrayAdding(tabell, value, 2);
                        continue block10;
                    }
                    case MtrlPris_Antal: {
                        value = StaticHelpers.format2Dec((double)totalMtrl);
                        this.cellFontGrayAdding(tabell, value, 2);
                        continue block10;
                    }
                    default: {
                        this.cellFontGrayAdding(tabell, "", 2);
                    }
                }
            }
        }
    }

    private double addRow(PdfPTable tabell, Kolumn k, RadStruct rad, Projekt proj, int radNr) {
        String s;
        int alignment = 1;
        switch (k) {
            case RadNr: {
                s = "" + (radNr + 1);
                alignment = 0;
                break;
            }
            case Fabrikat: {
                s = proj.getFabrikat().toString();
                alignment = 0;
                break;
            }
            case ByggdelID: {
                s = rad.getByggdel().getId();
                alignment = 0;
                break;
            }
            case ByggdelFull: {
                s = rad.getByggdel().getId() + " - " + rad.getDescription();
                alignment = 0;
                break;
            }
            case Beskrivning: {
                s = rad.getDescription();
                alignment = 0;
                break;
            }
            case Dimension: {
                s = rad.getDim().toString();
                alignment = 0;
                break;
            }
            case UnderlagID: {
                s = rad.getUnderlagID();
                alignment = 0;
                break;
            }
            case M\u00e5lningsmtrlID: {
                s = rad.getYtmaterialID();
                alignment = 0;
                break;
            }
            case Produkt: {
                s = proj.getDatabaseInstance().getProduktNamn(proj.getFabrikat(), rad.getProduktKod());
                alignment = 0;
                break;
            }
            case AMAkod: {
                proj.getRadHanterare();
                s = RadHanterare.getAmaKod((RadStruct)rad);
                alignment = 0;
                break;
            }
            case Till\u00e4gg: {
                s = EditableRadTable.formatTlgList(rad.getTillagg());
                alignment = 0;
                break;
            }
            case Enhet: {
                s = proj.getRadHanterare().getEnhet(rad, (RowHandlerStrategy)RowHandlerStrategyImplEkalkyl.KNOWS_ABOUT_PROJEKT);
                alignment = 0;
                break;
            }
            case Arbetskostnad: {
                s = StaticHelpers.format2Dec((double)proj.getRadHanterare().getArbetskostnadPerEnh(rad));
                alignment = 2;
                break;
            }
            case Materialkostnad: {
                s = StaticHelpers.format2Dec((double)proj.getRadHanterare().getMaterialPerEnh(rad));
                alignment = 2;
                break;
            }
            case FastKostnad: {
                s = StaticHelpers.format2Dec((double)proj.getRadHanterare().getFastaKostnaderPerEnh(rad));
                alignment = 2;
                break;
            }
            case Vinst: {
                s = StaticHelpers.format2Dec((double)proj.getRadHanterare().getVinstPerEnh(rad));
                alignment = 2;
                break;
            }
            case PrisPerEnhet: {
                s = StaticHelpers.format2Dec((double)proj.getRadHanterare().getPrisPerEnh(rad));
                alignment = 2;
                break;
            }
            case TidPerEnhet: {
                s = StaticHelpers.tidFormat((double)proj.getRadHanterare().getTidPerEnh(rad));
                alignment = 2;
                break;
            }
            case Antal: {
                s = StaticHelpers.format2Dec((double)rad.getAntalEnh());
                alignment = 2;
                break;
            }
            case TotalPris: {
                s = StaticHelpers.format2Dec((double)(proj.getRadHanterare().getPrisPerEnh(rad) * rad.getAntalEnh()));
                alignment = 2;
                break;
            }
            case TotalTid: {
                s = StaticHelpers.tidFormat((double)(proj.getRadHanterare().getTidPerEnh(rad) * rad.getAntalEnh()));
                alignment = 2;
                break;
            }
            case Kul\u00f6r: {
                s = rad.getKulor() == null ? "" : rad.getKulor();
                alignment = 0;
                break;
            }
            case AntalMedEnhet: {
                s = StaticHelpers.format2Dec((double)rad.getAntalEnh()) + " " + proj.getRadHanterare().getEnhet(rad, (RowHandlerStrategy)RowHandlerStrategyImplEkalkyl.KNOWS_ABOUT_PROJEKT);
                alignment = 2;
                break;
            }
            case Underlag: {
                Collection us = proj.getDatabaseInstance().getUnderlag(rad);
                s = "Underlag finns inte!";
                for (Underlag u : us) {
                    if (!u.getId().equals(rad.getUnderlagID())) continue;
                    s = u.getDescription();
                }
                alignment = 0;
                break;
            }
            case M\u00e5lningsmaterial: {
                Collection ys = proj.getDatabaseInstance().getYtmaterial(rad);
                s = "Ytmaterialet finns inte!";
                for (Ytmaterial y : ys) {
                    if (!y.getId().equals(rad.getYtmaterialID())) continue;
                    s = y.getDescription();
                }
                alignment = 0;
                break;
            }
            case F\u00f6rbehandling: {
                s = proj.getDatabaseInstance().getBehandling(BehandlingsTyp.F\u00f6rbehandling, rad).getDescription();
                alignment = 0;
                break;
            }
            case Underbehandling: {
                s = proj.getDatabaseInstance().getBehandling(BehandlingsTyp.Underbehandling, rad).getDescription();
                alignment = 0;
                break;
            }
            case F\u00e4rdigbehandling: {
                s = proj.getDatabaseInstance().getBehandling(BehandlingsTyp.F\u00e4rdigbehandling, rad).getDescription();
                alignment = 0;
                break;
            }
            case AckPunkter: {
                TreeMap ackpunkter = new TreeMap();
                MappingUtilities.join(ackpunkter, (Map)proj.getDatabaseInstance().getBehandling(BehandlingsTyp.F\u00e4rdigbehandling, rad).getAckordspunkter());
                MappingUtilities.join(ackpunkter, (Map)proj.getDatabaseInstance().getBehandling(BehandlingsTyp.Underbehandling, rad).getAckordspunkter());
                MappingUtilities.join(ackpunkter, (Map)proj.getDatabaseInstance().getBehandling(BehandlingsTyp.F\u00f6rbehandling, rad).getAckordspunkter());
                s = "";
                Iterator it = ackpunkter.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry e = it.next();
                    s = s + e.getValue() + "x" + (String)e.getKey();
                    if (!it.hasNext()) continue;
                    s = s + ", ";
                }
                alignment = 0;
                break;
            }
            case AckgrL\u00f6n_F\u00f6r: {
                s = StaticHelpers.format2Dec((double)proj.getDatabaseInstance().getBehandling(BehandlingsTyp.F\u00f6rbehandling, rad).getAckpris());
                alignment = 2;
                break;
            }
            case AckgrL\u00f6n_Under: {
                s = StaticHelpers.format2Dec((double)proj.getDatabaseInstance().getBehandling(BehandlingsTyp.Underbehandling, rad).getAckpris());
                alignment = 2;
                break;
            }
            case AckgrL\u00f6n_F\u00e4rdig: {
                s = StaticHelpers.format2Dec((double)proj.getDatabaseInstance().getBehandling(BehandlingsTyp.F\u00e4rdigbehandling, rad).getAckpris());
                alignment = 2;
                break;
            }
            case AckgrL\u00f6n_Samman_till\u00e4gg: {
                s = StaticHelpers.format2Dec((double)proj.getAckgrundl\u00f6nInklTill\u00e4gg(rad));
                alignment = 2;
                break;
            }
            case AckgrL\u00f6n_Total_Antal: {
                s = StaticHelpers.format2Dec((double)(proj.getAckgrundl\u00f6nInklTill\u00e4gg(rad) * rad.getAntalEnh()));
                alignment = 2;
                break;
            }
            case MtrlPerEnhet: {
                s = StaticHelpers.format2Dec((double)proj.getRadHanterare().getMaterialPerEnh(rad));
                alignment = 2;
                break;
            }
            case MtrlPris_Antal: {
                s = StaticHelpers.format2Dec((double)(proj.getRadHanterare().getMaterialPerEnh(rad) * rad.getAntalEnh()));
                alignment = 2;
                break;
            }
            default: {
                s = "Fel";
                alignment = 0;
            }
        }
        try {
            this.cellFontGrayAdding(tabell, s, alignment);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (k == Kolumn.TotalPris || k == Kolumn.AckgrL\u00f6n_Samman_till\u00e4gg || k == Kolumn.MtrlPris_Antal) {
            s = s.replaceAll(",", ".");
            char[] toCharArray = s.toCharArray();
            StringBuffer g = new StringBuffer();
            String test = "-0123456789.";
            for (char c : toCharArray) {
                if (test.indexOf(c) <= -1) continue;
                g.append(c);
            }
            return Double.parseDouble(g.toString());
        }
        if (k == Kolumn.TotalTid) {
            String[] split = s.split(":");
            double d = StaticHelpers.toDouble((String)split[0]);
            double i = StaticHelpers.toDouble((String)split[1]);
            i = i * 1.0 / 0.6;
            return d += i * 0.01;
        }
        return 0.0;
    }
}

