/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.util.pdf;

import com.itextpdf.text.pdf.PdfPTable;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import se.sjobeck.datastructures.Projekt;
import se.sjobeck.datastructures.kalkylering.RadStruct;
import se.sjobeck.util.StaticHelpers;
import se.sjobeck.util.pdf.AbstractTabell;
import se.sjobeck.util.pdf.Kolumn;

public class MaterialTabell
extends AbstractTabell {
    MaterialTabell() {
        this.kolumner = Kolumn.values();
    }

    @Override
    void addRows(PdfPTable tabell, Kolumn[] cols, List<RadStruct> rader, Projekt proj) {
        TreeMap<Key, Data> compoundMapping = new TreeMap<Key, Data>();
        boolean gray = false;
        for (RadStruct r : rader) {
            System.out.println(" YtMaterialId " + r.getYtmaterialID());
            System.out.println(" Kul\u00f6r " + r.getKulor());
            System.out.println("produktnamn: " + proj.getRadHanterare().getProduktNamn(r));
            System.out.println("produktkod: " + r.getProduktKod());
            Map materialLista = proj.getRadHanterare().getMaterialLista(r);
            if (materialLista == null) continue;
            for (Map.Entry entry : materialLista.entrySet()) {
                Data data;
                if (((String)entry.getKey()).equals("__f") || ((String)entry.getKey()).equals("__1") || ((String)entry.getKey()).equals("__2")) continue;
                Key key = new Key((String)entry.getKey());
                System.out.println(r + ", " + r.getProduktKod() + ", " + entry + ", " + (String)entry.getKey());
                if (r.getProduktKod() != null && r.getProduktKod().equals(entry.getKey()) && r.getKulor() != null) {
                    key.kul\u00f6r = r.getKulor();
                }
                if ((data = (Data)compoundMapping.get(key)) == null) {
                    data = new Data();
                }
                double dimMod = 1.0;
                if (r.getDim() != null) {
                    dimMod = r.getDim().getMtrlMod();
                }
                System.out.println("key " + key);
                data.value = r.getAntalEnh() * (Double)entry.getValue() * dimMod + data.value;
                if (r.getProduktKod() != null && r.getProduktKod().equals(entry.getKey()) && r.getKulor() != null) {
                    data.kul\u00f6r = r.getKulor();
                }
                compoundMapping.put(key, data);
            }
        }
        double summa = 0.0;
        for (Map.Entry e : compoundMapping.entrySet()) {
            try {
                if (gray) {
                    tabell.getDefaultCell().setGrayFill(1.0f);
                } else {
                    tabell.getDefaultCell().setGrayFill(0.95f);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            for (Kolumn k : cols) {
                summa += this.addProduktCell(tabell, k, (Key)e.getKey(), (Data)e.getValue(), proj);
            }
            gray = !gray;
        }
        if (gray) {
            tabell.getDefaultCell().setGrayFill(1.0f);
        } else {
            tabell.getDefaultCell().setGrayFill(0.95f);
        }
        for (int i = 0; i < cols.length - 1; ++i) {
            this.cellFontGrayAdding(tabell, "", 2);
        }
        String value = StaticHelpers.format2Dec((double)summa);
        this.cellFontGrayAdding(tabell, value, 2);
    }

    double addProduktCell(PdfPTable tabell, Kolumn k, Key key, Data data, Projekt proj) {
        String s;
        System.out.println("key data addProduktCel " + key + ", " + data);
        int alignment = 2;
        switch (k) {
            case M\u00e5lningsmaterial: 
            case Produkt: {
                s = proj.getDatabaseInstance().getProduktNamn(proj.getFabrikat(), key.produkt);
                alignment = 0;
                break;
            }
            case Enhet: {
                s = proj.getDatabaseInstance().getProduktEnhet(proj.getFabrikat(), key.produkt);
                break;
            }
            case Kul\u00f6r: {
                s = data.kul\u00f6r;
                break;
            }
            case PrisPerEnhet: {
                s = StaticHelpers.format2Dec((double)(proj.getDatabaseInstance().getProduktPris(proj.getFabrikat(), key.produkt) * ((100.0 + proj.getTimprisStruct().getMatpristlg()) * 0.01))) + "/" + proj.getDatabaseInstance().getProduktEnhet(proj.getFabrikat(), key.produkt);
                break;
            }
            case Antal: {
                s = StaticHelpers.format2Dec((double)data.value) + " " + proj.getDatabaseInstance().getProduktEnhet(proj.getFabrikat(), key.produkt);
                break;
            }
            case TotalPris: {
                s = StaticHelpers.format2Dec((double)(data.value * proj.getDatabaseInstance().getProduktPris(proj.getFabrikat(), key.produkt) * ((100.0 + proj.getTimprisStruct().getMatpristlg()) * 0.01)));
                break;
            }
            default: {
                s = "Fel";
            }
        }
        try {
            this.cellFontGrayAdding(tabell, s, alignment);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (k == Kolumn.TotalPris) {
            s = s.replaceAll(",", ".");
            return StaticHelpers.toDouble((String)s);
        }
        return 0.0;
    }

    private class Key
    implements Comparable<Key> {
        public String produkt;
        public String kul\u00f6r;

        public Key(String p) {
            this.produkt = p;
            this.kul\u00f6r = "";
        }

        public String toString() {
            return this.produkt + this.kul\u00f6r;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object obj) {
            return this.toString().equals(obj);
        }

        @Override
        public int compareTo(Key o) {
            return this.toString().compareTo(o.toString());
        }
    }

    private class Data {
        public Double value = 0.0;
        public String kul\u00f6r = "";
    }
}

