/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.util.pdf;

import java.util.Enumeration;
import java.util.Vector;
import javax.swing.tree.TreeNode;
import se.sjobeck.datastructures.KalkylNod;
import se.sjobeck.datastructures.Projekt;
import se.sjobeck.datastructures.kalkylering.BehandlingsTyp;
import se.sjobeck.datastructures.kalkylering.RadStruct;
import se.sjobeck.util.pdf.PsiTabell;
import se.sjobeck.util.pdf.PsiTabellFactory;
import se.sjobeck.util.pdf.PsiTabellObject;
import se.sjobeck.util.pdf.PsiTabellObjectImpl;

public class EgenKontroll {
    PsiTabellObject pto_projektname;
    Vector<Vector<PsiTabell>> vec_tabell;
    String plats;
    String kontakt;
    String kund;
    String ansvarig;
    String foretag;

    public EgenKontroll() {
        this.preAmakodTabell();
        this.postAmamkodTabell();
    }

    public EgenKontroll(Projekt currentProject) {
        this.preAmakodTabell();
        this.amakodTabell1(currentProject);
        this.postAmamkodTabell();
    }

    public Vector<PsiTabell> getTabell(int index) {
        return this.vec_tabell.get(index);
    }

    private void preAmakodTabell() {
        this.vec_tabell = new Vector();
        Vector<PsiTabell> tabeller = new Vector<PsiTabell>();
        Vector<Object> listObject = new Vector<Object>();
        listObject.add("H\u00e4rmed intygas att");
        listObject.add("OK");
        listObject.add("M\u00e5lningsbehandling av rubr.objekt har utf\u00f6rts av yrkeskunning personal i enlighet med av uppdragsgivaren utf\u00e4rdade best\u00e4llningshandlingar, till\u00e4mpliga lag- och byggkrav samt \u00f6vriga redovisade dokument s\u00e5som m\u00f6tesprotokoll, avvikelsehandlingar etc");
        listObject.add("");
        listObject.add("Arbetet har utf\u00f6rts enligt f\u00e4rdtillverkarens anvisningar och god m\u00e5leritradition.");
        listObject.add("");
        listObject.add("Till\u00e4mpliga lagar och f\u00f6rordningar g\u00e4llande milj\u00f6skydd har f\u00f6ljts.");
        listObject.add("");
        listObject.add("Endast godk\u00e4nda st\u00e4llningar, liftar och skyddsanordningar har anv\u00e4nts");
        listObject.add("");
        int[] columnweight = new int[]{9, 1};
        PsiTabell intygstabell = PsiTabellFactory.buildPsiTabell("Egenkontroll", listObject, 2, columnweight);
        int[] columnweight0 = new int[]{2, 1, 1};
        Vector<Object> listObject0 = new Vector<Object>();
        listObject0.add("Egenkontroll utf\u00f6rd av:");
        listObject0.add("Datum");
        listObject0.add("Sign");
        listObject0.add(" ");
        listObject0.add(" ");
        listObject0.add(" ");
        PsiTabell egenkontrolltabell = PsiTabellFactory.buildPsiTabell("Egenkontroll", listObject0, 3, columnweight0);
        PsiTabellObject cellObject = egenkontrolltabell.getCellObject(0, 1);
        cellObject.setTextSize(40);
        tabeller.add(intygstabell);
        tabeller.add(egenkontrolltabell);
        this.vec_tabell.add(tabeller);
    }

    private void amakodTabell1(Projekt currentProject) {
        this.pto_projektname = new PsiTabellObjectImpl((Object)currentProject.getFileReference().getName(), 18, PsiTabellObject.TextSetting.FAT);
        KalkylNod knod = currentProject.getRader();
        Enumeration<TreeNode> dfs = knod.depthFirstEnumeration();
        while (dfs.hasMoreElements()) {
            KalkylNod nextNod = (KalkylNod)dfs.nextElement();
            if (!nextNod.okToPrint) continue;
            int[] columnweight = new int[]{2, 1, 9, 2};
            Vector<Object> listObject = new Vector<Object>();
            listObject.add("Del");
            listObject.add(" ");
            listObject.add("\u00c5tg\u00e4rd");
            listObject.add("Utf\u00f6rt");
            String rubrik = nextNod.getBeskrivning();
            PsiTabell rumsnodtabell = PsiTabellFactory.buildPsiTabell(rubrik, listObject, 4, columnweight);
            Vector<PsiTabell> tabeller = new Vector<PsiTabell>();
            tabeller.add(rumsnodtabell);
            for (RadStruct rader : nextNod.getRader()) {
                listObject = new Vector();
                listObject.add(rader.getByggdel().getId() + " - " + rader.getDescription());
                listObject.add(rader.getF\u00f6rbehandlingID());
                String fullDescription = "Ingen f\u00f6rbehandling f\u00f6r egen behandling " + rader.getBehKod();
                try {
                    fullDescription = currentProject.getDatabaseInstance().getBehandling(BehandlingsTyp.F\u00f6rbehandling, rader).getDescription();
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                listObject.add(fullDescription);
                listObject.add(" ");
                String biffo = rader.getUnderlagID() + rader.getYtmaterialID() + "-";
                listObject.add(biffo);
                listObject.add(rader.getUnderbehandlingID());
                fullDescription = "Ingen underbehandling f\u00f6r egen behandling " + rader.getBehKod();
                try {
                    fullDescription = currentProject.getDatabaseInstance().getBehandling(BehandlingsTyp.Underbehandling, rader).getDescription();
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                listObject.add(fullDescription);
                listObject.add(" ");
                String miffo = rader.getKulor();
                if (miffo != null) {
                    listObject.add(miffo);
                } else {
                    listObject.add(" ");
                }
                listObject.add(rader.getF\u00e4rdigbehandlingID());
                fullDescription = "Ingen f\u00e4rdigbehandling f\u00f6r egen behandling " + rader.getBehKod();
                try {
                    fullDescription = currentProject.getDatabaseInstance().getBehandling(BehandlingsTyp.F\u00e4rdigbehandling, rader).getDescription();
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                listObject.add(fullDescription);
                listObject.add(" ");
                rubrik = " ";
                rumsnodtabell = PsiTabellFactory.buildPsiTabell(rubrik, listObject, 4, columnweight);
                tabeller.add(rumsnodtabell);
            }
            this.vec_tabell.add(tabeller);
        }
    }

    private void postAmamkodTabell() {
    }

    public PsiTabellObject getProjektNamn() {
        return this.pto_projektname;
    }

    public void setPlats(String plats) {
        this.plats = plats;
    }

    public void setKontakt(String kontakt) {
        this.kontakt = kontakt;
    }

    public void setKund(String kund) {
        this.kund = kund;
    }

    public void setAnsvarig(String ansvarig) {
        this.ansvarig = ansvarig;
    }

    public void setF\u00f6retag(String foretag) {
        this.foretag = foretag;
    }

    int getNumberOfpages() {
        return this.vec_tabell.size();
    }
}

