/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.util.pdf;

import com.itextpdf.text.Chunk;
import com.itextpdf.text.Document;
import com.itextpdf.text.Element;
import com.itextpdf.text.FontFactory;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.TreeNode;
import se.sjobeck.datastructures.KalkylNod;
import se.sjobeck.datastructures.Projekt;
import se.sjobeck.datastructures.kalkylering.RadStruct;
import se.sjobeck.gui.DialogCreator;
import se.sjobeck.util.pdf.Content;
import se.sjobeck.util.pdf.Kolumn;

abstract class AbstractTabell
implements Content {
    public boolean rumsvis = false;
    public Kolumn[] kolumner;
    public int[] bredder;
    public String[] rubriker;
    public int kantbredd = 1;

    AbstractTabell() {
    }

    @Override
    public void addContent(Document doc, Projekt proj, File outputFile, boolean printFolders) {
        try {
            PdfPTable tabell = new PdfPTable(this.bredder.length);
            tabell.setWidths(this.bredder);
            tabell.setWidthPercentage(100.0f);
            this.addHeaders(tabell, this.rubriker);
            KalkylNod nod = proj.getRader();
            Comparator<RadStruct> comp = new Comparator<RadStruct>(){

                private int byggdelValue(String s) {
                    switch (s.charAt(0)) {
                        case 'G': {
                            return -4;
                        }
                        case 'S': {
                            return -3;
                        }
                        case 'V': {
                            return -2;
                        }
                        case 'T': {
                            return -1;
                        }
                    }
                    return s.charAt(0);
                }

                @Override
                public int compare(RadStruct rad1, RadStruct rad2) {
                    int byggdel2;
                    int ret = 0;
                    int byggdel1 = this.byggdelValue(rad1.getDescription());
                    ret = byggdel1 * (byggdel2 = this.byggdelValue(rad2.getDescription())) > 0 ? byggdel2 - byggdel1 : byggdel1 - byggdel2;
                    return ret;
                }
            };
            if (this.rumsvis) {
                PdfPCell titleCell = new PdfPCell();
                titleCell.setPaddingTop(1.0f);
                titleCell.setColspan(this.kolumner.length);
                titleCell.setBorder(0);
                titleCell.setGrayFill(0.8f);
                Enumeration<TreeNode> dfs = nod.depthFirstEnumeration();
                while (dfs.hasMoreElements()) {
                    KalkylNod nextNode = (KalkylNod)dfs.nextElement();
                    if (!nextNode.okToPrint || !nextNode.isLeaf() && !printFolders) continue;
                    Phrase title = new Phrase(new Chunk(nextNode.getPathName(), FontFactory.getFont((String)"Helvetica-Bold", (float)10.0f)));
                    titleCell.setPhrase(title);
                    tabell.addCell(titleCell);
                    List<RadStruct> vec = nextNode.getRader();
                    Collections.sort(vec, comp);
                    this.addRows(tabell, this.kolumner, vec, proj);
                }
            } else if (nod.okToPrint) {
                List<RadStruct> vec = nod.getPrintableRader();
                Collections.sort(vec, comp);
                this.addRows(tabell, this.kolumner, vec, proj);
            }
            doc.add((Element)tabell);
        }
        catch (Exception e) {
            DialogCreator.showError((Object)"Kunde inte skriva ut korrekt, kontrollera felaktiga rader", (String)"Felaktiga kalkylrader");
            e.printStackTrace();
        }
    }

    private void addHeaders(PdfPTable tabell, String[] rubriker) {
        tabell.getDefaultCell().setBorderWidth(1.0f);
        tabell.getDefaultCell().setHorizontalAlignment(1);
        for (String s : rubriker) {
            tabell.addCell(s);
        }
        tabell.setHeaderRows(1);
        tabell.getDefaultCell().setBorderWidth(0.0f);
    }

    abstract void addRows(PdfPTable var1, Kolumn[] var2, List<RadStruct> var3, Projekt var4);

    protected void cellFontGrayAdding(PdfPTable tabell, String s, int alignment) {
        float grayfill = tabell.getDefaultCell().getGrayFill();
        PdfPCell p = new PdfPCell();
        Phrase phrase = new Phrase(new Chunk(s, FontFactory.getFont((String)"Helvetica", (float)10.0f)));
        p.setPhrase(phrase);
        p.setHorizontalAlignment(alignment);
        p.setBorder(0);
        p.setGrayFill(grayfill);
        tabell.addCell(p);
    }
}

