/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.gui;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import se.sjobeck.datastructures.Projekt;
import se.sjobeck.datastructures.XLCell;
import se.sjobeck.datastructures.XLNod;
import se.sjobeck.gui.AntialiasedJLabel;
import se.sjobeck.gui.SelectingEditor;
import se.sjobeck.gui.multilinetable2.MultilineAwareRowHeader;
import se.sjobeck.gui.multilinetable2.TextAreaRenderer;
import se.sjobeck.parser2.Function;
import se.sjobeck.util.StaticHelpers;

public class XLPanel
extends JPanel {
    private XLModel model;
    private JScrollPane jScrollPane1;
    private JTable jTable1;
    protected JLabel titel;

    public XLPanel() {
        Logger.getLogger("se.sjobeck").entering("XLPanel", "[constructor]");
        this.initComponents();
        this.model = new XLModel();
        this.jTable1.setModel(this.model);
        XLRenderer renderer = new XLRenderer();
        Enumeration<TableColumn> tcs = this.jTable1.getColumnModel().getColumns();
        while (tcs.hasMoreElements()) {
            tcs.nextElement().setCellRenderer((TableCellRenderer)((Object)renderer));
        }
        this.jTable1.setDefaultEditor(Object.class, new XLEditor());
        MultilineAwareRowHeader rowHead = new MultilineAwareRowHeader(this.jTable1);
        this.jScrollPane1.setRowHeaderView((Component)rowHead);
        Logger.getLogger("se.sjobeck").exiting("XLPanel", "[constructor]");
    }

    public void setNode(XLNod n) {
        this.model.setNode(n.getProject(), n);
        this.titel.setText(n.getBeskrivning());
    }

    private void initComponents() {
        this.titel = new AntialiasedJLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new XLTable();
        this.setLayout(new GridBagLayout());
        this.titel.setFont(new Font("SansSerif", 1, 24));
        this.titel.setIcon(new ImageIcon(this.getClass().getResource("/org/tangoProject/large/x-office-spreadsheet.png")));
        this.titel.setText("jLabel1");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(20, 24, 20, 5);
        this.add((Component)this.titel, gridBagConstraints);
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable1.setAutoResizeMode(0);
        this.jTable1.setCellSelectionEnabled(true);
        this.jScrollPane1.setViewportView(this.jTable1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 24, 5, 5);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
    }

    private class XLTable
    extends JTable {
        private XLTable() {
        }

        @Override
        public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
            if (this.isEditing()) {
                return;
            }
            super.changeSelection(rowIndex, columnIndex, toggle, extend);
        }

        @Override
        public boolean editCellAt(int row, int column, EventObject e) {
            if (this.isEditing() && e instanceof MouseEvent) {
                return false;
            }
            return super.editCellAt(row, column, e);
        }
    }

    private class XLRenderer
    extends TextAreaRenderer {
        private TextAreaRenderer left = new TextAreaRenderer();
        private TextAreaRenderer right = new TextAreaRenderer(2);

        XLRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            double number = Function.getValue((String)value.toString(), (List[])new List[]{XLPanel.this.model.getFunctions(), XLPanel.this.model.getConstants()});
            if (Double.isNaN(number)) {
                return this.left.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
            return this.right.getTableCellRendererComponent(table, (Object)StaticHelpers.format2Dec((double)number), isSelected, hasFocus, row, column);
        }
    }

    private class XLEditor
    extends SelectingEditor
    implements MouseListener {
        private JTable table;

        XLEditor() {
            super(new JTextField());
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
            this.table = table;
            for (MouseListener m : table.getMouseListeners()) {
                if (!m.equals(this)) continue;
                return super.getTableCellEditorComponent(table, value, isSelected, row, col);
            }
            table.addMouseListener(this);
            return super.getTableCellEditorComponent(table, value, isSelected, row, col);
        }

        @Override
        public void cancelCellEditing() {
            this.table.removeMouseListener(this);
            super.cancelCellEditing();
        }

        @Override
        public boolean stopCellEditing() {
            if (super.stopCellEditing()) {
                this.table.removeMouseListener(this);
                return true;
            }
            return false;
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int col = this.table.columnAtPoint(e.getPoint());
            int row = this.table.rowAtPoint(e.getPoint());
            String s = XLPanel.this.model.getColumnName(col) + (row + 1);
            String previous = this.delegate.getCellEditorValue().toString();
            if (previous == null) {
                this.delegate.setValue(s);
            } else {
                String trimmed = previous.trim();
                if (trimmed.length() == 0) {
                    this.delegate.setValue(previous + s);
                    return;
                }
                switch (trimmed.charAt(trimmed.length() - 1)) {
                    case '*': 
                    case '+': 
                    case '-': 
                    case '/': {
                        this.delegate.setValue(previous + s);
                        break;
                    }
                    default: {
                        this.delegate.setValue(previous + "+" + s);
                    }
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    private class XLModel
    extends AbstractTableModel {
        private Projekt currentProject;
        private XLNod currentNode;
        private Vector<Function> fs = new Vector();

        private XLModel() {
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (this.currentNode == null) {
                return "";
            }
            for (XLCell cell : this.currentNode.celler) {
                if (cell.x != col || cell.y != row) continue;
                return cell.formel;
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return true;
        }

        @Override
        public int getColumnCount() {
            return 10;
        }

        @Override
        public int getRowCount() {
            return 100;
        }

        public void setNode(Projekt project, XLNod n) {
            this.currentProject = project;
            this.currentNode = n;
            this.buildFunctions();
            super.fireTableDataChanged();
        }

        @Override
        public void setValueAt(Object o, int row, int col) {
            this.currentNode.editCell(o.toString(), row, col);
            this.buildFunctions();
            super.fireTableDataChanged();
        }

        private void buildFunctions() {
            this.fs.clear();
            for (XLCell cell : this.currentNode.celler) {
                Function newFunction = new Function(super.getColumnName(cell.x) + (cell.y + 1), cell.formel, null);
                this.fs.add(newFunction);
            }
        }

        public Vector<Function> getFunctions() {
            return this.fs;
        }

        public Vector<Function> getConstants() {
            return this.currentProject.getKonstanter();
        }
    }
}

