/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.gui;

import java.util.List;
import se.sjobeck.datastructures.RumNod;
import se.sjobeck.gui.FunctionTableModel;
import se.sjobeck.parser2.Function;
import se.sjobeck.util.StaticHelpers;

public class VariableTableModel
extends FunctionTableModel {
    private RumNod currentNode = null;

    public void setNode(RumNod newNode) {
        this.currentNode = newNode;
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        try {
            return this.currentNode.getVariabler().size() / 2 + this.currentNode.getVariabler().size() % 2;
        }
        catch (NullPointerException e) {
            return 0;
        }
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public String getColumnName(int col) {
        switch (col % 2) {
            case 0: {
                return "Namn";
            }
            case 1: {
                return "V\u00e4rde";
            }
        }
        return null;
    }

    @Override
    public Function getFunction(int row, int col) {
        if (this.mapRow(row, col) < this.currentNode.getVariabler().size()) {
            return this.currentNode.getVariabler().elementAt(this.mapRow(row, col));
        }
        return null;
    }

    public int mapRow(int row, int col) {
        if (col == -1 || row == -1) {
            return 0;
        }
        return 2 * row + col / 2;
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (this.mapRow(row, column) >= this.currentNode.getVariabler().size()) {
            return null;
        }
        Function v = this.getFunction(row, column);
        switch (column % 2) {
            case 0: {
                return v.getDescription() + " (" + v.getIdentifier() + ")";
            }
            case 1: {
                try {
                    return StaticHelpers.format2Dec((double)v.getValue(new List[]{this.currentNode.getVariabler(), this.currentNode.getProject().getKonstanter()}));
                }
                catch (IllegalArgumentException e) {
                    return "#";
                }
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        Function v = this.getFunction(rowIndex, columnIndex);
        switch (columnIndex % 2) {
            case 0: {
                v.setDescription(aValue.toString());
                break;
            }
            case 1: {
                v.setValueStr(aValue.toString());
            }
        }
        this.fireTableDataChanged();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex % 2 != 0 && this.mapRow(rowIndex, columnIndex) < this.currentNode.getVariabler().size();
    }

    public boolean isCellPredefined(int rowIndex, int columnIndex) {
        Function f = this.getFunction(rowIndex, columnIndex);
        return f != null && f.isPredefined();
    }
}

