/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import se.sjobeck.datastructures.Drawing;
import se.sjobeck.datastructures.ProjectManager;
import se.sjobeck.datastructures.RumNod;
import se.sjobeck.datastructures.TlgStruct;
import se.sjobeck.datastructures.kalkylering.Byggdel;
import se.sjobeck.datastructures.kalkylering.RadStruct;
import se.sjobeck.datastructures.kalkylering.TillaggsKategori;
import se.sjobeck.gui.Ackumulerat;
import se.sjobeck.gui.AliasesListModel;
import se.sjobeck.gui.AntialiasedJLabel;
import se.sjobeck.gui.FetchDialog;
import se.sjobeck.gui.FocusPolicy;
import se.sjobeck.gui.FunctionEditor;
import se.sjobeck.gui.HidingCheckBoxList;
import se.sjobeck.gui.KalkylGUI;
import se.sjobeck.gui.MyCellRenderer;
import se.sjobeck.gui.ShowGeometraDrawingOrDrawing;
import se.sjobeck.gui.SplitPaneFactory;
import se.sjobeck.gui.StatistikPanel;
import se.sjobeck.gui.VariableTableCellRenderer;
import se.sjobeck.gui.VariableTableModel;
import se.sjobeck.gui.undo.DeleteRows;

public class RumPanel
extends JPanel
implements ListDataListener {
    private KalkylGUI gui;
    private VariableTableModel variableTableModel;
    private RumNod currentNode;
    private RadStruct[] copyObject;
    private FetchDialog fetchDialog;
    private AliasesListModel aliasMap;
    private ProjectManager projectManager;
    private TableModelListener variableTableListener = new TableModelListener(){

        @Override
        public void tableChanged(TableModelEvent e) {
            RumPanel.this.projectManager.getCurrentProject().recalculate(RumPanel.this.projectManager.getCurrentKalkylNod());
            RumPanel.this.rumRader.repaint();
            ((StatistikPanel)RumPanel.this.statistik).updateStatistics();
        }
    };
    private Observer treeObserver = new Observer(){

        @Override
        public void update(Observable o, Object arg) {
            if (arg != null && arg.equals(RumPanel.this.currentNode)) {
                RumPanel.this.titel.setText(RumPanel.this.currentNode.getBeskrivning());
                ((StatistikPanel)RumPanel.this.statistik).updateStatistics();
            }
        }
    };
    private ActionListener aliasItemListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent evt) {
            RadStruct[] rader = RumPanel.this.aliasMap.getRows(((JMenuItem)evt.getSource()).getText());
            for (int i = rader.length - 1; i >= 0; --i) {
                ((Ackumulerat)RumPanel.this.rumRader).addRow(rader[i]);
            }
        }
    };
    private int currentDrawing = 0;
    private final ListSelectionListener mlsl = new MyListSelectionListener();
    private JMenuItem addAlias;
    private JPanel contents;
    private JPanel imagePanel;
    private JMenu insertAliasedRow;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSplitPane jSplitPane1;
    private JSplitPane jSplitPane2;
    private JSplitPane jSplitPane3;
    protected JPanel rumRader;
    private JList rumstill\u00e4gg_jList;
    private JPanel statistik;
    private JMenuItem tableCopy;
    private JMenuItem tableCut;
    private JMenuItem tableDelete;
    private JMenuItem tableExtendedEdit;
    private JMenuItem tableFetch;
    private JMenuItem tableInsert;
    private JMenuItem tablePaste;
    private JPopupMenu tablePopup;
    private JMenuItem tableSetDefault;
    protected JLabel titel;
    private JTable variabelTabell;

    public RumPanel(final KalkylGUI gui, ProjectManager manager) {
        Logger.getLogger("se.sjobeck").entering("RumPanel", "[constructor]");
        Logger.getLogger("se.sjobeck.gui.RumPanel").info("Bygger gr\u00e4nssnitt... Rum-panel");
        this.gui = gui;
        this.projectManager = manager;
        this.fetchDialog = new FetchDialog(gui, manager);
        this.variableTableModel = new VariableTableModel();
        this.initComponents();
        Preferences RumPanel2 = Preferences.userNodeForPackage(this.getClass());
        ((Ackumulerat)this.rumRader).jTable1.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            private void maybeShowPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    int row = ((Ackumulerat)RumPanel.this.rumRader).jTable1.rowAtPoint(e.getPoint());
                    int col = ((Ackumulerat)RumPanel.this.rumRader).jTable1.columnAtPoint(e.getPoint());
                    RumPanel.this.tableExtendedEdit.setEnabled(((Ackumulerat)RumPanel.this.rumRader).jTable1.isCellEditable(row, col));
                    RumPanel.this.tablePopup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        InputMap im = this.variabelTabell.getInputMap(1);
        ActionMap am = this.variabelTabell.getActionMap();
        AbstractAction customTabbingAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTable table = (JTable)e.getSource();
                int row = table.getSelectedRow();
                int col = table.getSelectedColumn();
                if (col != -1 && row != -1 && (!table.isEditing() || table.getCellEditor().stopCellEditing())) {
                    do {
                        if (++row != table.getRowCount()) continue;
                        row = 0;
                        if (++col < table.getColumnCount()) continue;
                        RumPanel.this.rumRader.grabFocus();
                        return;
                    } while (!table.getModel().isCellEditable(row, col) || RumPanel.this.variableTableModel.isCellPredefined(row, col));
                    table.setRowSelectionInterval(row, row);
                    table.setColumnSelectionInterval(col, col);
                }
            }
        };
        am.put(im.get(KeyStroke.getKeyStroke("pressed ENTER")), customTabbingAction);
        im.put(KeyStroke.getKeyStroke("pressed TAB"), im.get(KeyStroke.getKeyStroke("pressed ENTER")));
        TableColumnModel cModel = this.variabelTabell.getColumnModel();
        VariableTableCellRenderer left = new VariableTableCellRenderer(this.variableTableModel, 0);
        VariableTableCellRenderer center = new VariableTableCellRenderer(this.variableTableModel, 1);
        cModel.getColumn(0).setCellRenderer((TableCellRenderer)((Object)left));
        cModel.getColumn(1).setCellRenderer((TableCellRenderer)((Object)center));
        cModel.getColumn(2).setCellRenderer((TableCellRenderer)((Object)left));
        cModel.getColumn(3).setCellRenderer((TableCellRenderer)((Object)center));
        FunctionEditor fedit = new FunctionEditor(this.variableTableModel);
        cModel.getColumn(1).setCellEditor(fedit);
        cModel.getColumn(3).setCellEditor(fedit);
        this.variabelTabell.getTableHeader().setReorderingAllowed(false);
        this.variableTableModel.addTableModelListener(this.variableTableListener);
        this.variabelTabell.changeSelection(0, 1, false, false);
        am = ((Ackumulerat)this.rumRader).jTable1.getActionMap();
        im = ((Ackumulerat)this.rumRader).jTable1.getInputMap(1);
        AbstractAction previousAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                gui.previousLeaf();
                ((Ackumulerat)RumPanel.this.rumRader).grabFocus();
            }
        };
        AbstractAction nextAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                gui.nextLeaf();
                ((Ackumulerat)RumPanel.this.rumRader).grabFocus();
            }
        };
        AbstractAction fetchAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RumPanel.this.fetchRow();
            }
        };
        AbstractAction copyAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RumPanel.this.copyRow();
            }
        };
        AbstractAction cutAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RumPanel.this.cutRow();
            }
        };
        AbstractAction pasteAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RumPanel.this.pasteRow();
            }
        };
        AbstractAction insertAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RumPanel.this.insertRow();
            }
        };
        AbstractAction deleteAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RumPanel.this.deleteRow();
            }
        };
        am.put("copy", copyAction);
        am.put("paste", pasteAction);
        am.put("cut", cutAction);
        am.put("doInsert", insertAction);
        im.put(KeyStroke.getKeyStroke("pressed INSERT"), "doInsert");
        am.put("deleteRow", deleteAction);
        im.put(KeyStroke.getKeyStroke("shift pressed DELETE"), "deleteRow");
        am.put("nextLeaf", nextAction);
        im.put(KeyStroke.getKeyStroke("shift pressed RIGHT"), "nextLeaf");
        am.put("previousLeaf", previousAction);
        im.put(KeyStroke.getKeyStroke("shift pressed LEFT"), "previousLeaf");
        am.put("fetchRow", fetchAction);
        im.put(KeyStroke.getKeyStroke("pressed F12"), "fetchRow");
        this.aliasMap = gui.getAliasList();
        this.aliasMap.addListDataListener(this);
        this.contentsChanged(null);
        Logger.getLogger("se.sjobeck").exiting("RumPanel", "[constructor]");
        this.statistik.setVisible(false);
        ((ShowGeometraDrawingOrDrawing)this.imagePanel).getDrawingPanel().setManager(this.projectManager);
        ((ShowGeometraDrawingOrDrawing)this.imagePanel).getDrawingPanel().setRumPanel(this);
        this.rumstill\u00e4gg_jList.setCellRenderer(new MyCellRenderer());
    }

    public void tableGrabFocus() {
        this.rumRader.grabFocus();
    }

    public void updatePanel() {
        this.currentNode = (RumNod)this.projectManager.getCurrentNod();
        this.currentNode.getProject().setTreeObserver(this.treeObserver);
        this.titel.setText(this.currentNode.getBeskrivning());
        if (this.currentNode.getDrawing() == null) {
            this.currentNode.setDrawing(Drawing.standard[0].copy());
            this.currentDrawing = 0;
        }
        ((ShowGeometraDrawingOrDrawing)this.imagePanel).setDrawing(this.currentNode.getDrawing());
        this.variableTableModel.setNode(this.currentNode);
        ((StatistikPanel)this.statistik).setCurrentNode(this.currentNode);
        this.variabelTabell.setColumnSelectionInterval(1, 1);
        this.variabelTabell.setRowSelectionInterval(0, 0);
        ((Ackumulerat)this.rumRader).setNode(this.currentNode);
        this.update_rumstill\u00e4ggslista();
    }

    private void update_rumstill\u00e4ggslista() {
        List get = (List)this.projectManager.getCurrentProject().getDatabaseInstance().getTill\u00e4ggsTabell().get(TillaggsKategori.Hinder.stringReference());
        Object[] toArray = get.toArray();
        List rader = this.currentNode.getRader();
        Vector<TlgStruct> selected_ones = new Vector<TlgStruct>();
        for (RadStruct rs : rader) {
            for (TlgStruct ts : rs.getTillagg()) {
                if (!get.contains(ts) || selected_ones.contains(ts)) continue;
                selected_ones.add(ts);
            }
        }
        if (this.currentNode instanceof RumNod && this.currentNode.golvYta() < 8.0 && this.currentNode.takYtaPlussV\u00e4ggyta() < 20.0) {
            TlgStruct nr641 = null;
            for (TlgStruct ts : get) {
                if (!ts.getAckpunkt().equals("641")) continue;
                nr641 = ts;
            }
            if (nr641 != null && !selected_ones.contains(nr641)) {
                selected_ones.add(nr641);
            }
        }
        this.rumstill\u00e4gg_jList.setListData(toArray);
        HidingCheckBoxList hcbl = (HidingCheckBoxList)this.rumstill\u00e4gg_jList;
        for (TlgStruct ts : selected_ones) {
            hcbl.setSelectedValue(ts, false);
        }
        if (((Vector)rader).size() > 0) {
            HidingCheckBoxList.setInomhus(((RadStruct)((Vector)rader).get(0)).getInomhus());
            HidingCheckBoxList.setUtomhus(!((RadStruct)((Vector)rader).get(0)).getInomhus());
        }
    }

    private RumNod currentNode() {
        if (this.currentNode == null) {
            throw new IllegalArgumentException();
        }
        return this.currentNode;
    }

    public void deleteRow() {
        DeleteRows edit = new DeleteRows(this.projectManager.getCurrentRumNod(), ((Ackumulerat)this.rumRader).getSelectedRows());
        this.gui.addUndoable(this.projectManager.getCurrentProject(), edit);
        ((Ackumulerat)this.rumRader).deleteSelected();
        this.currentNode.invalidate();
    }

    public void insertRow() {
        ((Ackumulerat)this.rumRader).insertRow();
        this.currentNode.invalidate();
    }

    public void setDefault() {
        ((Ackumulerat)this.rumRader).setDefault();
    }

    private void setCopyObject() {
        RadStruct[] tmp = ((Ackumulerat)this.rumRader).getSelectedRows();
        this.copyObject = new RadStruct[tmp.length];
        for (int i = 0; i < tmp.length; ++i) {
            try {
                this.copyObject[i] = (RadStruct)tmp[i].clone();
                continue;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
    }

    private void initComponents() {
        this.tablePopup = new JPopupMenu();
        this.tableExtendedEdit = new JMenuItem();
        this.insertAliasedRow = new JMenu();
        this.jMenuItem1 = new JMenuItem();
        this.jMenuItem2 = new JMenuItem();
        this.tableCut = new JMenuItem();
        this.tableCopy = new JMenuItem();
        this.tablePaste = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.tableInsert = new JMenuItem();
        this.tableDelete = new JMenuItem();
        this.tableFetch = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.tableSetDefault = new JMenuItem();
        this.addAlias = new JMenuItem();
        this.statistik = new StatistikPanel(this.projectManager);
        this.titel = new AntialiasedJLabel();
        this.jSplitPane2 = SplitPaneFactory.createSplitPane((Window)this.gui, (String)"rumPanel1");
        this.contents = new JPanel();
        this.rumRader = new Ackumulerat(this.gui, this.projectManager, false, true);
        this.jSplitPane1 = SplitPaneFactory.createSplitPane((Window)this.gui, (String)"rumPanel2");
        this.imagePanel = new ShowGeometraDrawingOrDrawing();
        this.jSplitPane3 = new JSplitPane();
        this.jScrollPane2 = new JScrollPane();
        this.rumstill\u00e4gg_jList = new HidingCheckBoxList();
        this.rumstill\u00e4gg_jList.addListSelectionListener(this.mlsl);
        this.jScrollPane1 = new JScrollPane();
        this.variabelTabell = new JTable();
        this.tableExtendedEdit.setAction(((Ackumulerat)this.rumRader).getExtendedEditingAction());
        this.tableExtendedEdit.setAccelerator(KeyStroke.getKeyStroke(113, 0));
        this.tableExtendedEdit.setText("Redigera");
        this.tablePopup.add(this.tableExtendedEdit);
        this.insertAliasedRow.setIcon(new ImageIcon(this.getClass().getResource("/org/tangoProject/small/format-indent-more.png")));
        this.insertAliasedRow.setText("Infoga Recept");
        this.jMenuItem1.setText("Test 1");
        this.insertAliasedRow.add(this.jMenuItem1);
        this.jMenuItem2.setText("Item");
        this.insertAliasedRow.add(this.jMenuItem2);
        this.tablePopup.add(this.insertAliasedRow);
        this.tableCut.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.tableCut.setIcon(new ImageIcon(this.getClass().getResource("/org/tangoProject/small/edit-cut.png")));
        this.tableCut.setText("Klipp ut");
        this.tableCut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RumPanel.this.tableCutActionPerformed(evt);
            }
        });
        this.tablePopup.add(this.tableCut);
        this.tableCopy.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.tableCopy.setIcon(new ImageIcon(this.getClass().getResource("/org/tangoProject/small/edit-copy.png")));
        this.tableCopy.setText("Kopiera");
        this.tableCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RumPanel.this.tableCopyActionPerformed(evt);
            }
        });
        this.tablePopup.add(this.tableCopy);
        this.tablePaste.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        this.tablePaste.setIcon(new ImageIcon(this.getClass().getResource("/org/tangoProject/small/edit-paste.png")));
        this.tablePaste.setText("Klistra in");
        this.tablePaste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RumPanel.this.tablePasteActionPerformed(evt);
            }
        });
        this.tablePopup.add(this.tablePaste);
        this.tablePopup.add(this.jSeparator2);
        this.tableInsert.setAccelerator(KeyStroke.getKeyStroke(155, 0));
        this.tableInsert.setIcon(new ImageIcon(this.getClass().getResource("/com/sun/javaLookAndFeelIcons/toolbarButtonGraphics/table/RowInsertAfter16.gif")));
        this.tableInsert.setText("L\u00e4gg till rad");
        this.tableInsert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RumPanel.this.tableInsertActionPerformed(evt);
            }
        });
        this.tablePopup.add(this.tableInsert);
        this.tableDelete.setAccelerator(KeyStroke.getKeyStroke(127, 1));
        this.tableDelete.setIcon(new ImageIcon(this.getClass().getResource("/com/sun/javaLookAndFeelIcons/toolbarButtonGraphics/table/RowDelete16.gif")));
        this.tableDelete.setText("Ta bort rad");
        this.tableDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RumPanel.this.tableDeleteActionPerformed(evt);
            }
        });
        this.tablePopup.add(this.tableDelete);
        this.tableFetch.setAccelerator(KeyStroke.getKeyStroke(72, 2));
        this.tableFetch.setIcon(new ImageIcon(this.getClass().getResource("/org/tangoProject/small/go-jump.png")));
        this.tableFetch.setText("H\u00e4mta rad");
        this.tableFetch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RumPanel.this.tableFetchActionPerformed(evt);
            }
        });
        this.tablePopup.add(this.tableFetch);
        this.tablePopup.add(this.jSeparator1);
        this.tableSetDefault.setText("G\u00f6r till standard-rad");
        this.tableSetDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RumPanel.this.tableSetDefaultActionPerformed(evt);
            }
        });
        this.tablePopup.add(this.tableSetDefault);
        this.addAlias.setIcon(new ImageIcon(this.getClass().getResource("/org/tangoProject/small/format-indent-more.png")));
        this.addAlias.setText("G\u00f6r ett recept av markerade rader");
        this.addAlias.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RumPanel.this.addAliasActionPerformed(evt);
            }
        });
        this.tablePopup.add(this.addAlias);
        this.setFocusTraversalPolicy((FocusTraversalPolicy)new FocusPolicy(new Component[]{this.variabelTabell}));
        this.setFocusTraversalPolicyProvider(true);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 24, 5, 5);
        this.add((Component)this.statistik, gridBagConstraints);
        this.titel.setFont(new Font("SansSerif", 1, 24));
        this.titel.setIcon(new ImageIcon(this.getClass().getResource("/org/tangoProject/large/x-office-spreadsheet.png")));
        this.titel.setText("jLabel1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(15, 24, 15, 5);
        this.add((Component)this.titel, gridBagConstraints);
        this.jSplitPane2.setOrientation(0);
        this.jSplitPane2.setResizeWeight(0.5);
        this.contents.setLayout(new GridBagLayout());
        this.rumRader.setBorder(BorderFactory.createTitledBorder("Kalkylrader"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.contents.add((Component)this.rumRader, gridBagConstraints);
        this.jSplitPane2.setLeftComponent(this.contents);
        this.jSplitPane1.setResizeWeight(0.5);
        this.imagePanel.setBorder(BorderFactory.createTitledBorder("Grafik"));
        this.imagePanel.setOpaque(false);
        this.jSplitPane1.setLeftComponent(this.imagePanel);
        this.jSplitPane3.setOrientation(0);
        this.jSplitPane3.setResizeWeight(0.5);
        this.jScrollPane2.setBorder(BorderFactory.createTitledBorder("Rumstill\u00e4gg"));
        this.jScrollPane2.setViewportView(this.rumstill\u00e4gg_jList);
        this.jSplitPane3.setTopComponent(this.jScrollPane2);
        this.jScrollPane1.setBorder(BorderFactory.createTitledBorder("Rumsm\u00e5tt"));
        this.variabelTabell.setModel(this.variableTableModel);
        this.variabelTabell.setCellSelectionEnabled(true);
        this.variabelTabell.setIntercellSpacing(new Dimension(0, 0));
        this.variabelTabell.setOpaque(false);
        this.variabelTabell.setShowHorizontalLines(false);
        this.variabelTabell.setShowVerticalLines(false);
        this.jScrollPane1.setViewportView(this.variabelTabell);
        this.jSplitPane3.setRightComponent(this.jScrollPane1);
        this.jSplitPane1.setRightComponent(this.jSplitPane3);
        this.jSplitPane2.setRightComponent(this.jSplitPane1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 24, 5, 5);
        this.add((Component)this.jSplitPane2, gridBagConstraints);
    }

    private void addAliasActionPerformed(ActionEvent evt) {
        RadStruct[] rader = ((Ackumulerat)this.rumRader).getSelectedRows();
        String namn = "";
        while (KalkylGUI.invalidAlias(namn, this.gui.getAliasList(), this)) {
            if ((namn = (String)JOptionPane.showInputDialog(this.gui, "Ange namn", "Beteckning f\u00f6r raden", -1, null, null, namn)) == null) {
                return;
            }
            namn = namn.toUpperCase();
        }
        if (namn != null) {
            RadStruct[] copy = new RadStruct[rader.length];
            for (int i = 0; i < copy.length; ++i) {
                copy[i] = rader[i].copy();
            }
            this.aliasMap.addEntry(namn, copy);
        }
    }

    private void tableInsertActionPerformed(ActionEvent evt) {
        this.insertRow();
    }

    private void tableDeleteActionPerformed(ActionEvent evt) {
        this.deleteRow();
    }

    private void tableSetDefaultActionPerformed(ActionEvent evt) {
        this.setDefault();
    }

    private void tableCopyActionPerformed(ActionEvent evt) {
        this.copyRow();
    }

    private void tableCutActionPerformed(ActionEvent evt) {
        this.cutRow();
    }

    private void tablePasteActionPerformed(ActionEvent evt) {
        this.pasteRow();
    }

    private void tableFetchActionPerformed(ActionEvent evt) {
        this.fetchRow();
    }

    public void fetchRow() {
        ((Ackumulerat)this.rumRader).appendRows(this.fetchDialog.showDialog());
        this.currentNode.invalidate();
        this.updatePanel();
    }

    public void pasteRow() {
        if (this.copyObject != null) {
            for (int i = this.copyObject.length - 1; i >= 0; --i) {
                ((Ackumulerat)this.rumRader).addRow(this.copyObject[i]);
            }
            this.currentNode.invalidate();
        }
    }

    public void cutRow() {
        this.setCopyObject();
        DeleteRows edit = new DeleteRows(this.projectManager.getCurrentRumNod(), ((Ackumulerat)this.rumRader).getSelectedRows());
        this.gui.addUndoable(this.projectManager.getCurrentProject(), edit);
        ((Ackumulerat)this.rumRader).deleteSelected();
        this.currentNode.invalidate();
    }

    public void copyRow() {
        this.setCopyObject();
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        this.insertAliasedRow.removeAll();
        for (int i = 0; i < this.aliasMap.getSize(); ++i) {
            JMenuItem item = new JMenuItem((String)this.aliasMap.getElementAt(i));
            item.addActionListener(this.aliasItemListener);
            this.insertAliasedRow.add(item);
        }
        this.insertAliasedRow.setEnabled(this.insertAliasedRow.getItemCount() > 0);
    }

    private class MyListSelectionListener
    implements ListSelectionListener {
        private MyListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                Object[] sv = RumPanel.this.rumstill\u00e4gg_jList.getSelectedValues();
                Vector<TlgStruct> selectedValues = new Vector<TlgStruct>();
                for (Object obj : sv) {
                    if (!(obj instanceof TlgStruct)) continue;
                    selectedValues.add((TlgStruct)obj);
                }
                List allValues = (List)RumPanel.this.projectManager.getCurrentProject().getDatabaseInstance().getTill\u00e4ggsTabell().get(TillaggsKategori.Hinder.stringReference());
                TlgStruct nr641 = null;
                for (TlgStruct ts : selectedValues) {
                    if (!ts.getAckpunkt().equals("641")) continue;
                    nr641 = ts;
                }
                List rader = RumPanel.this.currentNode.getRader();
                for (RadStruct rs : rader) {
                    String enhet;
                    TlgStruct[] fumo = rs.getTillagg();
                    List<TlgStruct> remove_stuff = this.remove_stuff(fumo, allValues);
                    remove_stuff.addAll(selectedValues);
                    if (rs.getByggdel() != Byggdel.V\u00e4gg && rs.getByggdel() != Byggdel.Tak && nr641 != null) {
                        remove_stuff.remove(nr641);
                    } else if (!(rs.getByggdel() != Byggdel.V\u00e4gg && rs.getByggdel() != Byggdel.Tak || nr641 == null || (enhet = ((Ackumulerat)RumPanel.this.rumRader).getEnhet(rs)).equals("m\u00b2"))) {
                        remove_stuff.remove(nr641);
                    }
                    rs.setTillagg(remove_stuff.toArray(new TlgStruct[remove_stuff.size()]));
                }
                RumPanel.this.rumRader.repaint();
                ((StatistikPanel)RumPanel.this.statistik).updateStatistics();
            }
        }

        private List<TlgStruct> remove_stuff(TlgStruct[] changethis, List<TlgStruct> toberemoved) {
            Vector<TlgStruct> newone = new Vector<TlgStruct>();
            for (TlgStruct ts : changethis) {
                if (toberemoved.contains(ts)) continue;
                newone.add(ts);
            }
            return newone;
        }
    }
}

