/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.gui;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import se.sjobeck.datastructures.ConstantsNode;
import se.sjobeck.datastructures.CustomAMANod;
import se.sjobeck.datastructures.EditableRadTable;
import se.sjobeck.datastructures.FabrikatNod;
import se.sjobeck.datastructures.GrenNod;
import se.sjobeck.datastructures.KalkylNod;
import se.sjobeck.datastructures.KommentarNod;
import se.sjobeck.datastructures.RumNod;
import se.sjobeck.datastructures.TimprisNod;
import se.sjobeck.datastructures.XLNod;
import se.sjobeck.datastructures.kalkylering.RadStruct;
import se.sjobeck.gui.KalkylGUI;
import se.sjobeck.util.StaticHelpers;

public class ProjectTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static Icon rootIcon = new ImageIcon(KalkylGUI.class.getResource("/org/tangoProject/medium/go-home.png"));
    private static Icon branchIcon = new ImageIcon(KalkylGUI.class.getResource("/org/tangoProject/medium/x-directory-normal.png"));
    private static Icon openBranchIcon = new ImageIcon(KalkylGUI.class.getResource("/org/tangoProject/medium/x-directory-normal-open.png"));
    private static Icon leafIcon = new ImageIcon(KalkylGUI.class.getResource("/org/tangoProject/medium/x-office-spreadsheet.png"));
    private static Icon commentIcon = new ImageIcon(KalkylGUI.class.getResource("/org/tangoProject/medium/emblem-important.png"));
    private static Icon priceIcon = new ImageIcon(KalkylGUI.class.getResource("/org/tangoProject/medium/image-loading.png"));
    private static Icon errorIcon = new ImageIcon(KalkylGUI.class.getResource("/org/tangoProject/medium/dialog-warning.png"));
    private static Icon xlIcon = new ImageIcon(KalkylGUI.class.getResource("/org/tangoProject/medium/x-office-spreadsheet.png"));

    private boolean hasErrors(KalkylNod nod) {
        block4: {
            block3: {
                if (!(nod instanceof GrenNod)) break block3;
                for (int i = 0; i < nod.getChildCount(); ++i) {
                    if (!this.hasErrors((KalkylNod)nod.getChildAt(i))) continue;
                    return true;
                }
                break block4;
            }
            if (!(nod instanceof RumNod)) break block4;
            for (RadStruct r : nod.getRader()) {
                for (int i = 0; i < 12; ++i) {
                    if (!EditableRadTable.hasErrors(r, i, nod)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Icon icon;
        KalkylNod nod = (KalkylNod)value;
        String text = nod.toString();
        if (nod.isRoot()) {
            icon = rootIcon;
        } else if (nod instanceof RumNod) {
            text = nod.toString() + " [" + StaticHelpers.format2Dec((double)nod.getAntal()) + " st]";
            icon = leafIcon;
        } else if (nod instanceof XLNod) {
            icon = xlIcon;
        } else if (nod instanceof KommentarNod) {
            icon = commentIcon;
        } else if (nod instanceof TimprisNod) {
            icon = priceIcon;
        } else if (nod instanceof ConstantsNode) {
            icon = commentIcon;
        } else if (nod instanceof CustomAMANod) {
            icon = commentIcon;
        } else if (nod instanceof FabrikatNod) {
            icon = commentIcon;
            text = "Projektf\u00f6ruts\u00e4ttningar";
        } else {
            text = nod.toString() + " [" + StaticHelpers.format2Dec((double)nod.getAntal()) + " st]";
            icon = expanded ? openBranchIcon : branchIcon;
        }
        Component c = super.getTreeCellRendererComponent(tree, text, selected, expanded, leaf, row, hasFocus);
        try {
            if (this.hasErrors(nod)) {
                ((JLabel)c).setIcon(errorIcon);
            } else {
                ((JLabel)c).setIcon(icon);
            }
        }
        catch (Exception e) {
            ((JLabel)c).setIcon(errorIcon);
        }
        return c;
    }
}

