/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.gui;

import java.awt.Point;
import java.util.Vector;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import se.sjobeck.datastructures.GrenNod;
import se.sjobeck.datastructures.KommentarNod;
import se.sjobeck.datastructures.RumNod;
import se.sjobeck.datastructures.XLNod;
import se.sjobeck.gui.dndtree.DNDTree;
import se.sjobeck.gui.dndtree.DefaultTreeTransferHandler;

public class NodeTreeTransferHandler
extends DefaultTreeTransferHandler {
    private TreeSelectionListener listener;

    public NodeTreeTransferHandler(DNDTree tree, TreeSelectionListener listener) {
        super(tree, 2);
    }

    public boolean canPerformAction(DNDTree target, DefaultMutableTreeNode draggedNode, int action, Point location) {
        TreePath pathTarget = target.getPathForLocation(location.x, location.y);
        if (pathTarget == null) {
            target.setSelectionPath(null);
            return false;
        }
        target.setSelectionPath(pathTarget);
        if (action == 2) {
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)pathTarget.getLastPathComponent();
            return !draggedNode.isNodeDescendant(parentNode) && !parentNode.isRoot() && this.isTreeNode(parentNode) && this.isTreeNode(draggedNode);
        }
        return false;
    }

    public boolean executeDrop(DNDTree target, DefaultMutableTreeNode draggedNode, DefaultMutableTreeNode newParentNode, int index, Vector expandedStates, int action) {
        return this.validate(draggedNode.getParent()) && super.executeDrop(target, draggedNode, newParentNode, index, expandedStates, action) && this.validate(draggedNode);
    }

    private boolean validate(TreeNode node) {
        if (node instanceof RumNod) {
            ((RumNod)node).invalidate();
        } else if (node instanceof GrenNod) {
            ((GrenNod)node).invalidate();
        }
        return true;
    }

    private boolean isTreeNode(DefaultMutableTreeNode node) {
        return node instanceof RumNod || node instanceof GrenNod || node instanceof XLNod || node instanceof KommentarNod;
    }
}

