/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.gui;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import se.sjobeck.datastructures.GrenNod;
import se.sjobeck.datastructures.KalkylNod;
import se.sjobeck.datastructures.ProjectManager;
import se.sjobeck.datastructures.RumNod;
import se.sjobeck.datastructures.kalkylering.RadStruct;
import se.sjobeck.util.StaticHelpers;

class NodeTableModel
extends AbstractTableModel {
    private KalkylNod currentNode = KalkylNod.nullValue;
    Vector<KalkylNod> noder = new Vector();
    private ProjectManager projectManager;
    boolean ascending = true;
    int sortColumn = -1;
    private Comparator<KalkylNod> nodComparator = new Comparator<KalkylNod>(){

        @Override
        public int compare(KalkylNod n1, KalkylNod n2) {
            int compare;
            switch (NodeTableModel.this.sortColumn) {
                case -1: {
                    return 0;
                }
                case 0: {
                    compare = n1.getBeskrivning().compareTo(n2.getBeskrivning());
                    break;
                }
                case 1: {
                    compare = Double.compare(n1.getAntal(), n2.getAntal());
                    break;
                }
                case 2: {
                    compare = Double.compare(NodeTableModel.this.totalKostnad(n1.getRader()), NodeTableModel.this.totalKostnad(n2.getRader()));
                    break;
                }
                case 3: {
                    compare = Double.compare(n1.getAntal() * NodeTableModel.this.totalKostnad(n1.getRader()), n2.getAntal() * NodeTableModel.this.totalKostnad(n2.getRader()));
                    break;
                }
                case 4: {
                    compare = Double.compare(n1.getAntal() * NodeTableModel.this.totalTid(n1.getRader()), n2.getAntal() * NodeTableModel.this.totalTid(n2.getRader()));
                    break;
                }
                case 5: {
                    compare = Double.compare(NodeTableModel.this.totalKostnad(n1.getRader()) / n1.golvYta(), NodeTableModel.this.totalKostnad(n2.getRader()) / n2.golvYta());
                    break;
                }
                case 6: {
                    compare = Double.compare(NodeTableModel.this.totalTid(n1.getRader()) / n1.golvYta(), NodeTableModel.this.totalTid(n2.getRader()) / n2.golvYta());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Sorting index out of bounds!");
                }
            }
            if (!NodeTableModel.this.ascending) {
                compare *= -1;
            }
            return compare;
        }
    };

    NodeTableModel(ProjectManager manager) {
        this.projectManager = manager;
    }

    public void setData(KalkylNod parent) {
        this.currentNode = parent;
        this.noder.removeAllElements();
        for (int i = 0; i < this.currentNode.getChildCount(); ++i) {
            this.noder.add((KalkylNod)this.currentNode.getChildAt(i));
        }
        this.performSort();
    }

    @Override
    public int getRowCount() {
        return this.noder.size();
    }

    @Override
    public int getColumnCount() {
        return 7;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return "Delobjekt";
            }
            case 1: {
                return "Antal";
            }
            case 2: {
                return "\u00e1 pris";
            }
            case 3: {
                return "Total";
            }
            case 4: {
                return "Tid";
            }
            case 5: {
                return "Kostnad / m\u00b2";
            }
            case 6: {
                return "Tid / m\u00b2";
            }
        }
        return "Error.";
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (row >= this.noder.size() || row < 0) {
            return "Error";
        }
        try {
            KalkylNod nod = this.noder.get(row);
            if (nod instanceof GrenNod || nod instanceof RumNod) {
                switch (column) {
                    case 0: {
                        return nod.getBeskrivning();
                    }
                    case 1: {
                        return StaticHelpers.format2Dec((double)nod.getAntal());
                    }
                    case 2: {
                        return StaticHelpers.format2Dec((double)this.totalKostnad(nod.getRader()));
                    }
                    case 3: {
                        return StaticHelpers.format2Dec((double)(nod.getAntal() * this.totalKostnad(nod.getRader())));
                    }
                    case 4: {
                        return StaticHelpers.tidFormat((double)(nod.getAntal() * this.totalTid(nod.getRader())));
                    }
                    case 5: {
                        return StaticHelpers.format2Dec((double)(this.totalKostnad(nod.getRader()) / nod.golvYta()));
                    }
                    case 6: {
                        return StaticHelpers.tidFormat((double)(this.totalTid(nod.getRader()) / nod.golvYta()));
                    }
                }
                return "Error";
            }
            switch (column) {
                case 0: {
                    return nod.getBeskrivning();
                }
            }
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private double totalTid(List<RadStruct> blad) {
        double ret = 0.0;
        for (RadStruct struct : blad) {
            ret += this.projectManager.getCurrentProject().getRadHanterare().getTidPerEnh(struct) * struct.getAntalEnh();
        }
        return ret;
    }

    private double totalKostnad(List<RadStruct> blad) {
        double ret = 0.0;
        for (RadStruct struct : blad) {
            ret += this.projectManager.getCurrentProject().getRadHanterare().getPrisPerEnh(struct) * struct.getAntalEnh();
        }
        return ret;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        KalkylNod nod = this.noder.get(rowIndex);
        if (columnIndex == 0) {
            nod.setBeskrivning((String)aValue);
        } else if (columnIndex == 1) {
            nod.setAntal((String)aValue);
        }
        this.performSort();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0 || columnIndex == 1;
    }

    public boolean isLeaf(int row) {
        return this.noder.get(row).isLeaf();
    }

    public void sortByColumn(int colNum) {
        this.ascending = colNum == this.sortColumn ? !this.ascending : true;
        this.sortColumn = colNum;
        this.performSort();
    }

    public void reorder(int start, int end) {
        KalkylNod temp = this.noder.get(start);
        this.noder.set(start, this.noder.get(end));
        this.noder.set(end, temp);
        this.sortByColumn(-1);
    }

    public int getSortingColumn() {
        return this.sortColumn;
    }

    private void performSort() {
        Collections.sort(this.noder, this.nodComparator);
        this.fireTableDataChanged();
    }
}

