/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import javax.swing.text.BadLocationException;
import se.sjobeck.datastructures.GrenNod;
import se.sjobeck.datastructures.KalkylNod;
import se.sjobeck.datastructures.ProjectManager;
import se.sjobeck.datastructures.Projekt;
import se.sjobeck.datastructures.TlgStruct;
import se.sjobeck.datastructures.kalkylering.Fabrikat;
import se.sjobeck.datastructures.kalkylering.ProjektInfo;
import se.sjobeck.datastructures.kalkylering.RadHanterare;
import se.sjobeck.datastructures.kalkylering.RadStruct;
import se.sjobeck.datastructures.kalkylering.TimprisStruct;
import se.sjobeck.datastructures.kalkylering.UE_OvrigaKostnader;
import se.sjobeck.gui.AntialiasedJLabel;
import se.sjobeck.gui.DialogCreator;
import se.sjobeck.gui.FabrikatListCellRenderer;
import se.sjobeck.gui.MyIntegerInputVerifier;
import se.sjobeck.gui.Tillagg;
import se.sjobeck.gui.model.DataBaseChooserComboBoxModel;
import se.sjobeck.gui.model.DateWrapper;
import se.sjobeck.gui.models.UE_OvrigaKostnaderTableModel;
import se.sjobeck.images.IconLoader;
import se.sjobeck.util.StaticHelpers;
import se.sjobeck.util.pdf.OutputGenerator;
import se.sjobeck.util.pdf.ProjektSammanstallning;
import se.sjobeck.util.pdf.PsiTabell;
import se.sjobeck.util.pdf.PsiTabellFactory;

public class FilePanel
extends JPanel
implements TableModelListener {
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private Map<String, ProjektInfo> summaries;
    private ProjectManager manager;
    private Map<String, String> descriptions;
    private ImageIcon fileIcon = IconLoader.getIcon((String)"/org/tangoProject/large/go-home.png");
    private ImageIcon directoryIcon = IconLoader.getIcon((String)"/org/tangoProject/large/x-directory-normal.png");
    private Map<String, String> sammanst\u00e4llning = new Hashtable<String, String>();
    private DocumentListener updateListener = new DocumentListener(){

        @Override
        public void changedUpdate(DocumentEvent e) {
            Logger.getLogger("se.sjobeck").entering("FilePanel.documentListener", "changedUpdate", e);
            this.updateDescription();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            Logger.getLogger("se.sjobeck").entering("FilePanel.documentListener", "insertUpdate", e);
            this.updateDescription();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            Logger.getLogger("se.sjobeck").entering("FilePanel.documentListener", "removeUpdate", e);
            this.updateDescription();
        }

        private void updateDescription() {
            Logger.getLogger("se.sjobeck").finer("fileDescriptions.put(" + FilePanel.this.filnamn.getText() + ", " + FilePanel.this.filBeskrivning.getText() + ")");
            FilePanel.this.descriptions.put(FilePanel.this.filnamn.getText(), FilePanel.this.filBeskrivning.getText());
        }
    };
    private JComboBox DataBaseComboBox;
    private JComboBox ackgrProcent;
    private JButton addUEOKjButton;
    private JLabel dbTimeLabel;
    private JComboBox fargCombo;
    public JComboBox fastkost;
    private JEditorPane filBeskrivning;
    private JLabel filnamn;
    private JCheckBox jCheckBox1;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel102;
    private JLabel jLabel103;
    private JLabel jLabel104;
    private JLabel jLabel105;
    private JLabel jLabel106;
    private JLabel jLabel107;
    private JLabel jLabel108;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel22;
    private JLabel jLabel23;
    private JLabel jLabel24;
    private JLabel jLabel25;
    private JLabel jLabel26;
    private JLabel jLabel27;
    private JLabel jLabel28;
    private JLabel jLabel29;
    private JLabel jLabel3;
    private JLabel jLabel30;
    private JLabel jLabel31;
    private JLabel jLabel32;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JLabel jLabel90;
    private JLabel jLabel96;
    private JPanel jPanel1;
    private JPanel jPanel10;
    private JPanel jPanel11;
    private JPanel jPanel12;
    private JPanel jPanel13;
    private JPanel jPanel14;
    private JPanel jPanel15;
    private JPanel jPanel16;
    private JPanel jPanel17;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private JTabbedPane jTabbedPane1;
    private JTable jTable1;
    private JPanel mainPanel;
    public JComboBox matpristlg;
    public JComboBox overtid;
    private JButton removeUEOKjButton;
    public JComboBox reskostkm;
    public JComboBox reskostkr;
    public JComboBox tidlon;
    private JPanel tillagg;
    public JComboBox timlon;
    public JLabel timpris;
    public JComboBox traktDag;
    public JComboBox traktNatt;
    public JComboBox vinst;
    private ProjektInfo projektInfo = null;
    private boolean ignoreJCombo = true;
    private final ActionListener reskostkmActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent evt) {
            FilePanel.this.projektInfo.getTimprisStruct().setReskostKmPerDag(FilePanel.this.parseDouble(FilePanel.this.reskostkm));
            FilePanel.this.updateTimprisOchSammanst\u00e4llning();
        }
    };
    private final ActionListener reskostkrActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent evt) {
            FilePanel.this.projektInfo.getTimprisStruct().setReskostKrPerDag(FilePanel.this.parseDouble(FilePanel.this.reskostkr));
            FilePanel.this.updateTimprisOchSammanst\u00e4llning();
        }
    };
    private final ActionListener traktDagActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent evt) {
            FilePanel.this.projektInfo.getTimprisStruct().setTraktamentePerDag(FilePanel.this.parseDouble(FilePanel.this.traktDag));
            FilePanel.this.updateTimprisOchSammanst\u00e4llning();
        }
    };
    private final ActionListener traktNattActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent evt) {
            FilePanel.this.projektInfo.getTimprisStruct().setTraktamentePerNatt(FilePanel.this.parseDouble(FilePanel.this.traktNatt));
            FilePanel.this.updateTimprisOchSammanst\u00e4llning();
        }
    };
    private final ActionListener timlonActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent evt) {
            FilePanel.this.projektInfo.getTimprisStruct().setTimlon(FilePanel.this.parseDouble(FilePanel.this.timlon));
            FilePanel.this.updateTimprisOchSammanst\u00e4llning();
        }
    };
    private final ActionListener overtidActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent evt) {
            FilePanel.this.projektInfo.getTimprisStruct().setOvertidsTlg(FilePanel.this.parseDouble(FilePanel.this.overtid));
            FilePanel.this.updateTimprisOchSammanst\u00e4llning();
        }
    };
    private final ActionListener fastkostActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent evt) {
            FilePanel.this.projektInfo.getTimprisStruct().setFastKostnad(FilePanel.this.parseDouble(FilePanel.this.fastkost));
            FilePanel.this.updateTimprisOchSammanst\u00e4llning();
        }
    };
    private final ActionListener vinstActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent evt) {
            FilePanel.this.projektInfo.getTimprisStruct().setVinst(FilePanel.this.parseDouble(FilePanel.this.vinst));
            FilePanel.this.updateTimprisOchSammanst\u00e4llning();
        }
    };
    private final ActionListener tidlonActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent evt) {
            FilePanel.this.projektInfo.getTimprisStruct().setTidlonPct(FilePanel.this.parseDouble(FilePanel.this.tidlon));
            FilePanel.this.updateTimprisOchSammanst\u00e4llning();
        }
    };
    private final ActionListener ackgrLonProcent = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            double value = 1.0;
            Object b = FilePanel.this.ackgrProcent.getSelectedItem();
            if (b instanceof String) {
                String c = (String)b;
                try {
                    c = c.replace(',', '.');
                    Double valueOf = Double.valueOf(c);
                    value = 1.0 + 0.01 * valueOf;
                }
                catch (NumberFormatException nfe) {}
            } else if (b instanceof Integer) {
                Integer c = (Integer)b;
                value = 1.0 + 0.01 * (double)c.intValue();
            } else if (b instanceof Double) {
                Double val = (Double)b;
                value = 1.0 + 0.01 * val;
            }
            FilePanel.this.manager.getCurrentProject().setAckPrisProcent(value);
            FilePanel.this.updateTimprisOchSammanst\u00e4llning();
        }
    };
    private final Map<JComboBox, ActionListener> actionMap;

    public FilePanel(Map<String, ProjektInfo> summaries, Map<String, String> descriptions, ProjectManager manager) {
        assert (summaries != null);
        assert (manager != null);
        assert (descriptions != null);
        this.summaries = summaries;
        this.manager = manager;
        this.descriptions = descriptions;
        this.initComponents();
        this.fargCombo.setRenderer(new FabrikatListCellRenderer());
        this.actionMap = new HashMap<JComboBox, ActionListener>(){
            {
                this.put(FilePanel.this.reskostkm, FilePanel.this.reskostkmActionListener);
                this.put(FilePanel.this.reskostkr, FilePanel.this.reskostkrActionListener);
                this.put(FilePanel.this.traktDag, FilePanel.this.traktDagActionListener);
                this.put(FilePanel.this.traktNatt, FilePanel.this.traktNattActionListener);
                this.put(FilePanel.this.timlon, FilePanel.this.timlonActionListener);
                this.put(FilePanel.this.overtid, FilePanel.this.overtidActionListener);
                this.put(FilePanel.this.fastkost, FilePanel.this.fastkostActionListener);
                this.put(FilePanel.this.vinst, FilePanel.this.vinstActionListener);
                this.put(FilePanel.this.tidlon, FilePanel.this.tidlonActionListener);
                this.put(FilePanel.this.ackgrProcent, FilePanel.this.ackgrLonProcent);
            }
        };
    }

    private void addAnteckningar(ProjektSammanstallning projektSammanst\u00e4llning) {
        try {
            PsiTabell buildEnklaRaderMedTextTabell = PsiTabellFactory.buildEnklaRaderMedTextTabell("Anteckningar", this.filBeskrivning.getDocument().getText(0, this.filBeskrivning.getDocument().getLength()) + "\n");
            projektSammanst\u00e4llning.addPsiTabell(buildEnklaRaderMedTextTabell);
        }
        catch (BadLocationException ex) {
            Logger.getLogger(FilePanel.class.getName()).log(Level.SEVERE, null, ex);
            projektSammanst\u00e4llning.addPsiTabell(PsiTabellFactory.buildEnklaRaderMedTextTabell("n\u00e5t fel med anteckningar", "troligen \u00e4r det getDocument() som g\u00e5tt s\u00f6nder"));
        }
    }

    private double timmarTidlon() {
        Object selectedItem = this.tidlon.getSelectedItem();
        double fd = 0.0;
        if (selectedItem instanceof Double) {
            fd = (Double)selectedItem;
        } else if (selectedItem instanceof String) {
            fd = StaticHelpers.toDouble((String)((String)selectedItem));
        } else if (selectedItem instanceof Integer) {
            fd = (double)((Integer)selectedItem).intValue() * 1.0;
        }
        String t = "";
        String f = this.jLabel25.getText();
        for (int i = 0; i < f.length(); ++i) {
            if ("0123456789,.".indexOf(f.charAt(i)) <= -1) continue;
            t = t + f.charAt(i);
        }
        return StaticHelpers.toDouble((String)t) * fd * 0.01;
    }

    private void addDebiteringSammanst\u00e4llningIhopSlagna(ProjektSammanstallning projektSammanst\u00e4llning) {
        Vector<Object> fudo = new Vector<Object>();
        String timmarTidlon = StaticHelpers.format2Dec((double)this.timmarTidlon());
        fudo.add(this.jLabel7.getText() + " kr/tim");
        fudo.add(this.timlon.getSelectedItem());
        fudo.add(this.jLabel6.getText() + " (ackordsgrundl\u00f6n)");
        fudo.add(this.jLabel14.getText());
        fudo.add(this.jLabel104.getText());
        fudo.add(this.fastkost.getSelectedItem());
        fudo.add(this.jLabel8.getText());
        fudo.add(this.jLabel15.getText());
        fudo.add(this.jLabel13.getText() + " kr/tim");
        fudo.add(this.overtid.getSelectedItem());
        fudo.add(this.jLabel9.getText());
        fudo.add(this.jLabel16.getText());
        fudo.add(this.jLabel105.getText());
        fudo.add(this.vinst.getSelectedItem());
        fudo.add(this.jLabel2.getText());
        fudo.add(this.jLabel26.getText());
        fudo.add("Reskostnad " + this.jLabel90.getText());
        fudo.add(this.reskostkm.getSelectedItem());
        fudo.add(this.jLabel10.getText());
        fudo.add(this.jLabel17.getText());
        fudo.add("Reskostnad " + this.jLabel96.getText());
        fudo.add(this.reskostkr.getSelectedItem());
        fudo.add(this.jLabel22.getText());
        fudo.add(this.jLabel23.getText());
        fudo.add("Traktamente " + this.jLabel102.getText());
        fudo.add(this.traktDag.getSelectedItem());
        fudo.add(this.jLabel11.getText());
        fudo.add(this.jLabel18.getText());
        fudo.add("Traktamente " + this.jLabel103.getText());
        fudo.add(this.traktNatt.getSelectedItem());
        fudo.add(this.jLabel12.getText());
        fudo.add(this.jLabel19.getText());
        fudo.add(this.jLabel106.getText() + " (exkl moms)");
        fudo.add(this.timpris.getText());
        fudo.add(this.jLabel20.getText());
        fudo.add(this.jLabel21.getText());
        fudo.add(this.jLabel106.getText() + " (inkl moms)");
        fudo.add(Double.parseDouble(this.timpris.getText()) * 1.25);
        fudo.add(this.jLabel24.getText() + " (inkl tidl\u00f6n)");
        fudo.add(this.jLabel25.getText());
        fudo.add(this.jLabel108.getText());
        fudo.add(this.tidlon.getSelectedItem());
        fudo.add("Timmar tidl\u00f6n");
        fudo.add(timmarTidlon);
        int[] lullul = new int[]{32, 34, 40};
        int[] columnWeight = new int[]{2, 1, 2, 1};
        PsiTabell bfkmtoell = PsiTabellFactory.buildFyraKolumnerMedTextOchExtraLulLul("Debitering", fudo, lullul, columnWeight);
        projektSammanst\u00e4llning.addPsiTabell(bfkmtoell);
    }

    private void addDebitering(ProjektSammanstallning projektSammanst\u00e4llning) throws NumberFormatException {
        Vector<Object> fudo = new Vector<Object>();
        fudo.add(this.jLabel7.getText() + " kr/tim");
        fudo.add(this.timlon.getSelectedItem());
        fudo.add(this.jLabel104.getText());
        fudo.add(this.fastkost.getSelectedItem());
        fudo.add(this.jLabel13.getText() + " kr/tim");
        fudo.add(this.overtid.getSelectedItem());
        fudo.add(this.jLabel105.getText());
        fudo.add(this.vinst.getSelectedItem());
        fudo.add("Reskostnad");
        fudo.add("");
        fudo.add("Traktamente");
        fudo.add("");
        fudo.add("Reskostnad " + this.jLabel90.getText());
        fudo.add(this.reskostkm.getSelectedItem());
        fudo.add(this.jLabel102.getText());
        fudo.add(this.traktDag.getSelectedItem());
        fudo.add("Reskostnad " + this.jLabel96.getText());
        fudo.add(this.reskostkr.getSelectedItem());
        fudo.add(this.jLabel103.getText());
        fudo.add(this.traktNatt.getSelectedItem());
        fudo.add("Debitering exkl moms");
        fudo.add("");
        fudo.add("Debitering inl moms");
        fudo.add("");
        fudo.add(this.jLabel106.getText());
        fudo.add(this.timpris.getText());
        fudo.add(this.jLabel106.getText());
        fudo.add(Double.parseDouble(this.timpris.getText()) * 1.25);
        fudo.add(this.jLabel108.getText());
        fudo.add(this.tidlon.getSelectedItem());
        fudo.add("");
        fudo.add("");
        int[] lullul = new int[]{9, 11, 21, 23};
        int[] columnWeight = new int[]{1, 1, 1, 1};
        PsiTabell bfkmtoell = PsiTabellFactory.buildFyraKolumnerMedTextOchExtraLulLul("Debitering", fudo, lullul, columnWeight);
        projektSammanst\u00e4llning.addPsiTabell(bfkmtoell);
    }

    private void addNyckelTal(ProjektSammanstallning projektSammanst\u00e4llning) {
        Vector<Object> fudo = new Vector<Object>();
        float golvyta = 1.0f;
        for (int i = 0; i < ((Projekt)this.projektInfo).getRootNode().getChildCount(); ++i) {
            if (!((KalkylNod)((Projekt)this.projektInfo).getRootNode().getChildAt(i)).getBeskrivning().equals("Total")) continue;
            golvyta = (float)((GrenNod)((Projekt)this.projektInfo).getRootNode().getChildAt(i)).golvYta();
        }
        double gf = (StaticHelpers.toDouble((String)this.jLabel14.getText()) + StaticHelpers.toDouble((String)this.jLabel15.getText()) + StaticHelpers.toDouble((String)this.jLabel17.getText()) + StaticHelpers.toDouble((String)this.jLabel23.getText()) + StaticHelpers.toDouble((String)this.jLabel18.getText())) / StaticHelpers.toDouble((String)this.jLabel14.getText());
        String ogio = StaticHelpers.format2Dec((double)gf);
        fudo.add("Omr\u00e4kningsfaktor grundl\u00f6n inkl ortstill\u00e4gg");
        fudo.add(ogio);
        double f = this.getMatPrisTlg();
        fudo.add("Omr\u00e4kningsfaktor material");
        fudo.add(StaticHelpers.format2Dec((double)(1.0 + f * 0.01)));
        fudo.add("Arbetskostnad / m2 golvyta");
        fudo.add(StaticHelpers.format2Dec((double)(StaticHelpers.toDouble((String)this.jLabel14.getText()) * 1.0 / (double)golvyta)));
        fudo.add("Materialkostnad / m2 golvyta");
        fudo.add(StaticHelpers.format2Dec((double)(StaticHelpers.toDouble((String)this.jLabel16.getText()) * 1.0 / (double)golvyta)));
        fudo.add("Kostnad / m2 golvyta");
        fudo.add(StaticHelpers.format2Dec((double)(StaticHelpers.toDouble((String)this.jLabel19.getText()) * 1.0 / (double)golvyta)));
        projektSammanst\u00e4llning.addPsiTabell(PsiTabellFactory.buildTv\u00e5KolumnerMedText("Nyckeltal", fudo));
    }

    private double getMatPrisTlg() {
        double retValue = 0.0;
        Object obj = this.matpristlg.getSelectedItem();
        if (obj instanceof String) {
            String value = (String)obj;
            return value.charAt(0) == '-' ? -StaticHelpers.toDouble((String)value) : StaticHelpers.toDouble((String)value);
        }
        if (obj instanceof Double) {
            Double d = (Double)obj;
            return d;
        }
        if (obj instanceof Integer) {
            Integer i = (Integer)obj;
            return (double)i.intValue() * 1.0;
        }
        return retValue;
    }

    private void addProjektTill\u00e4gg(ProjektSammanstallning projektSammanst\u00e4llning) {
        TlgStruct[] globalaTillagg;
        Vector<Object> fudo = new Vector<Object>();
        fudo.add("Nummer");
        fudo.add("Avtalstext");
        for (TlgStruct ts : globalaTillagg = this.projektInfo.getGlobalaTillagg()) {
            fudo.add(ts.getAckpunkt());
            String text = ts.getAvtalsText();
            fudo.add(text);
        }
        projektSammanst\u00e4llning.addPsiTabell(PsiTabellFactory.buildTv\u00e5KolumnerMedText("Projekttill\u00e4gg", fudo, 1, 10));
    }

    private void addSammanSt\u00e4llning(ProjektSammanstallning projektSammanst\u00e4llning) {
        Vector<Object> fudo = new Vector<Object>();
        fudo.add(this.jLabel6.getText() + " (ackordsgrundl\u00f6n)");
        fudo.add(this.jLabel14.getText());
        fudo.add(this.jLabel8.getText());
        fudo.add(this.jLabel15.getText());
        fudo.add(this.jLabel9.getText());
        fudo.add(this.jLabel16.getText());
        fudo.add(this.jLabel2.getText());
        fudo.add(this.jLabel26.getText());
        fudo.add(this.jLabel10.getText());
        fudo.add(this.jLabel17.getText());
        fudo.add(this.jLabel22.getText());
        fudo.add(this.jLabel23.getText());
        fudo.add(this.jLabel11.getText());
        fudo.add(this.jLabel18.getText());
        fudo.add(this.jLabel12.getText());
        fudo.add(this.jLabel19.getText());
        fudo.add(this.jLabel20.getText());
        fudo.add(this.jLabel21.getText());
        fudo.add(this.jLabel24.getText());
        fudo.add(this.jLabel25.getText());
        fudo.add("Timmar tidl\u00f6n");
        fudo.add("unknown formula");
        projektSammanst\u00e4llning.addPsiTabell(PsiTabellFactory.buildTv\u00e5KolumnerMedText("Sammanst\u00e4llning", fudo));
    }

    private void addUE\u00d6vrigaKostnader(ProjektSammanstallning projektSammanst\u00e4llning) {
        Vector<Object> fudo = new Vector<Object>();
        fudo.add("Specifikation");
        fudo.add("Belopp kr");
        fudo.add("P\u00e5slag %");
        fudo.add("Pris kr");
        int tot_belopp = 0;
        double tot_pris = 0.0;
        int rad = 1;
        for (int i = 0; i < this.projektInfo.getNumberOfUEOK(); ++i) {
            if (!this.projektInfo.getUEOK(i).isOnOff()) continue;
            ++rad;
            fudo.add(this.projektInfo.getUEOK(i).getText());
            tot_belopp += this.projektInfo.getUEOK(i).getBelopp();
            fudo.add(this.projektInfo.getUEOK(i).getBelopp());
            fudo.add(this.projektInfo.getUEOK(i).getP\u00e5slag());
            double t = this.projektInfo.getUEOK(i).getPris();
            tot_pris += t;
            fudo.add(StaticHelpers.format2Dec((double)t));
        }
        fudo.add("Total");
        fudo.add(tot_belopp);
        fudo.add("");
        fudo.add(StaticHelpers.format2Dec((double)tot_pris));
        int[] lullul_2 = new int[]{4 * rad + 2, 4 * rad + 4};
        int[] columnWeight = new int[]{2, 1, 1, 1};
        projektSammanst\u00e4llning.addPsiTabell(PsiTabellFactory.buildFyraKolumnerMedTextOchExtraLulLul("UE, \u00d6vriga kostnader", fudo, lullul_2, columnWeight));
    }

    private void initComponents() {
        this.filnamn = new AntialiasedJLabel();
        this.jSplitPane1 = new JSplitPane();
        this.jPanel9 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.filBeskrivning = new JEditorPane();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel2 = new JPanel();
        this.jPanel5 = new JPanel();
        this.tillagg = new Tillagg(this);
        this.jPanel13 = new JPanel();
        this.dbTimeLabel = new JLabel();
        this.DataBaseComboBox = new JComboBox();
        this.jLabel27 = new JLabel();
        this.jPanel10 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jPanel11 = new JPanel();
        this.addUEOKjButton = new JButton();
        this.removeUEOKjButton = new JButton();
        this.mainPanel = new JPanel();
        this.jLabel3 = new AntialiasedJLabel();
        this.jPanel6 = new JPanel();
        this.jLabel106 = new JLabel();
        this.timpris = new JLabel();
        this.jLabel108 = new JLabel();
        this.tidlon = new JComboBox();
        this.jPanel7 = new JPanel();
        this.jLabel104 = new JLabel();
        this.fastkost = new JComboBox();
        this.jLabel105 = new JLabel();
        this.vinst = new JComboBox();
        this.jLabel4 = new JLabel();
        this.jPanel17 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jLabel102 = new JLabel();
        this.traktDag = new JComboBox();
        this.jLabel103 = new JLabel();
        this.traktNatt = new JComboBox();
        this.jCheckBox1 = new JCheckBox();
        this.jPanel4 = new JPanel();
        this.jLabel7 = new JLabel();
        this.timlon = new JComboBox();
        this.jLabel13 = new JLabel();
        this.overtid = new JComboBox();
        this.jLabel5 = new JLabel();
        this.jLabel28 = new JLabel();
        this.ackgrProcent = new JComboBox();
        this.jPanel1 = new JPanel();
        this.jLabel90 = new JLabel();
        this.reskostkm = new JComboBox();
        this.jLabel96 = new JLabel();
        this.reskostkr = new JComboBox();
        this.jPanel16 = new JPanel();
        this.jPanel12 = new JPanel();
        this.fargCombo = new JComboBox<Fabrikat>(Fabrikat.values());
        this.jLabel107 = new JLabel();
        this.matpristlg = new JComboBox();
        this.jPanel8 = new JPanel();
        this.jLabel6 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jLabel11 = new JLabel();
        this.jLabel12 = new JLabel();
        this.jLabel14 = new JLabel();
        this.jLabel15 = new JLabel();
        this.jLabel16 = new JLabel();
        this.jLabel17 = new JLabel();
        this.jLabel18 = new JLabel();
        this.jLabel20 = new JLabel();
        this.jLabel21 = new JLabel();
        this.jLabel22 = new JLabel();
        this.jLabel23 = new JLabel();
        this.jLabel24 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel26 = new JLabel();
        this.jPanel14 = new JPanel();
        this.jLabel19 = new JLabel();
        this.jPanel15 = new JPanel();
        this.jLabel25 = new JLabel();
        this.jLabel29 = new JLabel();
        this.jLabel30 = new JLabel();
        this.jLabel31 = new JLabel();
        this.jLabel32 = new JLabel();
        this.setLayout(new GridBagLayout());
        this.filnamn.setFont(new Font("SansSerif", 1, 24));
        this.filnamn.setIcon(new ImageIcon(this.getClass().getResource("/org/tangoProject/large/go-home.png")));
        this.filnamn.setText("Projektnamn:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(20, 24, 20, 5);
        this.add((Component)this.filnamn, gridBagConstraints);
        this.jSplitPane1.setBorder(null);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setResizeWeight(0.5);
        this.jSplitPane1.setDividerLocation(200);
        this.jPanel9.setLayout(new GridBagLayout());
        this.jLabel1.setFont(new Font("SansSerif", 1, 14));
        this.jLabel1.setText("Anteckningar");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        this.jPanel9.add((Component)this.jLabel1, gridBagConstraints);
        this.jScrollPane2.setBorder(BorderFactory.createTitledBorder(""));
        this.filBeskrivning.setBorder(null);
        this.jScrollPane2.setViewportView(this.filBeskrivning);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.weighty = 1.0;
        this.jPanel9.add((Component)this.jScrollPane2, gridBagConstraints);
        this.jSplitPane1.setTopComponent(this.jPanel9);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel5.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.jPanel2.add((Component)this.jPanel5, gridBagConstraints);
        this.tillagg.setName("tillagg");
        this.tillagg.setLayout(new GridLayout(1, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel2.add((Component)this.tillagg, gridBagConstraints);
        this.jPanel13.setLayout(new GridBagLayout());
        this.dbTimeLabel.setText("Projektet anv\u00e4nder databasen fr\u00e5n ...");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanel13.add((Component)this.dbTimeLabel, gridBagConstraints);
        this.DataBaseComboBox.setModel(new DataBaseChooserComboBoxModel());
        this.DataBaseComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilePanel.this.DataBaseComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        this.jPanel13.add((Component)this.DataBaseComboBox, gridBagConstraints);
        this.jLabel27.setText("V\u00e4lj annan databas");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.jPanel13.add((Component)this.jLabel27, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        this.jPanel2.add((Component)this.jPanel13, gridBagConstraints);
        this.jTabbedPane1.addTab("Projekttill\u00e4gg", this.jPanel2);
        this.jPanel10.setLayout(new GridBagLayout());
        this.jTable1.setModel((TableModel)new UE_OvrigaKostnaderTableModel(this.projektInfo));
        this.jTable1.setColumnSelectionAllowed(true);
        this.jTable1.setRowHeight(20);
        this.jTable1.getTableHeader().setReorderingAllowed(false);
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jTable1.getColumnModel().getSelectionModel().setSelectionMode(0);
        this.jTable1.getModel().addTableModelListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel10.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanel11.setLayout(new GridBagLayout());
        this.addUEOKjButton.setText("Ny rad");
        this.addUEOKjButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilePanel.this.addUEOKjButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel11.add((Component)this.addUEOKjButton, gridBagConstraints);
        this.removeUEOKjButton.setText("Ta bort rad");
        this.removeUEOKjButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilePanel.this.removeUEOKjButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel11.add((Component)this.removeUEOKjButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.jPanel10.add((Component)this.jPanel11, gridBagConstraints);
        this.jTabbedPane1.addTab("UE / \u00d6vriga kostnader", this.jPanel10);
        this.jSplitPane1.setRightComponent(this.jTabbedPane1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 10.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 5, 5);
        this.add((Component)this.jSplitPane1, gridBagConstraints);
        this.mainPanel.setLayout(new GridBagLayout());
        this.jLabel3.setFont(new Font("SansSerif", 1, 14));
        this.jLabel3.setText("Debitering");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.jLabel3, gridBagConstraints);
        this.jPanel6.setBorder(BorderFactory.createTitledBorder("Debitering exkl moms"));
        this.jPanel6.setLayout(new GridBagLayout());
        this.jLabel106.setFont(new Font("SansSerif", 0, 12));
        this.jLabel106.setHorizontalAlignment(4);
        this.jLabel106.setText("Timpris");
        this.jLabel106.setToolTipText("<html>" + StaticHelpers.fixhtmltags((String)ResourceBundle.getBundle("se/sjobeck/eKalkyl").getString("toolTip.timpris")) + "</html>");
        this.jLabel106.setFocusable(false);
        this.jLabel106.setHorizontalTextPosition(4);
        this.jLabel106.setMaximumSize(new Dimension(100, 24));
        this.jLabel106.setMinimumSize(new Dimension(100, 24));
        this.jLabel106.setPreferredSize(new Dimension(100, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.jPanel6.add((Component)this.jLabel106, gridBagConstraints);
        this.timpris.setFont(new Font("SansSerif", 3, 14));
        this.timpris.setText("##");
        this.timpris.setToolTipText("<html>" + StaticHelpers.fixhtmltags((String)ResourceBundle.getBundle("se/sjobeck/eKalkyl").getString("toolTip.timpris")) + "</html>");
        this.timpris.setFocusable(false);
        this.timpris.setMaximumSize(new Dimension(100, 24));
        this.timpris.setPreferredSize(new Dimension(70, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.weighty = 1.0;
        this.jPanel6.add((Component)this.timpris, gridBagConstraints);
        this.jLabel108.setFont(new Font("SansSerif", 0, 12));
        this.jLabel108.setHorizontalAlignment(4);
        this.jLabel108.setText("Tidl\u00f6n %");
        this.jLabel108.setToolTipText("<html>" + StaticHelpers.fixhtmltags((String)ResourceBundle.getBundle("se/sjobeck/eKalkyl").getString("toolTip.tidlon")) + "</html>");
        this.jLabel108.setFocusable(false);
        this.jLabel108.setHorizontalTextPosition(4);
        this.jLabel108.setMaximumSize(new Dimension(100, 24));
        this.jLabel108.setMinimumSize(new Dimension(100, 24));
        this.jLabel108.setPreferredSize(new Dimension(110, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.jPanel6.add((Component)this.jLabel108, gridBagConstraints);
        this.tidlon.setEditable(true);
        this.tidlon.setFont(new Font("SansSerif", 1, 12));
        this.tidlon.setModel(new DefaultComboBoxModel<String>(new String[]{"13"}));
        this.tidlon.setToolTipText("<html>" + StaticHelpers.fixhtmltags((String)ResourceBundle.getBundle("se/sjobeck/eKalkyl").getString("toolTip.tidlon")) + "</html>");
        this.tidlon.setAutoscrolls(true);
        this.tidlon.setMaximumSize(new Dimension(140, 24));
        this.tidlon.setMinimumSize(new Dimension(140, 24));
        this.tidlon.setName("vinst");
        this.tidlon.setOpaque(false);
        this.tidlon.setPreferredSize(new Dimension(140, 24));
        this.tidlon.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                FilePanel.this.selectAll(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.weighty = 1.0;
        this.jPanel6.add((Component)this.tidlon, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.mainPanel.add((Component)this.jPanel6, gridBagConstraints);
        this.jPanel7.setBorder(BorderFactory.createTitledBorder("Omkostnader"));
        this.jPanel7.setLayout(new GridBagLayout());
        this.jLabel104.setFont(new Font("SansSerif", 0, 12));
        this.jLabel104.setHorizontalAlignment(4);
        this.jLabel104.setText("Fast kostnad kr/tim");
        this.jLabel104.setToolTipText("<html>" + StaticHelpers.fixhtmltags((String)ResourceBundle.getBundle("se/sjobeck/eKalkyl").getString("toolTip.fastaKostnader")) + "</html>");
        this.jLabel104.setFocusable(false);
        this.jLabel104.setHorizontalTextPosition(4);
        this.jLabel104.setMaximumSize(new Dimension(100, 24));
        this.jLabel104.setMinimumSize(new Dimension(100, 24));
        this.jLabel104.setPreferredSize(new Dimension(100, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.jPanel7.add((Component)this.jLabel104, gridBagConstraints);
        this.fastkost.setEditable(true);
        this.fastkost.setFont(new Font("SansSerif", 1, 12));
        this.fastkost.setModel(new DefaultComboBoxModel<String>(new String[]{"100", "80", "90", "110", "120", "130", "140", "150"}));
        this.fastkost.setToolTipText("<html>" + StaticHelpers.fixhtmltags((String)ResourceBundle.getBundle("se/sjobeck/eKalkyl").getString("toolTip.fastaKostnader")) + "</html>");
        this.fastkost.setAutoscrolls(true);
        this.fastkost.setMaximumSize(new Dimension(140, 24));
        this.fastkost.setMinimumSize(new Dimension(140, 24));
        this.fastkost.setName("fastkost");
        this.fastkost.setOpaque(false);
        this.fastkost.setPreferredSize(new Dimension(140, 24));
        this.fastkost.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilePanel.this.fastkostActionPerformed(evt);
            }
        });
        this.fastkost.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                FilePanel.this.selectAll(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.weighty = 1.0;
        this.jPanel7.add((Component)this.fastkost, gridBagConstraints);
        this.jLabel105.setFont(new Font("SansSerif", 0, 12));
        this.jLabel105.setHorizontalAlignment(4);
        this.jLabel105.setText("Vinstmarginal %");
        this.jLabel105.setToolTipText("<html>" + StaticHelpers.fixhtmltags((String)ResourceBundle.getBundle("se/sjobeck/eKalkyl").getString("toolTip.fastaKostnader")) + "</html>");
        this.jLabel105.setFocusable(false);
        this.jLabel105.setHorizontalTextPosition(4);
        this.jLabel105.setMaximumSize(new Dimension(100, 24));
        this.jLabel105.setMinimumSize(new Dimension(100, 24));
        this.jLabel105.setPreferredSize(new Dimension(100, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.jPanel7.add((Component)this.jLabel105, gridBagConstraints);
        this.vinst.setEditable(true);
        this.vinst.setFont(new Font("SansSerif", 1, 12));
        this.vinst.setModel(new DefaultComboBoxModel<String>(new String[]{"10", "5", "15", "20", "25", "30", "35", "40", "45", "50", "60", "70", "80", "90", "100", ""}));
        this.vinst.setToolTipText("<html>" + StaticHelpers.fixhtmltags((String)ResourceBundle.getBundle("se/sjobeck/eKalkyl").getString("toolTip.fastaKostnader")) + "</html>");
        this.vinst.setAutoscrolls(true);
        this.vinst.setMaximumSize(new Dimension(140, 24));
        this.vinst.setMinimumSize(new Dimension(140, 24));
        this.vinst.setName("vinst");
        this.vinst.setOpaque(false);
        this.vinst.setPreferredSize(new Dimension(140, 24));
        this.vinst.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilePanel.this.vinstActionPerformed(evt);
            }
        });
        this.vinst.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                FilePanel.this.selectAll(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.weighty = 1.0;
        this.jPanel7.add((Component)this.vinst, gridBagConstraints);
        this.jLabel4.setForeground(new Color(0, 0, 255));
        this.jLabel4.setHorizontalAlignment(4);
        this.jLabel4.setText("M\u00e5leribudget");
        this.jLabel4.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                FilePanel.this.jLabel4MouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.jPanel7.add((Component)this.jLabel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weighty = 1.0;
        this.jPanel7.add((Component)this.jPanel17, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.mainPanel.add((Component)this.jPanel7, gridBagConstraints);
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Traktamente"));
        this.jPanel3.setLayout(new GridBagLayout());
        this.jLabel102.setFont(new Font("SansSerif", 0, 12));
        this.jLabel102.setHorizontalAlignment(4);
        this.jLabel102.setText("kr/dag");
        this.jLabel102.setToolTipText("<html>" + StaticHelpers.fixhtmltags((String)ResourceBundle.getBundle("se/sjobeck/eKalkyl").getString("toolTip.traktamente")) + "</html>");
        this.jLabel102.setFocusable(false);
        this.jLabel102.setHorizontalTextPosition(4);
        this.jLabel102.setMaximumSize(new Dimension(100, 24));
        this.jLabel102.setMinimumSize(new Dimension(100, 24));
        this.jLabel102.setPreferredSize(new Dimension(100, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.jPanel3.add((Component)this.jLabel102, gridBagConstraints);
        this.traktDag.setEditable(true);
        this.traktDag.setFont(new Font("SansSerif", 1, 12));
        this.traktDag.setModel(new DefaultComboBoxModel<String>(new String[]{"0", "100", "200"}));
        this.traktDag.setToolTipText("<html>" + StaticHelpers.fixhtmltags((String)ResourceBundle.getBundle("se/sjobeck/eKalkyl").getString("toolTip.traktamente")) + "</html>");
        this.traktDag.setAutoscrolls(true);
        this.traktDag.setMaximumSize(new Dimension(140, 24));
        this.traktDag.setMinimumSize(new Dimension(140, 24));
        this.traktDag.setName("traktdag");
        this.traktDag.setOpaque(false);
        this.traktDag.setPreferredSize(new Dimension(140, 24));
        this.traktDag.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                FilePanel.this.selectAll(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.weighty = 1.0;
        this.jPanel3.add((Component)this.traktDag, gridBagConstraints);
        this.jLabel103.setFont(new Font("SansSerif", 0, 12));
        this.jLabel103.setHorizontalAlignment(4);
        this.jLabel103.setText("kr/natt");
        this.jLabel103.setToolTipText("<html>" + StaticHelpers.fixhtmltags((String)ResourceBundle.getBundle("se/sjobeck/eKalkyl").getString("toolTip.traktamente")) + "</html>");
        this.jLabel103.setFocusable(false);
        this.jLabel103.setHorizontalTextPosition(4);
        this.jLabel103.setMaximumSize(new Dimension(100, 24));
        this.jLabel103.setMinimumSize(new Dimension(100, 24));
        this.jLabel103.setPreferredSize(new Dimension(100, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.jPanel3.add((Component)this.jLabel103, gridBagConstraints);
        this.traktNatt.setEditable(true);
        this.traktNatt.setFont(new Font("SansSerif", 1, 12));
        this.traktNatt.setModel(new DefaultComboBoxModel<String>(new String[]{"0", "100", "200"}));
        this.traktNatt.setToolTipText("<html>" + StaticHelpers.fixhtmltags((String)ResourceBundle.getBundle("se/sjobeck/eKalkyl").getString("toolTip.traktamente")) + "</html>");
        this.traktNatt.setAutoscrolls(true);
        this.traktNatt.setMaximumSize(new Dimension(140, 24));
        this.traktNatt.setMinimumSize(new Dimension(140, 24));
        this.traktNatt.setName("traktnatt");
        this.traktNatt.setOpaque(false);
        this.traktNatt.setPreferredSize(new Dimension(140, 24));
        this.traktNatt.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                FilePanel.this.selectAll(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.weighty = 1.0;
        this.jPanel3.add((Component)this.traktNatt, gridBagConstraints);
        this.jCheckBox1.setText("Utlandstraktamente");
        this.jCheckBox1.setToolTipText("<html>Vid utlandstraktamente finns ingen beloppbegr\u00e4nsning<br> som f\u00f6r svenska traktamenten.</html>");
        this.jCheckBox1.setHorizontalAlignment(2);
        this.jCheckBox1.setHorizontalTextPosition(4);
        this.jCheckBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilePanel.this.jCheckBox1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        this.jPanel3.add((Component)this.jCheckBox1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.mainPanel.add((Component)this.jPanel3, gridBagConstraints);
        this.jPanel4.setBorder(BorderFactory.createTitledBorder("kr/tim"));
        this.jPanel4.setLayout(new GridBagLayout());
        this.jLabel7.setFont(new Font("SansSerif", 0, 12));
        this.jLabel7.setHorizontalAlignment(4);
        this.jLabel7.setText("Timl\u00f6n");
        this.jLabel7.setToolTipText("<html>" + StaticHelpers.fixhtmltags((String)ResourceBundle.getBundle("se/sjobeck/eKalkyl").getString("toolTip.timlon")) + "</html>");
        this.jLabel7.setFocusable(false);
        this.jLabel7.setHorizontalTextPosition(4);
        this.jLabel7.setMaximumSize(new Dimension(100, 24));
        this.jLabel7.setMinimumSize(new Dimension(100, 24));
        this.jLabel7.setPreferredSize(new Dimension(100, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.jPanel4.add((Component)this.jLabel7, gridBagConstraints);
        this.timlon.setEditable(true);
        this.timlon.setFont(new Font("SansSerif", 1, 12));
        this.timlon.setModel(new DefaultComboBoxModel<String>(new String[]{"195", "200", "205", "210", "215", "220", "225", "230"}));
        this.timlon.setToolTipText("<html>" + StaticHelpers.fixhtmltags((String)ResourceBundle.getBundle("se/sjobeck/eKalkyl").getString("toolTip.timlon")) + "</html>");
        this.timlon.setMaximumSize(new Dimension(140, 24));
        this.timlon.setMinimumSize(new Dimension(140, 24));
        this.timlon.setName("timlon");
        this.timlon.setOpaque(false);
        this.timlon.setPreferredSize(new Dimension(140, 24));
        this.timlon.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                FilePanel.this.selectAll(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.weighty = 1.0;
        this.jPanel4.add((Component)this.timlon, gridBagConstraints);
        this.jLabel13.setFont(new Font("SansSerif", 0, 12));
        this.jLabel13.setHorizontalAlignment(4);
        this.jLabel13.setText("L\u00f6netill\u00e4gg");
        this.jLabel13.setToolTipText("<html>" + StaticHelpers.fixhtmltags((String)ResourceBundle.getBundle("se/sjobeck/eKalkyl").getString("toolTip.timlon")) + "</html>");
        this.jLabel13.setFocusable(false);
        this.jLabel13.setHorizontalTextPosition(4);
        this.jLabel13.setMaximumSize(new Dimension(100, 24));
        this.jLabel13.setMinimumSize(new Dimension(100, 24));
        this.jLabel13.setPreferredSize(new Dimension(100, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.jPanel4.add((Component)this.jLabel13, gridBagConstraints);
        this.overtid.setEditable(true);
        this.overtid.setFont(new Font("SansSerif", 1, 12));
        this.overtid.setModel(new DefaultComboBoxModel<String>(new String[]{"0", "5", "10", "15", "20", "25", "30", "40", "50"}));
        this.overtid.setToolTipText("<html>" + StaticHelpers.fixhtmltags((String)ResourceBundle.getBundle("se/sjobeck/eKalkyl").getString("toolTip.timlon")) + "</html>");
        this.overtid.setAutoscrolls(true);
        this.overtid.setMaximumSize(new Dimension(140, 24));
        this.overtid.setMinimumSize(new Dimension(140, 24));
        this.overtid.setName("overtid");
        this.overtid.setOpaque(false);
        this.overtid.setPreferredSize(new Dimension(140, 24));
        this.overtid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilePanel.this.overtidActionPerformed(evt);
            }
        });
        this.overtid.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                FilePanel.this.selectAll(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.weighty = 1.0;
        this.jPanel4.add((Component)this.overtid, gridBagConstraints);
        this.jLabel5.setForeground(new Color(0, 0, 255));
        this.jLabel5.setHorizontalAlignment(4);
        this.jLabel5.setText("L\u00f6nebikostnader");
        this.jLabel5.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                FilePanel.this.jLabel5MouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        this.jPanel4.add((Component)this.jLabel5, gridBagConstraints);
        this.jLabel28.setFont(new Font("SansSerif", 0, 12));
        this.jLabel28.setHorizontalAlignment(4);
        this.jLabel28.setText("P\u00e5slag Ackgrl\u00f6n %");
        this.jLabel28.setMaximumSize(new Dimension(100, 24));
        this.jLabel28.setMinimumSize(new Dimension(100, 24));
        this.jLabel28.setPreferredSize(new Dimension(110, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.jPanel4.add((Component)this.jLabel28, gridBagConstraints);
        this.ackgrProcent.setEditable(true);
        this.ackgrProcent.setFont(new Font("SansSerif", 1, 12));
        this.ackgrProcent.setModel(new DefaultComboBoxModel<String>(new String[]{"0", "5", "10", "15"}));
        this.ackgrProcent.setToolTipText("<html>I f\u00e4ltet kan ett %-uellt till\u00e4gg adderas till ackordsgrundl\u00f6nen. <br>\nTill\u00e4gget kan avse en generell kompensation f\u00f6r otydliga eller <br>\nsv\u00e5rber\u00e4knade handlingar, \u00e5tg\u00e4rder eller utf\u00f6rande.</html>\n");
        this.ackgrProcent.setMaximumSize(new Dimension(140, 24));
        this.ackgrProcent.setMinimumSize(new Dimension(140, 24));
        this.ackgrProcent.setPreferredSize(new Dimension(140, 24));
        this.ackgrProcent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilePanel.this.ackgrProcentActionPerformed(evt);
            }
        });
        this.ackgrProcent.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                FilePanel.this.selectAll(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.weighty = 1.0;
        this.jPanel4.add((Component)this.ackgrProcent, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.mainPanel.add((Component)this.jPanel4, gridBagConstraints);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Reskostnad"));
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel90.setFont(new Font("SansSerif", 0, 12));
        this.jLabel90.setHorizontalAlignment(4);
        this.jLabel90.setText("km/dag");
        this.jLabel90.setToolTipText("<html>" + StaticHelpers.fixhtmltags((String)ResourceBundle.getBundle("se/sjobeck/eKalkyl").getString("toolTip.reskostnad1")) + "</html>");
        this.jLabel90.setFocusable(false);
        this.jLabel90.setHorizontalTextPosition(4);
        this.jLabel90.setMaximumSize(new Dimension(100, 24));
        this.jLabel90.setMinimumSize(new Dimension(100, 24));
        this.jLabel90.setPreferredSize(new Dimension(100, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.jPanel1.add((Component)this.jLabel90, gridBagConstraints);
        this.reskostkm.setEditable(true);
        this.reskostkm.setFont(new Font("SansSerif", 1, 12));
        this.reskostkm.setModel(new DefaultComboBoxModel<String>(new String[]{"0", "5", "10", "15", "20", "25", "30", "35", "40", "45", "50", "60", "70", "80", "90", "100", "110", "120", "130", "140", "150", "200", "250", "300"}));
        this.reskostkm.setToolTipText("<html>" + StaticHelpers.fixhtmltags((String)ResourceBundle.getBundle("se/sjobeck/eKalkyl").getString("toolTip.reskostnad1")) + "</html>");
        this.reskostkm.setAutoscrolls(true);
        this.reskostkm.setMaximumSize(new Dimension(140, 24));
        this.reskostkm.setMinimumSize(new Dimension(140, 24));
        this.reskostkm.setName("reskostkm");
        this.reskostkm.setOpaque(false);
        this.reskostkm.setPreferredSize(new Dimension(140, 24));
        this.reskostkm.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                FilePanel.this.selectAll(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.reskostkm, gridBagConstraints);
        this.jLabel96.setFont(new Font("SansSerif", 0, 12));
        this.jLabel96.setHorizontalAlignment(4);
        this.jLabel96.setText("kr/dag");
        this.jLabel96.setToolTipText("<html>" + StaticHelpers.fixhtmltags((String)ResourceBundle.getBundle("se/sjobeck/eKalkyl").getString("toolTip.reskostnad2")) + "</html>");
        this.jLabel96.setFocusable(false);
        this.jLabel96.setHorizontalTextPosition(4);
        this.jLabel96.setMaximumSize(new Dimension(100, 24));
        this.jLabel96.setMinimumSize(new Dimension(110, 24));
        this.jLabel96.setPreferredSize(new Dimension(110, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.jPanel1.add((Component)this.jLabel96, gridBagConstraints);
        this.reskostkr.setEditable(true);
        this.reskostkr.setFont(new Font("SansSerif", 1, 12));
        this.reskostkr.setModel(new DefaultComboBoxModel<String>(new String[]{"0", "5", "10", "15", "20", "25", "30", "35", "40", "45", "50", "60", "70", "80", "90", "100", "110", "120", "130", "140", "150", "200", "250", "300"}));
        this.reskostkr.setToolTipText("<html>" + StaticHelpers.fixhtmltags((String)ResourceBundle.getBundle("se/sjobeck/eKalkyl").getString("toolTip.reskostnad2")) + "</html>");
        this.reskostkr.setMaximumSize(new Dimension(140, 24));
        this.reskostkr.setMinimumSize(new Dimension(140, 24));
        this.reskostkr.setName("reskostkr");
        this.reskostkr.setOpaque(false);
        this.reskostkr.setPreferredSize(new Dimension(140, 24));
        this.reskostkr.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                FilePanel.this.selectAll(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.reskostkr, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jPanel16, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.mainPanel.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel12.setBorder(BorderFactory.createTitledBorder("Material"));
        this.jPanel12.setLayout(new GridBagLayout());
        this.fargCombo.setToolTipText("<html>Vid byte av materialfabrikat kontrollera att de nya produkterna<br>motsvarar de utbytta. Denna kontroll skall \u00e4ven utf\u00f6ras d\u00e5 man<br>byter tillbaka till \"originalfabrikatet\".</html>");
        this.fargCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilePanel.this.fargComboActionPerformed(evt);
            }
        });
        this.fargCombo.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                FilePanel.this.selectAll(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.weighty = 1.0;
        this.jPanel12.add((Component)this.fargCombo, gridBagConstraints);
        this.jLabel107.setFont(new Font("SansSerif", 0, 12));
        this.jLabel107.setHorizontalAlignment(4);
        this.jLabel107.setText("Material +/- %");
        this.jLabel107.setToolTipText("<html>" + StaticHelpers.fixhtmltags((String)ResourceBundle.getBundle("se/sjobeck/eKalkyl").getString("tooltip.matpristlg")) + "</html>");
        this.jLabel107.setFocusable(false);
        this.jLabel107.setHorizontalTextPosition(4);
        this.jLabel107.setMaximumSize(new Dimension(100, 24));
        this.jLabel107.setMinimumSize(new Dimension(100, 24));
        this.jLabel107.setPreferredSize(new Dimension(100, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.jPanel12.add((Component)this.jLabel107, gridBagConstraints);
        this.matpristlg.setEditable(true);
        this.matpristlg.setFont(new Font("SansSerif", 1, 12));
        this.matpristlg.setModel(new DefaultComboBoxModel<String>(new String[]{"0", "5", "10", "15", "20", "25", "30", "35", "40", "45", "50", "60", "70", "80", "90", "100"}));
        this.matpristlg.setToolTipText("<html>" + StaticHelpers.fixhtmltags((String)ResourceBundle.getBundle("se/sjobeck/eKalkyl").getString("tooltip.matpristlg")) + "</html>");
        this.matpristlg.setAutoscrolls(true);
        this.matpristlg.setInputVerifier(new MyIntegerInputVerifier());
        this.matpristlg.setMaximumSize(new Dimension(140, 24));
        this.matpristlg.setMinimumSize(new Dimension(140, 24));
        this.matpristlg.setName("mattlg");
        this.matpristlg.setOpaque(false);
        this.matpristlg.setPreferredSize(new Dimension(140, 24));
        this.matpristlg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilePanel.this.matpristlgActionPerformed(evt);
            }
        });
        this.matpristlg.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                FilePanel.this.selectAll(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.weighty = 1.0;
        this.jPanel12.add((Component)this.matpristlg, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.mainPanel.add((Component)this.jPanel12, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 7;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 24, 0, 5);
        this.add((Component)this.mainPanel, gridBagConstraints);
        this.jPanel8.setBorder(BorderFactory.createTitledBorder("Sammanst\u00e4llning"));
        this.jPanel8.setLayout(new GridBagLayout());
        this.jLabel6.setText("Arbetskostnad");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.jPanel8.add((Component)this.jLabel6, gridBagConstraints);
        this.jLabel8.setText("L\u00f6nebikostnader");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.jPanel8.add((Component)this.jLabel8, gridBagConstraints);
        this.jLabel9.setText("Material");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.jPanel8.add((Component)this.jLabel9, gridBagConstraints);
        this.jLabel10.setText("Resor och traktamente");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.jPanel8.add((Component)this.jLabel10, gridBagConstraints);
        this.jLabel11.setText("Vinst");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.jPanel8.add((Component)this.jLabel11, gridBagConstraints);
        this.jLabel12.setBackground(new Color(153, 204, 255));
        this.jLabel12.setText("Anbudssumma (exkl moms)");
        this.jLabel12.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.jPanel8.add((Component)this.jLabel12, gridBagConstraints);
        this.jLabel14.setHorizontalAlignment(4);
        this.jLabel14.setText("0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 5, 0, 0);
        this.jPanel8.add((Component)this.jLabel14, gridBagConstraints);
        this.jLabel15.setHorizontalAlignment(4);
        this.jLabel15.setText("0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 5, 0, 0);
        this.jPanel8.add((Component)this.jLabel15, gridBagConstraints);
        this.jLabel16.setHorizontalAlignment(4);
        this.jLabel16.setText("0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 5, 0, 0);
        this.jPanel8.add((Component)this.jLabel16, gridBagConstraints);
        this.jLabel17.setHorizontalAlignment(4);
        this.jLabel17.setText("0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 5, 0, 0);
        this.jPanel8.add((Component)this.jLabel17, gridBagConstraints);
        this.jLabel18.setHorizontalAlignment(4);
        this.jLabel18.setText("0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 5, 0, 0);
        this.jPanel8.add((Component)this.jLabel18, gridBagConstraints);
        this.jLabel20.setText("Anbudsumma (inkl moms)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.jPanel8.add((Component)this.jLabel20, gridBagConstraints);
        this.jLabel21.setHorizontalAlignment(4);
        this.jLabel21.setText("0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 5, 0, 0);
        this.jPanel8.add((Component)this.jLabel21, gridBagConstraints);
        this.jLabel22.setText("Fasta kostnader");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.jPanel8.add((Component)this.jLabel22, gridBagConstraints);
        this.jLabel23.setHorizontalAlignment(4);
        this.jLabel23.setText("0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 5, 0, 0);
        this.jPanel8.add((Component)this.jLabel23, gridBagConstraints);
        this.jLabel24.setBackground(new Color(153, 204, 0));
        this.jLabel24.setText("Timmar");
        this.jLabel24.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.jPanel8.add((Component)this.jLabel24, gridBagConstraints);
        this.jLabel2.setText("UE / \u00d6vriga kostnader");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.jPanel8.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel26.setHorizontalAlignment(4);
        this.jLabel26.setText("0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 5, 0, 0);
        this.jPanel8.add((Component)this.jLabel26, gridBagConstraints);
        this.jPanel14.setBackground(new Color(153, 204, 255));
        this.jPanel14.setLayout(new GridBagLayout());
        this.jLabel19.setBackground(new Color(153, 204, 255));
        this.jLabel19.setHorizontalAlignment(4);
        this.jLabel19.setText("0");
        this.jLabel19.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel14.add((Component)this.jLabel19, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.jPanel8.add((Component)this.jPanel14, gridBagConstraints);
        this.jPanel15.setBackground(new Color(153, 204, 0));
        this.jPanel15.setLayout(new GridBagLayout());
        this.jLabel25.setBackground(new Color(153, 204, 0));
        this.jLabel25.setHorizontalAlignment(4);
        this.jLabel25.setText("0");
        this.jLabel25.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel15.add((Component)this.jLabel25, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.jPanel8.add((Component)this.jPanel15, gridBagConstraints);
        this.jLabel29.setText("TB");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.jPanel8.add((Component)this.jLabel29, gridBagConstraints);
        this.jLabel30.setText("TB %");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.jPanel8.add((Component)this.jLabel30, gridBagConstraints);
        this.jLabel31.setHorizontalAlignment(4);
        this.jLabel31.setText("0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 5, 0, 0);
        this.jPanel8.add((Component)this.jLabel31, gridBagConstraints);
        this.jLabel32.setHorizontalAlignment(4);
        this.jLabel32.setText("0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 5, 0, 0);
        this.jPanel8.add((Component)this.jLabel32, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 24, 5, 5);
        this.add((Component)this.jPanel8, gridBagConstraints);
    }

    private void jLabel4MouseClicked(MouseEvent evt) {
        try {
            Desktop.getDesktop().browse(new URI("https://maleribudget.3kametrics.se/"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jLabel5MouseClicked(MouseEvent evt) {
        try {
            Desktop.getDesktop().browse(new URI("https://ekalkyl.se/lonebikostnader"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void selectAll(FocusEvent evt) {
        ((JComboBox)evt.getSource()).getEditor().selectAll();
    }

    private void fargComboActionPerformed(ActionEvent evt) {
        if (this.ignoreJCombo) {
            this.ignoreJCombo = false;
        } else {
            try {
                this.manager.getCurrentProject().setFabrikat((Fabrikat)this.fargCombo.getSelectedItem());
                this.updateSammanst\u00e4llning();
            }
            catch (Exception exception) {
                // empty catch block
            }
            DialogCreator.showInformation((Component)this, (Object)"<html> Att byta materialfabrikat kan medf\u00f6ra att o\u00f6nskade produkter v\u00e4ljs. <br>Kontrollera alltid mappen \"Total\" och f\u00f6rs\u00e4kra dig om att automatiskt<br> valda produkter motsvarar dina \u00f6nskem\u00e5l. Om inte, \u00e4ndra till r\u00e4tt material!</html>", (String)"Kontrollera rader");
        }
    }

    private void fastkostActionPerformed(ActionEvent evt) {
    }

    private void vinstActionPerformed(ActionEvent evt) {
    }

    private void matpristlgActionPerformed(ActionEvent evt) {
        try {
            this.manager.getCurrentProject().getTimprisStruct().setMatpristlg(StaticHelpers.parseDouble((String)this.matpristlg.getSelectedItem().toString()));
            this.manager.getCurrentProject().getTimprisStruct().updateTimpris();
            this.updateSammanst\u00e4llning();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void removeUEOKjButtonActionPerformed(ActionEvent evt) {
        int selectedRow = this.jTable1.getSelectedRow();
        if (selectedRow > -1) {
            UE_OvrigaKostnader ueok = this.projektInfo.getUEOK(selectedRow);
            this.projektInfo.removeUEOK(ueok);
            ((AbstractTableModel)this.jTable1.getModel()).fireTableRowsDeleted(selectedRow - 1, selectedRow + 1);
        }
    }

    private void addUEOKjButtonActionPerformed(ActionEvent evt) {
        this.projektInfo.addUEOK(new UE_OvrigaKostnader(false, "", 0, 0));
        ((AbstractTableModel)this.jTable1.getModel()).fireTableRowsInserted(this.projektInfo.getNumberOfUEOK() - 1, this.projektInfo.getNumberOfUEOK() + 1);
    }

    private void jCheckBox1ActionPerformed(ActionEvent evt) {
        boolean selected = this.jCheckBox1.isSelected();
        if (selected) {
            this.traktDag.setEnabled(false);
            this.traktDag.setSelectedItem("0");
        } else {
            this.traktDag.setEnabled(true);
        }
        if (this.projektInfo != null) {
            this.manager.getCurrentProject().setUtlandsTraktamente(selected);
            this.manager.getCurrentProject().getTimprisStruct().setUtlandsTraktamente(selected);
            this.manager.getCurrentProject().getTimprisStruct().updateTimpris();
        }
        this.updateSammanst\u00e4llning();
    }

    private void DataBaseComboBoxActionPerformed(ActionEvent evt) {
        Object selectedItem = this.DataBaseComboBox.getSelectedItem();
        boolean showConfirm = DialogCreator.showConfirm((Component)this, (Object)("Vill du byta till databas till: " + selectedItem), (String)"Byte av Databas");
        if (showConfirm) {
            Date date = ((DateWrapper)selectedItem).getDate();
            Projekt currentProject = this.manager.getCurrentProject();
            currentProject.setToday(date.getTime());
            currentProject.checkLatestDatabaseDate();
            this.dbTimeLabel.setText("Projektet anv\u00e4nder databasen fr\u00e5n " + DateFormat.getDateInstance(3).format(new Date(currentProject.getToday())));
            currentProject.checkLatestDatabaseDate();
            currentProject.getRadHanterare().pricesChanged();
            ((Tillagg)this.tillagg).setCurrentProject(currentProject);
        }
        this.updateSammanst\u00e4llning();
    }

    private void ackgrProcentActionPerformed(ActionEvent evt) {
    }

    private void overtidActionPerformed(ActionEvent evt) {
    }

    public void setFile(File f) {
        this.filnamn.setText(f.getName());
        this.filBeskrivning.getDocument().removeDocumentListener(this.updateListener);
        this.filBeskrivning.setText(this.descriptions.get(f.getName()));
        this.filBeskrivning.getDocument().addDocumentListener(this.updateListener);
        if (f.isDirectory()) {
            this.filnamn.setIcon(this.directoryIcon);
            this.filBeskrivning.setEditable(true);
            this.filBeskrivning.setOpaque(true);
            this.setTraktamente(this.projektInfo);
            this.projektInfo = null;
        } else {
            boolean isEditable;
            this.filnamn.setIcon(this.fileIcon);
            Projekt info = this.manager.getProjectByFile(f);
            if (info != null) {
                this.dbTimeLabel.setText("Projektet anv\u00e4nder databasen fr\u00e5n " + DateFormat.getDateInstance(3).format(new Date(info.getToday())));
            }
            boolean bl = isEditable = info != null;
            if (info == null) {
                info = this.summaries.get(f);
                this.dbTimeLabel.setText("Projektet anv\u00e4nder databasen fr\u00e5n ...");
            }
            this.projektInfo = info;
            this.jTable1.setModel((TableModel)new UE_OvrigaKostnaderTableModel(this.projektInfo));
            this.jTable1.getModel().addTableModelListener(this);
            if (info != null && info.getTimprisStruct() != null) {
                this.disableTimprisListeners();
                this.ignoreJCombo = true;
                this.fargCombo.setSelectedItem(info.getFabrikat());
                this.fastkost.setSelectedItem(info.getTimprisStruct().getFastKostnad());
                this.overtid.setSelectedItem(info.getTimprisStruct().getOvertidsTlg());
                this.matpristlg.setSelectedItem(info.getTimprisStruct().getMatpristlg());
                this.reskostkm.setSelectedItem(info.getTimprisStruct().getReskostKmPerDag());
                this.reskostkr.setSelectedItem(info.getTimprisStruct().getReskostKrPerDag());
                this.tidlon.setSelectedItem(info.getTimprisStruct().getTidlonPct());
                this.timlon.setSelectedItem(info.getTimprisStruct().getTimlon());
                this.traktDag.setSelectedItem(info.getTimprisStruct().getTraktamentePerDag());
                this.traktNatt.setSelectedItem(info.getTimprisStruct().getTraktamentePerNatt());
                this.vinst.setSelectedItem(info.getTimprisStruct().getVinst());
                double ackprisProcent = info.getAckprisProcent();
                ackprisProcent = (ackprisProcent - 1.0) * 100.0;
                this.ackgrProcent.setSelectedItem(StaticHelpers.format((double)ackprisProcent));
                this.enableTimprisListeners();
                ((Tillagg)this.tillagg).setCurrentProject(info);
                this.updateTimprisOchSammanst\u00e4llning();
            } else {
                ((Tillagg)this.tillagg).clear();
                this.tillagg.repaint();
            }
            this.updateSammanst\u00e4llningFr\u00e5nProjektvynn\u00e4rmans\u00e4tterfil(f.getName());
            this.filBeskrivning.setEditable(isEditable);
            this.filBeskrivning.setOpaque(isEditable);
            this.fargCombo.setEnabled(isEditable);
            this.fastkost.setEnabled(isEditable);
            this.overtid.setEnabled(isEditable);
            this.reskostkm.setEnabled(isEditable);
            this.reskostkr.setEnabled(isEditable);
            this.matpristlg.setEnabled(isEditable);
            this.tidlon.setEnabled(isEditable);
            this.tillagg.setEnabled(isEditable);
            this.timlon.setEnabled(isEditable);
            this.timpris.setEnabled(isEditable);
            this.traktDag.setEnabled(isEditable);
            this.traktNatt.setEnabled(isEditable);
            this.vinst.setEnabled(isEditable);
            this.setTraktamente(info);
        }
    }

    private void setTraktamente(ProjektInfo info) {
        if (info != null) {
            try {
                this.jCheckBox1.setSelected(info.getUtlandsTraktamente());
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    private double parseDouble(JComboBox box) {
        return StaticHelpers.parseDouble((String)box.getSelectedItem().toString());
    }

    private void disableTimprisListeners() {
        assert (this.projektInfo != null);
        for (Map.Entry<JComboBox, ActionListener> entry : this.actionMap.entrySet()) {
            entry.getKey().removeActionListener(entry.getValue());
        }
    }

    private void enableTimprisListeners() {
        assert (this.projektInfo != null);
        for (Map.Entry<JComboBox, ActionListener> entry : this.actionMap.entrySet()) {
            entry.getKey().addActionListener(entry.getValue());
        }
    }

    private void updateTimprisOchSammanst\u00e4llning() {
        assert (this.projektInfo != null);
        this.updateTimpris();
        this.updateSammanst\u00e4llning();
    }

    private void updateTimpris() {
        this.projektInfo.getTimprisStruct().updateTimpris();
        this.timpris.setText(StaticHelpers.format2Dec((double)this.projektInfo.getTimprisStruct().getTimpris()));
    }

    public void disableAll() {
        this.filBeskrivning.setEnabled(false);
        this.tillagg.setEnabled(false);
        this.fargCombo.setEnabled(false);
        this.matpristlg.setEnabled(false);
        this.timlon.setEnabled(false);
        this.overtid.setEnabled(false);
        this.reskostkm.setEnabled(false);
        this.reskostkr.setEnabled(false);
        this.traktDag.setEnabled(false);
        this.traktNatt.setEnabled(false);
        this.fastkost.setEnabled(false);
        this.vinst.setEnabled(false);
        this.tidlon.setEnabled(false);
        this.addUEOKjButton.setEnabled(false);
        this.removeUEOKjButton.setEnabled(false);
        this.jCheckBox1.setEnabled(false);
        this.DataBaseComboBox.setEnabled(false);
        this.ackgrProcent.setEnabled(false);
    }

    public void enableAll() {
        this.filBeskrivning.setEnabled(true);
        this.tillagg.setEnabled(true);
        this.fargCombo.setEnabled(true);
        this.matpristlg.setEnabled(true);
        this.timlon.setEnabled(true);
        this.overtid.setEnabled(true);
        this.reskostkm.setEnabled(true);
        this.reskostkr.setEnabled(true);
        this.traktDag.setEnabled(!this.jCheckBox1.isSelected());
        this.traktNatt.setEnabled(true);
        this.fastkost.setEnabled(true);
        this.vinst.setEnabled(true);
        this.tidlon.setEnabled(true);
        this.addUEOKjButton.setEnabled(true);
        this.removeUEOKjButton.setEnabled(true);
        this.jCheckBox1.setEnabled(true);
        this.DataBaseComboBox.setEnabled(true);
        this.ackgrProcent.setEnabled(true);
    }

    public void setArbetskostnad(String s) {
        this.jLabel14.setText(s);
    }

    public void setL\u00f6nebikostnader(String s) {
        this.jLabel15.setText(s);
    }

    public void setMaterial(String s) {
        this.jLabel16.setText(s);
    }

    public void setUEOvrigaKostnader(String s) {
        this.jLabel26.setText(s);
    }

    public void setResor(String s) {
        this.jLabel17.setText(s);
    }

    public void setVinst(String s) {
        this.jLabel18.setText(s);
    }

    public void setAnbudsummaexklmoms(String s) {
        this.jLabel19.setText(s);
    }

    public void setFastakostnader(String s) {
        this.jLabel23.setText(s);
    }

    public void setAnbudsummainklmoms(String s) {
        this.jLabel21.setText(s);
    }

    public void setTimmar(String s) {
        this.jLabel25.setText(s);
    }

    public void setTB(String s) {
        this.jLabel31.setText(s);
    }

    public void setTB_Procent(String s) {
        this.jLabel32.setText(s);
    }

    private String bytnullmotstandard(String s) {
        return s != null ? s : "projekt ej \u00f6ppnat";
    }

    private void updateSammanst\u00e4llningFr\u00e5nProjektvynn\u00e4rmans\u00e4tterfil(String filnamn) {
        String s = this.bytnullmotstandard(this.sammanst\u00e4llning.get(filnamn + "arbetskostnad"));
        this.setArbetskostnad(s);
        s = this.bytnullmotstandard(this.sammanst\u00e4llning.get(filnamn + "l\u00f6nebikostnad"));
        this.setL\u00f6nebikostnader(s);
        s = this.bytnullmotstandard(this.sammanst\u00e4llning.get(filnamn + "material"));
        this.setMaterial(s);
        s = this.bytnullmotstandard(this.sammanst\u00e4llning.get(filnamn + "UE_OvrigaKostnader"));
        this.setUEOvrigaKostnader(s);
        s = this.bytnullmotstandard(this.sammanst\u00e4llning.get(filnamn + "resor"));
        this.setResor(s);
        s = this.bytnullmotstandard(this.sammanst\u00e4llning.get(filnamn + "fastakostnader"));
        this.setFastakostnader(s);
        s = this.bytnullmotstandard(this.sammanst\u00e4llning.get(filnamn + "vinst"));
        this.setVinst(s);
        s = this.bytnullmotstandard(this.sammanst\u00e4llning.get(filnamn + "anbudsummaexklmoms"));
        this.setAnbudsummaexklmoms(s);
        s = this.bytnullmotstandard(this.sammanst\u00e4llning.get(filnamn + "anbudsummainklmoms"));
        this.setAnbudsummainklmoms(s);
        s = this.bytnullmotstandard(this.sammanst\u00e4llning.get(filnamn + "timmar"));
        this.setTimmar(s);
        s = this.bytnullmotstandard(this.sammanst\u00e4llning.get(filnamn + "TB"));
        this.setTB(s);
        s = this.bytnullmotstandard(this.sammanst\u00e4llning.get(filnamn + "TB_Procent"));
        this.setTB_Procent(s);
    }

    public void updateSammanst\u00e4llning() {
        try {
            RadHanterare r = this.manager.getCurrentProject().getRadHanterare();
            KalkylNod kn = this.manager.getCurrentProject().getRader();
            List<RadStruct> lrs = kn.getRader();
            TimprisStruct ts = this.manager.getCurrentProject().getTimprisStruct();
            double arbetskostnad = 0.0;
            double l\u00f6nebikostnad = 0.0;
            double material = 0.0;
            double tid = 0.0;
            for (RadStruct rs : lrs) {
                arbetskostnad += r.getTidPerEnh(rs) * ts.getArbskostSumma() * rs.getAntalEnh();
                l\u00f6nebikostnad += r.getTidPerEnh(rs) * ts.getL\u00f6nebikostnad() * rs.getAntalEnh();
                material += r.getMaterialPerEnh(rs) * rs.getAntalEnh();
                tid += r.getTidPerEnh(rs) * rs.getAntalEnh();
            }
            double resor = tid * ts.getResorochtraktamente();
            double fast_kost = tid * ts.getFastKostnad();
            double ue_kost = this.projektInfo.getUEOKPris();
            double anbudssumma = tid * ts.getTimpris() + (ue_kost + material) / (1.0 - ts.getVinst() * 0.01);
            double ___vinst = anbudssumma * ts.getVinst() * 0.01;
            double ackordssumma = arbetskostnad - l\u00f6nebikostnad;
            double TB = fast_kost + ___vinst;
            double TB_Procent = TB / anbudssumma * 100.0;
            this.setArbetskostnad(StaticHelpers.format2Dec((double)ackordssumma));
            this.setL\u00f6nebikostnader(StaticHelpers.format2Dec((double)l\u00f6nebikostnad));
            this.setMaterial(StaticHelpers.format2Dec((double)material));
            this.setUEOvrigaKostnader(StaticHelpers.format2Dec((double)ue_kost));
            this.setResor(StaticHelpers.format2Dec((double)resor));
            this.setFastakostnader(StaticHelpers.format2Dec((double)fast_kost));
            this.setVinst(StaticHelpers.format2Dec((double)___vinst));
            this.setAnbudsummaexklmoms(StaticHelpers.format2Dec((double)anbudssumma));
            this.setAnbudsummainklmoms(StaticHelpers.format2Dec((double)(anbudssumma * 1.25)));
            this.setTimmar(StaticHelpers.format2Dec((double)tid));
            this.setTB(StaticHelpers.format2Dec((double)TB));
            this.setTB_Procent(StaticHelpers.format2Dec((double)TB_Procent));
            if (this.manager.getCurrentProject().getFileReference().getName().equals(this.filnamn.getText())) {
                this.sammanst\u00e4llning.put(this.filnamn.getText() + "arbetskostnad", StaticHelpers.format2Dec((double)ackordssumma));
                this.sammanst\u00e4llning.put(this.filnamn.getText() + "l\u00f6nebikostnad", StaticHelpers.format2Dec((double)l\u00f6nebikostnad));
                this.sammanst\u00e4llning.put(this.filnamn.getText() + "material", StaticHelpers.format2Dec((double)material));
                this.sammanst\u00e4llning.put(this.filnamn.getText() + "resor", StaticHelpers.format2Dec((double)resor));
                this.sammanst\u00e4llning.put(this.filnamn.getText() + "UE_OvrigaKostnader", StaticHelpers.format2Dec((double)ue_kost));
                this.sammanst\u00e4llning.put(this.filnamn.getText() + "vinst", StaticHelpers.format2Dec((double)___vinst));
                this.sammanst\u00e4llning.put(this.filnamn.getText() + "anbudsummaexklmoms", StaticHelpers.format2Dec((double)anbudssumma));
                this.sammanst\u00e4llning.put(this.filnamn.getText() + "fastakostnader", StaticHelpers.format2Dec((double)fast_kost));
                this.sammanst\u00e4llning.put(this.filnamn.getText() + "anbudsummainklmoms", StaticHelpers.format2Dec((double)(anbudssumma * 1.25)));
                this.sammanst\u00e4llning.put(this.filnamn.getText() + "timmar", StaticHelpers.format2Dec((double)tid));
                this.sammanst\u00e4llning.put(this.filnamn.getText() + "TB", StaticHelpers.format2Dec((double)TB));
                this.sammanst\u00e4llning.put(this.filnamn.getText() + "TB_Procent", StaticHelpers.format2Dec((double)TB_Procent));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.updateSammanst\u00e4llning();
    }

    public void printSammanst\u00e4llning() {
        ProjektSammanstallning projektSammanst\u00e4llning = new ProjektSammanstallning(this.filnamn.getText());
        this.addDebiteringSammanst\u00e4llningIhopSlagna(projektSammanst\u00e4llning);
        this.addNyckelTal(projektSammanst\u00e4llning);
        this.addProjektTill\u00e4gg(projektSammanst\u00e4llning);
        this.addUE\u00d6vrigaKostnader(projektSammanst\u00e4llning);
        this.addAnteckningar(projektSammanst\u00e4llning);
        Vector<String> fodu = new Vector<String>();
        fodu.add("PDF-filter");
        fodu.add("pdf");
        File showFileChooser = DialogCreator.showFileChooser((String)"Spara", fodu, (String)(this.filnamn.getText() + "-Projektsammanst\u00e4llning.pdf"));
        if (!showFileChooser.getName().endsWith(".pdf")) {
            try {
                showFileChooser = new File(showFileChooser.getCanonicalPath() + ".pdf");
            }
            catch (IOException ex) {
                Logger.getLogger(FilePanel.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (showFileChooser != null) {
            OutputGenerator.generatePdf(projektSammanst\u00e4llning, showFileChooser);
        }
        try {
            Desktop.getDesktop().open(showFileChooser);
        }
        catch (IOException ex) {
            Logger.getLogger(FilePanel.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

