/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.gui;

import java.util.Collection;
import javax.swing.JFrame;
import javax.swing.ListModel;
import se.sjobeck.datastructures.DimStruct;
import se.sjobeck.datastructures.FormelDim;
import se.sjobeck.datastructures.ProjectManager;
import se.sjobeck.datastructures.kalkylering.RadStruct;
import se.sjobeck.gui.FormelFonster;
import se.sjobeck.gui.GenericListModel;
import se.sjobeck.gui.PopupListEditor;

public class DimensionListEditor
extends PopupListEditor {
    private transient FormelFonster funster;
    private transient GenericListModel<DimStruct> listModel;
    private static final DimStruct generate = new DimStruct("", "Generera Formel", "", "", 0.0, 0.0);
    private ProjectManager manager;

    public DimensionListEditor(JFrame frame, ProjectManager manager) {
        super(true);
        this.funster = new FormelFonster(frame);
        this.listModel = new GenericListModel();
        this.manager = manager;
    }

    @Override
    public ListModel getListModel(RadStruct r) {
        this.listModel.clear();
        this.listModel.addElement((Object)generate);
        this.listModel.addAll((Collection)this.manager.getCurrentProject().getDatabaseInstance().getDimensioner());
        this.funster.setDimension((Object)r.getDim(), r.getInomhus());
        return this.listModel;
    }

    @Override
    public Object getValue(RadStruct r) {
        if (r.getDim() != null && r.getDim() instanceof FormelDim) {
            return generate;
        }
        return r.getDim();
    }

    @Override
    public Object getCellEditorValue() {
        if (this.textField.getText().equals(generate.get_Text())) {
            this.funster.setVisible(true);
            DimStruct ds = this.funster.getDimStruct();
            if (ds != null) {
                return ds;
            }
            return null;
        }
        for (DimStruct value : this.listModel.getList()) {
            if (!this.textField.getText().equals(value.toString())) continue;
            return value;
        }
        return null;
    }

    @Override
    public void willShowDialog() {
    }
}

