/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.gui;

import java.util.logging.Logger;
import se.sjobeck.datastructures.ProjectManager;
import se.sjobeck.gui.FunctionTableModel;
import se.sjobeck.parser2.Function;
import se.sjobeck.util.StaticHelpers;

public class CustomAmaTableModel
extends FunctionTableModel {
    private String[] columns = new String[]{"AMA-kod", "Beskrivning", "Enhet", "Tid per enhet", "Materialpris per enhet"};
    private ProjectManager projectManager;
    private Function placeHolder = new Function("", "", "");

    CustomAmaTableModel(ProjectManager manager) {
        this.projectManager = manager;
    }

    @Override
    public Function getFunction(int row, int col) {
        switch (col) {
            case 1: {
                this.placeHolder.setValueStr(this.projectManager.getCurrentProject().getCustomAmaBeskrivning(row));
                break;
            }
            case 2: {
                this.placeHolder.setValueStr(this.projectManager.getCurrentProject().getCustomAmaEnhet(row));
                break;
            }
            case 3: {
                this.placeHolder.setValueStr(this.projectManager.getCurrentProject().getCustomAmaAckTidFunction(row));
                break;
            }
            case 4: {
                this.placeHolder.setValueStr(this.projectManager.getCurrentProject().getCustomAmaMaterialPrisFunction(row));
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal column " + col);
            }
        }
        return this.placeHolder;
    }

    @Override
    public String getColumnName(int col) {
        return this.columns[col];
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public int getRowCount() {
        try {
            return this.projectManager.getCurrentProject().getCustomAmaCount() + 1;
        }
        catch (Exception e) {
            return 1;
        }
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row == this.projectManager.getCurrentProject().getCustomAmaCount()) {
            return "";
        }
        switch (col) {
            case 0: {
                return this.projectManager.getCurrentProject().getCustomAmaName(row);
            }
            case 1: {
                return this.projectManager.getCurrentProject().getCustomAmaBeskrivning(row);
            }
            case 2: {
                return this.projectManager.getCurrentProject().getCustomAmaEnhet(row);
            }
            case 3: {
                try {
                    return StaticHelpers.tidFormat((double)this.projectManager.getCurrentProject().getCustomAmaAckTid(row));
                }
                catch (Exception e) {
                    return "#";
                }
            }
            case 4: {
                try {
                    return StaticHelpers.format2Dec((double)this.projectManager.getCurrentProject().getCustomAmaMaterialPris(row));
                }
                catch (Exception e) {
                    return "#";
                }
            }
        }
        return "#";
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col != 0 ^ row == this.projectManager.getCurrentProject().getCustomAmaCount();
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        Logger.getLogger("se.sjobeck").entering("CustomAmaTableModel", "setValueAt");
        String s = (String)value;
        if (col == 0) {
            if (!"".equals(s) && s != null && row == this.projectManager.getCurrentProject().getCustomAmaCount()) {
                this.projectManager.getCurrentProject().addCustomAMA(s);
                super.fireTableRowsInserted(row, row);
            }
        } else {
            switch (col) {
                case 1: {
                    this.projectManager.getCurrentProject().setCustomAmaBeskrivning(row, s);
                    break;
                }
                case 2: {
                    this.projectManager.getCurrentProject().setCustomAmaEnhet(row, s);
                    break;
                }
                case 3: {
                    this.projectManager.getCurrentProject().setCustomAmaAckTid(row, s);
                    break;
                }
                case 4: {
                    this.projectManager.getCurrentProject().setCustomAmaMaterialPris(row, s);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Could not change column " + col + "!");
                }
            }
            super.fireTableRowsUpdated(row, row);
        }
    }

    public void deleteRow(int row) {
        if (row >= 0) {
            this.projectManager.getCurrentProject().removeCustomAmaRow(row);
            super.fireTableDataChanged();
        }
    }
}

