/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import se.sjobeck.datastructures.ProjectManager;
import se.sjobeck.datastructures.Projekt;
import se.sjobeck.gui.AntialiasedJLabel;
import se.sjobeck.gui.ConstantTableModel;
import se.sjobeck.gui.FunctionEditor;
import se.sjobeck.gui.KalkylGUI;
import se.sjobeck.gui.multilinetable2.MultilineAwareRowHeader;
import se.sjobeck.gui.multilinetable2.TextAreaRenderer;
import se.sjobeck.parser2.Function;
import se.sjobeck.util.StaticHelpers;

public class ConstantsPanel
extends JPanel {
    private static char[] illegalChars = new char[]{'\"', '\'', '/', '*', '+', '-', ',', '.', '(', ')', ' ', '\t'};
    private static String[] illegalPatterns = new String[]{"H", "O", "B", "L\\d*", "G", "T", "V\\d*"};
    private ConstantTableModel model;
    private KalkylGUI gui;
    private ProjectManager projectManager;
    private JTable globalaVariabler;
    private JButton jButton10;
    private JButton jButton11;
    private JButton jButton9;
    private JScrollPane jScrollPane1;
    protected JLabel titel;

    public ConstantsPanel(KalkylGUI gui, Projekt current) {
        throw new IllegalArgumentException();
    }

    public ConstantsPanel(KalkylGUI gui, ProjectManager manager) {
        Logger.getLogger("se.sjobeck").entering("ConstantsPanel", "[constructor]");
        this.gui = gui;
        this.projectManager = manager;
        this.model = new ConstantTableModel(this.projectManager);
        this.initComponents();
        TextAreaRenderer renderer = new TextAreaRenderer(1);
        TableColumnModel cModel = this.globalaVariabler.getColumnModel();
        cModel.getColumn(0).setCellRenderer((TableCellRenderer)renderer);
        cModel.getColumn(1).setCellRenderer((TableCellRenderer)renderer);
        cModel.getColumn(2).setCellRenderer((TableCellRenderer)renderer);
        MultilineAwareRowHeader rowHead = new MultilineAwareRowHeader(this.globalaVariabler);
        this.jScrollPane1.setRowHeaderView((Component)rowHead);
        this.globalaVariabler.getColumnModel().getColumn(1).setCellEditor(new FunctionEditor(this.model));
        Logger.getLogger("se.sjobeck").exiting("ConstantsPanel", "[constructor]");
    }

    private void initComponents() {
        this.titel = new AntialiasedJLabel();
        this.jScrollPane1 = new JScrollPane();
        this.globalaVariabler = new JTable();
        this.jButton9 = new JButton();
        this.jButton10 = new JButton();
        this.jButton11 = new JButton();
        this.setLayout(new GridBagLayout());
        this.titel.setFont(new Font("SansSerif", 1, 24));
        this.titel.setIcon(new ImageIcon(this.getClass().getResource("/org/tangoProject/large/emblem-important.png")));
        this.titel.setText("Fasta m\u00e5tt");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(20, 24, 20, 5);
        this.add((Component)this.titel, gridBagConstraints);
        this.globalaVariabler.setModel(this.model);
        this.globalaVariabler.setAutoResizeMode(3);
        this.globalaVariabler.setIntercellSpacing(new Dimension(0, 0));
        this.globalaVariabler.setShowHorizontalLines(false);
        this.globalaVariabler.setShowVerticalLines(false);
        this.jScrollPane1.setViewportView(this.globalaVariabler);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 24, 5, 5);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jButton9.setText("L\u00e4gg till");
        this.jButton9.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConstantsPanel.this.jButton9ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.add((Component)this.jButton9, gridBagConstraints);
        this.jButton10.setText("Ta bort");
        this.jButton10.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConstantsPanel.this.jButton10ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.add((Component)this.jButton10, gridBagConstraints);
        this.jButton11.setText("Byt namn");
        this.jButton11.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.add((Component)this.jButton11, gridBagConstraints);
    }

    private void jButton10ActionPerformed(ActionEvent evt) {
        int which = this.globalaVariabler.getSelectedRow();
        if (JOptionPane.showConfirmDialog(this, "Vill du verkligen ta bort m\u00e5ttet '" + this.projectManager.getCurrentProject().getKonstanter().get(which).getDescription() + "'?", "Bekr\u00e4fta borttagning", 0, 3) == 0) {
            this.projectManager.getCurrentProject().getKonstanter().remove(which);
            this.projectManager.getCurrentProject().getRadHanterare().conditionsChanged();
            this.projectManager.getCurrentProject().recalculate(this.projectManager.getCurrentProject().getRader());
            this.model.fireTableDataChanged();
        }
    }

    private boolean checkNamn(String namn) {
        if (namn == null || namn.equals("")) {
            return false;
        }
        boolean ret = true;
        Vector<Function> funcs = this.projectManager.getCurrentProject().getKonstanter();
        for (Function func : funcs) {
            if (!func.getIdentifier().equalsIgnoreCase(namn)) continue;
            StaticHelpers.warn((String)("Det finns redan ett m\u00e5tt som kallas '" + func.getIdentifier() + "'"));
            ret = false;
        }
        for (char illegal : illegalChars) {
            if (namn.indexOf(illegal) == -1) continue;
            StaticHelpers.warn((String)("Ett fast m\u00e5tt f\u00e5r inte inneh\u00e5lla '" + illegal + "' " + this.humanReadableAlias(illegal)));
            ret = false;
        }
        for (String illegalPattern : illegalPatterns) {
            if (!namn.toUpperCase().matches(illegalPattern)) continue;
            StaticHelpers.warn((String)("'" + namn + "' kan f\u00f6rv\u00e4xlas med ett rumsm\u00e5tt!"));
            ret = false;
        }
        return ret;
    }

    private String humanReadableAlias(char c) {
        switch (c) {
            case ' ': {
                return "[mellanslag]";
            }
            case '\t': {
                return "[tabb]";
            }
            case '\n': {
                return "[radmatning]";
            }
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case '-': 
            case '/': {
                return "[r\u00e4knetecken]";
            }
            case '\"': 
            case '\'': {
                return "[citattecken]";
            }
        }
        return "";
    }

    private void jButton9ActionPerformed(ActionEvent evt) {
        String namn = "";
        boolean namnOk = false;
        while (namn != null && !namnOk) {
            namn = (String)JOptionPane.showInputDialog(this.gui, "Ange namn", "Nytt m\u00e5tt", -1, null, null, namn);
            namnOk = this.checkNamn(namn);
        }
        if (namn != null) {
            this.projectManager.getCurrentProject().getKonstanter().add(new Function(namn, "0", ""));
            this.model.fireTableDataChanged();
            this.projectManager.getCurrentProject().recalculate(this.projectManager.getCurrentProject().getRader());
        }
    }

    public void updatePanel() {
        this.model.fireTableDataChanged();
    }
}

