/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellEditor;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;
import se.sjobeck.datastructures.Drawing;
import se.sjobeck.datastructures.DrawingLine;
import se.sjobeck.datastructures.ProjectManager;
import se.sjobeck.datastructures.RumNod;
import se.sjobeck.datastructures.kalkylering.RadStruct;
import se.sjobeck.gui.GenericListModel;
import se.sjobeck.gui.PopupEditorPanel;
import se.sjobeck.parser2.Function;
import se.sjobeck.util.StaticHelpers;

public class AntalEditor
extends JPanel
implements PopupEditorPanel {
    private GenericListModel<Function> variabelModel;
    private GenericListModel<Function> konstantModel;
    private ProjectManager projectManager;
    private TableCellEditor cellEditor;
    private JTextField resultat;
    private boolean showDialog;
    private String operatorStr = "+";
    private ButtonGroup buttonGroup1;
    private JButton cancelEditing;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTabbedPane jTabbedPane1;
    private JToggleButton jToggleButton1;
    private JToggleButton jToggleButton2;
    private JToggleButton jToggleButton3;
    private JToggleButton jToggleButton4;
    private JList konstantList;
    private JButton stopEditing;
    private JTextField text;
    private JList variabelList;
    private String originalValue = "";

    public AntalEditor(ProjectManager manager) {
        this.projectManager = manager;
        this.initComponents();
        this.variabelModel = new GenericListModel();
        this.konstantModel = new GenericListModel();
        this.variabelList.setModel(this.variabelModel);
        this.konstantList.setModel(this.konstantModel);
        FunctionListCellRenderer rend = new FunctionListCellRenderer();
        this.konstantList.setCellRenderer(rend);
        this.variabelList.setCellRenderer(rend);
        FunctionMouseListener listener = new FunctionMouseListener(this.konstantList, this.konstantModel);
        this.konstantList.addMouseListener(listener);
        listener = new FunctionMouseListener(this.variabelList, this.variabelModel);
        this.variabelList.addMouseListener(listener);
        this.text.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                AntalEditor.this.updateValue();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                AntalEditor.this.updateValue();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AntalEditor.this.updateValue();
            }
        });
        AbstractAction stop = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AntalEditor.this.cellEditor.stopCellEditing();
            }
        };
        AbstractAction cancel = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AntalEditor.this.cellEditor.cancelCellEditing();
            }
        };
        this.text.getInputMap().put(KeyStroke.getKeyStroke("pressed ENTER"), "closeDialog");
        this.text.getActionMap().put("closeDialog", stop);
        this.text.getInputMap().put(KeyStroke.getKeyStroke("pressed ESCAPE"), "cancelDialog");
        this.text.getActionMap().put("cancelDialog", cancel);
    }

    private void updateValue() {
        this.resultat.setText(StaticHelpers.format2Dec((double)Function.getValue((String)this.text.getText(), (List[])new List[]{this.variabelModel.getList(), this.projectManager.getCurrentProject().getKonstanter()})));
    }

    @Override
    public Object getValue(RadStruct r) {
        return r.getAntalFormel();
    }

    @Override
    public void willShowDialog() {
        this.text.setText(this.originalValue);
        this.text.selectAll();
        this.text.grabFocus();
        this.showDialog = true;
    }

    @Override
    public void init(RadStruct row, JTextField textfield, TableCellEditor editor) {
        this.originalValue = row.getAntalFormel();
        this.cellEditor = editor;
        this.showDialog = false;
        RumNod nod = (RumNod)this.projectManager.getCurrentKalkylNod();
        this.variabelModel.setListData(nod.getVariabler());
        this.konstantModel.setListData(this.projectManager.getCurrentProject().getKonstanter());
        if (nod.getDrawing() != null) {
            ((AntalDrawingPanel)this.jPanel2).setDrawing(nod.getDrawing());
        }
        this.resultat = textfield;
        this.updateValue();
    }

    @Override
    public void uninit() {
    }

    @Override
    public Component getComponent() {
        return this;
    }

    private boolean isOperator(char c) {
        return c == '+' || c == '-' || c == '*' || c == '/';
    }

    protected String getOperator() {
        return this.operatorStr;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.stopEditing = new JButton();
        this.cancelEditing = new JButton();
        this.text = new JTextField();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.jToggleButton1 = new JToggleButton();
        this.jToggleButton2 = new JToggleButton();
        this.jToggleButton3 = new JToggleButton();
        this.jToggleButton4 = new JToggleButton();
        this.jScrollPane1 = new JScrollPane();
        this.konstantList = new JList();
        this.jScrollPane2 = new JScrollPane();
        this.variabelList = new JList();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jButton3 = new JButton();
        this.jPanel2 = new AntalDrawingPanel();
        this.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.setFocusable(false);
        this.setMinimumSize(new Dimension(405, 240));
        this.setPreferredSize(new Dimension(405, 255));
        this.setLayout((LayoutManager)new AbsoluteLayout());
        this.stopEditing.setIcon(new ImageIcon(this.getClass().getResource("/se/sjobeck/images/dialog-ok.png")));
        this.stopEditing.setFocusable(false);
        this.stopEditing.setMargin(new Insets(2, 2, 2, 2));
        this.stopEditing.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AntalEditor.this.stopEditingActionPerformed(evt);
            }
        });
        this.add((Component)this.stopEditing, new AbsoluteConstraints(360, 230, 40, 20));
        this.cancelEditing.setIcon(new ImageIcon(this.getClass().getResource("/se/sjobeck/images/dialog-cancel.png")));
        this.cancelEditing.setFocusable(false);
        this.cancelEditing.setMargin(new Insets(2, 2, 2, 2));
        this.cancelEditing.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AntalEditor.this.cancelEditingActionPerformed(evt);
            }
        });
        this.add((Component)this.cancelEditing, new AbsoluteConstraints(320, 230, 40, 20));
        this.text.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AntalEditor.this.textActionPerformed(evt);
            }
        });
        this.add((Component)this.text, new AbsoluteConstraints(2, 2, 401, 18));
        this.jPanel1.setLayout((LayoutManager)new AbsoluteLayout());
        this.buttonGroup1.add(this.jToggleButton1);
        this.jToggleButton1.setSelected(true);
        this.jToggleButton1.setText("+");
        this.jToggleButton1.setFocusable(false);
        this.jToggleButton1.setMargin(new Insets(2, 2, 2, 2));
        this.jToggleButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AntalEditor.this.jToggleButton1ActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.jToggleButton1, new AbsoluteConstraints(0, 20, 40, 20));
        this.buttonGroup1.add(this.jToggleButton2);
        this.jToggleButton2.setText("-");
        this.jToggleButton2.setFocusable(false);
        this.jToggleButton2.setMargin(new Insets(2, 2, 2, 2));
        this.jToggleButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AntalEditor.this.jToggleButton2ActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.jToggleButton2, new AbsoluteConstraints(0, 40, 40, 20));
        this.buttonGroup1.add(this.jToggleButton3);
        this.jToggleButton3.setText("*");
        this.jToggleButton3.setFocusable(false);
        this.jToggleButton3.setMargin(new Insets(2, 2, 2, 2));
        this.jToggleButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AntalEditor.this.jToggleButton3ActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.jToggleButton3, new AbsoluteConstraints(0, 60, 40, 20));
        this.buttonGroup1.add(this.jToggleButton4);
        this.jToggleButton4.setText("/");
        this.jToggleButton4.setFocusable(false);
        this.jToggleButton4.setMargin(new Insets(2, 2, 2, 2));
        this.jToggleButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AntalEditor.this.jToggleButton4ActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.jToggleButton4, new AbsoluteConstraints(0, 80, 40, 20));
        this.jScrollPane1.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Konstanter"));
        this.jScrollPane1.setFocusable(false);
        this.konstantList.setSelectionMode(0);
        this.konstantList.setFocusable(false);
        this.jScrollPane1.setViewportView(this.konstantList);
        this.jPanel1.add((Component)this.jScrollPane1, new AbsoluteConstraints(40, 0, 180, 185));
        this.jScrollPane2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Rumsm\u00e5tt"));
        this.jScrollPane2.setFocusable(false);
        this.variabelList.setSelectionMode(0);
        this.variabelList.setFocusable(false);
        this.jScrollPane2.setViewportView(this.variabelList);
        this.jPanel1.add((Component)this.jScrollPane2, new AbsoluteConstraints(220, 0, 180, 185));
        this.jButton1.setText("(");
        this.jButton1.setFocusable(false);
        this.jButton1.setMargin(new Insets(2, 2, 2, 2));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AntalEditor.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.jButton1, new AbsoluteConstraints(0, 120, 40, 20));
        this.jButton2.setText(")");
        this.jButton2.setFocusable(false);
        this.jButton2.setMargin(new Insets(2, 2, 2, 2));
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AntalEditor.this.jButton2ActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.jButton2, new AbsoluteConstraints(0, 140, 40, 20));
        this.jButton3.setText("<-");
        this.jButton3.setFocusable(false);
        this.jButton3.setMargin(new Insets(2, 2, 2, 2));
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AntalEditor.this.jButton3ActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.jButton3, new AbsoluteConstraints(0, 160, 40, 20));
        this.jTabbedPane1.addTab("Rumsm\u00e5tt", this.jPanel1);
        this.jTabbedPane1.addTab("M\u00e4tbild", this.jPanel2);
        this.add((Component)this.jTabbedPane1, new AbsoluteConstraints(2, 20, 400, 210));
    }

    private void stopEditingActionPerformed(ActionEvent evt) {
        this.cellEditor.stopCellEditing();
    }

    private void cancelEditingActionPerformed(ActionEvent evt) {
        this.cellEditor.cancelCellEditing();
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        String oldStr = this.text.getText();
        String newStr = oldStr.indexOf(" ") == -1 ? "" : oldStr.substring(0, oldStr.lastIndexOf(" "));
        this.text.setText(newStr);
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        String oldStr = this.text.getText();
        this.text.setText(oldStr + ") ");
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        int i;
        String oldStr = this.text.getText();
        for (i = oldStr.length() - 1; i >= 0 && Character.isWhitespace(oldStr.charAt(i)); --i) {
        }
        if (i >= 0 && !this.isOperator(oldStr.charAt(i)) && oldStr.charAt(i) != '(') {
            oldStr = oldStr + " " + this.getOperator();
        }
        this.text.setText(oldStr + " (");
    }

    private void jToggleButton4ActionPerformed(ActionEvent evt) {
        this.operatorStr = "/";
    }

    private void jToggleButton3ActionPerformed(ActionEvent evt) {
        this.operatorStr = "*";
    }

    private void jToggleButton2ActionPerformed(ActionEvent evt) {
        this.operatorStr = "-";
    }

    private void jToggleButton1ActionPerformed(ActionEvent evt) {
        this.operatorStr = "+";
    }

    private void textActionPerformed(ActionEvent evt) {
    }

    @Override
    public Object getCellEditorValue() {
        if (this.showDialog) {
            return this.text.getText();
        }
        return this.resultat.getText();
    }

    @Override
    public boolean stopCellEditing() {
        return true;
    }

    class AntalDrawingPanel
    extends JPanel
    implements MouseMotionListener,
    MouseListener {
        private Drawing d;
        private Dimension cachedSize = null;
        private Rectangle constraints = new Rectangle();
        private DrawingLine activeLine;
        private Vector<DrawingLine> selectedLines = new Vector();

        public AntalDrawingPanel() {
            this.addMouseMotionListener(this);
            this.addMouseListener(this);
        }

        public void setDrawing(Drawing d) {
            this.d = d;
            this.selectedLines.clear();
        }

        @Override
        public void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            Stroke defaultStroke = g2.getStroke();
            g2.setStroke(new BasicStroke(4.0f));
            if (!this.getSize().equals(this.cachedSize)) {
                this.cachedSize = this.getSize();
                this.constraints.setBounds(5, 5, this.cachedSize.width - 5, this.cachedSize.height - 20);
            }
            g2.setColor(this.getBackground());
            g2.fillRect(0, 0, this.cachedSize.width, this.cachedSize.height);
            g2.setColor(this.getForeground());
            this.d.paintDrawing(g2, this.constraints);
            g2.setColor(Color.GREEN);
            for (DrawingLine line : this.selectedLines) {
                g2.draw(line);
            }
            if (this.activeLine != null) {
                g2.setColor(Color.RED);
                g2.draw(this.activeLine);
            }
            g2.setStroke(defaultStroke);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.activeLine = this.d.getLine(e.getPoint());
            this.repaint();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.activeLine = this.d.getLine(e.getPoint());
            if (this.activeLine != null) {
                DrawingLine removeLine = null;
                for (DrawingLine line : this.selectedLines) {
                    if (!line.getP1().equals(this.activeLine.getP1()) || !line.getP2().equals(this.activeLine.getP2())) continue;
                    removeLine = line;
                }
                if (removeLine != null) {
                    this.selectedLines.remove(removeLine);
                } else {
                    this.selectedLines.add(this.activeLine);
                }
                String text = "";
                for (int i = 0; i < this.selectedLines.size(); ++i) {
                    if (i > 0) {
                        text = text + " + ";
                    }
                    text = text + this.selectedLines.get((int)i).variable;
                }
                AntalEditor.this.text.setText(text);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    private class FunctionMouseListener
    implements MouseListener {
        GenericListModel<Function> model;
        JList list;

        public FunctionMouseListener(JList list, GenericListModel<Function> model) {
            this.model = model;
            this.list = list;
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int index = this.list.locationToIndex(e.getPoint());
            if (index >= 0) {
                int i;
                Function f = (Function)this.model.getElementAt(index);
                String oldStr = AntalEditor.this.text.getText();
                for (i = oldStr.length() - 1; i >= 0 && Character.isWhitespace(oldStr.charAt(i)); --i) {
                }
                if (i >= 0 && AntalEditor.this.isOperator(oldStr.charAt(i))) {
                    oldStr = oldStr.substring(0, i).trim();
                }
                if (i < 0 || oldStr.charAt(i) == '(') {
                    AntalEditor.this.text.setText(oldStr + f.getIdentifier());
                } else {
                    AntalEditor.this.text.setText(oldStr + " " + AntalEditor.this.getOperator() + " " + f.getIdentifier());
                }
            }
        }
    }

    private class FunctionListCellRenderer
    extends JButton
    implements ListCellRenderer {
        FunctionListCellRenderer() {
            super.setMargin(new Insets(2, 2, 2, 2));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Function f = (Function)value;
            this.setText(f.getIdentifier() + " ( " + f.getDescription() + ")");
            return this;
        }
    }
}

