/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Collection;
import java.util.logging.Logger;
import javax.swing.ComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;
import se.sjobeck.datastructures.ProjectManager;
import se.sjobeck.datastructures.kalkylering.Behandling;
import se.sjobeck.datastructures.kalkylering.BehandlingsTyp;
import se.sjobeck.datastructures.kalkylering.RadHanterare;
import se.sjobeck.datastructures.kalkylering.RadStruct;
import se.sjobeck.datastructures.kalkylering.Underlag;
import se.sjobeck.datastructures.kalkylering.Ytmaterial;
import se.sjobeck.gui.FocusPolicy;
import se.sjobeck.gui.GenericComboBoxModel;
import se.sjobeck.gui.GenericListModel;
import se.sjobeck.gui.PopupEditorPanel;
import se.sjobeck.gui.PopupRenderer;

public class AmaKodPanel
extends JPanel
implements PopupEditorPanel {
    private RadStruct struct;
    private TableCellEditor editor;
    private JTextField textfield;
    private ProjectManager projectManager;
    private GenericComboBoxModel<Ytmaterial> ytmaterialModel;
    private GenericComboBoxModel<Underlag> underlagModel;
    private GenericListModel<Behandling> f\u00f6rbehandlingar;
    private GenericListModel<Behandling> underbehandlingar;
    private GenericListModel<Behandling> f\u00e4rdigbehandlingar;
    private ActionListener underlagActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent evt) {
            Logger.getLogger("se.sjobeck.gui.AmaKodPanel").entering("AmaKodPanel", "underlagActionPerformed", evt);
            Underlag u = (Underlag)AmaKodPanel.this.underlagModel.getSelectedItem();
            Logger.getLogger("se.sjobeck.gui.AmaKodPanel").fine("Valt underlag: " + u);
            if (u == null) {
                AmaKodPanel.this.struct.setUnderlagID(null);
            } else {
                AmaKodPanel.this.struct.setUnderlagID(u.getId());
            }
            AmaKodPanel.this.ytmaterialModel.setListData(AmaKodPanel.this.projectManager.getCurrentProject().getDatabaseInstance().getYtmaterial(AmaKodPanel.this.struct));
            AmaKodPanel.this.updateBehandlingar();
            AmaKodPanel.this.updateBehkod();
        }
    };
    private ActionListener ytmaterialActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent evt) {
            Logger.getLogger("se.sjobeck.gui.AmaKodPanel").entering("AmaKodPanel", "materialActionPerformed", evt);
            if (AmaKodPanel.this.ytmaterialModel.getSelectedItem() != null) {
                AmaKodPanel.this.struct.setYtmaterialID(((Ytmaterial)AmaKodPanel.this.ytmaterialModel.getSelectedItem()).getId());
            }
            AmaKodPanel.this.updateBehandlingar();
            AmaKodPanel.this.updateBehkod();
        }
    };
    private DocumentListener updateListener = new DocumentListener(){

        @Override
        public void changedUpdate(DocumentEvent e) {
            try {
                AmaKodPanel.this.parseAmaKod();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            try {
                AmaKodPanel.this.parseAmaKod();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            try {
                AmaKodPanel.this.parseAmaKod();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    };
    private Object forOb;
    private Object underOb;
    private Object fardigOb;
    private JButton cancelEditing;
    public JList fardigbehandling;
    public JTextArea fardigbeskrivning;
    public JList forbehandling;
    public JTextArea forbeskrivning;
    private JScrollPane jScrollPane10;
    private JScrollPane jScrollPane11;
    private JScrollPane jScrollPane12;
    private JScrollPane jScrollPane7;
    private JScrollPane jScrollPane8;
    private JScrollPane jScrollPane9;
    public JComboBox material;
    private JButton stopEditing;
    public JList underbehandling;
    public JTextArea underbeskrivning;
    public JComboBox underlag;

    @Override
    public Component getComponent() {
        return this;
    }

    private ListSelectionListener buildListSelectionListener(final JTextArea text) {
        return new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                if (!evt.getValueIsAdjusting()) {
                    Behandling b = (Behandling)((JList)evt.getSource()).getSelectedValue();
                    if (b != null) {
                        text.setText(b.getFullDescription());
                    } else {
                        text.setText("[Ingen behandling vald]");
                    }
                    AmaKodPanel.this.updateBehkod();
                }
            }
        };
    }

    public AmaKodPanel(ProjectManager pm) {
        this.projectManager = pm;
        this.struct = new RadStruct();
        RadHanterare.setDefaults((RadStruct)this.struct);
        this.ytmaterialModel = new GenericComboBoxModel(true);
        this.underlagModel = new GenericComboBoxModel(true);
        this.f\u00f6rbehandlingar = new GenericListModel();
        this.underbehandlingar = new GenericListModel();
        this.f\u00e4rdigbehandlingar = new GenericListModel();
        this.initComponents();
        this.forbehandling.addListSelectionListener(this.buildListSelectionListener(this.forbeskrivning));
        this.underbehandling.addListSelectionListener(this.buildListSelectionListener(this.underbeskrivning));
        this.fardigbehandling.addListSelectionListener(this.buildListSelectionListener(this.fardigbeskrivning));
        this.material.setRenderer(new PopupRenderer());
        this.underlag.setRenderer(new PopupRenderer());
    }

    @Override
    public Object getValue(RadStruct r) {
        return RadHanterare.getAmaKod((RadStruct)r);
    }

    @Override
    public void init(RadStruct row, JTextField text, TableCellEditor editor) {
        this.textfield = text;
        this.editor = editor;
        this.struct.setByggdel(row.getByggdel());
    }

    @Override
    public void willShowDialog() {
        this.underlag.removeActionListener(this.underlagActionListener);
        this.material.removeActionListener(this.ytmaterialActionListener);
        this.underlagModel.setListData(this.projectManager.getCurrentProject().getDatabaseInstance().getUnderlag(this.struct));
        this.ytmaterialModel.setListData(this.projectManager.getCurrentProject().getDatabaseInstance().getYtmaterial(this.struct));
        this.underlag.addActionListener(this.underlagActionListener);
        this.material.addActionListener(this.ytmaterialActionListener);
        try {
            this.parseAmaKod();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.textfield.getDocument().addDocumentListener(this.updateListener);
    }

    @Override
    public void uninit() {
        if (this.textfield != null) {
            this.textfield.getDocument().removeDocumentListener(this.updateListener);
        }
    }

    public void updateBehkod() {
        Logger.getLogger("se.sjobeck").entering("AmaKodPanel", "updateBehkod");
        if (this.textfield != null && this.isVisible()) {
            this.textfield.getDocument().removeDocumentListener(this.updateListener);
            try {
                Underlag u = (Underlag)this.underlagModel.getSelectedItem();
                String newKod = u != null ? u.getId() : "#";
                Ytmaterial y = (Ytmaterial)this.ytmaterialModel.getSelectedItem();
                newKod = y != null ? newKod + y.getId() + " - " : newKod + "# - ";
                try {
                    newKod = newKod + ((Behandling)this.forbehandling.getSelectedValue()).getId() + " ";
                }
                catch (Exception e) {
                    newKod = newKod + "# ";
                }
                try {
                    newKod = newKod + ((Behandling)this.underbehandling.getSelectedValue()).getId() + " ";
                }
                catch (Exception e) {
                    newKod = newKod + "## ";
                }
                try {
                    newKod = newKod + ((Behandling)this.fardigbehandling.getSelectedValue()).getId();
                }
                catch (Exception e) {
                    newKod = newKod + "##";
                }
                this.textfield.setText(newKod);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.textfield.getDocument().addDocumentListener(this.updateListener);
        }
        Logger.getLogger("se.sjobeck").exiting("AmaKodPanel", "updateBehkod");
    }

    private Object fetchLoadOb(JList list) {
        Object ret = null;
        if (list.equals(this.forbehandling) && this.forOb != null) {
            ret = this.forOb;
        } else if (list.equals(this.underbehandling) && this.underOb != null) {
            ret = this.underOb;
        } else if (list.equals(this.fardigbehandling) && this.fardigOb != null) {
            ret = this.fardigOb;
        }
        return ret;
    }

    private void updateBehandlingar() {
        Logger.getLogger("se.sjobeck.gui.AmaKodPanel").entering("AmaKodPanel", "updateBehandlingar");
        if (this.underlag.getSelectedIndex() == -1 || this.material.getSelectedIndex() == -1) {
            return;
        }
        this.f\u00f6rbehandlingar.setListData((Collection)this.projectManager.getCurrentProject().getDatabaseInstance().getBehandlingar(BehandlingsTyp.F\u00f6rbehandling, this.struct));
        this.underbehandlingar.setListData((Collection)this.projectManager.getCurrentProject().getDatabaseInstance().getBehandlingar(BehandlingsTyp.Underbehandling, this.struct));
        this.f\u00e4rdigbehandlingar.setListData((Collection)this.projectManager.getCurrentProject().getDatabaseInstance().getBehandlingar(BehandlingsTyp.F\u00e4rdigbehandling, this.struct));
        Logger.getLogger("se.sjobeck.gui.AmaKodPanel").exiting("AmaKodPanel", "updateBehandlingar");
    }

    public void parseAmaKod() {
        String s = this.textfield.getText();
        int offset = this.skipIgnorable(s, 0);
        offset = this.parseUnderlag(s, offset);
        offset = this.skipIgnorable(s, offset);
        offset = this.parseYtmaterial(s, offset);
        offset = this.skipIgnorable(s, offset);
        offset = this.parseBehandling(this.forbehandling, s, offset);
        offset = this.skipIgnorable(s, offset);
        offset = this.parseBehandling(this.underbehandling, s, offset);
        offset = this.skipIgnorable(s, offset);
        offset = this.parseBehandling(this.fardigbehandling, s, offset);
    }

    private int skipIgnorable(String s, int offset) {
        while (offset < s.length() && (s.charAt(offset) == ' ' || s.charAt(offset) == '-')) {
            ++offset;
        }
        return offset;
    }

    private int parseUnderlag(String s, int offset) {
        if (s.startsWith("#", offset)) {
            this.underlag.setSelectedIndex(-1);
            this.material.repaint();
            return offset + 1;
        }
        for (int i = this.underlagModel.getSize() - 1; i >= 0; --i) {
            Underlag u = (Underlag)this.underlagModel.getElementAt(i);
            if (!s.startsWith(u.getId(), offset)) continue;
            this.underlag.setSelectedIndex(i);
            this.underlag.repaint();
            return offset + u.getId().length();
        }
        this.underlag.setSelectedIndex(0);
        this.underlag.repaint();
        throw new IllegalArgumentException("Could not parse string '" + s.substring(offset) + "'");
    }

    private int parseYtmaterial(String s, int offset) {
        if (s.startsWith("#", offset)) {
            this.material.setSelectedIndex(-1);
            this.material.repaint();
            return offset + 1;
        }
        for (int i = this.ytmaterialModel.getSize() - 1; i >= 0; --i) {
            Ytmaterial y = (Ytmaterial)this.ytmaterialModel.getElementAt(i);
            if (!s.startsWith(y.getId(), offset)) continue;
            this.material.setSelectedIndex(i);
            this.material.repaint();
            return offset + y.getId().length();
        }
        this.material.setSelectedIndex(0);
        this.material.repaint();
        throw new IllegalArgumentException("Could not parse string '" + s.substring(offset) + "'");
    }

    private int parseBehandling(JList list, String s, int offset) {
        if (s.startsWith("##", offset)) {
            list.setSelectedIndex(-1);
            return offset + 2;
        }
        ListModel model = list.getModel();
        for (int i = model.getSize() - 1; i >= 0; --i) {
            Behandling b = (Behandling)model.getElementAt(i);
            if (!s.startsWith(b.getId(), offset)) continue;
            list.setSelectedIndex(i);
            return offset + b.getId().length();
        }
        list.setSelectedIndex(-1);
        throw new IllegalArgumentException("Could not parse string '" + s.substring(offset) + "'");
    }

    @Override
    public boolean stopCellEditing() {
        return true;
    }

    private void initComponents() {
        this.underlag = new JComboBox<Underlag>((ComboBoxModel<Underlag>)this.underlagModel);
        this.material = new JComboBox<Ytmaterial>((ComboBoxModel<Ytmaterial>)this.ytmaterialModel);
        this.jScrollPane7 = new JScrollPane();
        this.forbehandling = new JList<Behandling>((ListModel<Behandling>)this.f\u00f6rbehandlingar);
        this.jScrollPane8 = new JScrollPane();
        this.underbehandling = new JList<Behandling>((ListModel<Behandling>)this.underbehandlingar);
        this.jScrollPane9 = new JScrollPane();
        this.fardigbehandling = new JList<Behandling>((ListModel<Behandling>)this.f\u00e4rdigbehandlingar);
        this.jScrollPane10 = new JScrollPane();
        this.forbeskrivning = new JTextArea();
        this.jScrollPane11 = new JScrollPane();
        this.underbeskrivning = new JTextArea();
        this.jScrollPane12 = new JScrollPane();
        this.fardigbeskrivning = new JTextArea();
        this.cancelEditing = new JButton();
        this.stopEditing = new JButton();
        this.setBorder(new LineBorder(new Color(0, 0, 0), 1, true));
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy((FocusTraversalPolicy)new FocusPolicy(new Component[]{this.underlag, this.material, this.forbehandling, this.underbehandling, this.fardigbehandling}));
        this.setPreferredSize(new Dimension(400, 255));
        this.setLayout((LayoutManager)new AbsoluteLayout());
        this.underlag.setFocusCycleRoot(true);
        this.underlag.setMaximumSize(new Dimension(120, 21));
        this.underlag.setMinimumSize(new Dimension(21, 21));
        this.underlag.setOpaque(false);
        this.underlag.setPreferredSize(new Dimension(120, 21));
        this.add((Component)this.underlag, new AbsoluteConstraints(2, 2, 197, 17));
        this.material.setFocusCycleRoot(true);
        this.material.setMaximumSize(new Dimension(120, 21));
        this.material.setMinimumSize(new Dimension(21, 21));
        this.material.setOpaque(false);
        this.material.setPreferredSize(new Dimension(120, 21));
        this.add((Component)this.material, new AbsoluteConstraints(201, 2, 197, 17));
        this.jScrollPane7.setHorizontalScrollBarPolicy(31);
        this.jScrollPane7.setAutoscrolls(true);
        this.jScrollPane7.setFocusCycleRoot(true);
        this.jScrollPane7.setOpaque(false);
        this.forbehandling.setSelectionMode(0);
        this.forbehandling.setFocusCycleRoot(true);
        this.forbehandling.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                AmaKodPanel.this.behandlingFocusGained(evt);
            }
        });
        this.jScrollPane7.setViewportView(this.forbehandling);
        this.add((Component)this.jScrollPane7, new AbsoluteConstraints(2, 20, 50, 210));
        this.jScrollPane8.setHorizontalScrollBarPolicy(31);
        this.jScrollPane8.setFocusCycleRoot(true);
        this.jScrollPane8.setOpaque(false);
        this.underbehandling.setSelectionMode(0);
        this.underbehandling.setFocusCycleRoot(true);
        this.underbehandling.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                AmaKodPanel.this.behandlingFocusGained(evt);
            }
        });
        this.jScrollPane8.setViewportView(this.underbehandling);
        this.add((Component)this.jScrollPane8, new AbsoluteConstraints(53, 20, 50, 210));
        this.jScrollPane9.setHorizontalScrollBarPolicy(31);
        this.jScrollPane9.setFocusCycleRoot(true);
        this.jScrollPane9.setOpaque(false);
        this.fardigbehandling.setSelectionMode(0);
        this.fardigbehandling.setFocusCycleRoot(true);
        this.fardigbehandling.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                AmaKodPanel.this.behandlingFocusGained(evt);
            }
        });
        this.jScrollPane9.setViewportView(this.fardigbehandling);
        this.add((Component)this.jScrollPane9, new AbsoluteConstraints(104, 20, 50, 210));
        this.jScrollPane10.setFocusCycleRoot(true);
        this.jScrollPane10.setFocusable(false);
        this.jScrollPane10.setMaximumSize(new Dimension(120, 40));
        this.jScrollPane10.setOpaque(false);
        this.jScrollPane10.setPreferredSize(new Dimension(120, 40));
        this.forbeskrivning.setEditable(false);
        this.forbeskrivning.setFont(new Font("SansSerif", 0, 11));
        this.forbeskrivning.setLineWrap(true);
        this.forbeskrivning.setWrapStyleWord(true);
        this.forbeskrivning.setFocusable(false);
        this.jScrollPane10.setViewportView(this.forbeskrivning);
        this.add((Component)this.jScrollPane10, new AbsoluteConstraints(156, 20, 242, 70));
        this.jScrollPane11.setFocusCycleRoot(true);
        this.jScrollPane11.setFocusable(false);
        this.jScrollPane11.setMaximumSize(new Dimension(120, 40));
        this.jScrollPane11.setOpaque(false);
        this.jScrollPane11.setPreferredSize(new Dimension(120, 40));
        this.underbeskrivning.setEditable(false);
        this.underbeskrivning.setFont(new Font("SansSerif", 0, 11));
        this.underbeskrivning.setLineWrap(true);
        this.underbeskrivning.setWrapStyleWord(true);
        this.underbeskrivning.setFocusable(false);
        this.jScrollPane11.setViewportView(this.underbeskrivning);
        this.add((Component)this.jScrollPane11, new AbsoluteConstraints(156, 90, 242, 70));
        this.jScrollPane12.setHorizontalScrollBarPolicy(31);
        this.jScrollPane12.setFocusCycleRoot(true);
        this.jScrollPane12.setFocusable(false);
        this.jScrollPane12.setMaximumSize(new Dimension(120, 40));
        this.jScrollPane12.setOpaque(false);
        this.jScrollPane12.setPreferredSize(new Dimension(120, 40));
        this.fardigbeskrivning.setEditable(false);
        this.fardigbeskrivning.setFont(new Font("SansSerif", 0, 11));
        this.fardigbeskrivning.setLineWrap(true);
        this.fardigbeskrivning.setWrapStyleWord(true);
        this.fardigbeskrivning.setFocusable(false);
        this.jScrollPane12.setViewportView(this.fardigbeskrivning);
        this.add((Component)this.jScrollPane12, new AbsoluteConstraints(156, 160, 242, 70));
        this.cancelEditing.setIcon(new ImageIcon(this.getClass().getResource("/se/sjobeck/images/dialog-cancel.png")));
        this.cancelEditing.setMargin(new Insets(2, 2, 2, 2));
        this.cancelEditing.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AmaKodPanel.this.cancelEditingActionPerformed(evt);
            }
        });
        this.add((Component)this.cancelEditing, new AbsoluteConstraints(318, 233, 40, 20));
        this.stopEditing.setIcon(new ImageIcon(this.getClass().getResource("/se/sjobeck/images/dialog-ok.png")));
        this.stopEditing.setMargin(new Insets(2, 2, 2, 2));
        this.stopEditing.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AmaKodPanel.this.stopEditingActionPerformed(evt);
            }
        });
        this.add((Component)this.stopEditing, new AbsoluteConstraints(358, 233, 40, 20));
    }

    private void cancelEditingActionPerformed(ActionEvent evt) {
        this.editor.cancelCellEditing();
    }

    private void stopEditingActionPerformed(ActionEvent evt) {
        this.editor.stopCellEditing();
    }

    private void behandlingFocusGained(FocusEvent evt) {
        if (((JList)evt.getComponent()).getSelectedIndex() == -1) {
            ((JList)evt.getComponent()).setSelectedIndex(0);
        }
    }

    @Override
    public Object getCellEditorValue() {
        return this.textfield.getText();
    }
}

