/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.datastructures;

import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import javax.swing.tree.TreeNode;
import se.sjobeck.datastructures.KalkylNod;
import se.sjobeck.datastructures.Projekt;
import se.sjobeck.datastructures.Remark;
import se.sjobeck.datastructures.RumNod;
import se.sjobeck.datastructures.TlgStruct;
import se.sjobeck.datastructures.kalkylering.RadStruct;
import se.sjobeck.datastructures.kalkylering.TimprisStruct;

public class RemarkFactory {
    public static List<Remark> checkProject(Projekt p) {
        LinkedList<Remark> remarkList = new LinkedList<Remark>();
        TimprisStruct timpris = p.getTimprisStruct();
        TlgStruct[] tillagg = p.getGlobalaTillagg();
        Enumeration<TreeNode> e = p.getRader().depthFirstEnumeration();
        while (e.hasMoreElements()) {
            KalkylNod n = (KalkylNod)e.nextElement();
            if (n.getAllowsChildren() && n.isLeaf()) {
                remarkList.add(new Remark("Tom gren", n, null));
            }
            if (!(n instanceof RumNod)) continue;
            List<RadStruct> rader = n.getRader();
            if (rader.isEmpty()) {
                remarkList.add(new Remark("Inga rader specificerade", n, null));
            }
            for (int i = 0; i < rader.size(); ++i) {
                RadStruct rad = rader.get(i);
                List produkter = p.getDatabaseInstance().getYtprodukter(rad, p.getFabrikat());
                if (produkter == null || produkter.isEmpty() || rad.getProduktKod() != null) continue;
                remarkList.add(new Remark("Rad " + (i + 1) + ": Produkt saknas", n, null));
            }
            boolean finns641 = false;
            for (RadStruct rs : rader) {
                for (TlgStruct ts : rs.getTillagg()) {
                    finns641 = ts.getAckpunkt().equals("641") || finns641;
                }
            }
            if (!finns641 || !(((RumNod)n).takYtaPlussV\u00e4ggyta() > 20.0)) continue;
            remarkList.add(new Remark("kontrollera till\u00e4gg 641", n, null));
        }
        return remarkList;
    }
}

